/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataPortable;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSException;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.Namespace;
import com.wm.lang.schema.ComplexType;
import com.wm.lang.schema.ContentType;
import com.wm.lang.schema.DatatypeFactory;
import com.wm.lang.schema.Flat;
import com.wm.lang.schema.Model;
import com.wm.lang.schema.NodeWorkspace;
import com.wm.lang.schema.PolyComplexType;
import com.wm.lang.schema.Reserve;
import com.wm.lang.schema.Schema;
import com.wm.lang.schema.SimpleType;
import com.wm.lang.schema.SimpleTypeUtil;
import com.wm.lang.schema.TypeDef;
import com.wm.lang.schema.Util;
import com.wm.lang.schema.W3CKeys;
import com.wm.lang.schema.WmAttribute;
import com.wm.lang.schema.WmComplexTypeRef;
import com.wm.lang.schema.WmElement;
import com.wm.lang.schema.WmTag;
import com.wm.lang.schema.conv.Builder;
import com.wm.lang.schema.conv.Context;
import com.wm.lang.schema.conv.Profiler;
import com.wm.lang.schema.resources.ValidationMessageBundle;
import com.wm.lang.schema.util.Entry;
import com.wm.lang.schema.util.HashSet;
import com.wm.lang.schema.util.Iterator;
import com.wm.lang.xml.Attribute;
import com.wm.lang.xml.ElementNodeBase;
import com.wm.lang.xml.TextNode;
import com.wm.util.Destroyable;
import com.wm.util.IntEnum;
import com.wm.util.LocalizedException;
import com.wm.util.LocalizedMessage;
import com.wm.util.NCName;
import com.wm.util.Name;
import com.wm.util.QName;
import com.wm.util.Showable;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;
import com.wm.util.sort.Sortable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class WmComplexType
implements ComplexType,
Entry,
Destroyable,
IDataPortable,
Sortable,
Showable,
W3CKeys {
    private static final boolean debug = false;
    String _ncName;
    Vector _attributes;
    Vector _elements;
    Model _model;
    SimpleType _simpleType;
    boolean _isAbstract;
    int _internalType;
    Schema _owner;
    Schema[] _schemas;
    HashSet _typeHeirarchy;
    boolean _isExpanded;
    boolean _hasSimpleType;
    static final boolean DEBUG = false;
    public static final int CT_INSTANCE = 1;
    public static final int CT_REFERENCE = 2;
    public static final int CT_POLYMORPHIC = 3;
    public static final int CT_UNKNOWN = 10;
    static final IntEnum _internalTypeEnum = new IntEnum(0);
    public static final String KEY_CT_ELEMENTS = "elements";
    public static final String KEY_CT_ATTRIBUTES = "attributes";
    public static final String KEY_CT_CONTENTMODEL = "contentModel";
    public static final String KEY_CT_CONTENTTYPE = "contentType";
    public static final String KEY_CT_INTERNALTYPE = "internalType";
    public static final String KEY_CT_SIMPLETYPE = "simpleType";
    public static final String KEY_CT_PARENT_ANCESTOR_HEIRARCHY = "parent-ancestors";
    public static final String KEY_CT_IS_EXPANDED = "isExpanded";
    boolean _isDestroyed = false;
    static final String VALUE_CT_CONTENTTYPE = "complex";

    public WmComplexType(Schema owner, IData values) {
        this();
        this._owner = owner;
        this.setFromData(values);
    }

    public WmComplexType(String ncName) {
        this._ncName = ncName;
        this._attributes = new Vector();
        this._elements = new Vector();
        this._internalType = 1;
    }

    public WmComplexType() {
        this._attributes = new Vector();
        this._elements = new Vector();
        this._internalType = 1;
    }

    protected WmComplexType(String ncName, int internalType) {
        this._ncName = ncName;
        this._internalType = internalType;
        this._attributes = null;
        this._elements = null;
    }

    public int getType() {
        return 2;
    }

    public String getName() {
        return this._ncName;
    }

    public WmAttribute getAttribute(QName name) {
        int index;
        if (name != null && (index = WmComplexType.lookup(this._attributes, name)) > -1) {
            return (WmAttribute)this._attributes.elementAt(index);
        }
        return null;
    }

    public WmElement getElement(QName name) {
        int index;
        if (name != null && (index = WmComplexType.lookup(this._elements, name)) > -1) {
            return (WmElement)this._elements.elementAt(index);
        }
        return null;
    }

    public Schema getOwner() {
        return this._owner;
    }

    public Schema[] getSchemas() {
        return this._schemas;
    }

    private static final int lookup(Vector container, QName key) {
        int index = -1;
        if (container == null) {
            return index;
        }
        int size = container.size();
        for (int i = 0; i < size; ++i) {
            if (!container.elementAt(i).equals(key)) continue;
            index = i;
            break;
        }
        return index;
    }

    private int lookupAttributes(QName key) {
        int index = -1;
        if (this._attributes == null) {
            return index;
        }
        int size = this._attributes.size();
        for (int i = 0; i < size; ++i) {
            WmAttribute attr = (WmAttribute)this._attributes.elementAt(i);
            if (!attr.equals(key, true)) continue;
            index = i;
            break;
        }
        return index;
    }

    public Model getContentModel() {
        return this._model;
    }

    public int getContentModelType() {
        if (this._model != null) {
            return this._model.getType();
        }
        return 20;
    }

    public Enumeration elements() {
        return this._elements.elements();
    }

    public Enumeration attributes() {
        return this._attributes.elements();
    }

    public SimpleType getSimpleType() {
        return this._simpleType;
    }

    public boolean isAbstract() {
        return this._isAbstract;
    }

    public HashSet getTypeHeirarchy() {
        return this._typeHeirarchy;
    }

    public void setName(String ncName) {
        this._ncName = ncName;
    }

    public void addAttribute(WmAttribute attr) {
        if (attr != null) {
            attr.setOwner(this._owner);
            this._attributes.addElement(attr);
        }
    }

    public WmAttribute removeAttribute(QName name) {
        int index;
        WmTag attr = null;
        if (name != null && (index = WmComplexType.lookup(this._attributes, name)) > -1) {
            attr = (WmAttribute)this._attributes.elementAt(index);
            this._attributes.removeElement(attr);
        }
        if (attr != null) {
            attr.setOwner(null);
            attr.setDestroyed();
        }
        return attr;
    }

    public void addElement(WmElement element) {
        if (element != null) {
            element.setOwner(this._owner);
            this._elements.addElement(element);
        }
    }

    public WmElement removeElement(QName name) {
        return null;
    }

    public void removeAllElements() {
        int size = this._elements.size();
        for (int i = 0; i < size; ++i) {
            WmElement element = (WmElement)this._elements.elementAt(i);
            element.setOwner(null);
            element.setDestroyed();
        }
        this._elements.removeAllElements();
    }

    public void addTag(WmTag tag) {
        if (tag != null) {
            if (tag.getTagType() == 1) {
                this.addElement((WmElement)tag);
            } else if (tag.getTagType() == 2) {
                this.addAttribute((WmAttribute)tag);
            }
        }
    }

    public void setModel(Model model) {
        this._model = model;
        this._model.setOwner(this);
    }

    public void setSimpleType(SimpleType simpleType) {
        if (simpleType != null) {
            simpleType.setOwner(this._owner);
        }
        this._simpleType = simpleType;
        this._hasSimpleType = this._simpleType != null;
    }

    public int getInternalType() {
        return this._internalType;
    }

    public void setInternalType(int itype) {
        this._internalType = itype;
    }

    public void setOwner(Schema owner) {
        WmTag tag;
        Enumeration enumvar;
        this._owner = owner;
        if (this._simpleType != null) {
            this._simpleType.setOwner(this._owner);
        }
        if (this._elements != null) {
            enumvar = this._elements.elements();
            while (enumvar.hasMoreElements()) {
                tag = (WmTag)enumvar.nextElement();
                tag.setOwner(this._owner);
            }
        }
        if (this._attributes != null) {
            enumvar = this._attributes.elements();
            while (enumvar.hasMoreElements()) {
                tag = (WmTag)enumvar.nextElement();
                tag.setOwner(this._owner);
            }
        }
    }

    public void setSchemas(Schema[] schemas) {
        this._schemas = schemas;
    }

    public void setAbstract(boolean isAbstract) {
        this._isAbstract = isAbstract;
    }

    public void setTypeHeirarchy(HashSet typeHeirarchy) {
        this._typeHeirarchy = typeHeirarchy;
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{KEY_CT_CONTENTTYPE, Integer.toString(2)}, {KEY_CT_INTERNALTYPE, _internalTypeEnum.getString(this._internalType, "unknown")}, {"name", this._ncName}, {KEY_CT_ELEMENTS, this._elements}, {KEY_CT_ATTRIBUTES, this._attributes}, {KEY_CT_CONTENTMODEL, this._model}, {KEY_CT_SIMPLETYPE, this._simpleType}, {"abstract", this._isAbstract ? "true" : null}, {KEY_CT_PARENT_ANCESTOR_HEIRARCHY, WmComplexType.toArray(this._typeHeirarchy)}, {KEY_CT_IS_EXPANDED, this._isExpanded ? "true" : null}};
        return new Values(o);
    }

    public IData getAsData() {
        Object[][] o = new Object[][]{{KEY_CT_CONTENTTYPE, Integer.toString(2)}, {KEY_CT_INTERNALTYPE, _internalTypeEnum.getString(this._internalType, "unknown")}, {"name", this._ncName}, {KEY_CT_ELEMENTS, this._elements}, {KEY_CT_ATTRIBUTES, this._attributes}, {KEY_CT_CONTENTMODEL, this._model}, {KEY_CT_SIMPLETYPE, this._simpleType}, {"abstract", this._isAbstract ? "true" : null}, {KEY_CT_PARENT_ANCESTOR_HEIRARCHY, WmComplexType.toArray(this._typeHeirarchy)}, {KEY_CT_IS_EXPANDED, this._isExpanded ? "true" : null}};
        return IDataFactory.create(o);
    }

    private static final Values[] toArray(HashSet set) {
        if (set == null) {
            return null;
        }
        Values[] valArray = new Values[set.size()];
        Iterator it = set.iterator();
        int i = 0;
        while (it.hasNext()) {
            valArray[i] = ((ValuesCodable)it.next()).getValues();
            ++i;
        }
        return valArray;
    }

    public void setValues(Values values) {
        Values inVal;
        this._ncName = values.getString("name");
        this._internalType = _internalTypeEnum.getInt(values.getString(KEY_CT_INTERNALTYPE), 10);
        Object in = values.get(KEY_CT_ELEMENTS);
        if (in != null && in instanceof Vector) {
            if (this._elements != null) {
                this._elements.removeAllElements();
            } else {
                this._elements = new Vector();
            }
            this.createElements((Vector)in);
        }
        if ((in = values.get(KEY_CT_ATTRIBUTES)) != null && in instanceof Vector) {
            if (this._attributes != null) {
                this._attributes.removeAllElements();
            } else {
                this._attributes = new Vector();
            }
            this.createAttributes((Vector)in);
        }
        this._model = (inVal = values.getValues(KEY_CT_CONTENTMODEL)) != null ? Model.create(inVal, this) : null;
        inVal = values.getValues(KEY_CT_SIMPLETYPE);
        if (inVal != null) {
            try {
                this.setSimpleType(DatatypeFactory.create(inVal));
            }
            catch (NSException ns) {
                this.setSimpleType(null);
            }
        } else {
            this.setSimpleType(null);
        }
        this._isAbstract = values.getBoolean("abstract");
        Object[] inArray = (Object[])values.get(KEY_CT_PARENT_ANCESTOR_HEIRARCHY);
        if (inArray != null) {
            if (this._typeHeirarchy == null) {
                this._typeHeirarchy = new HashSet();
            }
            for (int i = 0; i < inArray.length; ++i) {
                this._typeHeirarchy.add(QName.create((Values)inArray[i]));
            }
        } else {
            this._typeHeirarchy = null;
        }
        this._isExpanded = values.getBoolean(KEY_CT_IS_EXPANDED);
    }

    public void setFromData(IData values) {
        String isExpanded;
        IData inVal;
        IDataCursor ic = values.getCursor();
        this._ncName = IDataUtil.getString(ic, "name");
        this._internalType = _internalTypeEnum.getInt(IDataUtil.getString(ic, KEY_CT_INTERNALTYPE), 10);
        Object in = IDataUtil.get(ic, KEY_CT_ELEMENTS);
        if (in != null && in instanceof Vector) {
            if (this._elements != null) {
                this._elements.removeAllElements();
            } else {
                this._elements = new Vector();
            }
            this.createElements((Vector)in);
        }
        if ((in = IDataUtil.get(ic, KEY_CT_ATTRIBUTES)) != null && in instanceof Vector) {
            if (this._attributes != null) {
                this._attributes.removeAllElements();
            } else {
                this._attributes = new Vector();
            }
            this.createAttributes((Vector)in);
        }
        this._model = (inVal = (IData)IDataUtil.get(ic, KEY_CT_CONTENTMODEL)) != null ? Model.create(inVal, this) : null;
        inVal = (IData)IDataUtil.get(ic, KEY_CT_SIMPLETYPE);
        if (inVal != null) {
            try {
                this.setSimpleType(DatatypeFactory.create(inVal));
            }
            catch (NSException ns) {
                this.setSimpleType(null);
            }
        } else {
            this.setSimpleType(null);
        }
        this._isAbstract = ic.first("abstract") ? IDataUtil.getBoolean(ic) : false;
        Object[] inArray = (Object[])IDataUtil.get(ic, KEY_CT_PARENT_ANCESTOR_HEIRARCHY);
        if (inArray != null) {
            if (this._typeHeirarchy == null) {
                this._typeHeirarchy = new HashSet();
            }
            for (int i = 0; i < inArray.length; ++i) {
                this._typeHeirarchy.add(QName.create((IData)inArray[i]));
            }
        } else {
            this._typeHeirarchy = null;
        }
        this._isExpanded = (isExpanded = IDataUtil.getString(ic, KEY_CT_IS_EXPANDED)) != null && isExpanded.equalsIgnoreCase("true");
        ic.destroy();
    }

    private void createElements(Vector vec) {
        int size = vec.size();
        for (int i = 0; i < size; ++i) {
            Object vecItem = vec.elementAt(i);
            if (vecItem instanceof IData) {
                this.addElement(WmElement.create(this._owner, (IData)vecItem));
                continue;
            }
            IData val = ((WmTag)vecItem).getAsData();
            this.addElement(WmElement.create(this._owner, val));
        }
    }

    private void createAttributes(Vector vec) {
        int size = vec.size();
        for (int i = 0; i < size; ++i) {
            Object vecItem = vec.elementAt(i);
            if (vecItem instanceof IData) {
                this.addAttribute(WmAttribute.create(this._owner, (IData)vecItem));
                continue;
            }
            IData val = ((WmTag)vecItem).getAsData();
            this.addAttribute(WmAttribute.create(this._owner, val));
        }
    }

    public void addTo(Hashtable ht) {
        if (this._ncName != null && this._ncName.length() > 0) {
            ht.put(this.getName(), this);
        }
    }

    public boolean isValidlyDerivedFrom(QName name) {
        if (this._typeHeirarchy == null) {
            return false;
        }
        return this._typeHeirarchy.contains(name);
    }

    public void validate(ElementNodeBase node, NodeWorkspace workspace, String baseLocationPath) {
        QName name;
        if (this.isAbstract()) {
            workspace.addError(baseLocationPath, "", "NV-015", new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_ABSTRACT_TYPE, null, this.getName()));
            return;
        }
        if (!workspace.ignoreNilValue) {
            this.validateContentModel(node, workspace, baseLocationPath);
        }
        WmAttribute currentAttributeDecl = null;
        Vector<QName> names = null;
        boolean[] flags = new boolean[this._attributes.size()];
        for (Attribute attribute = node.getFirstAttribute(); attribute != null && !workspace.completed; attribute = attribute.getNext()) {
            int index;
            name = QName.create(attribute.getNamespaceUri(), attribute.getLocalNameWm());
            if (workspace.verbose) {
                if (names == null) {
                    names = new Vector<QName>();
                }
                names.addElement(name);
                System.out.println("WmComplexType.validate @@ Current AII is " + name);
            }
            if ((index = this.lookupAttributes(name)) > -1) {
                currentAttributeDecl = (WmAttribute)this._attributes.elementAt(index);
                flags[index] = true;
                currentAttributeDecl.validate(attribute, workspace, baseLocationPath);
                continue;
            }
            if (Reserve.current().contains(name)) continue;
            workspace.addError(baseLocationPath, "@" + name.getNCName(), "NV-006", new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_OPRHAN_AII, null));
        }
        for (int i = 0; i < flags.length && !workspace.completed; ++i) {
            if (flags[i]) continue;
            currentAttributeDecl = (WmAttribute)this._attributes.elementAt(i);
            if (currentAttributeDecl.isRequired()) {
                workspace.addError(baseLocationPath, "@" + currentAttributeDecl.getName(), "NV-007", new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_MISSING_AII, null));
                continue;
            }
            if (!currentAttributeDecl.isAugmentable()) continue;
            currentAttributeDecl.augment(node, workspace);
            if (!workspace.verbose) continue;
            name = currentAttributeDecl.getQName();
            workspace.sb.append("\t[Contribution]AII  " + name + '\n');
            if (names == null) {
                names = new Vector();
            }
            names.addElement(name);
        }
        if (workspace.completed) {
            return;
        }
        if (this._hasSimpleType && !workspace.ignoreNilValue && !workspace.ignoreContent) {
            workspace.baseLocationPath = baseLocationPath;
            workspace.relativeLocationPath = "";
            String data = "";
            if (workspace.tNodes != null) {
                TextNode[] tNodes = workspace.tNodes;
                data = Util.compose(tNodes);
            }
            this._simpleType.validate(data, workspace);
            if (workspace.childNames != null && workspace.childNames.length > 1) {
                workspace.addError(baseLocationPath, this.getName(), "NV-005", new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_EIIS_FOUND, null));
            }
        }
        if (workspace.verbose) {
            Object[] attrNames = null;
            if (names != null) {
                attrNames = new QName[names.size()];
                names.copyInto(attrNames);
            }
            workspace.attrNames = attrNames;
        }
    }

    private void validateContentModel(ElementNodeBase node, NodeWorkspace workspace, String baseLocationPath) {
        block5: {
            if (this._model != null && workspace.childNames != null) {
                try {
                    this._model.validate(workspace.childNames, workspace, baseLocationPath);
                }
                catch (RuntimeException rt) {
                    if (workspace.childNames.length <= 1) break block5;
                    workspace.addError(baseLocationPath, "", "NV-009", new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_AMBIGUOUS_CONTENT_MODEL, null));
                }
            }
        }
        if (this._model.getType() != 4 && this._simpleType == null && workspace.tNodes != null && workspace.tNodes.length > 0) {
            for (int i = 0; i < workspace.tNodes.length; ++i) {
                String text = workspace.tNodes[i].getText();
                if (text == null || text.trim().length() == 0) continue;
                workspace.addError(baseLocationPath, "", "NV-009", new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_AMBIGUOUS_CONTENT_MODEL, null));
                break;
            }
        }
    }

    public int compare(Sortable compareTo, boolean reverse, int column) {
        if (compareTo instanceof TypeDef) {
            return this.getName().toLowerCase().compareTo(((TypeDef)compareTo).getName().toLowerCase());
        }
        return 0;
    }

    public boolean isDestroyed() {
        return this._isDestroyed;
    }

    public void setDestroyed() {
        this._isDestroyed = true;
    }

    public static WmComplexType create(Schema owner, IData values) {
        IDataCursor ic = values.getCursor();
        int internalType = _internalTypeEnum.getInt(IDataUtil.getString(ic, KEY_CT_INTERNALTYPE), 10);
        ic.destroy();
        switch (internalType) {
            case 1: {
                return new WmComplexType(owner, values);
            }
            case 2: {
                return new WmComplexTypeRef(owner, values);
            }
            case 3: {
                return new PolyComplexType(owner, values);
            }
        }
        return null;
    }

    public static WmComplexType create(String ncName) {
        return new WmComplexType(ncName);
    }

    public static WmComplexType create(String ncName, String targetNS, String targetNCName) {
        return new WmComplexTypeRef(ncName, QName.create(targetNS, targetNCName));
    }

    public static WmComplexType create(QName targetName) {
        return new WmComplexTypeRef(null, targetName);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(":");
        sb.append(" ncName = " + this._ncName + ';');
        sb.append(" contentType = COMPLEX;");
        sb.append(" internalType = " + _internalTypeEnum.getString(this._internalType, "unknown") + ';');
        sb.append(" simpleType = [" + this._simpleType + "];");
        sb.append(" attributes = " + this._attributes + ';');
        sb.append(" model = [" + this._model + "];");
        sb.append(" elements = " + this._elements);
        return sb.toString();
    }

    public boolean validate(String data, Object context) {
        return false;
    }

    public Values getView() {
        Object[][] o = new Object[][]{{KEY_CT_CONTENTTYPE, VALUE_CT_CONTENTTYPE}, {"name", this._ncName}, {KEY_CT_ELEMENTS, this._elements != null ? WmComplexType.createView(this._elements) : null}, {KEY_CT_ATTRIBUTES, this._attributes != null ? WmComplexType.createView(this._attributes) : null}, {KEY_CT_CONTENTMODEL, this._model != null ? this._model.getView() : null}, {KEY_CT_SIMPLETYPE, this._simpleType != null ? ((Showable)((Object)this._simpleType)).getView() : null}};
        return new Values(o);
    }

    public Object deepClone() {
        IData values = this.getAsData();
        WmComplexType clone = WmComplexType.create(this.getOwner(), values);
        return clone;
    }

    private static Values[] createView(Vector vec) {
        int size = vec.size();
        if (size < 1) {
            return null;
        }
        Values[] valuesArray = new Values[size];
        Enumeration enumvar = vec.elements();
        int i = 0;
        while (enumvar.hasMoreElements()) {
            valuesArray[i] = ((Showable)enumvar.nextElement()).getView();
            ++i;
        }
        return valuesArray;
    }

    public Profiler createProfile() {
        Profiler profiler = Profiler.create();
        profiler.setHasComplexType();
        int noOfAttributes = this._attributes.size();
        if (this._hasSimpleType) {
            profiler.setHasSimpleType();
        }
        if (this._model != null) {
            profiler.setHasModel();
            int modelType = this._model.getType();
            switch (modelType) {
                case 4: {
                    profiler.setMixedModelFlag();
                    break;
                }
                case 6: {
                    profiler.setAnyModelFlag();
                    break;
                }
                case 7: {
                    profiler.setEmptyModelFlag();
                    break;
                }
                default: {
                    profiler.setOtherModelFlag();
                }
            }
            Flat[] flatModel = this._model.getFlattenedModel();
            if (flatModel != null) {
                for (int i = 0; i < flatModel.length; ++i) {
                    if (!flatModel[i].isAny()) continue;
                    profiler.setAnyModelFlag();
                    break;
                }
            }
        }
        if (!profiler.getAnyModelFlag()) {
            for (int i = 0; i < noOfAttributes; ++i) {
                WmAttribute attr = (WmAttribute)this._attributes.elementAt(i);
                if (!attr.isWildCard()) continue;
                profiler.setHasModel();
                profiler.setAnyModelFlag();
                break;
            }
        }
        if (profiler.getAnyModelFlag()) {
            profiler.unsetEmptyModelFlag();
        }
        if (this._attributes.size() > 0) {
            profiler.setHasAttributes();
        }
        if (this._elements.size() > 0) {
            profiler.setHasChildElements();
        }
        return profiler;
    }

    public boolean isProxy() {
        return false;
    }

    public boolean targetExists() {
        return true;
    }

    public void rearrageAttributes() {
        int size = this._attributes.size();
        if (size > 0) {
            int i;
            boolean[] wildcards = new boolean[size];
            Vector<WmAttribute> temp = new Vector<WmAttribute>();
            for (i = 0; i < size; ++i) {
                WmAttribute attr = (WmAttribute)this._attributes.elementAt(i);
                wildcards[i] = attr.isWildCard();
                if (!wildcards[i]) continue;
                temp.addElement(attr);
            }
            for (i = size - 1; i > -1; --i) {
                if (!wildcards[i]) continue;
                this._attributes.removeElementAt(i);
            }
            int wildcardSize = temp.size();
            for (i = 0; i < wildcardSize; ++i) {
                this._attributes.addElement(temp.elementAt(i));
            }
        }
    }

    public QName getQName() {
        if (this.getName() == null) {
            return null;
        }
        return QName.create(this.getOwner().getTargetNamespace(), this.getName());
    }

    public void collectRepeatingQNames(Context context, HashSet repeatingQNames, Schema[] schemas) throws LocalizedException {
        Enumeration elements = this.elements();
        while (elements.hasMoreElements()) {
            ((WmElement)elements.nextElement()).collectRepeatingQNames(context, new HashSet(), repeatingQNames, schemas, new HashSet());
            if (context.isSuccessful()) continue;
            return;
        }
    }

    public NSField createRecord(Builder builder, Context context) {
        Flat[] flatModel;
        this.setSchemas(context.getSchemas());
        Namespace ns = context.getNamespace();
        String name = this.getName();
        NSRecord nsr = new NSRecord(ns);
        nsr.setName(name);
        nsr.setClosed(true);
        Enumeration attributes = this.attributes();
        while (attributes.hasMoreElements()) {
            WmAttribute oneAttr = (WmAttribute)attributes.nextElement();
            nsr.addField(oneAttr.createRecord(builder, context));
        }
        Model model = this.getContentModel();
        Enumeration attribs = this.attributes();
        if (model.getType() == 4 || this._simpleType != null && attribs != null && attribs.hasMoreElements()) {
            NSField nsf = new NSField(nsr.getNamespace(), "*body", 1, 0);
            nsf.setOptional(true);
            if (this._simpleType != null) {
                nsf.setContentType(this._simpleType);
            }
            nsr.addField(nsf);
        }
        if (model != null && (flatModel = model.getFlattenedModel()) != null) {
            for (int i = 0; i < flatModel.length; ++i) {
                if (flatModel[i].isAny()) {
                    nsr.setClosed(false);
                    continue;
                }
                WmElement element = this.getElement(flatModel[i].getSymbol());
                if (element == null) continue;
                context.setCurrentFlatModel(flatModel[i]);
                ContentType ct = Util.mapSoapEncDataTypeToXsdDataType(context, element.getType());
                if (ct.getType() == 1) {
                    String prefix;
                    String fn = context.useNCNameDecoder() ? NCName.decode(element.getName()) : element.getName();
                    Name tns = element.getQName().getNamespaceName();
                    if (tns != null && (prefix = context.resolveURIReferenceToPrefix(tns.toString())) != null) {
                        context.addUsedPrefixURIPair(prefix, tns.toString());
                        fn = prefix + ":" + element.getName();
                    }
                    NSField fld = new NSField(nsr.getNamespace(), NSRecord.TYPE, fn, 1, 0);
                    SimpleType st = null;
                    try {
                        st = SimpleTypeUtil.cloneSmartly(context.getNamespace(), (SimpleType)ct);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    if (flatModel[i].isRepeatable()) {
                        fld.setDimensions(1);
                    }
                    if (!flatModel[i].isRequired()) {
                        fld.setOptional(true);
                    } else {
                        fld.setOptional(false);
                    }
                    fld.setNillable(element.isNullable());
                    fld.setContentType(st);
                    Util.setXmlNamespace(fld, tns);
                    nsr.addField(fld);
                    continue;
                }
                nsr.addField(element.createRecord(builder, context));
            }
        }
        return nsr;
    }

    public void setExpanded(boolean isExpanded) {
        this._isExpanded = isExpanded;
    }

    public boolean isExpanded() {
        return this._isExpanded;
    }

    static {
        _internalTypeEnum.addInt("instance", 1);
        _internalTypeEnum.addInt("reference", 2);
        _internalTypeEnum.addInt("polymorphic", 3);
        _internalTypeEnum.addInt("unknown", 10);
    }
}

