/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSField;
import com.wm.lang.schema.AnyAttribute;
import com.wm.lang.schema.ContentType;
import com.wm.lang.schema.NodeWorkspace;
import com.wm.lang.schema.Schema;
import com.wm.lang.schema.SimpleType;
import com.wm.lang.schema.WmAttributeRef;
import com.wm.lang.schema.WmTag;
import com.wm.lang.schema.conv.Builder;
import com.wm.lang.schema.conv.Context;
import com.wm.lang.schema.conv.Profiler;
import com.wm.lang.schema.resources.ValidationMessageBundle;
import com.wm.lang.xml.Attribute;
import com.wm.lang.xml.ElementNodeBase;
import com.wm.util.IntEnum;
import com.wm.util.LocalizedMessage;
import com.wm.util.Name;
import com.wm.util.QName;
import com.wm.util.Showable;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;

public class WmAttribute
extends WmTag
implements ValuesCodable,
Showable {
    private static final boolean debug = false;
    boolean _required;
    int _internalType;
    boolean _usageSpecified;
    boolean _wsdlArrayType;
    static final int ATTRIBUTE_INSTANCE = 1;
    static final int ATTRIBUTE_REFERENCE = 2;
    static final int ATTRIBUTE_ANY = 3;
    static final int ATTRIBUTE_UNKNOWN = 10;
    static final IntEnum _internalTypeEnum = new IntEnum(0);
    public static final String KEY_ATTR_REQUIRED = "required";
    public static final String KEY_ATTR_INTERNALTYPE = "internalType";

    public WmAttribute(Schema owner, IData values) {
        super(owner, values);
    }

    public WmAttribute() {
        this.setTagType(2);
        this._internalType = 1;
    }

    public WmAttribute(String ncName) {
        super(ncName);
        this.setTagType(2);
        this._internalType = 1;
    }

    public WmAttribute(String ncName, boolean required, String defaultValue, String fixedValue, ContentType type) {
        super(ncName, 2, defaultValue, fixedValue, type);
        this._required = required;
        this._internalType = 1;
    }

    protected WmAttribute(String ncName, int internalType) {
        this(ncName);
        this._internalType = internalType;
    }

    public boolean isRequired() {
        return this._required;
    }

    public void setRequired(boolean required) {
        this._required = required;
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{KEY_ATTR_REQUIRED, this._required ? "true" : "false"}, {KEY_ATTR_INTERNALTYPE, _internalTypeEnum.getString(this._internalType, "unknown")}};
        return super.getValues().copyFrom(new Values(o));
    }

    public void setValues(Values values) {
        super.setValues(values);
        String req = values.getString(KEY_ATTR_REQUIRED);
        this._required = req != null && req.equalsIgnoreCase("true");
        this._internalType = _internalTypeEnum.getInt(values.getString(KEY_ATTR_INTERNALTYPE), 10);
    }

    public IData getAsData() {
        IData values = super.getAsData();
        IDataCursor ic = values.getCursor();
        ic.insertAfter(KEY_ATTR_REQUIRED, this._required ? "true" : "false");
        ic.insertAfter(KEY_ATTR_INTERNALTYPE, _internalTypeEnum.getString(this._internalType, "unknown"));
        ic.destroy();
        return values;
    }

    public void setFromData(IData values) {
        super.setFromData(values);
        IDataCursor ic = values.getCursor();
        String req = IDataUtil.getString(ic, KEY_ATTR_REQUIRED);
        this._required = req != null && req.equalsIgnoreCase("true");
        this._internalType = _internalTypeEnum.getInt(IDataUtil.getString(ic, KEY_ATTR_INTERNALTYPE), 10);
        ic.destroy();
    }

    public void validate(ElementNodeBase node, NodeWorkspace workspace, String baseLocationPath) {
    }

    public void validate(Attribute attr, NodeWorkspace workspace, String baseLocationPath) {
        if (workspace.completed) {
            return;
        }
        String fixed = this.getFixedValue();
        SimpleType type = (SimpleType)this.getType();
        if (fixed != null) {
            if (!attr.getValue().equals(fixed)) {
                workspace.addError(baseLocationPath, "@" + this.getName(), "NV-008", new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_INVALID_CII, null));
            }
        } else if (!workspace.ignoreContent && type != null) {
            workspace.baseLocationPath = baseLocationPath;
            workspace.relativeLocationPath = "@" + this.getName();
            type.validate(attr.getValue(), workspace);
        }
    }

    public void augment(ElementNodeBase node, NodeWorkspace workspace) {
        QName name = this.getQName();
        try {
            node.assignAttribute(Name.create(name.getNamespace()), Name.create(name.getNCName()), this.getCII());
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public int getInternalType() {
        return this._internalType;
    }

    public void setUseWsdlArrayType(boolean at) {
        this._wsdlArrayType = at;
    }

    public boolean useWsdlArrayType() {
        return this._wsdlArrayType;
    }

    public void setType(ContentType type) {
        if (type.getType() == 2) {
            return;
        }
        super.setType(type);
    }

    public static final WmAttribute create(Schema owner, IData values) {
        IDataCursor ic = values.getCursor();
        int internalType = _internalTypeEnum.getInt(IDataUtil.getString(ic, KEY_ATTR_INTERNALTYPE), 10);
        ic.destroy();
        switch (internalType) {
            case 1: {
                return new WmAttribute(owner, values);
            }
            case 2: {
                return new WmAttributeRef(owner, values);
            }
            case 3: {
                return new AnyAttribute(owner, values);
            }
        }
        return null;
    }

    public static final WmAttribute create(String ncName) {
        return new WmAttribute(ncName);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(" required = " + this._required);
        sb.append(" internalType = " + _internalTypeEnum.getString(this._internalType, "unknown") + ';');
        return sb.toString();
    }

    public Values getView() {
        Object[][] o = new Object[][]{{KEY_ATTR_REQUIRED, this._required ? "true" : "false"}};
        return super.getView().copyFrom(new Values(o));
    }

    public void setUsageSpecified() {
        this._usageSpecified = true;
    }

    public boolean isUsageSpecified() {
        return this._usageSpecified;
    }

    public NSField createRecord(Builder builder, Context context) {
        this.setSchemas(context.getSchemas());
        return builder.build(this, context);
    }

    public Integer createID() {
        Profiler profiler = Profiler.create();
        profiler.setAttributeFlag();
        if (this.getType() != null) {
            profiler.setHasSimpleType();
        }
        return profiler.createID();
    }

    boolean isWildCard() {
        return false;
    }

    boolean equals(Object lhs, boolean turnOnWildCardMatching) {
        return super.equals(lhs);
    }

    static {
        _internalTypeEnum.addInt("instance", 1);
        _internalTypeEnum.addInt("reference", 2);
        _internalTypeEnum.addInt("any", 3);
        _internalTypeEnum.addInt("unknown", 10);
    }
}

