/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataPortable;
import com.wm.data.IDataUtil;
import com.wm.data.ValuesEmulator;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.schema.Validator;
import com.wm.lang.schema.ValuesWorkspace;
import com.wm.lang.schema.resources.ValidationMessageBundle;
import com.wm.lang.schema.util.HashSet;
import com.wm.util.JavaWrapperType;
import com.wm.util.LocalizedMessage;
import com.wm.util.coder.IDataCodable;
import com.wm.util.pluggable.WmIDataList;

public class ValuesValidator
extends Validator {
    NSRecord _nsr;
    static final int TYPE_UNKNOWN = 3;
    static final int TYPE_NULL = -1;
    static final int TYPE_STRING = 1;
    static final int TYPE_VALUES = 2;
    static final int DIM_SCALAR = 0;
    static final int DIM_ARRAY = 1;
    static final int DIM_TABLE = 2;
    private static final String CODE_MISSING_OBJECT = "VV-001";
    private static final String CODE_ORPHAN_OBJECT = "VV-002";
    private static final String CODE_DIMENSION_MISMATCH = "VV-003";
    private static final String CODE_TYPE_MISMATCH = "VV-004";
    private static final String CODE_TAG_IS_ABSENT = "VV-005";
    private static final String CODE_VALUE_IS_NULL = "VV-006";
    private static final String CODE_NIL_SHOULD_NOT_EXIST = "VV-007";
    private static final String MESSAGE_MISSING_OBJECT = "Missing Object";
    private static final String MESSAGE_ORPHAN_OBJECT = "Undefined Object found";
    private static final String MESSAGE_DIMENSION_MISMATCH = "Dimension mismatch";
    private static final String MESSAGE_TYPE_MISMATCH = "Type mismatch";
    private static final String MESSAGE_TAG_IS_ABSENT = "Field is absent, field must exist";
    private static final String MESSAGE_VALUE_IS_NULL = "Value cannot be null, allow null value=false";
    private static final String MESSAGE_ARRAY_EXPECTED = ", List expected";
    private static final String MESSAGE_SCALAR_EXPECTED = ", Single item expected";
    private static final String MESSAGE_TABLE_EXPECTED = ", Table expected";
    private static final String MESSAGE_STRING_EXPECTED = ", String expected";
    private static final String MESSAGE_VALUES_EXPECTED = ", Record expected";
    private static final String MESSAGE_OBJECT_EXPECTED = ", Object expected";
    private String attrPrefix = "@";
    String nilAttribute;
    String typeAttribute;
    String schemaLocationAttribute;
    String noNamespaceSchemaLocationAttribute;
    private static final String SKIP_MANDATORY = "watt.core.validation.skipMandatoryFields";
    boolean skipMandatoryFields;
    boolean publishableDoc = false;
    private static final String VALIDATE_EMPTY_STR = "watt.server.deprecate.validate.emptystring";
    boolean validateEmptyString = true;

    public ValuesValidator(IData rtObject, NSRecord nsr) {
        this._workspace = new ValuesWorkspace(rtObject);
        this._nsr = nsr;
        if (nsr.isPublishable()) {
            this.publishableDoc = true;
        }
        this.skipMandatoryFields = new Boolean(System.getProperty(SKIP_MANDATORY, "false"));
        this.validateEmptyString = new Boolean(System.getProperty(VALIDATE_EMPTY_STR, "true"));
    }

    public IData validate() {
        String[] keys = ValuesEmulator.getKeys(((ValuesWorkspace)this._workspace).top);
        if (keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                if (!keys[i].endsWith("version")) continue;
                this.attrPrefix = keys[i].substring(0, keys[i].lastIndexOf("version"));
            }
            if (this.attrPrefix == null) {
                this.attrPrefix = "@";
            }
        }
        String ignoreAttributePrefix = this.attrPrefix + "xsi:";
        this.nilAttribute = ignoreAttributePrefix + "nil";
        this.typeAttribute = ignoreAttributePrefix + "type";
        this.schemaLocationAttribute = ignoreAttributePrefix + "schemaLocation";
        this.noNamespaceSchemaLocationAttribute = ignoreAttributePrefix + "noNamespaceSchemaLocation";
        this.validate(((ValuesWorkspace)this._workspace).top, this._nsr, "");
        return ValuesValidator.createResult(this._workspace.valid, this._workspace.getErrors(), null);
    }

    private void validate(IData values, NSRecord record, String baseLocationPath) {
        if (this._workspace.completed) {
            return;
        }
        NSField[] children = record.getFieldNodes();
        HashSet names = null;
        boolean closed = record.isClosed();
        boolean tagPresent = false;
        if (closed) {
            names = children.length > 0 ? new HashSet(children.length) : new HashSet(1);
        }
        IDataCursor idc = values.getCursor();
        String nilAttrValue = (String)IDataUtil.get(idc, this.attrPrefix + "xsi:" + "nil");
        if (!record.isNillable() && nilAttrValue != null) {
            this._workspace.addError(baseLocationPath, "xsi:nil", CODE_NIL_SHOULD_NOT_EXIST, new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_NIL_SHOULD_NOT_EXIST, null, record.getName()));
        }
        boolean isNilAttr = record.isNillable() && ("true".equals(nilAttrValue) || "1".equals(nilAttrValue));
        for (int index = 0; index < children.length && !this._workspace.completed; ++index) {
            String nodeName;
            block24: {
                NSField child;
                block20: {
                    int objectDim;
                    int objectType;
                    IData[] unknown;
                    String countString;
                    block21: {
                        block22: {
                            block23: {
                                boolean missDupField = false;
                                child = children[index];
                                nodeName = child.getName();
                                tagPresent = idc.first(nodeName);
                                if (!tagPresent) break block20;
                                if (isNilAttr && !nodeName.startsWith(this.attrPrefix)) {
                                    this._workspace.addError(baseLocationPath, child.getName(), CODE_ORPHAN_OBJECT, new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_NO_CHAR_OR_CHILD, null, record.getName()));
                                    if (!closed) continue;
                                    names.add(nodeName);
                                    continue;
                                }
                                idc.home();
                                int count = 0;
                                for (int idx = 0; idx <= index; ++idx) {
                                    if (!children[idx].getName().equals(nodeName)) continue;
                                    ++count;
                                }
                                countString = count > 1 ? "(" + Integer.toString(count) + ")" : "";
                                while (count > 0) {
                                    if (idc.next(nodeName)) {
                                        --count;
                                        continue;
                                    }
                                    if (child.isOptional()) break;
                                    this._workspace.addError(baseLocationPath, child.getName(), CODE_TAG_IS_ABSENT, new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_TAG_IS_ABSENT, null));
                                    missDupField = true;
                                    break;
                                }
                                if (missDupField) continue;
                                unknown = idc.getValue();
                                if (unknown instanceof WmIDataList) {
                                    unknown = ((WmIDataList)unknown).getItems();
                                } else if (unknown instanceof IDataCodable) {
                                    unknown = ((IDataCodable)unknown).getIData();
                                } else if (unknown instanceof IDataPortable) {
                                    unknown = ((IDataPortable)unknown).getAsData();
                                }
                                objectType = ValuesValidator.findType(unknown);
                                objectDim = ValuesValidator.findDim(unknown);
                                if (objectType == -1) break block21;
                                if (child.getType() != 2 && child.getType() != 4) break block22;
                                if (objectType != 2 || objectDim != 0) break block23;
                                this.validate((IData)unknown, (NSRecord)child, baseLocationPath + "/" + nodeName + countString);
                                break block21;
                            }
                            if (objectType != 2 || objectDim != 1) break block21;
                            this.validate(unknown, (NSRecord)child, baseLocationPath + "/" + nodeName + countString);
                            break block21;
                        }
                        if (child.getType() == 1 && objectType == 2) {
                            IDataCursor childIdc = ((IData)unknown).getCursor();
                            String nilValue = (String)IDataUtil.get(childIdc, this.attrPrefix + "xsi:" + "nil");
                            if (child.isNillable() && ("true".equals(nilValue) || "1".equals(nilValue))) {
                                this.checkDataExists(childIdc, baseLocationPath, child);
                                if (!closed) continue;
                                names.add(nodeName);
                                continue;
                            }
                        }
                    }
                    this.validate(unknown, objectType, objectDim, child, baseLocationPath, countString);
                    break block24;
                }
                if (!child.isOptional() && !this.skipMandatoryFields) {
                    if (nodeName.startsWith(this.attrPrefix)) {
                        this._workspace.addError(baseLocationPath, child.getName(), CODE_TAG_IS_ABSENT, new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_TAG_IS_ABSENT, null));
                    } else if (!isNilAttr) {
                        this._workspace.addError(baseLocationPath, child.getName(), CODE_TAG_IS_ABSENT, new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_TAG_IS_ABSENT, null));
                    }
                }
            }
            if (!closed) continue;
            names.add(nodeName);
        }
        idc.destroy();
        if (closed && !this._workspace.completed) {
            this.validateOpenness(values, names, baseLocationPath);
        }
    }

    private void checkDataExists(IDataCursor childIdc, String baseLocationPath, NSField child) {
        childIdc.home();
        while (childIdc.next()) {
            String key = childIdc.getKey();
            if (key.startsWith(this.attrPrefix)) continue;
            this._workspace.addError(baseLocationPath, child.getName(), CODE_ORPHAN_OBJECT, new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_NO_CHAR_OR_CHILD, null, child.getName()));
        }
    }

    private void validate(IData[] vArray, NSRecord record, String baseLocationPath) {
        if (this._workspace.completed) {
            return;
        }
        for (int index = 0; index < vArray.length && !this._workspace.completed; ++index) {
            if (vArray[index] == null) continue;
            this.validate(vArray[index], record, baseLocationPath + "[" + index + "]");
        }
    }

    private void validate(Object unknown, int objectType, int objectDim, NSField child, String baseLocationPath, String countString) {
        if (this._workspace.completed) {
            return;
        }
        boolean nillable = child.isNillable();
        if (objectType == -1) {
            if (!child.isNillable()) {
                this._workspace.addError(baseLocationPath, child.getName() + countString, CODE_VALUE_IS_NULL, new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_VALUE_IS_NULL, null));
            }
            return;
        }
        int type = child.getType();
        int dimension = child.getDimensions();
        int wrapperType = child.getJavaWrapperType();
        if (type == 3 && dimension == 0 && wrapperType == 0) {
            return;
        }
        if (type == 3 && dimension == 1 && wrapperType == 0 && objectDim >= 1) {
            return;
        }
        if (dimension != objectDim) {
            if (dimension == 0) {
                this._workspace.addError(baseLocationPath, child.getName() + countString, CODE_DIMENSION_MISMATCH, new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_SCALAR_EXPECTED, null));
            } else if (dimension == 1) {
                this._workspace.addError(baseLocationPath, child.getName() + countString, CODE_DIMENSION_MISMATCH, new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_ARRAY_EXPECTED, null));
            } else if (dimension == 2) {
                this._workspace.addError(baseLocationPath, child.getName() + countString, CODE_DIMENSION_MISMATCH, new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_TABLE_EXPECTED, null));
            }
        }
        if (this._workspace.completed) {
            return;
        }
        if (type == 4) {
            type = 2;
        }
        if (objectType != type) {
            if (type == 2 || type == 4) {
                this._workspace.addError(baseLocationPath, child.getName() + countString, CODE_TYPE_MISMATCH, new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_VALUES_EXPECTED, null));
            } else if (type == 1) {
                this._workspace.addError(baseLocationPath, child.getName() + countString, CODE_TYPE_MISMATCH, new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_STRING_EXPECTED, null));
            } else if (type == 3) {
                Class[] wrapper_type_class = JavaWrapperType.getClasses();
                Class clazz = ValuesValidator.getObjectClass(unknown);
                if (wrapperType != 0 && clazz != wrapper_type_class[wrapperType]) {
                    this._workspace.addError(baseLocationPath, child.getName() + countString, CODE_TYPE_MISMATCH, new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_WRAPPER_TYPE_EXPECTED, "", new Object[]{child.getJavaWrapperTypeString(), clazz.getName()}));
                }
            }
        } else if (type == 3) {
            Class[] wrapper_type_class = JavaWrapperType.getClasses();
            Class clazz = ValuesValidator.getObjectClass(unknown);
            if (wrapperType != 0 && clazz != wrapper_type_class[wrapperType]) {
                this._workspace.addError(baseLocationPath, child.getName() + countString, CODE_TYPE_MISMATCH, new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_WRAPPER_TYPE_EXPECTED, "", new Object[]{child.getJavaWrapperTypeString(), clazz.getName()}));
            }
        }
        if (this._workspace.completed) {
            return;
        }
        if (objectType == 1 && !this._workspace.ignoreContent) {
            this.requestContentValidation(unknown, objectDim, child, baseLocationPath);
        }
    }

    private void requestContentValidation(Object unknown, int objectDim, NSField child, String baseLocationPath) {
        if (objectDim == 0) {
            this.validateContent((String)unknown, child, baseLocationPath, child.getName());
        } else if (objectDim == 1) {
            String[] list = (String[])unknown;
            String name = child.getName();
            for (int index = 0; index < list.length && !this._workspace.completed; ++index) {
                this.validateContent(list[index], child, baseLocationPath, name + "[" + index + "]");
            }
        } else if (objectDim == 2) {
            String[][] table = (String[][])unknown;
            String name = child.getName();
            for (int row = 0; row < table.length; ++row) {
                for (int col = 0; col < table[row].length; ++col) {
                    this.validateContent(table[row][col], child, baseLocationPath, name + "[" + row + "][" + col + "]");
                }
            }
        } else {
            return;
        }
    }

    private void validateContent(String data, NSField child, String baseLocationPath, String relativeLocationPath) {
        if (data == null) {
            if (!child.isNillable()) {
                this._workspace.addError(baseLocationPath, relativeLocationPath, CODE_VALUE_IS_NULL, new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_VALUE_IS_NULL, null));
            } else {
                return;
            }
        }
        this._workspace.baseLocationPath = baseLocationPath;
        this._workspace.relativeLocationPath = relativeLocationPath;
        if (this.validateEmptyString || !this.publishableDoc || data != null && data.length() != 0 && !"".equals(data) && child.isNillable()) {
            child.validateContent(data, this._workspace);
        }
    }

    private void validateOpenness(IData list, HashSet closedSet, String baseLocationPath) {
        IDataCursor idc = list.getCursor();
        while (idc.next() && !this._workspace.completed) {
            String key = idc.getKey();
            if (closedSet.contains(key) || key.equals(this.nilAttribute) || key.equals(this.typeAttribute) || key.equals(this.schemaLocationAttribute) || key.equals(this.noNamespaceSchemaLocationAttribute)) continue;
            this._workspace.addError(baseLocationPath, key, CODE_ORPHAN_OBJECT, new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_ORPHAN_OBJECT, null));
        }
        idc.destroy();
    }

    private static int findType(Object unknown) {
        if (unknown == null) {
            return -1;
        }
        if (unknown instanceof String || unknown instanceof String[] || unknown instanceof String[][]) {
            return 1;
        }
        if (unknown instanceof IData || unknown instanceof IData[]) {
            return 2;
        }
        return 3;
    }

    private static int findDim(Object unknown) {
        if (unknown instanceof Object[][]) {
            return 2;
        }
        if (unknown instanceof Object[]) {
            return 1;
        }
        return 0;
    }

    private static Class getObjectClass(Object unknown) {
        Class<?> clazz = unknown.getClass();
        if (clazz == byte[].class) {
            return clazz;
        }
        if (clazz.isArray()) {
            Object[] oa = (Object[])unknown;
            for (int i = 0; i < oa.length; ++i) {
                if (oa[i] == null) continue;
                return ValuesValidator.getObjectClass(oa[i]);
            }
            return clazz.getComponentType();
        }
        return clazz;
    }
}

