/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataPortable;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.util.IntEnum;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;

public class ValidatorOptions
implements ValuesCodable,
Cloneable,
IDataPortable {
    int _option;
    int _maxErrors;
    boolean _ignoreContent;
    boolean _validationEnabled;
    private static NSRecord _nsRecord = null;
    public static final int NO_VALIDATION = 1;
    public static final int DEFAULT_VALIDATION = 2;
    public static final int DYNAMIC_VALIDATION = 3;
    public static final String SYS_PROP_MAX_ERRORS = "watt.core.validation.maxErrors";
    public static final String SYS_PROP_IGNORE_CONTENT = "watt.core.validation.ignoreContent";
    public static final String SYS_PROP_VALIDATION_ENABLED = "watt.core.validation.validationEnabled";
    public final String KEY_VALIDATION_OPTION = "validation_option";
    static final IntEnum optionEnum = new IntEnum(0);

    public ValidatorOptions() {
        this(1);
    }

    public ValidatorOptions(int userSelection) {
        this.setUserOption(userSelection);
    }

    public ValidatorOptions(IData values) {
        this.setFromData(values);
    }

    public int getMaximumErrors() {
        return this._maxErrors;
    }

    public boolean getIgnoreContent() {
        return this._ignoreContent;
    }

    public boolean isValidationEnabled() {
        return this._validationEnabled;
    }

    public int getUserOption() {
        return this._option;
    }

    public void setUserOption(int userSelection) {
        switch (userSelection) {
            case 2: {
                this._option = 2;
                try {
                    this._maxErrors = Integer.parseInt(System.getProperty(SYS_PROP_MAX_ERRORS));
                }
                catch (NumberFormatException ne) {
                    this._maxErrors = 1;
                }
                this._ignoreContent = new Boolean(System.getProperty(SYS_PROP_IGNORE_CONTENT));
                String propValue = System.getProperty(SYS_PROP_VALIDATION_ENABLED);
                if (propValue != null) {
                    this._validationEnabled = new Boolean(propValue);
                    break;
                }
                this._validationEnabled = true;
                break;
            }
            default: {
                this._option = 1;
                this._maxErrors = 1;
                this._ignoreContent = false;
                this._validationEnabled = false;
            }
        }
    }

    public void setValues(Values values) {
        try {
            this.setUserOption(optionEnum.getInt(values.getString("validation_option"), 1));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{"validation_option", optionEnum.getString(this.getUserOption(), "none")}};
        return new Values(o);
    }

    public void setFromData(IData values) {
        IDataCursor ic = values.getCursor();
        try {
            this.setUserOption(optionEnum.getInt(IDataUtil.getString(ic, "validation_option"), 1));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ic.destroy();
    }

    public IData getAsData() {
        Object[][] o = new Object[][]{{"validation_option", optionEnum.getString(this.getUserOption(), "none")}};
        return IDataFactory.create(o);
    }

    public String encodeToString() {
        return optionEnum.getString(this.getUserOption(), "none");
    }

    public static final ValidatorOptions createFromString(String str) {
        return new ValidatorOptions(optionEnum.getInt(str, 1));
    }

    public NSRecord getMetaData() {
        if (_nsRecord == null) {
            String[] choices = new String[]{"none", "default"};
            _nsRecord = new NSRecord(null);
            NSField nsf = new NSField(null, "validation_option", 1, 0);
            nsf.setStringOptions(choices);
            _nsRecord.addField(nsf);
        }
        return _nsRecord;
    }

    static {
        optionEnum.addInt("none", 1);
        optionEnum.addInt("default", 2);
        optionEnum.addInt("dynamic", 3);
    }
}

