/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema;

import com.wm.data.IData;
import com.wm.lang.ns.NSNode;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSSchema;
import com.wm.lang.ns.NSType;
import com.wm.lang.ns.Namespace;
import com.wm.lang.schema.NodeValidator;
import com.wm.lang.schema.ValidationWorkspace;
import com.wm.lang.schema.ValidatorOptions;
import com.wm.lang.schema.ValuesValidator;
import com.wm.lang.xml.ElementNodeBase;
import com.wm.lang.xml.Node;
import com.wm.lang.xml.WMDocumentException;
import com.wm.util.Values;
import java.util.Locale;

public abstract class Validator {
    public static final int DEFAULT_MAXIMUM_ERRORS = 1;
    public static final int ALL_ERRORS = -1;
    ValidationWorkspace _workspace;
    Namespace _ns;
    public static final String IS_VALID = "isValid";
    public static final String ERRORS = "errors";
    public static final String MESSAGE = "message";
    static final ValidatorOptions _defaultVOptions = new ValidatorOptions(2);
    static final int TYPE_IDATA = 1;
    static final int TYPE_NODE = 2;

    protected void Validator() {
    }

    public static final Validator create(Object object, Object conformsTo) {
        int objectType = 0;
        if (object == null) {
            return null;
        }
        if (object instanceof Node) {
            objectType = 2;
        } else if (object instanceof IData) {
            objectType = 1;
        }
        if (conformsTo != null) {
            if (!(conformsTo instanceof NSNode)) {
                return null;
            }
        } else {
            if (objectType == 2) {
                return Validator.createValidator((Node)object);
            }
            return null;
        }
        NSType nodeType = ((NSNode)conformsTo).getNodeTypeObj();
        if (objectType == 1 && nodeType.equals(NSRecord.TYPE)) {
            return Validator.createValidator((IData)object, (NSRecord)conformsTo);
        }
        if (objectType == 2 && nodeType.equals(NSSchema.TYPE)) {
            return Validator.createValidator((Node)object, (NSSchema)conformsTo);
        }
        return null;
    }

    public static final Validator create(Object object, Object conformsTo, ValidatorOptions options) {
        Validator validator = Validator.create(object, conformsTo);
        if (validator != null) {
            validator.setOptions(options);
        }
        return validator;
    }

    static final Validator createValidator(IData rtObject, NSRecord nsr) {
        ValuesValidator validator = new ValuesValidator(rtObject, nsr);
        validator.setOptions(Validator.getDefaultOptions());
        return validator;
    }

    static final Validator createValidator(Node node, NSSchema schema) {
        NSSchema[] schemas = new NSSchema[]{schema};
        if (node instanceof ElementNodeBase) {
            return new NodeValidator((ElementNodeBase)node, schemas);
        }
        return null;
    }

    static final Validator createValidator(Node node) {
        if (node instanceof ElementNodeBase) {
            return new NodeValidator((ElementNodeBase)node);
        }
        return null;
    }

    public abstract IData validate() throws WMDocumentException;

    public int getMaximumErrors() {
        return this._workspace.maximumErrors;
    }

    public boolean getIgnoreContent() {
        return this._workspace.ignoreContent;
    }

    public static final ValidatorOptions getDefaultOptions() {
        return _defaultVOptions;
    }

    public void setMaximumErrors(int maximumErrors) {
        if (maximumErrors > 0 || maximumErrors == -1) {
            this._workspace.maximumErrors = maximumErrors;
        }
    }

    public void setIgnoreContent(boolean ignoreContent) {
        this._workspace.ignoreContent = ignoreContent;
    }

    public void setNamespace(Namespace ns) {
        this._ns = ns;
    }

    public void setVerbose(boolean isVerbose) {
        this._workspace.verbose = isVerbose;
    }

    public void setLocale(Locale locale) {
        if (this._workspace == null) {
            return;
        }
        this._workspace.setLocale(locale);
    }

    public Locale getLocale() {
        if (this._workspace == null) {
            return new Locale("", "");
        }
        return this._workspace.getLocale();
    }

    public void setOptions(ValidatorOptions validatorOptions) {
        if (validatorOptions != null) {
            this.setMaximumErrors(validatorOptions.getMaximumErrors());
            this.setIgnoreContent(validatorOptions.getIgnoreContent());
        }
    }

    static final Values createResult(boolean isValid, Object errors, String message) {
        Values result = new Values(3);
        result.put(IS_VALID, new Boolean(isValid).toString());
        result.put(ERRORS, errors);
        if (message != null) {
            result.put(MESSAGE, message);
        }
        return result;
    }
}

