/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema;

import com.wm.util.LocalizedMessage;
import com.wm.util.Values;
import java.util.Locale;
import java.util.Vector;

public class ValidationWorkspace {
    private Locale locale;
    boolean valid = true;
    boolean completed = false;
    int maximumErrors = 1;
    boolean ignoreContent = false;
    boolean verbose;
    String baseLocationPath;
    String relativeLocationPath;
    protected int _noofErrors = 0;
    protected Vector _errors = new Vector(1);
    protected int _workspaceType;
    public static final int DEFAULT_MAXIMUM_ERRORS = 1;
    public static final int ALL_ERRORS = -1;
    public static final String PATH_NAME = "pathName";
    public static final String ERROR_CODE = "errorCode";
    public static final String ERROR_MESSAGE = "errorMessage";
    public static final String SEPARATOR_PATH = "/";
    public static final int VALUES_WORKSPACE = 1;
    public static final int NODE_WORKSPACE = 2;

    ValidationWorkspace() {
    }

    public void addError(String errorCode, String errorMessage) {
        Values error = new Values(4);
        error.put(PATH_NAME, this.baseLocationPath + SEPARATOR_PATH + this.relativeLocationPath);
        error.put(ERROR_CODE, errorCode);
        error.put(ERROR_MESSAGE, errorMessage);
        this._errors.addElement(error);
        this._noofErrors = this._errors.size();
        this.valid = false;
        if (this.maximumErrors != -1 && this._noofErrors == this.maximumErrors) {
            this.completed = true;
        }
    }

    public void addError(String baseLocationPath, String relativeLocationPath, String errorCode, String errorMessage) {
        this.baseLocationPath = baseLocationPath;
        this.relativeLocationPath = relativeLocationPath;
        this.addError(errorCode, errorMessage);
    }

    public void addError(String errorCode, LocalizedMessage errorMessage) {
        Values error = new Values(4);
        error.put(PATH_NAME, this.baseLocationPath + SEPARATOR_PATH + this.relativeLocationPath);
        error.put(ERROR_CODE, errorCode);
        error.put(ERROR_MESSAGE, errorMessage.getLocalizedMessage(this.getLocale()));
        this._errors.addElement(error);
        this._noofErrors = this._errors.size();
        this.valid = false;
        if (this.maximumErrors != -1 && this._noofErrors == this.maximumErrors) {
            this.completed = true;
        }
    }

    public void addError(String baseLocationPath, String relativeLocationPath, String errorCode, LocalizedMessage errorMessage) {
        this.baseLocationPath = baseLocationPath;
        this.relativeLocationPath = relativeLocationPath;
        this.addError(errorCode, errorMessage);
    }

    Object getErrors() {
        if (this._noofErrors > 0) {
            Object[] vArray = new Values[this._noofErrors];
            this._errors.copyInto(vArray);
            return vArray;
        }
        return null;
    }

    public int getWorkspaceType() {
        return this._workspaceType;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    Locale getLocale() {
        return this.locale;
    }

    void setLocale(Locale locale) {
        this.locale = locale;
    }
}

