/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema;

import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSSchema;
import com.wm.lang.schema.ContentType;
import com.wm.lang.schema.W3CNamespaces;
import com.wm.lang.schema.WmComplexType;
import com.wm.lang.schema.conv.Context;
import com.wm.lang.schema.datatypev2.DatatypeRef;
import com.wm.lang.schema.util.HashSet;
import com.wm.lang.xml.ElementNodeBase;
import com.wm.lang.xml.TextNode;
import com.wm.soap.coder.SoapConstants;
import com.wm.util.Name;
import com.wm.util.QName;

public class Util {
    private static final boolean debug = false;
    protected static final HashSet ANY_TYPE_NAMES = Util.createAnyTypeNames();

    public static final void setSchemaTypeName(NSField field, QName stn) {
        Name ns;
        field.setSchemaTypeName(stn);
        if (stn != null && (ns = stn.getNamespaceName()) != null && ns == W3CNamespaces.WEBM_DEFAULT_NAMESPACE) {
            field.setSchemaTypeName(QName.create(null, stn.getLocalName()));
        }
    }

    public static final void setXmlNamespace(NSField field, Name xmlns) {
        if (xmlns == W3CNamespaces.WEBM_DEFAULT_NAMESPACE) {
            field.setXmlNamespace(null);
        } else {
            field.setXmlNamespace(xmlns);
        }
    }

    public static final String compose(TextNode[] tNodes) {
        StringBuffer sb = new StringBuffer();
        if (tNodes != null) {
            for (int i = 0; i < tNodes.length; ++i) {
                sb.append(tNodes[i].getText());
            }
        }
        return sb.toString();
    }

    public static final int getDimensions(String arraytype) {
        int dim = 1;
        int cnt = 1;
        int cntBracket = 0;
        if (arraytype != null) {
            char[] ca = arraytype.toCharArray();
            for (int i = 0; i < ca.length; ++i) {
                if (ca[i] == ',') {
                    ++cnt;
                    continue;
                }
                if (ca[i] != ']') continue;
                ++cntBracket;
            }
            if (cnt == 2) {
                dim = 2;
            } else if (cntBracket == 2) {
                dim = 2;
            }
        }
        return dim;
    }

    public static final void setDimensions(NSField nsf, String arraytype) {
        int dim = Util.getDimensions(arraytype);
        if (nsf.getType() != 1 && dim == 2) {
            dim = 1;
        }
        nsf.setDimensions(dim);
    }

    public static final String retrieveXSIType(ElementNodeBase node) {
        String type = node.getAttributeValue(Name.create("http://www.w3.org/2000/10/XMLSchema-instance"), Name.create("type"));
        if (type == null) {
            type = node.getAttributeValue(Name.create("http://www.w3.org/1999/XMLSchema-instance"), Name.create("type"));
        }
        if (type == null) {
            type = node.getAttributeValue(Name.create("http://www.w3.org/2001/XMLSchema-instance"), Name.create("type"));
        }
        return type;
    }

    private static final HashSet createAnyTypeNames() {
        HashSet names = new HashSet(2);
        names.add(QName.create("http://www.w3.org/2000/08/XMLSchema", "anyType"));
        names.add(QName.create("http://www.w3.org/2000/10/XMLSchema", "anyType"));
        names.add(QName.create("http://www.w3.org/2001/XMLSchema", "anyType"));
        return names;
    }

    public static final boolean isAnyTypeName(QName name) {
        if (name == null) {
            return false;
        }
        return ANY_TYPE_NAMES.contains(name);
    }

    static ContentType mapSoapEncDataTypeToXsdDataType(Context context, ContentType ct) {
        NSSchema schema;
        WmComplexType complexCtype;
        QName complexCtypeQName;
        if (ct.getType() == 2 && (complexCtypeQName = (complexCtype = (WmComplexType)ct).getQName()) != null && complexCtypeQName.getNamespaceName() == SoapConstants.SOAP_ENCODING_11_NS && (schema = (NSSchema)context.getNamespace().getNode(NSName.create("pub.schema.w3c:datatypes"))).containsSimpleType(complexCtypeQName.getNCName())) {
            return DatatypeRef.create(context.getNamespace(), QName.create(schema.getTargetNamespace(), complexCtypeQName.getNCName()));
        }
        return ct;
    }
}

