/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema;

import com.wm.data.IData;
import com.wm.lang.schema.ComplexType;
import com.wm.lang.schema.Schema;
import com.wm.lang.schema.SimpleType;
import com.wm.lang.schema.WmTag;
import com.wm.lang.schema.util.CodableHashtable;

public class SymbolSpace
extends CodableHashtable {
    Schema _owner;

    public SymbolSpace(Schema owner, IData values) {
        this._owner = owner;
        if (values != null) {
            this.setFromData(values);
        }
    }

    public SymbolSpace(Schema owner, int initialCapacity) {
        super(initialCapacity);
        this._owner = owner;
    }

    public void customize(Object o) {
        if (o instanceof WmTag) {
            WmTag tag = (WmTag)o;
            tag.setOwner(this._owner);
            tag.setIsInTopSymbolSpace();
        } else if (o instanceof SimpleType) {
            ((SimpleType)o).setOwner(this._owner);
        } else if (o instanceof ComplexType) {
            ((ComplexType)o).setOwner(this._owner);
        }
    }

    private void reverse(Object o) {
        if (o instanceof WmTag) {
            WmTag tag = (WmTag)o;
            tag.setOwner(null);
            tag.resetIsInTopSymbolSpace();
        } else if (o instanceof SimpleType) {
            ((SimpleType)o).setOwner(null);
        } else if (o instanceof ComplexType) {
            ((ComplexType)o).setOwner(null);
        }
    }

    public synchronized Object put(Object key, Object value) {
        this.customize(value);
        return super.put(key, value);
    }

    public synchronized Object remove(Object key) {
        Object o = super.remove(key);
        if (o != null) {
            this.reverse(o);
        }
        return o;
    }
}

