/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema;

import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSNode;
import com.wm.lang.ns.NSSchema;
import com.wm.lang.ns.Namespace;
import com.wm.lang.schema.ContentType;
import com.wm.lang.schema.DatatypeFactory;
import com.wm.lang.schema.SPLString;
import com.wm.lang.schema.Schema;
import com.wm.lang.schema.SchemaRegistry;
import com.wm.lang.schema.SimpleType;
import com.wm.lang.schema.util.HashSet;
import com.wm.util.QName;
import com.wm.util.sort.QuickSort;
import com.wm.util.sort.Sortable;
import java.util.Enumeration;
import java.util.Vector;

public class SimpleTypeUtil {
    private static final NSName DT = NSName.create("pub.schema.w3c:datatypes");
    private static final String ANONYMOUS = "#anonymous";
    private static final String OLD_REAL = "real";
    private static final String REAL = "real (deprecated)";
    private static final String SOMETHING = "something";
    private static final String SYS_TURN_OFF_CLONING_DATATYPES = "watt.core.schema.tempForEDI.turnOffCloningDatatypes";
    private static final QName QNAME_OF_URSIMPLETYPE = QName.create("http://www.w3.org/1999/XMLSchema", "urSimpleType");
    private static final String SUFFIX = "_customized";
    private static boolean _turnOffCloningDatatypes;
    private static boolean _readSystemProperties;
    private static String[] _cachedNames;

    public static final String getBuiltInSimpleTypeXMLNamespace() {
        return "http://www.w3.org/2001/XMLSchema";
    }

    public static final synchronized String[] getBuiltInSimpleTypeNames(Namespace ns) {
        boolean builtInSchemaExists = false;
        SchemaRegistry schemaRegistry = SchemaRegistry.current();
        if (schemaRegistry.containsKey(SimpleTypeUtil.getBuiltInSimpleTypeXMLNamespace())) {
            HashSet builtInXMLNamespace = (HashSet)schemaRegistry.get(SimpleTypeUtil.getBuiltInSimpleTypeXMLNamespace());
            builtInSchemaExists = builtInXMLNamespace.contains(DT);
        }
        Object[] strNames = null;
        if (builtInSchemaExists && _cachedNames != null) {
            strNames = new String[_cachedNames.length];
            System.arraycopy(_cachedNames, 0, strNames, 0, _cachedNames.length);
        } else {
            NSNode node = ns.getNode(DT);
            Vector<String> names = new Vector<String>();
            if (node != null && node.getNodeTypeObj().equals(NSSchema.TYPE)) {
                Schema schema = (Schema)((Object)node);
                Enumeration types = schema.types();
                while (types.hasMoreElements()) {
                    ContentType type = (ContentType)types.nextElement();
                    if (type.getType() != 1 || ((SimpleType)type).isAbstract()) continue;
                    names.addElement(type.getName());
                }
                names.removeElement("QName");
                names.removeElement("NOTATION");
                names.removeElement("derivationControl");
                names.removeElement("simpleDerivationSet");
                strNames = new String[names.size()];
                names.copyInto(strNames);
                strNames = SimpleTypeUtil.sort((String[])strNames);
                _cachedNames = strNames;
            }
        }
        return strNames;
    }

    public static final QName[] getQNamesOfBuiltInSimpleTypes(Namespace ns) {
        String[] strNames = SimpleTypeUtil.getBuiltInSimpleTypeNames(ns);
        QName[] qNames = new QName[strNames.length];
        for (int i = 0; i < strNames.length; ++i) {
            qNames[i] = QName.create(SimpleTypeUtil.getBuiltInSimpleTypeXMLNamespace(), strNames[i]);
        }
        return qNames;
    }

    public static final SimpleType create(Namespace ns, String targetName) {
        if (targetName == null) {
            return null;
        }
        QName target = QName.create("http://www.w3.org/2001/XMLSchema", targetName);
        return SimpleTypeUtil.create(ns, target);
    }

    public static final SimpleType create(Namespace ns, QName target) {
        if (SimpleTypeUtil.isSafe(ns, target)) {
            return DatatypeFactory.create(ns, target);
        }
        return null;
    }

    public static final SimpleType clone(Namespace ns, QName target) {
        if (SimpleTypeUtil.isSafe(ns, target)) {
            SimpleType simpleType = null;
            NSName[] qnames = SchemaRegistry.resolve(target.getNamespace());
            if (qnames != null) {
                Schema schema;
                NSNode node;
                for (int index = 0; !(index >= qnames.length || (node = ns.getNode(qnames[index])) != null && node.getNodeTypeObj().equals(NSSchema.TYPE) && (simpleType = (schema = (Schema)((Object)node)).getSimpleType(target.getNCName())) != null); ++index) {
                }
            }
            if (simpleType != null) {
                try {
                    return (SimpleType)simpleType.deepClone();
                }
                catch (Exception ex) {
                    return null;
                }
            }
        }
        return null;
    }

    private static final boolean isSafe(Namespace ns, QName target) {
        return ns != null && target != null && target.getNamespace() != null && target.getNCName() != null;
    }

    public static final SimpleType cloneSmartly(Namespace ns, SimpleType simpleType) throws Exception {
        QName targetName;
        String xmlns;
        if (simpleType.isProxy() && (xmlns = (targetName = DatatypeFactory.getTargetName(simpleType)).getNamespace()) == null) {
            return SimpleTypeUtil.createProxy(ns, DatatypeFactory.getTargetOwnerNSName(simpleType), targetName.getNCName());
        }
        return DatatypeFactory.create(ns, simpleType.getValues());
    }

    public static final SimpleType clone(Namespace ns, SimpleType simpleType) {
        return null;
    }

    private static final String[] sort(String[] s) {
        Sortable[] ss = new SPLString[s.length];
        for (int i = 0; i < s.length; ++i) {
            ss[i] = new SPLString(s[i]);
        }
        SPLString[] sr = (SPLString[])new QuickSort(ss).getItems();
        String[] rv = new String[s.length];
        for (int i = 0; i < s.length; ++i) {
            rv[i] = sr[i].getValue();
        }
        return rv;
    }

    private static final boolean turnOffCloningDatatypes() {
        if (!_readSystemProperties) {
            _turnOffCloningDatatypes = new Boolean(System.getProperty(SYS_TURN_OFF_CLONING_DATATYPES));
            _readSystemProperties = true;
        }
        return _turnOffCloningDatatypes;
    }

    public static final SimpleType deriveFrom(Namespace ns, QName target) {
        if (SimpleTypeUtil.isSafe(ns, target)) {
            SimpleType simpleType = null;
            NSName[] qnames = SchemaRegistry.resolve(target.getNamespace());
            if (qnames != null) {
                Schema schema;
                NSNode node;
                for (int index = 0; !(index >= qnames.length || (node = ns.getNode(qnames[index])) != null && node.getNodeTypeObj().equals(NSSchema.TYPE) && (simpleType = (schema = (Schema)((Object)node)).getSimpleType(target.getNCName())) != null); ++index) {
                }
            }
            if (simpleType != null) {
                return SimpleTypeUtil.createDerivedType(simpleType);
            }
        }
        return null;
    }

    public static final SimpleType deriveFrom(Namespace ns, NSName b2bQName, String ncName) {
        Schema schema;
        SimpleType temp;
        NSNode node = ns.getNode(b2bQName);
        SimpleType simpleType = null;
        if (node != null && node.getNodeTypeObj().equals(NSSchema.TYPE) && (temp = (schema = (Schema)((Object)node)).getSimpleType(ncName)) != null) {
            simpleType = temp;
        }
        if (simpleType != null) {
            return SimpleTypeUtil.createDerivedType(simpleType);
        }
        return null;
    }

    private static final SimpleType createDerivedType(SimpleType simpleType) {
        try {
            SimpleType derivedType = DatatypeFactory.deriveFrom(simpleType);
            derivedType.setName(derivedType.getName() + SUFFIX);
            return derivedType;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static final SimpleType deriveFrom(SimpleType simpleType) throws Exception {
        if (simpleType == null) {
            return null;
        }
        return DatatypeFactory.deriveFrom(simpleType);
    }

    public static final SimpleType createProxy(Namespace ns, QName target) {
        if (SimpleTypeUtil.isSafe(ns, target)) {
            return DatatypeFactory.create(ns, target);
        }
        return null;
    }

    public static final SimpleType createProxy(Namespace ns, NSName targetB2BQName, String targetNCName) {
        if (targetB2BQName != null) {
            return DatatypeFactory.createReference(ns, QName.create(null, targetNCName), targetB2BQName);
        }
        return null;
    }
}

