/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSSchema;
import com.wm.lang.schema.util.HashSet;
import com.wm.lang.schema.util.Iterator;
import java.util.Enumeration;
import java.util.Hashtable;

public final class SchemaRegistry
extends Hashtable {
    static final SchemaRegistry _sr = new SchemaRegistry();
    Hashtable _transient = new Hashtable();

    public static final SchemaRegistry current() {
        return _sr;
    }

    private SchemaRegistry() {
        super(11);
    }

    boolean registerInTransientSpace(String targetNS, NSName b2bQName) {
        if (targetNS == null || b2bQName == null) {
            return false;
        }
        if (this._transient.containsKey(targetNS)) {
            ((HashSet)this._transient.get(targetNS)).add(b2bQName);
        } else {
            HashSet names = new HashSet(1);
            names.add(b2bQName);
            this._transient.put(targetNS, names);
        }
        return true;
    }

    boolean unregisterFromTransientSpace(String targetNS, NSName b2bQName) {
        if (targetNS == null || b2bQName == null || !this._transient.containsKey(targetNS)) {
            return false;
        }
        HashSet names = (HashSet)this._transient.get(targetNS);
        if (names.size() > 1) {
            names.remove(b2bQName);
        } else {
            this._transient.remove(targetNS);
        }
        return true;
    }

    boolean containsInTransientSpace(String targetNS) {
        return this._transient.containsKey(targetNS);
    }

    NSName[] resolveFromTransientSpace(String targetNS) {
        if (!this.containsInTransientSpace(targetNS)) {
            return null;
        }
        HashSet names = (HashSet)this._transient.get(targetNS);
        Object[] nsNames = new NSName[names.size()];
        names.toArray(nsNames);
        return nsNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final synchronized boolean register(NSSchema schema) {
        NSSchema nSSchema = schema;
        synchronized (nSSchema) {
            boolean successful;
            String targetNS = schema.getTargetNamespace();
            if (targetNS == null) {
                return true;
            }
            boolean bl = successful = schema.isTransient() ? SchemaRegistry.current().registerInTransientSpace(targetNS, schema.getNSName()) : SchemaRegistry.register(targetNS, schema.getNSName());
            if (successful) {
                schema.setRegistration();
            }
            return successful;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final synchronized boolean unregister(NSSchema schema) {
        NSSchema nSSchema = schema;
        synchronized (nSSchema) {
            boolean successful;
            String targetNS = schema.getTargetNamespace();
            if (targetNS == null) {
                return true;
            }
            boolean bl = successful = schema.isTransient() ? SchemaRegistry.current().unregisterFromTransientSpace(targetNS, schema.getNSName()) : SchemaRegistry.unregister(targetNS, schema.getNSName());
            if (successful) {
                schema.clearRegistration();
            }
            return successful;
        }
    }

    static final synchronized boolean register(String targetNS, NSName b2bQName) {
        if (targetNS == null || b2bQName == null) {
            return false;
        }
        if (SchemaRegistry.current().containsKey(targetNS)) {
            ((HashSet)SchemaRegistry.current().get(targetNS)).add(b2bQName);
        } else {
            HashSet names = new HashSet(1);
            names.add(b2bQName);
            SchemaRegistry.current().put(targetNS, names);
        }
        return true;
    }

    static final synchronized boolean unregister(String targetNS, NSName b2bQName) {
        if (targetNS == null || b2bQName == null || !SchemaRegistry.current().containsKey(targetNS)) {
            return false;
        }
        HashSet names = (HashSet)SchemaRegistry.current().get(targetNS);
        if (names.size() > 1) {
            names.remove(b2bQName);
        } else {
            SchemaRegistry.current().remove(targetNS);
        }
        return true;
    }

    public static final synchronized NSName[] resolve(String targetNS) {
        if (SchemaRegistry.current().containsInTransientSpace(targetNS)) {
            return SchemaRegistry.current().resolveFromTransientSpace(targetNS);
        }
        if (!SchemaRegistry.current().containsKey(targetNS)) {
            return null;
        }
        HashSet names = (HashSet)SchemaRegistry.current().get(targetNS);
        NSName[] nsNames = new NSName[names.size()];
        Iterator it = names.iterator();
        int index = 0;
        while (it.hasNext()) {
            nsNames[index] = (NSName)it.next();
            ++index;
        }
        return nsNames;
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("List of registered targetNS\n\n");
        Enumeration keys = SchemaRegistry.current().keys();
        int index = 1;
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            sb.append("(" + index + ") targetNS=" + key + " resolves to {");
            HashSet names = (HashSet)SchemaRegistry.current().get(key);
            Iterator it = names.iterator();
            while (it.hasNext()) {
                sb.append(it.next() + " ");
            }
            sb.setCharAt(sb.length() - 1, '}');
            sb.append('\n');
            sb.append('\n');
            ++index;
        }
        return sb.toString();
    }

    public static synchronized void setIData(IData idata) {
        SchemaRegistry.current().clear();
        IDataCursor cursor = idata.getCursor();
        if (cursor.first()) {
            SchemaRegistry.current().put(cursor.getKey(), SchemaRegistry.StringArrayToNSNames((Object[])cursor.getValue()));
            while (cursor.next()) {
                SchemaRegistry.current().put(cursor.getKey(), SchemaRegistry.StringArrayToNSNames((Object[])cursor.getValue()));
            }
        }
    }

    public static synchronized IData getIData() {
        Object[][] table = new Object[SchemaRegistry.current().size()][2];
        Enumeration keys = SchemaRegistry.current().keys();
        int i = 0;
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            table[i][0] = key;
            table[i++][1] = SchemaRegistry.NSNamesToStringArray((HashSet)SchemaRegistry.current().get(key));
        }
        return IDataFactory.create(table);
    }

    private static final HashSet StringArrayToNSNames(Object[] objectArray) {
        HashSet set = new HashSet(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            set.add(NSName.create((String)objectArray[i]));
        }
        return set;
    }

    private static final String[] NSNamesToStringArray(HashSet set) {
        String[] strArray = new String[set.size()];
        Iterator it = set.iterator();
        int i = 0;
        while (it.hasNext()) {
            strArray[i++] = ((NSName)it.next()).toString();
        }
        return strArray;
    }

    public static void main(String[] args) {
        SchemaRegistry sr = SchemaRegistry.current();
        SchemaRegistry.register("http://www.w3.org/1999/Style/Transform", NSName.create("pub.w3c:transform"));
        SchemaRegistry.register("http://www.w3.org/1999/XHTML", NSName.create("pub.w3c:html"));
        SchemaRegistry.register("http://www.w3.org/1999/XMLSchema", NSName.create("pub.w3c:instance"));
        SchemaRegistry.register("http://www.w3.org/1999/XMLSchema", NSName.create("pub.w3c:structures"));
        SchemaRegistry.register("http://www.w3.org/1999/XMLSchema", NSName.create("pub.w3c:datatypes"));
        System.out.println(sr.toString());
        SchemaRegistry.unregister("http://www.w3.org/1999/XMLSchema", NSName.create("pub.w3c:datatypes"));
        System.out.println(sr.toString());
        System.out.println(sr.getIData());
        SchemaRegistry.setIData(sr.getIData());
        System.out.println(sr.toString());
    }
}

