/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema;

import com.wm.lang.schema.PooledPatternMatcher;
import com.wm.util.pool.ObjectPool;
import com.wm.util.pool.PooledObject;

public class PatternMatcherPool
extends ObjectPool {
    static final String SYS_PROP_MIN_SIZE = "watt.core.datatype.patternMatcherPool.minSize";
    static final String SYS_PROP_MAX_SIZE = "watt.core.datatype.patternMatcherPool.maxSize";
    static final String SYS_PROP_DELAY_FILL = "watt.core.datatype.patternMatcherPool.delayFill";
    static final String POOL_NAME = "Pattern Matcher Pool";
    static final int DEFAULT_MIN_POOL = 10;
    static final int DEFAULT_MAX_POOL = 50;
    static final boolean DEFAULT_DELAY_FILL = false;
    private static PatternMatcherPool _pmPool;

    public static final PatternMatcherPool current() {
        if (_pmPool == null) {
            _pmPool = PatternMatcherPool.create();
        }
        return _pmPool;
    }

    private PatternMatcherPool(int minPool, int maxPool, boolean delayFill) {
        super(minPool, maxPool, POOL_NAME, delayFill);
    }

    public PooledObject createObject() {
        return new PooledPatternMatcher(this);
    }

    private static final PatternMatcherPool create() {
        int minPoolSize = 10;
        int maxPoolSize = 50;
        boolean delayFill = false;
        String prop = System.getProperty(SYS_PROP_MIN_SIZE);
        if (prop != null) {
            try {
                minPoolSize = Integer.parseInt(prop);
            }
            catch (NumberFormatException ne) {
                // empty catch block
            }
        }
        if ((prop = System.getProperty(SYS_PROP_MAX_SIZE)) != null) {
            try {
                maxPoolSize = Integer.parseInt(prop);
            }
            catch (NumberFormatException ne) {
                // empty catch block
            }
        }
        if ((prop = System.getProperty(SYS_PROP_DELAY_FILL)) != null) {
            delayFill = new Boolean(prop);
        }
        return new PatternMatcherPool(minPoolSize, maxPoolSize, delayFill);
    }
}

