/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema;

import com.wm.data.IData;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSNode;
import com.wm.lang.ns.NSSchema;
import com.wm.lang.schema.ComplexType;
import com.wm.lang.schema.NodeWorkspace;
import com.wm.lang.schema.QNamePacket;
import com.wm.lang.schema.Schema;
import com.wm.lang.schema.SchemaRegistry;
import com.wm.lang.schema.TypeDef;
import com.wm.lang.schema.Util;
import com.wm.lang.schema.Validator;
import com.wm.lang.schema.WmComplexType;
import com.wm.lang.schema.WmComplexTypeRef;
import com.wm.lang.schema.WmElement;
import com.wm.lang.schema.resources.ValidationMessageBundle;
import com.wm.lang.schema.util.HashSet;
import com.wm.lang.schema.util.Iterator;
import com.wm.lang.xml.Document;
import com.wm.lang.xml.ElementNode;
import com.wm.lang.xml.ElementNodeBase;
import com.wm.lang.xml.Node;
import com.wm.lang.xml.TextNode;
import com.wm.lang.xml.WMDocumentException;
import com.wm.util.LocalizedMessage;
import com.wm.util.QName;
import java.util.Locale;
import java.util.Vector;

public class NodeValidator
extends Validator {
    NSSchema[] _schemas;
    boolean _nominated;
    ElementNodeBase _node;
    private static final int DO_NOTHING = 1;
    private static final int FROM_NOMINATED_SCHEMA = 2;
    private static final int FROM_RESOLVED_SCHEMA = 3;
    private static final int[] _retrieveFrom = new int[]{1, 1, 2, 2, 1, 3, 1, 3};

    public NodeValidator(ElementNodeBase node, NSSchema[] schemas, Locale aLocale) {
        if (schemas != null) {
            Vector<NSSchema> nominations = new Vector<NSSchema>();
            for (int i = 0; i < schemas.length; ++i) {
                if (schemas[i].getTargetNamespace() != null) continue;
                nominations.addElement(schemas[i]);
            }
            int count = nominations.size();
            if (count > 0) {
                this._schemas = new NSSchema[count];
                nominations.copyInto(this._schemas);
            }
        }
        this._nominated = this._schemas != null && this._schemas.length > 0;
        this._node = node;
        this._workspace = new NodeWorkspace(node, this.getLocale());
    }

    public NodeValidator(ElementNodeBase node, NSSchema[] schemas) {
        this(node, schemas, new Locale("", ""));
    }

    public NodeValidator(ElementNodeBase node) {
        this(node, null, new Locale("", ""));
    }

    public IData validate() throws WMDocumentException {
        ElementNodeBase node = null;
        boolean validateMultiRoot = Boolean.valueOf(System.getProperty("watt.core.validation.multipleRoot", "true"));
        if (this._node.getNodeType() == 9) {
            try {
                node = (ElementNodeBase)((Document)this._node).getFirstElement();
                if (this._node.isXML() && validateMultiRoot && node != null) {
                    for (Node nextNode = node.getNextSiblingWm(); nextNode != null; nextNode = nextNode.getNextSiblingWm()) {
                        if (nextNode.getNodeType() != 1) continue;
                        this._workspace.addError("", "", "NV-022", new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_DUPLICATE_ROOT_ELEMENT, null, nextNode.getLocalName().toString()));
                    }
                }
            }
            catch (WMDocumentException ex) {
                this._workspace.addError("", "", "NV-001", new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_ANGRY_PARSER, null, ex.getLocalizedMessage(this.getLocale())));
            }
            if (node == null) {
                this._workspace.addError("", "", "NV-002", new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_MISSING_ROOT_EII, null));
            }
        } else {
            node = this._node;
        }
        if (node != null) {
            QName name = QName.create(node.getNamespaceUri(), node.getLocalNameWm());
            WmElement elementDecl = this.retrieveElementDecl(name);
            if (elementDecl == null) {
                this._workspace.addError("", name.getNCName(), "NV-003", new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_MISSING_ELEMENT_DECL, null));
            }
            this.validate(node, elementDecl, "", false);
        }
        return NodeValidator.createResult(this._workspace.valid, this._workspace.getErrors(), this._workspace.verbose ? ((NodeWorkspace)this._workspace).sb.toString() : null);
    }

    private void validate(ElementNodeBase node, WmElement elementDecl, String baseLocationPath, boolean isLax) throws WMDocumentException {
        QNamePacket packet;
        ElementNode elementNode;
        if (this._workspace.completed) {
            return;
        }
        QName name = null;
        ComplexType complexType = null;
        int model = -1;
        WmElement currentElementDecl = null;
        Vector<QNamePacket> packets = null;
        Vector<Node> textNodes = null;
        if (elementDecl != null && (complexType = this.retrieveComplexType(elementDecl, node)) != null) {
            model = complexType.getContentModelType();
        }
        if (complexType == null || model != 6) {
            try {
                for (Node unknown = node.getFirstChildWm(); unknown != null && !this._workspace.completed; unknown = unknown.getNextSiblingWm()) {
                    short nodeType = unknown.getNodeType();
                    if (nodeType == 1) {
                        elementNode = (ElementNode)unknown;
                        name = QName.create(elementNode.getNamespaceUri(), elementNode.getLocalNameWm());
                        if (packets == null) {
                            packets = new Vector<QNamePacket>();
                        }
                        packet = QNamePacket.createPacket(name, elementNode);
                        packets.addElement(packet);
                        if (this._workspace.verbose) {
                            System.out.println("== Current EII is " + name);
                        }
                        if (complexType != null) {
                            currentElementDecl = this.retrieveElementDecl(packet, complexType);
                        } else if (elementDecl == null) {
                            currentElementDecl = this.retrieveElementDecl(name);
                        }
                        packet.setElementDeclaration(currentElementDecl);
                        continue;
                    }
                    if (nodeType != 3) continue;
                    if (textNodes == null) {
                        textNodes = new Vector<Node>(2);
                    }
                    textNodes.addElement(unknown);
                }
            }
            catch (WMDocumentException ex) {
                this._workspace.addError(baseLocationPath, node.getLocalNameWm().toString(), "NV-001", new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_ANGRY_PARSER, null, ex.getLocalizedMessage(this.getLocale())));
                if (this._workspace.verbose) {
                    ex.printStackTrace();
                }
                throw new WMDocumentException(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_ANGRY_PARSER, null, ex.getLocalizedMessage(this.getLocale()));
            }
            catch (Exception ex) {
                this._workspace.addError(baseLocationPath, node.getLocalNameWm().toString(), "NV-001", new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_ANGRY_PARSER, null, ex.getLocalizedMessage()));
                if (this._workspace.verbose) {
                    ex.printStackTrace();
                }
                throw new WMDocumentException(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_ANGRY_PARSER, null, ex.getLocalizedMessage());
            }
        }
        if (elementDecl != null && !this._workspace.completed) {
            block33: {
                NodeWorkspace workspace = (NodeWorkspace)this._workspace;
                Object[] qNames = null;
                int size = 0;
                if (packets != null) {
                    size = packets.size();
                    qNames = new QName[size + 1];
                    packets.copyInto(qNames);
                } else {
                    qNames = new QName[1];
                }
                qNames[size] = QName.END;
                workspace.childNames = qNames;
                Object[] tNodes = null;
                if (textNodes != null) {
                    tNodes = new TextNode[textNodes.size()];
                    textNodes.copyInto(tNodes);
                }
                workspace.tNodes = tNodes;
                workspace.setCurrentNode(node);
                try {
                    elementDecl.validate(node, workspace, baseLocationPath);
                }
                catch (Exception ex) {
                    if (!workspace.verbose) break block33;
                    ex.printStackTrace();
                }
            }
            workspace.childNames = null;
            workspace.attrNames = null;
            workspace.tNodes = null;
            workspace.ignoreNilValue = false;
        }
        if (packets != null) {
            int size = packets.size();
            for (int i = 0; i < size; ++i) {
                packet = (QNamePacket)packets.elementAt(i);
                name = packet.getQName();
                elementNode = packet.getElementNode();
                currentElementDecl = packet.getElementDeclaration();
                boolean localLax = false;
                if (packet.isMatchedByAny()) {
                    int processContents = packet.getProcessContents();
                    if (processContents == 1) continue;
                    if (currentElementDecl == null) {
                        currentElementDecl = this.retrieveElementDecl(name);
                    }
                    if (processContents == 2) {
                        if (currentElementDecl == null) {
                            localLax = true;
                        }
                    } else if (currentElementDecl == null) {
                        this._workspace.addError(baseLocationPath + "/" + node.getLocalNameWm().toString(), name.getNCName(), "NV-003", new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_MISSING_ELEMENT_DECL, null));
                        continue;
                    }
                } else {
                    if (!isLax && currentElementDecl == null && (this._nominated || name.getNamespace() != null)) {
                        this._workspace.addError(baseLocationPath + "/" + node.getLocalNameWm().toString(), name.getNCName(), "NV-003", new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_MISSING_ELEMENT_DECL, null));
                    }
                    if (isLax && currentElementDecl == null) {
                        localLax = true;
                    }
                }
                this.validate(elementNode, currentElementDecl, baseLocationPath + "/" + node.getLocalNameWm().toString(), localLax);
            }
        }
    }

    private WmElement retrieveElementDecl(QName name) {
        String URI2 = name.getNamespace();
        NSName[] resolvedNames = null;
        int action = URI2 != null ? 4 : 0;
        action += this._nominated ? 2 : 0;
        if (URI2 != null) {
            resolvedNames = SchemaRegistry.resolve(URI2);
            action += resolvedNames != null && resolvedNames.length > 0 ? 1 : 0;
        }
        switch (_retrieveFrom[action]) {
            case 2: {
                for (int i = 0; i < this._schemas.length; ++i) {
                    if (!this._schemas[i].containsElement(name.getNCName())) continue;
                    return this._schemas[i].getElement(name.getNCName());
                }
                return null;
            }
            case 3: {
                for (int i = 0; i < resolvedNames.length; ++i) {
                    Schema schema;
                    NSNode node = this._ns.getNode(resolvedNames[i]);
                    if (node == null || !node.getNodeTypeObj().equals(NSSchema.TYPE) || !(schema = (Schema)((Object)node)).containsElement(name.getNCName())) continue;
                    return schema.getElement(name.getNCName());
                }
                return null;
            }
        }
        return null;
    }

    private WmElement retrieveElementDecl(QNamePacket packet, ComplexType complexType) {
        QName name = packet.getQName();
        WmElement elementDecl = complexType.getElement(name);
        if (elementDecl != null) {
            return elementDecl;
        }
        elementDecl = this.retrieveElementDecl(name);
        if (elementDecl == null) {
            return null;
        }
        HashSet substitutableFor = elementDecl.getSubstitutableFor();
        if (substitutableFor == null) {
            return null;
        }
        WmElement equivElementDecl = null;
        QName equivClass = null;
        Iterator it = substitutableFor.iterator();
        while (it.hasNext() && (equivElementDecl = complexType.getElement(equivClass = (QName)it.next())) == null) {
        }
        if (equivElementDecl == null) {
            return null;
        }
        packet.setQName(equivClass);
        return elementDecl;
    }

    ComplexType retrieveComplexType(WmElement elementDecl, ElementNodeBase node) {
        ComplexType complexType;
        String typeRef = Util.retrieveXSIType(node);
        TypeDef type = (TypeDef)elementDecl.getType();
        ComplexType complexType2 = complexType = type != null && type.getType() == 2 ? (ComplexType)type : null;
        if (typeRef == null) {
            return complexType;
        }
        if (!type.isProxy()) {
            return null;
        }
        QName typeName = null;
        try {
            typeName = QName.computeQName(typeRef, node);
        }
        catch (Exception ex) {
            return null;
        }
        WmComplexType nominatedType = WmComplexType.create(typeName);
        nominatedType.setOwner(elementDecl.getOwner());
        if (!((WmComplexTypeRef)nominatedType).targetExists()) {
            return null;
        }
        return nominatedType;
    }

    public void setAcceptNil(boolean acceptNil) {
    }

    public boolean getAcceptNil() {
        return true;
    }
}

