/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataPortable;
import com.wm.data.IDataUtil;
import com.wm.lang.schema.All;
import com.wm.lang.schema.Any;
import com.wm.lang.schema.Choice;
import com.wm.lang.schema.ComplexType;
import com.wm.lang.schema.Empty;
import com.wm.lang.schema.Flat;
import com.wm.lang.schema.Mixed;
import com.wm.lang.schema.NodeWorkspace;
import com.wm.lang.schema.Production;
import com.wm.lang.schema.Schema;
import com.wm.lang.schema.Sequence;
import com.wm.lang.schema.SimpleModel;
import com.wm.lang.schema.Symbol;
import com.wm.lang.schema.W3CKeys;
import com.wm.lang.schema.resources.ValidationMessageBundle;
import com.wm.lang.schema.util.HashSet;
import com.wm.lang.schema.util.Iterator;
import com.wm.util.IntEnum;
import com.wm.util.LocalizedMessage;
import com.wm.util.QName;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public abstract class Model
implements ValuesCodable,
W3CKeys,
IDataPortable {
    static final int DEFAULT_MIN_OCCURS = 0;
    static final int DEFAULT_MAX_OCCURS = 1;
    public static final int ASTERISK = -1;
    static final QName SYMBOL_SEQUENCE = QName.create(null, "$$SEQUENCE");
    static final QName SYMBOL_CHOICE = QName.create(null, "$$CHOICE");
    static final QName SYMBOL_ALL = QName.create(null, "$$ALL");
    static final QName SYMBOL_ANY = QName.create(null, "$$ANY");
    static final QName SYMBOL_MIXED = QName.create(null, "$$MIXED");
    static final QName SYMBOL_EMPTY = QName.create(null, "$$EMPTY");
    protected static final QName SYMBOL_DUMMY = QName.create(null, "$$DUMMY");
    public static final String KEY_M_SYMBOL = "symbol";
    public static final String KEY_M_MODEL_TYPE = "modelType";
    public static final String KEY_IS_GLOBAL = "isGlobal";
    public static final String KEY_DT_IS_EXPANDED = "isExpanded";
    public static final int MODEL_SIMPLE = 1;
    public static final int MODEL_SEQUENCE = 2;
    public static final int MODEL_CHOICE = 3;
    public static final int MODEL_MIXED = 4;
    public static final int MODEL_ALL = 5;
    public static final int MODEL_UNKNOWN = 20;
    public static final int MODEL_ANY = 6;
    public static final int MODEL_EMPTY = 7;
    public static final int MODEL_DUMMY = 10;
    static final IntEnum modelEnum = new IntEnum(0);
    int _minOccurs = 0;
    int _maxOccurs = 0;
    QName _symbol;
    int _modelType;
    ComplexType _owner;
    boolean _isGlobal;
    boolean _isExpanded;
    public static final String SYS_PROP_MAX_OCCURS = "watt.core.schema.maxOccursThresholdValue";
    Object[][] _parsingTable;
    Symbol _startSymbol;
    Symbol _endSymbol;
    Hashtable _terminals;
    Vector _wildCardTerminals;
    private static final int LEFT = 0;
    private static final int RIGHT = 1;

    Model(QName symbol, int minOccurs, int maxOccurs, int modelType, ComplexType owner) {
        this._symbol = symbol;
        if (minOccurs >= 0 && (maxOccurs > -1 && maxOccurs >= minOccurs || maxOccurs == -1)) {
            this._minOccurs = minOccurs;
            this._maxOccurs = maxOccurs;
        }
        this._modelType = modelType;
        this._owner = owner;
    }

    Model(QName symbol, int modelType, ComplexType owner) {
        this(symbol, 0, 1, modelType, owner);
    }

    Model(IData values, ComplexType owner) {
        this._owner = owner;
        this.setFromData(values);
    }

    public int getType() {
        return this._modelType;
    }

    public ComplexType getOwner() {
        return this._owner;
    }

    public int getMinOccurs() {
        return this._minOccurs;
    }

    public int getMaxOccurs() {
        return this._maxOccurs;
    }

    public QName getSymbol() {
        String ns;
        Schema schema;
        if (this._isGlobal && this._symbol.getNamespace() == null && this._owner != null && (schema = this._owner.getOwner()) != null && (ns = schema.getTargetNamespace()) != null) {
            return QName.create(ns, this._symbol.getNCName());
        }
        return this._symbol;
    }

    void setOwner(ComplexType owner) {
        this._owner = owner;
    }

    public void setGlobal(boolean isGlobal) {
        if (this._modelType == 1) {
            this._isGlobal = isGlobal;
        }
    }

    public void setOccurrence(int minOccurs, int maxOccurs) {
        if (Model.isValid(minOccurs, maxOccurs)) {
            this._minOccurs = minOccurs;
            this._maxOccurs = maxOccurs;
        }
    }

    public static final boolean isValid(int minOccurs, int maxOccurs) {
        return minOccurs >= 0 && (maxOccurs > -1 && maxOccurs >= minOccurs || maxOccurs == -1);
    }

    public void setValues(Values values) {
        this._symbol = QName.create(values.getValues(KEY_M_SYMBOL));
        this._minOccurs = values.getInt("minOccurs", 0);
        String in = values.getString("maxOccurs");
        if (in.equals("*")) {
            this._maxOccurs = -1;
        } else {
            try {
                this._maxOccurs = Integer.parseInt(in);
            }
            catch (Exception e) {
                this._maxOccurs = 1;
            }
        }
        this._modelType = modelEnum.getInt(values.getString(KEY_M_MODEL_TYPE), 20);
        this._isGlobal = values.getBoolean(KEY_IS_GLOBAL);
        this._isExpanded = values.getBoolean(KEY_DT_IS_EXPANDED);
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{KEY_M_SYMBOL, this._symbol != null ? this._symbol.getValues() : null}, {"minOccurs", Integer.toString(this._minOccurs)}, {"maxOccurs", this._maxOccurs == -1 ? "*" : Integer.toString(this._maxOccurs)}, {KEY_M_MODEL_TYPE, modelEnum.getString(this._modelType, "unknown")}, {KEY_IS_GLOBAL, this._isGlobal ? new Boolean(true) : null}, {KEY_DT_IS_EXPANDED, this._isExpanded ? "true" : null}};
        return new Values(o);
    }

    public void setFromData(IData values) {
        IDataCursor ic = values.getCursor();
        this._symbol = QName.create((IData)IDataUtil.get(ic, KEY_M_SYMBOL));
        this._minOccurs = IDataUtil.getInt(ic, "minOccurs", 0);
        String in = IDataUtil.getString(ic, "maxOccurs");
        if (in.equals("*")) {
            this._maxOccurs = -1;
        } else {
            try {
                this._maxOccurs = Integer.parseInt(in);
            }
            catch (Exception e) {
                this._maxOccurs = 1;
            }
        }
        this._modelType = modelEnum.getInt(IDataUtil.getString(ic, KEY_M_MODEL_TYPE), 20);
        this._isGlobal = ic.first(KEY_IS_GLOBAL) ? IDataUtil.getBoolean(ic) : false;
        String isExpanded = IDataUtil.getString(ic, KEY_DT_IS_EXPANDED);
        this._isExpanded = isExpanded != null && isExpanded.equalsIgnoreCase("true");
        ic.destroy();
    }

    public IData getAsData() {
        Object[][] o = new Object[][]{{KEY_M_SYMBOL, this._symbol != null ? this._symbol.getAsData() : null}, {"minOccurs", Integer.toString(this._minOccurs)}, {"maxOccurs", this._maxOccurs == -1 ? "*" : Integer.toString(this._maxOccurs)}, {KEY_M_MODEL_TYPE, modelEnum.getString(this._modelType, "unknown")}, {KEY_IS_GLOBAL, this._isGlobal ? new Boolean(true) : null}, {KEY_DT_IS_EXPANDED, this._isExpanded ? "true" : null}};
        return IDataFactory.create(o);
    }

    public static final Model create(IData values, ComplexType owner) {
        IDataCursor ic = values.getCursor();
        int modelType = modelEnum.getInt(IDataUtil.getString(ic, KEY_M_MODEL_TYPE), 20);
        ic.destroy();
        switch (modelType) {
            case 1: {
                return SimpleModel.createSimpleModel(values, owner);
            }
            case 2: {
                return Sequence.createSequence(values, owner);
            }
            case 3: {
                return Choice.createChoice(values, owner);
            }
            case 4: {
                return Mixed.createMixed(values, owner);
            }
            case 5: {
                return All.createAll(values, owner);
            }
            case 6: {
                return Any.createAny(values, owner);
            }
            case 7: {
                return Empty.createEmpty(values, owner);
            }
        }
        return null;
    }

    public static final Model create(int modelType) {
        return Model.create(1, 1, modelType);
    }

    public static final Model create(int minOccurs, int maxOccurs, int modelType) {
        switch (modelType) {
            case 2: {
                return Sequence.createSequence(minOccurs, maxOccurs);
            }
            case 3: {
                return Choice.createChoice(minOccurs, maxOccurs);
            }
            case 4: {
                return Mixed.createMixed(minOccurs, maxOccurs);
            }
            case 5: {
                return All.createAll(minOccurs, maxOccurs);
            }
            case 6: {
                return Any.createAny(minOccurs, maxOccurs);
            }
            case 7: {
                return Empty.createEmpty();
            }
        }
        return null;
    }

    public static final Model create(String symbol, int minOccurs, int maxOccurs) {
        return SimpleModel.createSimpleModel(symbol, minOccurs, maxOccurs);
    }

    public static final Model create(QName symbol, int minOccurs, int maxOccurs) {
        return SimpleModel.createSimpleModel(symbol, minOccurs, maxOccurs);
    }

    public static final Model create(QName symbol) {
        return Model.create(symbol, 1, 1);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("minOccurs = " + this._minOccurs + ';');
        sb.append(" maxOccurs = " + this._maxOccurs + ';');
        sb.append(" symbol = [" + this._symbol + "];");
        sb.append(" modelType = " + modelEnum.getString(this._modelType, "unknown"));
        return sb.toString();
    }

    public Values getView() {
        Object[][] o = new Object[][]{{KEY_M_SYMBOL, this._symbol != null ? this._symbol.getView() : null}, {"minOccurs", Integer.toString(this._minOccurs)}, {"maxOccurs", this._maxOccurs == -1 ? "*" : Integer.toString(this._maxOccurs)}, {KEY_M_MODEL_TYPE, modelEnum.getString(this._modelType, "unknown")}};
        return new Values(o);
    }

    private int getPrivateMaxOccurs() {
        try {
            int temp = Integer.parseInt(System.getProperty(SYS_PROP_MAX_OCCURS));
            if (this._maxOccurs > temp) {
                return -1;
            }
            return this._maxOccurs;
        }
        catch (NumberFormatException ne) {
            return this._maxOccurs;
        }
    }

    Symbol getStartSymbol() {
        return this._startSymbol;
    }

    protected void setStartSymbol(Symbol symbol) {
        this._startSymbol = symbol;
    }

    synchronized Object[][] getParsingTable(NodeWorkspace workspace) {
        if (this._parsingTable == null) {
            this.createParsingTable(workspace);
        }
        return this._parsingTable;
    }

    protected abstract int computeLFGrammar(Vector var1, Hashtable var2, Vector var3, int var4);

    private void createParsingTable(NodeWorkspace workspace) {
        Vector productions = new Vector();
        this._terminals = new Hashtable();
        this._wildCardTerminals = new Vector();
        this._endSymbol = Symbol.create(QName.create(null, "$"), true);
        this._terminals.put(this._endSymbol.getID(), this._endSymbol);
        Hashtable terminalsMatchedByWildCard = null;
        this.computeLFGrammar(productions, this._terminals, this._wildCardTerminals, 0);
        if (this._wildCardTerminals.size() == 0) {
            this._wildCardTerminals = null;
        }
        if (this._wildCardTerminals != null) {
            terminalsMatchedByWildCard = Model.pitch(this._terminals, this._wildCardTerminals);
        }
        Object[] first = Model.computeFirst(productions, terminalsMatchedByWildCard, workspace);
        HashSet[] follow = Model.computeFollow(productions, first, this._startSymbol, this._endSymbol);
        this._parsingTable = Model.computeParsingTable(productions, this._terminals, this._wildCardTerminals, first, follow);
        if (workspace.verbose) {
            Model.dumpOutputs(productions, first, follow, this._terminals, this._wildCardTerminals, this._parsingTable, workspace);
        }
    }

    private static final Hashtable pitch(Hashtable terminals, Vector wildCardTerminals) {
        Hashtable<Object, Object> result = null;
        Object[] terms = new Symbol[terminals.size()];
        Object[] wcts = new Symbol[wildCardTerminals.size()];
        Model.toArray(terminals, terms);
        wildCardTerminals.copyInto(wcts);
        HashSet set = null;
        for (int i = 0; i < wcts.length; ++i) {
            for (int j = 0; j < terms.length; ++j) {
                if (!((Symbol)wcts[i]).equals(terms[j])) continue;
                if (result == null) {
                    result = new Hashtable<Object, Object>();
                }
                if ((set = (HashSet)result.get(wcts[i])) == null) {
                    set = new HashSet();
                }
                set.add(terms[j]);
                result.put(wcts[i], set);
            }
        }
        if (result == null) {
            return null;
        }
        Enumeration keys = result.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            set = (HashSet)result.get(key);
            Object[] symbolArray = new Symbol[set.size()];
            set.toArray(symbolArray);
            result.put(key, symbolArray);
        }
        return result;
    }

    protected static final void addToProductions(Symbol nonTerminal, Object[] alternatives, Vector productions) {
        Production production = new Production();
        nonTerminal.grammarIndex = productions.size();
        production.nonTerminal = nonTerminal;
        production.alternatives = alternatives;
        productions.addElement(production);
    }

    private static final void addToProductions(Stack stack, Vector productions) {
        while (!stack.empty()) {
            Production production = (Production)stack.pop();
            production.nonTerminal.grammarIndex = productions.size();
            productions.addElement(production);
        }
    }

    private static final void pushProductionToStack(Symbol nonTerminal, Object[] alternatives, Stack stack) {
        Production production = new Production();
        production.nonTerminal = nonTerminal;
        production.alternatives = alternatives;
        stack.push(production);
    }

    protected final int createProductions(Vector productions, int suffix, Symbol symbol) {
        Symbol S;
        Symbol S0;
        Stack stack = new Stack();
        int localSuffix = suffix;
        int sMaxOccurs = this.getPrivateMaxOccurs();
        if (this._minOccurs == sMaxOccurs) {
            switch (this._minOccurs) {
                case 1: {
                    this._startSymbol = symbol;
                    return suffix;
                }
            }
            this._startSymbol = Symbol.create("S" + localSuffix, false);
            Object[] alternatives = new Object[1];
            Symbol[] alternative = new Symbol[this._minOccurs];
            for (int i = 0; i < alternative.length; ++i) {
                alternative[i] = symbol;
            }
            alternatives[0] = alternative;
            Model.addToProductions(this._startSymbol, alternatives, productions);
            return localSuffix + 1;
        }
        if (sMaxOccurs == -1) {
            Symbol S02;
            switch (this._minOccurs) {
                case 0: {
                    this._startSymbol = Symbol.create("S" + localSuffix, false);
                    Object[] alternatives = new Object[2];
                    Symbol[] alternative = new Symbol[]{symbol, this._startSymbol};
                    alternatives[0] = alternative;
                    alternative = new Symbol[]{Symbol.create(null, true)};
                    alternatives[1] = alternative;
                    Model.addToProductions(this._startSymbol, alternatives, productions);
                    return localSuffix + 1;
                }
            }
            this._startSymbol = Symbol.create("S" + localSuffix, false);
            Object[] alternatives = new Object[1];
            Symbol[] alternative = new Symbol[this._minOccurs + 1];
            for (int i = 0; i < alternative.length - 1; ++i) {
                alternative[i] = symbol;
            }
            alternative[i] = S02 = Symbol.create("S" + ++localSuffix, false);
            alternatives[0] = alternative;
            Model.pushProductionToStack(this._startSymbol, alternatives, stack);
            alternatives = new Object[2];
            alternative = new Symbol[]{symbol, S02};
            alternatives[0] = alternative;
            alternative = new Symbol[]{Symbol.create(null, true)};
            alternatives[1] = alternative;
            Model.pushProductionToStack(S02, alternatives, stack);
            Model.addToProductions(stack, productions);
            return localSuffix + 1;
        }
        if (this._minOccurs == 0) {
            Symbol[] alternative;
            Object[] alternatives;
            Symbol S2;
            if (sMaxOccurs == 1) {
                this._startSymbol = Symbol.create("S" + localSuffix, false);
                Object[] alternatives2 = new Object[2];
                Symbol[] alternative2 = new Symbol[]{symbol};
                alternatives2[0] = alternative2;
                alternative2 = new Symbol[]{Symbol.create(null, true)};
                alternatives2[1] = alternative2;
                Model.addToProductions(this._startSymbol, alternatives2, productions);
                return localSuffix + 1;
            }
            Symbol previous = this._startSymbol = Symbol.create("S" + localSuffix, false);
            for (int i = 1; i < sMaxOccurs; ++i) {
                S2 = Symbol.create("S" + ++localSuffix, false);
                alternatives = new Object[2];
                alternative = new Symbol[]{symbol, S2};
                alternatives[0] = alternative;
                alternative = new Symbol[]{Symbol.create(null, true)};
                alternatives[1] = alternative;
                Model.pushProductionToStack(previous, alternatives, stack);
                previous = S2;
            }
            S2 = Symbol.create("S" + ++localSuffix, false);
            alternatives = new Object[2];
            alternative = new Symbol[]{symbol};
            alternatives[0] = alternative;
            alternative = new Symbol[]{Symbol.create(null, true)};
            alternatives[1] = alternative;
            Model.pushProductionToStack(previous, alternatives, stack);
            Model.addToProductions(stack, productions);
            return localSuffix + 1;
        }
        this._startSymbol = Symbol.create("S" + localSuffix, false);
        Object[] alternatives = new Object[1];
        Symbol[] alternative = new Symbol[this._minOccurs + 1];
        for (int i = 0; i < alternative.length - 1; ++i) {
            alternative[i] = symbol;
        }
        alternative[i] = S0 = Symbol.create("S" + ++localSuffix, false);
        alternatives[0] = alternative;
        Model.pushProductionToStack(this._startSymbol, alternatives, stack);
        Symbol previous = S0;
        int size = sMaxOccurs - this._minOccurs + 1;
        for (int j = 2; j < size; ++j) {
            S = Symbol.create("S" + ++localSuffix, false);
            alternatives = new Object[2];
            alternative = new Symbol[]{symbol, S};
            alternatives[0] = alternative;
            alternative = new Symbol[]{Symbol.create(null, true)};
            alternatives[1] = alternative;
            Model.pushProductionToStack(previous, alternatives, stack);
            previous = S;
        }
        S = Symbol.create("S" + ++localSuffix, false);
        alternatives = new Object[2];
        alternative = new Symbol[]{symbol};
        alternatives[0] = alternative;
        alternative = new Symbol[]{Symbol.create(null, true)};
        alternatives[1] = alternative;
        Model.pushProductionToStack(previous, alternatives, stack);
        Model.addToProductions(stack, productions);
        return localSuffix + 1;
    }

    private static final Object[] computeFirst(Vector productions, Hashtable matchingTerminals, NodeWorkspace workspace) {
        int size = productions.size();
        Object[] first = new Object[size];
        for (int i = 0; i < size; ++i) {
            Production production = (Production)productions.elementAt(i);
            first[i] = Model.computeFirst(production, productions, matchingTerminals, first, workspace);
        }
        return first;
    }

    private static final Symbol[] computeFirst(Production production, Vector productions, Hashtable matchingTerminals, Object[] first, NodeWorkspace workspace) {
        HashSet set = new HashSet();
        boolean nullFound = false;
        block0: for (int i = 0; i < production.alternatives.length; ++i) {
            Symbol[] alternative = (Symbol[])production.alternatives[i];
            for (int j = 0; j < alternative.length; ++j) {
                Symbol currentSymbol = alternative[j];
                if (currentSymbol == Symbol.NULL) {
                    set.add(currentSymbol);
                    continue;
                }
                if (currentSymbol == production.nonTerminal) {
                    if (workspace.verbose) {
                        StringBuffer sb = workspace.sb;
                        sb.append("Left factored grammar is \n");
                        int size = productions.size();
                        for (int z = 0; z < size; ++z) {
                            sb.append(productions.elementAt(z).toString());
                            sb.append('\n');
                        }
                        sb.append("Throwing Runtime Exception\n\n");
                    }
                    throw new RuntimeException("Ambiguous content model in schema - not LL(1)");
                }
                if (currentSymbol.isTerminal()) {
                    Symbol[] terminalsMatchingWildCard;
                    set.add(currentSymbol);
                    if (!currentSymbol.isWildCard() || matchingTerminals == null || (terminalsMatchingWildCard = (Symbol[])matchingTerminals.get(currentSymbol)) == null) continue block0;
                    for (int l = 0; l < terminalsMatchingWildCard.length; ++l) {
                        set.add(terminalsMatchingWildCard[l]);
                    }
                    continue block0;
                }
                Symbol[] firstOfNonTerminal = (Symbol[])first[currentSymbol.grammarIndex];
                nullFound = false;
                for (int k = 0; k < firstOfNonTerminal.length; ++k) {
                    set.add(firstOfNonTerminal[k]);
                    if (firstOfNonTerminal[k] != Symbol.NULL) continue;
                    nullFound = true;
                }
                if (!nullFound) continue block0;
            }
        }
        Object[] f = new Symbol[set.size()];
        return (Symbol[])set.toArray(f);
    }

    private static final HashSet[] computeFollow(Vector productions, Object[] first, Symbol startSymbol, Symbol endSymbol) {
        Symbol symbol;
        int size = productions.size();
        HashSet[] follow = new HashSet[size];
        if (size - 1 >= 0) {
            symbol = ((Production)productions.elementAt((int)(size - 1))).nonTerminal;
            if (symbol == startSymbol) {
                HashSet set = new HashSet();
                set.add(endSymbol);
                follow[symbol.grammarIndex] = set;
            }
        } else {
            return null;
        }
        for (int i = size - 1; i >= 0; --i) {
            Production production = (Production)productions.elementAt(i);
            for (int j = 0; j < production.alternatives.length; ++j) {
                Symbol[] alternative = (Symbol[])production.alternatives[j];
                for (int k = 0; k < alternative.length; ++k) {
                    symbol = alternative[k];
                    if (symbol.isTerminal()) continue;
                    if (k == alternative.length - 1) {
                        Model.applyRule3(production.nonTerminal, symbol, follow);
                        continue;
                    }
                    Model.applyRule2(production.nonTerminal, symbol, k, alternative, first, follow);
                }
            }
        }
        return follow;
    }

    private static final void applyRule3(Symbol A, Symbol B, HashSet[] follow) {
        HashSet followA = follow[A.grammarIndex];
        HashSet followB = follow[B.grammarIndex];
        if (followA == null) {
            return;
        }
        if (followB == null) {
            followB = new HashSet();
        }
        Iterator it = followA.iterator();
        while (it.hasNext()) {
            followB.add(it.next());
        }
        follow[B.grammarIndex] = followB;
    }

    private static final void applyRule2(Symbol A, Symbol B, int positionOfB, Symbol[] production, Object[] first, HashSet[] follow) {
        HashSet firstOfBeta = Model.computeFirst(positionOfB + 1, production, first);
        if (firstOfBeta == null) {
            return;
        }
        HashSet followB = follow[B.grammarIndex];
        boolean nullFound = false;
        if (followB == null) {
            followB = new HashSet();
        }
        Iterator it = firstOfBeta.iterator();
        while (it.hasNext()) {
            Object symbol = it.next();
            if (symbol == Symbol.NULL) {
                nullFound = true;
                continue;
            }
            followB.add(symbol);
        }
        follow[B.grammarIndex] = followB;
        if (nullFound) {
            Model.applyRule3(A, B, follow);
        }
    }

    private static final HashSet computeFirst(int startIndex, Symbol[] production, Object[] first) {
        boolean nullInAllXi = true;
        HashSet set = new HashSet();
        for (int i = startIndex; i < production.length; ++i) {
            if (production[i].isTerminal()) {
                set.add(production[i]);
                nullInAllXi = false;
                break;
            }
            Symbol[] firstXi = (Symbol[])first[production[i].grammarIndex];
            boolean nullFound = false;
            for (int j = 0; j < firstXi.length; ++j) {
                if (firstXi[j] == Symbol.NULL) {
                    nullFound = true;
                    continue;
                }
                set.add(firstXi[j]);
            }
            boolean bl = nullInAllXi = nullInAllXi && nullFound;
            if (!nullFound) break;
        }
        if (nullInAllXi) {
            set.add(Symbol.NULL);
        }
        return set.size() > 0 ? set : null;
    }

    private static final Object[][] computeParsingTable(Vector productions, Hashtable terminals, Vector wildCardTerminals, Object[] first, HashSet[] follow) {
        int productionSize = productions.size();
        Object[][] parsingTable = new Object[productionSize][terminals.size() + (wildCardTerminals != null ? wildCardTerminals.size() : 0)];
        int index = 0;
        Enumeration<Object> enumvar = terminals.elements();
        while (enumvar.hasMoreElements()) {
            ((Symbol)enumvar.nextElement()).parsingTableIndex = index++;
        }
        if (wildCardTerminals != null) {
            enumvar = wildCardTerminals.elements();
            while (enumvar.hasMoreElements()) {
                ((Symbol)enumvar.nextElement()).parsingTableIndex = index++;
            }
        }
        for (int i = 0; i < productionSize; ++i) {
            Production production = (Production)productions.elementAt(i);
            production.nonTerminal.parsingTableIndex = production.nonTerminal.grammarIndex;
            for (int j = 0; j < production.alternatives.length; ++j) {
                HashSet currentFirst = Model.computeFirst(0, (Symbol[])production.alternatives[j], first);
                Iterator itFirst = currentFirst.iterator();
                while (itFirst.hasNext()) {
                    Symbol terminalFirst = (Symbol)itFirst.next();
                    if (terminalFirst == Symbol.NULL) {
                        HashSet currentFollow = follow[production.nonTerminal.grammarIndex];
                        Iterator itFollow = currentFollow.iterator();
                        while (itFollow.hasNext()) {
                            Symbol terminalFollow = (Symbol)itFollow.next();
                            parsingTable[production.nonTerminal.parsingTableIndex][terminalFollow.parsingTableIndex] = production.alternatives[j];
                        }
                        continue;
                    }
                    parsingTable[production.nonTerminal.parsingTableIndex][terminalFirst.parsingTableIndex] = production.alternatives[j];
                }
            }
        }
        return parsingTable;
    }

    void validate(QName[] input, NodeWorkspace workspace, String baseLocationPath) {
        this.validate(input, workspace, baseLocationPath, true);
    }

    void validate(QName[] input, NodeWorkspace workspace, String baseLocationPath, boolean reportErrors) {
        Stack stack = workspace.stack;
        Object[][] parsingTable = this.getParsingTable(workspace);
        QName[] inputBuffer = input;
        if (inputBuffer == null) {
            QName[] dummyBuffer = new QName[]{QName.create(null, "$")};
            inputBuffer = dummyBuffer;
        }
        stack.push(this._endSymbol);
        stack.push(this._startSymbol);
        Symbol stackSymbol = this._startSymbol;
        int ip = 0;
        while (ip < inputBuffer.length && stackSymbol != null) {
            QName inputSymbol = inputBuffer[ip];
            if (workspace.verbose) {
                workspace.sb.append("ip=" + ip + " input symbol=" + inputSymbol + ", stack symbol=" + stackSymbol + '\n');
            }
            if (stackSymbol.isTerminal()) {
                if (!stackSymbol.equals(inputSymbol)) break;
                stackSymbol.contribute(inputSymbol);
                stack.pop();
                ++ip;
            } else {
                Symbol[] production;
                int indexOf;
                Symbol terminal = (Symbol)this._terminals.get(inputSymbol);
                if (terminal == null && this._wildCardTerminals != null && (indexOf = this._wildCardTerminals.indexOf(inputSymbol)) > -1) {
                    terminal = (Symbol)this._wildCardTerminals.elementAt(indexOf);
                }
                if (terminal == null || (production = (Symbol[])parsingTable[stackSymbol.parsingTableIndex][terminal.parsingTableIndex]) == null) break;
                stack.pop();
                for (int i = production.length - 1; i >= 0; --i) {
                    if (production[i] == Symbol.NULL) continue;
                    stack.push(production[i]);
                }
            }
            if (stack.size() > 0) {
                stackSymbol = (Symbol)stack.peek();
                continue;
            }
            stackSymbol = null;
        }
        if (reportErrors && (ip != inputBuffer.length || stackSymbol != null)) {
            if (ip < inputBuffer.length - 1) {
                Model.reportError(baseLocationPath, ip, inputBuffer[ip], workspace);
            }
            if (ip == inputBuffer.length - 1 && stackSymbol != null) {
                workspace.addError(baseLocationPath, "", "NV-009", new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_INVALID_CONTENTMODEL2, null));
            }
        }
        if (workspace.verbose) {
            workspace.sb.append("Exit-on Stack Symbol is " + stackSymbol + " & ");
            workspace.sb.append("Exit-on input buffer pointer is " + ip + '\n');
        }
        workspace.ip = ip;
        stack.removeAllElements();
    }

    public int validate(QName[] input) {
        return this.validate(input, true);
    }

    public int validate(QName[] input, boolean reportErrors) {
        NodeWorkspace wkspace = new NodeWorkspace();
        this.validate(input, wkspace, "null", reportErrors);
        return wkspace.ip;
    }

    private static final void reportError(String baseLocationPath, int ip, QName symbol, NodeWorkspace workspace) {
        String ns = symbol.getNamespace();
        if (ns == null) {
            ns = "";
        }
        String sName = symbol.getNCName() + " {" + ns + "}";
        Object[] subs = new Object[]{sName, new Integer(ip)};
        workspace.addError(baseLocationPath, "", "NV-009", new LocalizedMessage(ValidationMessageBundle.class, ValidationMessageBundle.MESSAGE_INVALID_CONTENTMODEL, null, subs));
    }

    private static final void dumpOutputs(Vector productions, Object[] first, HashSet[] follow, Hashtable terms, Vector wildCardTerminals, Object[][] parsingTable, NodeWorkspace workspace) {
        Object[] terminals;
        StringBuffer sb = workspace.sb;
        sb.append("Left factored grammar is \n");
        int size = productions.size();
        for (int i = 0; i < size; ++i) {
            sb.append(productions.elementAt(i).toString());
            sb.append('\n');
        }
        sb.append('\n');
        for (int i = 0; i < first.length; ++i) {
            Symbol[] set = (Symbol[])first[i];
            sb.append("First (");
            sb.append(((Production)productions.elementAt((int)i)).nonTerminal);
            sb.append(") -> ");
            for (int j = 0; j < set.length; ++j) {
                sb.append(set[j]);
                if (j + 1 >= set.length) continue;
                sb.append(" | ");
            }
            sb.append('\n');
        }
        sb.append('\n');
        for (int i = 0; i < follow.length; ++i) {
            HashSet followI = follow[i];
            sb.append("Follow (");
            sb.append(((Production)productions.elementAt((int)i)).nonTerminal);
            sb.append(") -> ");
            if (followI != null) {
                Iterator it = followI.iterator();
                while (it.hasNext()) {
                    sb.append(it.next());
                    if (!it.hasNext()) continue;
                    sb.append(" | ");
                }
            }
            sb.append('\n');
        }
        sb.append('\n');
        if (wildCardTerminals != null) {
            terminals = new Symbol[terms.size() + wildCardTerminals.size()];
            Object[] temp1 = new Symbol[terms.size()];
            Object[] temp2 = new Symbol[wildCardTerminals.size()];
            Model.toArray(terms, temp1);
            wildCardTerminals.copyInto(temp2);
            Model.merge(temp1, temp2, terminals);
        } else {
            terminals = new Symbol[terms.size()];
            Model.toArray(terms, terminals);
        }
        for (int i = 0; i < parsingTable.length; ++i) {
            for (int j = 0; j < parsingTable[i].length; ++j) {
                sb.append('M');
                sb.append('[');
                sb.append(((Production)productions.elementAt((int)i)).nonTerminal);
                sb.append(',');
                sb.append(' ');
                sb.append(terminals[j]);
                sb.append(']');
                sb.append('\t');
                Symbol[] prod = (Symbol[])parsingTable[i][j];
                if (prod != null) {
                    for (int k = 0; k < prod.length; ++k) {
                        sb.append(prod[k]);
                        sb.append(' ');
                    }
                } else {
                    sb.append("$ERROR");
                }
                sb.append('\n');
            }
        }
        sb.append('\n');
    }

    public Object deepClone() {
        IData values = this.getAsData();
        Model clone = Model.create(values, this.getOwner());
        return clone;
    }

    private static final void toArray(Hashtable ht, Object[] oArray) {
        Enumeration enumvar = ht.elements();
        for (int i = 0; enumvar.hasMoreElements() && i < oArray.length; ++i) {
            oArray[i] = enumvar.nextElement();
        }
    }

    private static final void merge(Object[] a1, Object[] a2, Object[] result) {
        if (a1 == null || a2 == null || result == null) {
            return;
        }
        if (result.length != a1.length + a2.length) {
            return;
        }
        System.arraycopy(a1, 0, result, 0, a1.length);
        System.arraycopy(a2, 0, result, a1.length, a2.length);
    }

    abstract Flat[] getFlattenedModel();

    public void setExpanded(boolean isExpanded) {
        this._isExpanded = isExpanded;
    }

    public boolean isExpanded() {
        return this._isExpanded;
    }

    public static void main(String[] args) {
        Model model = Model.create(1, 1, 2);
        Flat[] flatArray = model.getFlattenedModel();
        System.out.println(flatArray.length);
        for (int i = 0; i < flatArray.length; ++i) {
            Flat flat = flatArray[i];
            System.out.println(((Object)flat).toString());
        }
    }

    static {
        modelEnum.addInt("simple", 1);
        modelEnum.addInt("sequence", 2);
        modelEnum.addInt("choice", 3);
        modelEnum.addInt("mixed", 4);
        modelEnum.addInt("all", 5);
        modelEnum.addInt("any", 6);
        modelEnum.addInt("empty", 7);
        modelEnum.addInt("unknown", 20);
    }
}

