/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSException;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.Namespace;
import com.wm.lang.schema.Keys;
import com.wm.lang.schema.SimpleType;
import com.wm.lang.schema.datatype.WmList;
import com.wm.lang.schema.datatypev2.Datatype;
import com.wm.lang.schema.datatypev2.DatatypeRef;
import com.wm.lang.schema.datatypev2.WmUnion;
import com.wm.util.Name;
import com.wm.util.QName;

public class DatatypeFactory
implements Keys {
    static final Name APRIL = Name.create("http://www.w3.org/1999/XMLSchema");
    static final Name OCTOBER = Name.create("http://www.w3.org/2000/10/XMLSchema");
    static final Name SEPTEMBER = Name.create("http://www.w3.org/2000/08/XMLSchema");

    public static SimpleType create(Name nsuri, String primitiveTypeName) throws NSException {
        if (nsuri != null) {
            if (nsuri == APRIL || nsuri == OCTOBER || nsuri == SEPTEMBER) {
                return com.wm.lang.schema.datatype.Datatype.create(primitiveTypeName);
            }
            return Datatype.create(primitiveTypeName);
        }
        return null;
    }

    public static SimpleType createReference(Name nsuri, QName typeName) {
        if (nsuri != null) {
            if (nsuri == APRIL || nsuri == OCTOBER || nsuri == SEPTEMBER) {
                return new com.wm.lang.schema.datatype.DatatypeRef(typeName);
            }
            return new DatatypeRef(typeName);
        }
        return null;
    }

    public static SimpleType createReference(Namespace b2bns, QName target, NSName targetB2BQName) {
        return DatatypeRef.create(b2bns, target, targetB2BQName);
    }

    public static SimpleType createList(Name nsuri, QName typeName) {
        if (nsuri != null) {
            if (nsuri == APRIL || nsuri == OCTOBER || nsuri == SEPTEMBER) {
                return new WmList(typeName);
            }
            return new com.wm.lang.schema.datatypev2.WmList(typeName);
        }
        return null;
    }

    public static SimpleType createUnion(Name nsuri, QName[] typeNames) {
        if (nsuri != null) {
            if (nsuri == APRIL || nsuri == OCTOBER || nsuri == SEPTEMBER) {
                return new com.wm.lang.schema.datatype.WmUnion(typeNames);
            }
            return new WmUnion(typeNames);
        }
        return null;
    }

    public static SimpleType create(Namespace ns, IData val) throws NSException {
        IDataCursor ic = val.getCursor();
        String uriString = IDataUtil.getString(ic, "dataTypeVersion");
        ic.destroy();
        try {
            if (uriString == null) {
                return com.wm.lang.schema.datatype.Datatype.create(ns, val);
            }
            if (uriString.equals("dtVersion2")) {
                return Datatype.create(ns, val);
            }
        }
        catch (NSException e) {
            throw new NSException(e.toString());
        }
        return null;
    }

    public static SimpleType create(IData val) throws NSException {
        IDataCursor ic = val.getCursor();
        String uriString = IDataUtil.getString(ic, "dataTypeVersion");
        ic.destroy();
        try {
            if (uriString == null) {
                return com.wm.lang.schema.datatype.Datatype.create(val);
            }
            if (uriString.equals("dtVersion2")) {
                return Datatype.create(val);
            }
        }
        catch (NSException e) {
            throw new NSException(e.toString());
        }
        return null;
    }

    public static SimpleType create(Namespace ns, QName target) {
        return Datatype.create(ns, target);
    }

    public static final SimpleType deriveFrom(SimpleType datatype) throws NSException {
        if (datatype instanceof Datatype) {
            return Datatype.deriveFrom(datatype);
        }
        return com.wm.lang.schema.datatype.Datatype.deriveFrom(datatype);
    }

    public static final NSName getTargetOwnerNSName(SimpleType dt) throws NSException {
        if (!dt.isProxy()) {
            return null;
        }
        if (dt.getVersion().equals("dtVersion2")) {
            DatatypeRef ref = (DatatypeRef)dt;
            return ref.getTargetOwnerNSName();
        }
        com.wm.lang.schema.datatype.DatatypeRef ref2 = (com.wm.lang.schema.datatype.DatatypeRef)dt;
        return ref2.getTargetOwnerNSName();
    }

    public static final QName getTargetName(SimpleType dt) throws NSException {
        if (!dt.isProxy()) {
            return null;
        }
        if (dt.getVersion().equals("dtVersion2")) {
            DatatypeRef ref = (DatatypeRef)dt;
            return ref.getTargetName();
        }
        com.wm.lang.schema.datatype.DatatypeRef ref2 = (com.wm.lang.schema.datatype.DatatypeRef)dt;
        return ref2.getTargetName();
    }
}

