/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSContentType;
import com.wm.lang.ns.NSDatatype;
import com.wm.lang.ns.NSException;
import com.wm.lang.ns.NSSchema;
import com.wm.lang.ns.NSType;
import com.wm.lang.ns.Namespace;
import com.wm.lang.schema.ContentType;
import com.wm.lang.schema.DatatypeFactory;
import com.wm.lang.schema.WmComplexType;

public class ContentTypeFactory {
    static final String CONTENT_TYPE = "contentType";

    public static final ContentType create(Namespace ns, IData values) {
        ContentTypeFactory.handleMigration(values);
        IDataCursor ic = values.getCursor();
        int contentType = IDataUtil.getInt(ic, CONTENT_TYPE, -1);
        switch (contentType) {
            case 1: {
                NSType nodeType = NSType.create(IDataUtil.getString(ic, "node_type"));
                try {
                    if (nodeType.equals(NSContentType.TYPE) || nodeType.equals(NSDatatype.TYPE)) {
                        return NSDatatype.create(ns, values);
                    }
                    return DatatypeFactory.create(ns, values);
                }
                catch (NSException nse) {
                    return null;
                }
            }
            case 2: {
                return WmComplexType.create(null, values);
            }
            case 3: {
                return NSSchema.create(ns, values);
            }
        }
        return null;
    }

    static final void handleMigration(IData values) {
        IDataCursor ic = values.getCursor();
        int contentType = IDataUtil.getInt(ic, CONTENT_TYPE, -1);
        if (contentType == 1 || contentType == 2 || contentType == 3) {
            return;
        }
        IDataUtil.put(ic, CONTENT_TYPE, Integer.toString(1));
        IDataUtil.put(ic, "internalType", "instance");
        ic.destroy();
    }
}

