/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema;

import com.wm.data.IData;
import com.wm.lang.schema.ComplexModel;
import com.wm.lang.schema.ComplexType;
import com.wm.lang.schema.Flat;
import com.wm.lang.schema.Model;
import com.wm.lang.schema.NodeWorkspace;
import com.wm.lang.schema.NonTerminal;
import com.wm.lang.schema.Symbol;
import com.wm.lang.schema.W3CKeys;
import com.wm.util.QName;
import com.wm.util.coder.ValuesCodable;
import java.util.Hashtable;
import java.util.Vector;

public class Choice
extends ComplexModel
implements ValuesCodable,
W3CKeys {
    Choice(int minOccurs, int maxOccurs, ComplexType owner) {
        super(SYMBOL_CHOICE, minOccurs, maxOccurs, 3, owner);
    }

    Choice(ComplexType owner) {
        this(0, 1, owner);
    }

    protected Choice(QName symbol, int minOccurs, int maxOccurs, int modelType, ComplexType owner) {
        super(symbol, minOccurs, maxOccurs, modelType, owner);
    }

    public static final Choice createChoice(IData values, ComplexType owner) {
        Choice choice = new Choice(owner);
        choice.setFromData(values);
        return choice;
    }

    public static final Choice createChoice(int minOccurs, int maxOccurs) {
        return new Choice(minOccurs, maxOccurs, null);
    }

    void pushProduction(NodeWorkspace workspace) {
    }

    boolean pushProduction(QName prefix, NonTerminal symbol, NodeWorkspace workspace) {
        return true;
    }

    protected int computeLFGrammar(Vector productions, Hashtable terminals, Vector wildCardTerminals, int suffix) {
        Object[] alternatives;
        int localSuffix = super.computeLFGrammar(productions, terminals, wildCardTerminals, suffix);
        Symbol nonTerminal = Symbol.create("S" + localSuffix, false);
        ++localSuffix;
        int size = this._children.size();
        if (size > 0) {
            alternatives = new Object[this._children.size()];
            for (int i = 0; i < size; ++i) {
                Symbol[] alternative = new Symbol[]{((Model)this._children.elementAt(i)).getStartSymbol()};
                alternatives[i] = alternative;
            }
        } else {
            alternatives = new Object[1];
            Symbol[] alternative = new Symbol[]{Symbol.NULL};
            alternatives[0] = alternative;
        }
        Choice.addToProductions(nonTerminal, alternatives, productions);
        if (size > 0) {
            return this.createProductions(productions, localSuffix, nonTerminal);
        }
        this.setStartSymbol(nonTerminal);
        return localSuffix;
    }

    Flat[] getFlattenedModel() {
        Vector temp = new Vector();
        int minO = this.getMinOccurs();
        int maxO = this.getMaxOccurs();
        for (int i = 0; i < this._children.size(); ++i) {
            Model model = (Model)this._children.elementAt(i);
            int type = model.getType();
            Flat[] tempArray = model.getFlattenedModel();
            Choice.mergeChoiceName(temp, tempArray, type);
        }
        Flat[] flatArray = Choice.convertToFlatArray(temp);
        temp.removeAllElements();
        return Choice.updradeChoiceChild(flatArray, minO, maxO);
    }
}

