/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema;

import com.wm.lang.schema.QNamePacket;
import com.wm.lang.schema.Symbol;
import com.wm.lang.schema.util.HashSet;
import com.wm.lang.schema.util.Iterator;
import com.wm.util.QName;
import com.wm.util.QNameComparable;

class AnySymbol
extends Symbol
implements QNameComparable {
    int _qualifier;
    HashSet _uris;
    int _processContents;

    protected AnySymbol(Object id, int qualifier, HashSet uris, int processContents) {
        super(id, true);
        this._qualifier = qualifier;
        this._uris = uris;
        this._processContents = processContents;
    }

    public boolean isWildCard() {
        return true;
    }

    public boolean equals(Object lhs) {
        if (this == lhs) {
            return true;
        }
        if (lhs instanceof QName) {
            if (lhs == QName.END) {
                return false;
            }
            QName name = (QName)lhs;
            return this.matches(name);
        }
        if (lhs instanceof AnySymbol) {
            AnySymbol symbol = (AnySymbol)lhs;
            if (symbol._qualifier == this._qualifier && symbol._processContents == this._processContents && this.areTheyEqual(symbol._uris, this._uris)) {
                return true;
            }
        } else if (lhs instanceof Symbol) {
            Symbol symbol = (Symbol)lhs;
            QName id = (QName)symbol.getID();
            return this.equals(id);
        }
        return false;
    }

    private boolean matches(QName name) {
        if (this._qualifier == 0) {
            return true;
        }
        String ns = name.getNamespace();
        if (ns == null) {
            ns = "$$unqualified";
        }
        if (this._qualifier == 1) {
            return !this._uris.contains(ns);
        }
        if (this._qualifier == 2) {
            return this._uris.contains(ns);
        }
        return false;
    }

    private boolean areTheyEqual(HashSet a, HashSet b) {
        if (a == b) {
            return true;
        }
        int sizeOfA = -1;
        int sizeOfB = -1;
        if (a != null) {
            sizeOfA = a.size();
        }
        if (b != null) {
            sizeOfB = b.size();
        }
        if (sizeOfA == sizeOfB) {
            Iterator it = a.iterator();
            while (it.hasNext()) {
                if (b.contains(it.next())) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    static final Symbol createAny(Object id, int qualifier, HashSet uris, int processContents) {
        return new AnySymbol(id, qualifier, uris, processContents);
    }

    void contribute(QName name) {
        QNamePacket pkt = (QNamePacket)name;
        pkt.setMatchedByAny(true);
        pkt.setProcessContents(this._processContents);
    }
}

