/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSField;
import com.wm.lang.schema.Any;
import com.wm.lang.schema.NodeWorkspace;
import com.wm.lang.schema.Reserve;
import com.wm.lang.schema.Schema;
import com.wm.lang.schema.WmAttribute;
import com.wm.lang.schema.WmAttributeRef;
import com.wm.lang.schema.conv.Builder;
import com.wm.lang.schema.conv.Context;
import com.wm.lang.xml.Attribute;
import com.wm.util.QName;
import com.wm.util.Values;

public class AnyAttribute
extends WmAttribute {
    Any _model;
    static final String SYMBOL_ANY = "$$ANY_ATTRIBUTE";
    static final String KEY_AA_WILDCARD = "wildcard";

    public AnyAttribute() {
        super(SYMBOL_ANY, 3);
    }

    public AnyAttribute(Schema owner, IData values) {
        super(owner, values);
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{KEY_AA_WILDCARD, this._model != null ? this._model.getValues() : null}};
        return super.getValues().copyFrom(new Values(o));
    }

    public void setValues(Values values) {
        super.setValues(values);
        Values in = values.getValues(KEY_AA_WILDCARD);
        this._model = in != null ? Any.createAny(in, null) : null;
    }

    public IData getAsData() {
        IData val = super.getAsData();
        if (this._model != null) {
            IDataCursor ic = val.getCursor();
            ic.insertAfter(KEY_AA_WILDCARD, this._model.getAsData());
            ic.destroy();
        }
        return val;
    }

    public void setFromData(IData values) {
        super.setFromData(values);
        IDataCursor ic = values.getCursor();
        IData in = (IData)IDataUtil.get(ic, KEY_AA_WILDCARD);
        ic.destroy();
        this._model = in != null ? Any.createAny(in, null) : null;
    }

    public Any getModel() {
        return this._model;
    }

    public void setModel(Any model) {
        this._model = model;
    }

    boolean isWildCard() {
        return true;
    }

    boolean equals(Object lhs, boolean turnOnWildCardMatching) {
        if (!turnOnWildCardMatching) {
            return false;
        }
        if (Reserve.current().contains(lhs)) {
            return false;
        }
        if (lhs instanceof QName) {
            QName name = (QName)lhs;
            if (this._model != null) {
                return this._model.equals(name);
            }
        }
        return false;
    }

    public void validate(Attribute attr, NodeWorkspace workspace, String baseLocationPath) {
        if (workspace.completed) {
            return;
        }
        if (this._model != null) {
            int processContents = this._model.getProcessContents();
            if (processContents == 1) {
                return;
            }
            QName name = QName.create(attr.getNamespaceUri(), attr.getLocalNameWm());
            WmAttributeRef ref = new WmAttributeRef(name);
            ref.setOwner(this.getOwner());
            if (processContents == 2 && !ref.targetExists()) {
                return;
            }
            ref.validate(attr, workspace, baseLocationPath);
        }
    }

    public NSField createRecord(Builder builder, Context context) {
        return null;
    }
}

