/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.schema;

import com.wm.data.IData;
import com.wm.lang.schema.ComplexModel;
import com.wm.lang.schema.ComplexType;
import com.wm.lang.schema.Flat;
import com.wm.lang.schema.Model;
import com.wm.lang.schema.NodeWorkspace;
import com.wm.lang.schema.NonTerminal;
import com.wm.lang.schema.Production;
import com.wm.lang.schema.Symbol;
import com.wm.lang.schema.W3CKeys;
import com.wm.util.QName;
import com.wm.util.coder.ValuesCodable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class All
extends ComplexModel
implements ValuesCodable,
W3CKeys {
    All(int minOccurs, int maxOccurs, ComplexType owner) {
        super(SYMBOL_ALL, minOccurs, maxOccurs, 5, owner);
    }

    All(ComplexType owner) {
        this(0, 1, owner);
    }

    public static final All createAll(IData values, ComplexType owner) {
        All all = new All(owner);
        all.setFromData(values);
        return all;
    }

    public static final All createAll(int minOccurs, int maxOccurs) {
        return new All(minOccurs, maxOccurs, null);
    }

    void pushProduction(NodeWorkspace workspace) {
    }

    boolean pushProduction(QName prefix, NonTerminal symbol, NodeWorkspace workspace) {
        return true;
    }

    @Override
    protected int computeLFGrammar(Vector productions, Hashtable terminals, Vector wildCardTerminals, int suffix) {
        int localSuffix = super.computeLFGrammar(productions, terminals, wildCardTerminals, suffix);
        Symbol nonTerminal = Symbol.create("S" + localSuffix, false);
        ++localSuffix;
        HashMap<Symbol, Production> productionsMap = new HashMap<Symbol, Production>();
        for (Object production : productions) {
            productionsMap.put(((Production)production).nonTerminal, (Production)production);
        }
        if (this._children != null && this._children.size() > 0) {
            ArrayList<Symbol> childStartSymbols = new ArrayList<Symbol>(this._children.size());
            ArrayList<Symbol> childrenWithMinOccursAsZero = new ArrayList<Symbol>(this._children.size());
            for (Object child : this._children) {
                Object[] alternatives;
                Symbol childStartSymbol = ((Model)child).getStartSymbol();
                if (((Model)child).getMinOccurs() != 0) {
                    childStartSymbols.add(childStartSymbol);
                    continue;
                }
                Production childProduction = (Production)productionsMap.get(childStartSymbol);
                for (Object alternative : alternatives = childProduction.alternatives) {
                    Symbol[] alternatSymbols = (Symbol[])alternative;
                    if (alternatSymbols.length == 1 && alternatSymbols[0].equals(Symbol.NULL)) continue;
                    childStartSymbols.add(alternatSymbols[0]);
                    childrenWithMinOccursAsZero.add(alternatSymbols[0]);
                }
                productions.removeElement(childProduction);
            }
            localSuffix = this.generateProductions(productions, childStartSymbols, childrenWithMinOccursAsZero, nonTerminal, localSuffix);
        } else {
            ArrayList<Symbol[]> alternatives = new ArrayList<Symbol[]>();
            Symbol[] alternative = new Symbol[]{Symbol.NULL};
            alternatives.add(alternative);
            All.addToProductions(nonTerminal, alternatives.toArray(), productions);
        }
        return this.createProductions(productions, localSuffix, nonTerminal);
    }

    private int generateProductions(Vector productions, List<Symbol> children, List<Symbol> childrenWithMinOccursAsZero, Symbol nonTerminal, int suffix) {
        switch (children.size()) {
            case 1: {
                if (!childrenWithMinOccursAsZero.contains(children.get(0))) {
                    All.addToProductions(nonTerminal, new Object[]{new Symbol[]{children.get(0)}}, productions);
                    break;
                }
                All.addToProductions(nonTerminal, new Object[]{new Symbol[]{children.get(0)}, new Symbol[]{Symbol.NULL}}, productions);
                break;
            }
            case 2: {
                if (!childrenWithMinOccursAsZero.contains(children.get(0)) && !childrenWithMinOccursAsZero.contains(children.get(1))) {
                    All.addToProductions(nonTerminal, new Object[]{new Symbol[]{children.get(0), children.get(1)}, new Symbol[]{children.get(1), children.get(0)}}, productions);
                    break;
                }
                suffix = this.generateProductionsForMoreThanOneChild(productions, children, childrenWithMinOccursAsZero, nonTerminal, suffix);
                break;
            }
            default: {
                suffix = this.generateProductionsForMoreThanOneChild(productions, children, childrenWithMinOccursAsZero, nonTerminal, suffix);
            }
        }
        return suffix;
    }

    private int generateProductionsForMoreThanOneChild(Vector productions, List<Symbol> children, List<Symbol> childrenWithMinOccursAsZero, Symbol nonTerminal, int suffix) {
        ArrayList<Symbol[]> alternatives = new ArrayList<Symbol[]>();
        boolean nullProductionRequired = true;
        for (Symbol child : children) {
            Symbol[] alternative = new Symbol[2];
            alternative[0] = child;
            Symbol newNonTerminal = Symbol.create("S" + suffix, false);
            ++suffix;
            alternative[1] = newNonTerminal;
            alternatives.add(alternative);
            ArrayList<Symbol> childrenSansCurrent = new ArrayList<Symbol>(children);
            childrenSansCurrent.remove(child);
            suffix = this.generateProductions(productions, childrenSansCurrent, childrenWithMinOccursAsZero, newNonTerminal, suffix);
            if (childrenWithMinOccursAsZero.contains(child)) continue;
            nullProductionRequired = false;
        }
        if (nullProductionRequired) {
            Symbol[] alternative = new Symbol[]{Symbol.NULL};
            alternatives.add(alternative);
        }
        All.addToProductions(nonTerminal, alternatives.toArray(), productions);
        return suffix;
    }

    @Override
    protected Flat[] getFlattenedModel() {
        Vector temp = new Vector();
        int minO = this.getMinOccurs();
        int maxO = this.getMaxOccurs();
        for (int i = 0; i < this._children.size(); ++i) {
            Model model = (Model)this._children.elementAt(i);
            int type = model.getType();
            Flat[] tempArray = model.getFlattenedModel();
            this.mergeAllName(temp, tempArray);
        }
        Flat[] flatArray = All.convertToFlatArray(temp);
        temp.removeAllElements();
        return All.upgradeAllChild(flatArray, minO, maxO);
    }
}

