/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.ns;

import com.wm.lang.ns.WmPathInfo;

public class WmPathItem {
    public static final int PATH_NAME = 0;
    public static final int PATH_POSITION = 1;
    public static final int PATH_COMBO = 2;
    public static final int PATH_COMPLEX = 3;
    public static final int TYPE_ANY = -1;
    public static final int DIMENSION_ANY = -1;
    public static final int INDEX_NONE = -1;
    public static final int INDEX_APPEND = Integer.MAX_VALUE;
    public static final int INDEX_VAR = -2;
    public static final String INDEX_NONE_VIS = "none";
    public static final String INDEX_APPEND_VIS = "end";
    String name;
    String nsName;
    int position;
    int arrayIndex;
    int tableIndex;
    String varArrayIndex;
    String varTableIndex;
    int type;
    int javaType;
    int dim;
    int pathType;
    public static final String ESCAPE_SEPARATOR = "\\";

    public WmPathItem(String name, String nsName, int position, int arrayIndex, int tableIndex, int type, int dim) {
        this.name = name;
        this.nsName = nsName;
        this.position = position;
        this.arrayIndex = arrayIndex;
        this.tableIndex = tableIndex;
        this.type = type;
        this.dim = dim;
        this.javaType = 0;
        this.pathType = name != null && position > -1 ? 2 : ((name == null || name.length() == 0) && position > -1 ? 1 : 0);
    }

    public WmPathItem(String name, String nsName, int position, int arrayIndex, String varArrayIndex, int tableIndex, String varTableIndex, int type, int dim) {
        this(name, nsName, position, arrayIndex, tableIndex, type, dim);
        this.varArrayIndex = varArrayIndex;
        this.varTableIndex = varTableIndex;
    }

    public WmPathItem(String name, String nsName, int position, int arrayIndex, String varArrayIndex, int tableIndex, String varTableIndex, int type, int javaType, int dim) {
        this(name, nsName, position, arrayIndex, varArrayIndex, tableIndex, varTableIndex, type, dim);
        this.javaType = javaType;
    }

    public String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public String getNSName() {
        return this.nsName;
    }

    public int getPosition() {
        return this.position;
    }

    public int getArrayIndex() {
        return this.arrayIndex;
    }

    public int getTableIndex() {
        return this.tableIndex;
    }

    public String getVarArrayIndex() {
        return this.varArrayIndex;
    }

    public String getVarTableIndex() {
        return this.varTableIndex;
    }

    public int getType() {
        return this.type;
    }

    public int getJavaType() {
        return this.javaType;
    }

    public int getNodeDimension() {
        return this.dim;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNSName(String nsName) {
        this.nsName = nsName;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void setArrayIndex(int arrayIndex) {
        this.arrayIndex = arrayIndex;
    }

    public void setTableIndex(int tableIndex) {
        this.tableIndex = tableIndex;
    }

    public void setVarArrayIndex(String varArrayIndex) {
        this.varArrayIndex = varArrayIndex;
    }

    public void setVarTableIndex(String varTableIndex) {
        this.varTableIndex = varTableIndex;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setJavaType(int type) {
        this.javaType = type;
    }

    public void setNodeDimension(int dim) {
        this.dim = dim;
    }

    public String getVisualArrayIndex() {
        return this.getVisualIndex(this.arrayIndex);
    }

    public String getVisualTableIndex() {
        return this.getVisualIndex(this.tableIndex);
    }

    public void setArrayIndex(String number) throws Exception {
        this.arrayIndex = this.getIndex(number);
    }

    public void setTableIndex(String number) throws Exception {
        this.tableIndex = this.getIndex(number);
    }

    String getVisualIndex(int index) {
        if (index == Integer.MAX_VALUE) {
            return INDEX_APPEND_VIS;
        }
        if (index == -1) {
            return INDEX_NONE_VIS;
        }
        return Integer.toString(index);
    }

    int getIndex(String number) throws Exception {
        if (number == null || INDEX_NONE_VIS.equals(number)) {
            return -1;
        }
        if (INDEX_APPEND_VIS.equals(number)) {
            return Integer.MAX_VALUE;
        }
        return Integer.parseInt(number);
    }

    public int getPathType() {
        return this.pathType;
    }

    public void setPathType(int type) {
        this.pathType = type;
    }

    public Object clone() {
        WmPathItem clone = new WmPathItem(this.name, this.nsName, this.position, this.arrayIndex, this.varArrayIndex, this.tableIndex, this.varTableIndex, this.type, this.dim);
        clone.setPathType(this.pathType);
        clone.setJavaType(this.javaType);
        return clone;
    }

    public String getID() {
        StringBuffer sb = new StringBuffer();
        sb.append("/" + WmPathInfo.encodePathName(this.name));
        int pos = this.position;
        if (pos < 0) {
            pos = 0;
        }
        sb.append("(" + pos + ")");
        if (this.arrayIndex != -1) {
            if (this.arrayIndex != -2) {
                sb.append("[" + this.arrayIndex + "]");
            } else {
                sb.append("[" + (this.varArrayIndex == null ? "" + this.arrayIndex : this.varArrayIndex) + "]");
            }
        }
        if (this.tableIndex != -1) {
            sb.append("[" + this.tableIndex + "]");
        }
        return sb.toString();
    }

    public int getDimension() {
        int dataDim = this.dim;
        if (this.arrayIndex != -1) {
            --dataDim;
        }
        if (this.tableIndex != -1) {
            --dataDim;
        }
        return dataDim;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("/" + WmPathInfo.encodePathName(this.name));
        if (this.position >= 0) {
            sb.append("(" + this.position + ")");
        }
        if (this.arrayIndex != -1) {
            sb.append("[" + (this.arrayIndex == -2 ? this.escapeVarString(this.varArrayIndex) : String.valueOf(this.arrayIndex)) + "]");
        }
        if (this.tableIndex != -1) {
            sb.append("[" + (this.tableIndex == -2 ? this.escapeVarString(this.varTableIndex) : String.valueOf(this.tableIndex)) + "]");
        }
        if (this.type != -1) {
            sb.append(";" + Integer.toString(this.type));
        }
        if (this.javaType != 0) {
            sb.append("." + Integer.toString(this.javaType));
        }
        if (this.dim != -1) {
            sb.append(";" + Integer.toString(this.dim));
        }
        if (this.nsName != null) {
            sb.append(";" + this.nsName);
        }
        return sb.toString();
    }

    public String getDisplayString() {
        StringBuffer sb = new StringBuffer();
        sb.append("/" + WmPathInfo.encodePathName(this.name));
        if (this.position >= 0) {
            sb.append("(" + this.position + ")");
        }
        if (this.arrayIndex != -1) {
            sb.append("[" + (this.arrayIndex == -2 ? this.varArrayIndex : String.valueOf(this.arrayIndex)) + "]");
        }
        if (this.tableIndex != -1) {
            sb.append("[" + (this.tableIndex == -2 ? this.varTableIndex : String.valueOf(this.tableIndex)) + "]");
        }
        return sb.toString();
    }

    public String escapeVarString(String varString) {
        int index = varString.indexOf("/");
        if (index == -1) {
            return varString;
        }
        int start = 0;
        StringBuffer sb = new StringBuffer();
        while (index != -1) {
            sb.append(varString.substring(start, index));
            sb.append(ESCAPE_SEPARATOR);
            sb.append("/");
            start = index + 1;
            index = varString.indexOf("/", start);
        }
        sb.append(varString.substring(start));
        return sb.toString();
    }
}

