/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.ns;

import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSRecordRef;
import com.wm.lang.ns.WmPathItem;
import com.wm.util.StringParser;
import java.util.Vector;

public class WmPathInfo {
    public static final String SEPARATOR_PATH = "/";
    public static final String SEPARATOR_TYPE = ";";
    public static final String SEPARATOR_JAVATYPE = ".";
    public static final String SEPARATOR_LBRACKET = "[";
    public static final String SEPARATOR_RBRACKET = "]";
    public static final String SEPARATOR_LPBRACKET = "(";
    public static final String SEPARATOR_RPBRACKET = ")";
    private static final String FIELDNAME_ENCODECHAR = "\"";
    private static final String VARSUBST_CHAR = "%";

    public static String createPath(NSField field, int arrayIndex) {
        NSName ns;
        if (field == null) {
            return "";
        }
        NSRecord parent = field.getParentRecord();
        if (parent == null) {
            return "";
        }
        if (parent.getParentRecord() instanceof NSRecordRef) {
            parent = parent.getParentRecord();
        }
        if (field.equals(parent)) {
            return "";
        }
        StringBuffer p = new StringBuffer("");
        p.append(WmPathInfo.createPath(parent, -1));
        p.append(SEPARATOR_PATH);
        p.append(WmPathInfo.encodePathName(field.getName()));
        int position = WmPathInfo.getPosition(field);
        if (position >= 0) {
            p.append(SEPARATOR_LPBRACKET);
            p.append(Integer.toString(position));
            p.append(SEPARATOR_RPBRACKET);
        }
        if (arrayIndex != -1) {
            p.append(SEPARATOR_LBRACKET);
            p.append(Integer.toString(arrayIndex));
            p.append(SEPARATOR_RBRACKET);
        }
        p.append(SEPARATOR_TYPE);
        p.append(field.getType());
        if (field.getJavaWrapperType() != 0) {
            p.append(SEPARATOR_JAVATYPE);
            p.append(field.getJavaWrapperType());
        }
        p.append(SEPARATOR_TYPE);
        p.append(field.getDimensions());
        if (field instanceof NSRecordRef && (ns = ((NSRecordRef)field).getTargetName()) != null) {
            p.append(SEPARATOR_TYPE);
            p.append(ns.toString());
        }
        return p.toString();
    }

    public static String createPath(NSField field) {
        return WmPathInfo.createPath(field, -1);
    }

    public static int getPosition(NSField field) {
        NSRecord parent = field.getParentRecord();
        if (parent == null) {
            return -1;
        }
        NSField[] fields = parent.getFieldsByName(field.getName());
        if (fields == null || fields.length < 2) {
            return -1;
        }
        for (int i = 0; i < fields.length; ++i) {
            if (field != fields[i]) continue;
            return i;
        }
        return -1;
    }

    public static String getPath(String name, int type, int dim) {
        StringBuffer p = new StringBuffer();
        p.append(SEPARATOR_PATH);
        p.append(WmPathInfo.encodePathName(name));
        p.append(SEPARATOR_TYPE);
        p.append(type);
        p.append(SEPARATOR_TYPE);
        p.append(dim);
        return p.toString();
    }

    public static String getPath(String[] paths, int[] types, int[] dims) {
        StringBuffer p = new StringBuffer();
        for (int i = 0; i < paths.length; ++i) {
            p.append(WmPathInfo.getPath(paths[i], types[i], dims[i]));
        }
        return p.toString();
    }

    public static String getPath(String name, int type, int dim, NSName referenceName) {
        StringBuffer p = new StringBuffer(WmPathInfo.getPath(name, type, dim));
        p.append(SEPARATOR_TYPE);
        p.append(referenceName.toString());
        return p.toString();
    }

    public static WmPathItem[] parsePath(String path) {
        if (path == null || path.length() == 0) {
            return null;
        }
        Vector<WmPathItem> pathInfo = new Vector<WmPathItem>();
        StringParser st = new StringParser(path, SEPARATOR_PATH, FIELDNAME_ENCODECHAR, true);
        int type = -1;
        int javaType = 0;
        int dim = -1;
        while (st.hasMoreTokens()) {
            String name = st.nextToken();
            type = -1;
            javaType = 0;
            dim = -1;
            String nsName = null;
            int position = -1;
            int arrayIndex = -1;
            int tableIndex = -1;
            String varArrayIndex = null;
            String varTableIndex = null;
            StringParser dt = new StringParser(name, SEPARATOR_TYPE, FIELDNAME_ENCODECHAR, true);
            if (dt.hasMoreTokens()) {
                String s = dt.nextToken();
                int quote = 0;
                if (s.startsWith(FIELDNAME_ENCODECHAR)) {
                    quote = s.lastIndexOf(FIELDNAME_ENCODECHAR);
                }
                int pos = s.indexOf(SEPARATOR_LPBRACKET, quote);
                int ind = s.indexOf(SEPARATOR_LBRACKET, quote);
                name = quote > 0 ? s.substring(1, quote) : (pos != -1 ? s.substring(0, pos) : (ind != -1 ? s.substring(0, ind) : s));
                if (pos != -1) {
                    try {
                        position = s.indexOf(SEPARATOR_RPBRACKET, quote);
                        if (position != -1 && position > pos) {
                            position = Integer.parseInt(s.substring(pos + 1, position));
                        }
                    }
                    catch (Exception e) {
                        position = -1;
                    }
                }
                if (ind != -1 && (pos = s.indexOf(SEPARATOR_RBRACKET, ind)) != -1 && pos > ind) {
                    try {
                        int tempVarind = s.indexOf(VARSUBST_CHAR, ind);
                        if (tempVarind != -1 && tempVarind < pos) {
                            int tempVarind2 = s.indexOf(VARSUBST_CHAR, tempVarind + 1);
                            if (tempVarind2 > pos) {
                                pos = s.indexOf(SEPARATOR_RBRACKET, tempVarind2);
                            }
                            arrayIndex = -2;
                            varArrayIndex = s.substring(ind + 1, pos);
                        } else {
                            arrayIndex = Integer.parseInt(s.substring(ind + 1, pos));
                        }
                    }
                    catch (Exception e) {
                        arrayIndex = -1;
                    }
                    ind = s.indexOf(SEPARATOR_LBRACKET, pos);
                    if (ind != -1) {
                        pos = s.indexOf(SEPARATOR_RBRACKET, ind);
                        try {
                            if (pos != -1 && pos > ind) {
                                int tempVarind = s.indexOf(VARSUBST_CHAR, ind);
                                if (tempVarind != -1 && tempVarind < pos) {
                                    tableIndex = -2;
                                    varTableIndex = s.substring(ind + 1, pos);
                                } else {
                                    tableIndex = Integer.parseInt(s.substring(ind + 1, pos));
                                }
                            }
                        }
                        catch (Exception e) {
                            tableIndex = -1;
                        }
                    }
                }
            }
            if (dt.hasMoreTokens()) {
                try {
                    String objType = dt.nextToken();
                    int index = objType.indexOf(SEPARATOR_JAVATYPE);
                    if (index != -1) {
                        javaType = Integer.parseInt(objType.substring(index + 1));
                        type = Integer.parseInt(objType.substring(0, index));
                    } else {
                        type = Integer.parseInt(objType);
                    }
                }
                catch (Exception e) {
                    type = -1;
                    javaType = 0;
                }
            }
            if (dt.hasMoreTokens()) {
                try {
                    dim = Integer.parseInt(dt.nextToken());
                }
                catch (Exception e) {
                    dim = -1;
                }
            }
            if (dt.hasMoreTokens()) {
                nsName = dt.nextToken();
            }
            pathInfo.addElement(new WmPathItem(name, nsName, position, arrayIndex, varArrayIndex, tableIndex, varTableIndex, type, javaType, dim));
        }
        if (pathInfo.size() == 0) {
            return null;
        }
        Object[] result = new WmPathItem[pathInfo.size()];
        pathInfo.copyInto(result);
        return result;
    }

    public static String encodePathName(String name) {
        if (WmPathInfo.containsSep(name)) {
            return new String(FIELDNAME_ENCODECHAR + WmPathInfo.checkForQuotes(name) + FIELDNAME_ENCODECHAR);
        }
        return name;
    }

    private static String checkForQuotes(String name) {
        StringBuffer xname = new StringBuffer(name.length() + 5);
        int idx = 0;
        int offset = 0;
        while (idx >= 0) {
            idx = name.indexOf(FIELDNAME_ENCODECHAR.charAt(0), offset);
            if (idx < 0) continue;
            xname.append(name.substring(offset, idx));
            xname.append("\\\\\"");
            offset = idx + 1;
        }
        xname.append(name.substring(offset));
        return xname.toString();
    }

    private static boolean containsSep(String name) {
        if (name == null) {
            return false;
        }
        String sep = new String("/;[]()\"");
        for (int i = 0; i < sep.length(); ++i) {
            if (name.indexOf(sep.charAt(i)) < 0) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        int i;
        String path = "/A;0;0/B(1);0;0/C(2)[1];0;0";
        System.out.println("path=" + path);
        WmPathItem[] items = WmPathInfo.parsePath(path);
        for (i = 0; i < items.length; ++i) {
            System.out.println("name=" + items[i].getName() + "  pos=" + items[i].getPosition() + "  array=" + items[i].getArrayIndex() + "  type=" + items[i].getType() + "  dim=" + items[i].getDimension());
        }
        path = "/A(;0;0/B(1);1;2/C(2A)[1];0;0";
        System.out.println("path=" + path);
        items = WmPathInfo.parsePath(path);
        for (i = 0; i < items.length; ++i) {
            System.out.println("name=" + items[i].getName() + "  pos=" + items[i].getPosition() + "  array=" + items[i].getArrayIndex() + "  type=" + items[i].getType() + "  dim=" + items[i].getDimension());
        }
        path = "/A(;0;0/B(1);1;2/C(2)[1][3];0;0";
        System.out.println("path=" + path);
        items = WmPathInfo.parsePath(path);
        for (i = 0; i < items.length; ++i) {
            System.out.println("name=" + items[i].getName() + "  pos=" + items[i].getPosition() + "  array=" + items[i].getArrayIndex() + "table=" + items[i].getTableIndex() + "  type=" + items[i].getType() + "  dim=" + items[i].getDimension());
        }
    }
}

