/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.ns;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.lang.ns.NSException;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.resources.NSExceptionBundle;
import com.wm.util.JournalLogger;
import com.wm.util.QName;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class UIDRegistry {
    static final UIDRegistry _UIDRegistry = new UIDRegistry();
    private Hashtable registry = new Hashtable();
    public static final int FAC_NS_MSG_ALREADY_REGISTERED = 2;
    public static final int FAC_NS_MSG_REGISTERED = 3;

    public static UIDRegistry current() {
        return _UIDRegistry;
    }

    private UIDRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean register(QName UID, NSName b2bQName) throws NSException {
        UIDRegistry uidreg = UIDRegistry.current();
        if (UID == null || b2bQName == null) {
            return false;
        }
        Hashtable hashtable = uidreg.registry;
        synchronized (hashtable) {
            if (!uidreg.registry.containsKey(UID)) {
                uidreg.registry.put(UID, b2bQName);
                JournalLogger.logDebugPlus(3, 3, 81, UID.toString(), b2bQName.toString());
                return true;
            }
        }
        NSName registeredNode = UIDRegistry.find(UID);
        if (registeredNode != null && registeredNode.toString().equals(b2bQName.toString())) {
            return true;
        }
        JournalLogger.logError(2, 81, UID.toString(), b2bQName.toString());
        throw new NSException(NSExceptionBundle.class, NSExceptionBundle.UID_ALREADY_REGISTERED, "", UID.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unregister(QName UID) {
        UIDRegistry uidreg = UIDRegistry.current();
        Hashtable hashtable = uidreg.registry;
        synchronized (hashtable) {
            if (UID == null || !uidreg.registry.containsKey(UID)) {
                return false;
            }
            if (uidreg.registry.remove(UID) != null) {
                return true;
            }
        }
        return false;
    }

    public static NSName find(QName UID) {
        if (UID == null) {
            return null;
        }
        UIDRegistry uidreg = UIDRegistry.current();
        NSName value = (NSName)uidreg.registry.get(UID);
        return value;
    }

    public static NSName resolve(QName UID) {
        UIDRegistry uidreg = UIDRegistry.current();
        NSName value = (NSName)uidreg.registry.get(UID);
        if (value == null) {
            String local = UID.getNCName();
            if (local == null) {
                return null;
            }
            String ns = UID.getNamespace();
            if (ns == null) {
                ns = "";
            }
            if (ns.startsWith("http://localhost/")) {
                ns = ns.substring("http://localhost/".length());
            }
            value = NSName.create(ns, local);
        }
        return value;
    }

    public static IData[] list() {
        UIDRegistry uidreg = UIDRegistry.current();
        Vector<IData> v = new Vector<IData>();
        Enumeration keys = uidreg.registry.keys();
        while (keys.hasMoreElements()) {
            QName UID = (QName)keys.nextElement();
            NSName nsName = UIDRegistry.find(UID);
            IData qname = IDataFactory.create();
            IDataCursor qnamecr = qname.getCursor();
            qnamecr.insertAfter("namespaceName", UID.getNamespace());
            qnamecr.insertAfter("localName", UID.getNCName());
            IData pair = IDataFactory.create();
            IDataCursor paircr = pair.getCursor();
            paircr.insertAfter("universalName", qname);
            paircr.insertAfter("svcName", nsName.toString());
            v.addElement(pair);
        }
        IData[] list = new IData[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            list[i] = (IData)v.elementAt(i);
        }
        return list;
    }

    public String toString() {
        return this.toString("List of registered targets:");
    }

    public String toString(String title) {
        StringBuffer sb = new StringBuffer();
        sb.append(title + "\n");
        Enumeration keys = this.registry.keys();
        int index = 1;
        while (keys.hasMoreElements()) {
            QName UID = (QName)keys.nextElement();
            NSName b2bQName = UIDRegistry.find(UID);
            sb.append("  (" + index + ") UID=" + UID + " = " + b2bQName + "\n");
            ++index;
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        UIDRegistry sr = UIDRegistry.current();
        QName ackfoo = QName.create("/ack", "foo");
        String s = sr.toString("Start");
        System.out.println(s);
        try {
            UIDRegistry.register(QName.create("/URI/", "service1"), NSName.create("my.pkg:service1"));
            UIDRegistry.register(QName.create("/URI/", "service2"), NSName.create("my.pkg:service2"));
            UIDRegistry.register(QName.create("/AnotherURI/", "service1"), NSName.create("my.pkg:service1"));
            s = sr.toString("3 entries");
            System.out.println(s);
            UIDRegistry.register(ackfoo, NSName.create("pub.w3c:foo"));
            s = sr.toString("foo should be foo");
            System.out.println(s);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("This should throw an exception (re-registering foo)");
        try {
            UIDRegistry.register(ackfoo, NSName.create("pub.w3c:anewfoo"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("unregistering, then re-registering foo");
        UIDRegistry.unregister(ackfoo);
        try {
            UIDRegistry.register(ackfoo, NSName.create("pub.w3c:anewfoo"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            s = sr.toString("foo should be anewfoo");
            System.out.println(s);
            QName bar = QName.create("bar", "bar");
            UIDRegistry.register(bar, NSName.create("pub.w3c:bar"));
            s = sr.toString("just added bar");
            System.out.println(s);
            UIDRegistry.unregister(bar);
            s = sr.toString("removed bar");
            System.out.println(s);
            QName zzzz = QName.create("/myURI/", "ZZZZ");
            UIDRegistry.register(zzzz, NSName.create("AAAA"));
            UIDRegistry.unregister(zzzz);
            UIDRegistry.register(zzzz, NSName.create("ZZZZZ"));
            s = sr.toString("ZZZZ should be ZZZZZ");
            System.out.println(s);
            UIDRegistry.unregister(bar);
            IData[] list = sr.list();
            for (int i = 0; i < list.length; ++i) {
                s = list.toString();
                System.out.println("IDATA:" + s);
            }
            s = sr.toString("Final");
            System.out.println(s);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String result = "Final\n  (1) UID={/ack}foo = pub.w3c:anewfoo\n  (2) UID={/AnotherURI/}service1 = my.pkg:service1\n  (3) UID={/URI/}service2 = my.pkg:service2\n  (4) UID={/URI/}service1 = my.pkg:service1\n  (5) UID={/myURI/}ZZZZ = ZZZZZ\n";
        if (!s.equals(result)) {
            System.out.println("ERROR!  Final string is:\n" + s + "<<<\nbut it should be:\n" + result + "<<<");
        } else {
            System.out.println("Success!");
        }
    }
}

