/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.ns;

import com.wm.lang.ns.NSException;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSRecordWmPathProcessor;
import com.wm.lang.ns.NSService;
import com.wm.lang.ns.NSSignature;
import com.wm.lang.ns.WmPathInfo;
import com.wm.lang.ns.WmPathItem;
import com.wm.lang.ns.resources.NSExceptionBundle;
import com.wm.util.StringParser;
import java.util.Vector;

public class ServicePathInfo {
    public static final String TYPE_INVOKE = "invoke";
    public static final String TYPE_SIGNATURE = "signature";
    public static final String TYPE_SUB_PATH = "subPath";
    public static final int INDEX_NONE = -1;
    public static final int INDEX_ATTRIBUTE = -2;
    public static final int INDEX_SIGNATURE_IN = 1;
    public static final int INDEX_SIGNATURE_OUT = 2;
    private static final String VERSION_TAG = "Service Path";
    private static final String VERSION_NUMBER = "1.0";
    public static final String SEPARATOR_PATH = "/";
    public static final String SEPARATOR_TYPE = ";";
    public static final String SUB_PATH_SEP = "\"";
    private static ServicePathInfo _instance;

    protected ServicePathInfo() {
    }

    public static ServicePathInfo current() {
        if (_instance == null) {
            _instance = new ServicePathInfo();
        }
        return _instance;
    }

    protected String getVersionTag() {
        return VERSION_TAG;
    }

    protected String getVersionNumber() {
        return VERSION_NUMBER;
    }

    protected String createVersion() {
        return SEPARATOR_PATH + this.getVersionTag() + SEPARATOR_TYPE + this.getVersionNumber();
    }

    protected boolean validateVersion(String versionPath) {
        StringParser dt = new StringParser(versionPath, SEPARATOR_TYPE, SUB_PATH_SEP, true);
        String tag = dt.hasMoreTokens() ? dt.nextToken() : null;
        String number = dt.hasMoreTokens() ? dt.nextToken() : null;
        return this.getVersionTag().equals(tag) && this.getVersionNumber().equals(number);
    }

    public String createPath(String type, int index, String subPath) {
        if (type == null) {
            return null;
        }
        StringBuffer p = new StringBuffer(this.createVersion());
        ServicePathItem pathItem = new ServicePathItem(type, index, subPath);
        p.append(pathItem.toString());
        return p.toString();
    }

    public ServicePathItem[] parsePath(String path) throws Exception {
        if (path == null || path.length() == 0) {
            throw new NSException(NSExceptionBundle.class, NSExceptionBundle.ILLEGAL_PATH_NULL, "");
        }
        StringParser st = new StringParser(path, SEPARATOR_PATH, SUB_PATH_SEP, true);
        if (!st.hasMoreTokens()) {
            throw new NSException(NSExceptionBundle.class, NSExceptionBundle.ILLEGAL_ARGUMENT_PATH, "", path);
        }
        if (!this.validateVersion(st.nextToken())) {
            throw new NSException(NSExceptionBundle.class, NSExceptionBundle.VERSION_TAG_MISMATCH, "");
        }
        Vector<ServicePathItem> pathInfo = new Vector<ServicePathItem>();
        while (st.hasMoreTokens()) {
            ServicePathItem item = this.createPathItem(st.nextToken());
            if (item == null) continue;
            pathInfo.addElement(item);
        }
        if (pathInfo.size() == 0) {
            return null;
        }
        Object[] result = new ServicePathItem[pathInfo.size()];
        pathInfo.copyInto(result);
        return result;
    }

    protected ServicePathItem createPathItem(String path) {
        ServicePathItem item = new ServicePathItem(null, -1, null);
        try {
            item.parse(path);
            return item;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object get(NSService service, String path) {
        ServicePathItem[] items = null;
        try {
            items = this.parsePath(path);
        }
        catch (Exception e) {
            return null;
        }
        if (items == null) {
            return null;
        }
        if (TYPE_SIGNATURE.equals(items[0].getType())) {
            try {
                return this.get(service, items[0]);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public void set(NSService svc, Object node, String path) {
        new Exception("Not implemented yet").printStackTrace();
    }

    public Object get(NSRecord record, String path) {
        if (path == null || path.length() == 0) {
            return record;
        }
        return NSRecordWmPathProcessor.get(record, path);
    }

    public void set(NSRecord record, NSField node, String path) {
        NSRecordWmPathProcessor.put(record, node, WmPathInfo.parsePath(path));
    }

    public Object[] getPathNodes(NSRecord record, String path) {
        if (record == null || path == null) {
            return null;
        }
        WmPathItem[] pathInfo = WmPathInfo.parsePath(path);
        if (pathInfo == null) {
            return null;
        }
        int len = pathInfo.length - 1;
        Object[] nodes = new Object[pathInfo.length];
        for (int i = 0; i < len; ++i) {
            NSField field = NSRecordWmPathProcessor.get(record, pathInfo[i]);
            nodes[i] = field;
            if (!(field instanceof NSRecord)) {
                return nodes;
            }
            record = (NSRecord)field;
        }
        nodes[len] = NSRecordWmPathProcessor.get(record, pathInfo[len]);
        return nodes;
    }

    public Object get(NSService service, ServicePathItem item) throws Exception {
        if (!TYPE_SIGNATURE.equals(item.getType())) {
            throw new NSException(NSExceptionBundle.class, NSExceptionBundle.NOT_A_SIGNATURE, "");
        }
        if (item.getIndex() == 1) {
            NSSignature sig = service.getSignature();
            if (sig != null && sig.getInput() != null) {
                return this.get(sig.getInput(), item.getSubPath());
            }
            return null;
        }
        if (item.getIndex() == 2) {
            NSSignature sig = service.getSignature();
            if (sig != null && sig.getOutput() != null) {
                return this.get(sig.getOutput(), item.getSubPath());
            }
            return null;
        }
        return service.getSpecification();
    }

    public static void main(String[] args) {
    }

    public int getSignatureType(String path) {
        int type = -1;
        ServicePathItem[] items = null;
        try {
            items = this.parsePath(path);
        }
        catch (Exception e) {
            return type;
        }
        if (items != null && items[0].getType().equals(TYPE_SIGNATURE)) {
            type = items[0].getIndex();
        }
        return type;
    }

    public static class ServicePathItem {
        protected String type;
        protected int index;
        protected String subPath;

        public ServicePathItem(String type, int index, String subPath) {
            this.type = type;
            this.subPath = subPath;
            this.index = index;
        }

        public String getType() {
            return this.type;
        }

        public int getIndex() {
            return this.index;
        }

        public String getSubPath() {
            return this.subPath;
        }

        public String toString() {
            StringBuffer path = new StringBuffer(ServicePathInfo.SEPARATOR_PATH);
            path.append(this.type);
            path.append(ServicePathInfo.SEPARATOR_TYPE);
            path.append(this.index);
            if (this.subPath != null) {
                path.append(ServicePathInfo.SEPARATOR_TYPE);
                path.append(ServicePathInfo.TYPE_SUB_PATH);
                path.append(ServicePathInfo.SEPARATOR_TYPE);
                path.append(ServicePathInfo.SUB_PATH_SEP);
                path.append(this.subPath);
                path.append(ServicePathInfo.SUB_PATH_SEP);
            }
            return path.toString();
        }

        public void parse(String path) throws Exception {
            this.type = null;
            this.index = -1;
            this.subPath = null;
            StringParser dt = new StringParser(path, ServicePathInfo.SEPARATOR_TYPE, ServicePathInfo.SUB_PATH_SEP, false);
            if (!dt.hasMoreTokens()) {
                throw new NSException(NSExceptionBundle.class, NSExceptionBundle.ILLEGAL_ARGUMENT_PATH, "", path);
            }
            this.type = dt.nextToken();
            try {
                this.index = Integer.parseInt(dt.nextToken());
            }
            catch (Exception e) {
                this.index = -1;
            }
            if (dt.hasMoreTokens() && ServicePathInfo.TYPE_SUB_PATH.equals(dt.nextToken()) && dt.hasMoreTokens()) {
                this.subPath = dt.nextToken();
            }
        }
    }
}

