/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.ns;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataPortable;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSException;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSNode;
import com.wm.lang.ns.NSPackage;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSRecordRef;
import com.wm.lang.ns.NSType;
import com.wm.lang.ns.Namespace;
import com.wm.lang.ns.UIDRegistry;
import com.wm.lang.schema.datatypev2.WmString;
import com.wm.lang.websvc.WSBinder;
import com.wm.lang.websvc.WSContext;
import com.wm.lang.websvc.WSElement;
import com.wm.lang.websvc.WSFault;
import com.wm.lang.websvc.WSHandler;
import com.wm.lang.websvc.WSHeader;
import com.wm.lang.websvc.WSMessage;
import com.wm.lang.websvc.WSOperation;
import com.wm.lang.websvc.WSReqMessage;
import com.wm.lang.websvc.WSRespMessage;
import com.wm.lang.websvc.resources.NSWebsvcExceptionBundle;
import com.wm.lang.wsdl.ExtendedElement;
import com.wm.lang.wsdl.Folder;
import com.wm.lang.wsdl.Message;
import com.wm.lang.wsdl.Part;
import com.wm.lang.wsdl.Service;
import com.wm.lang.wsdl.WSD;
import com.wm.lang.wsdl.WsdlMerger;
import com.wm.lang.wsdl.generator.WSDGenerator;
import com.wm.lang.xml.Attribute;
import com.wm.lang.xml.Document;
import com.wm.lang.xml.ElementNode;
import com.wm.lang.xml.NamespaceDecl;
import com.wm.lang.xml.Node;
import com.wm.lang.xml.WMDocumentException;
import com.wm.lang.xql.XqlQuery;
import com.wm.util.Config;
import com.wm.util.NCName;
import com.wm.util.Name;
import com.wm.util.QName;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Types;
import javax.wsdl.WSDLElement;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap12.SOAP12Body;
import javax.wsdl.extensions.soap12.SOAP12Fault;
import javax.wsdl.extensions.soap12.SOAP12Header;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NSWSDescriptor
extends NSNode
implements ValuesCodable,
IDataPortable {
    public static final String TYPE_KEY = "webServiceDescriptor";
    public static final NSType TYPE = NSType.create("webServiceDescriptor");
    private static boolean debug = new Boolean(System.getProperty("watt.server.WSDL.debug", "false"));
    public static final String KEY_WSD_INBOUND = "inbound";
    public static final String KEY_WSD_WSI = "WSICompliant";
    public static final String KEY_WSD_SOAP_PROTOCOL = "SOAPProtocol";
    public static final String KEY_WSD_TARGET_NAMESPACE = "targetNamespace";
    public static final String KEY_WSD_WSDL_URL = "WSDLURL";
    public static final String KEY_WSD_EXTERNAL_WSDL_URL = "externalWSDLURL";
    public static final String KEY_WSD_EXTERNAL_WSDL = "externalWSDL";
    public static final String KEY_WSD_ATTACHMENT = "attachmentEnabled";
    public static final String KEY_WSD_MTOM_THRESHOLD = "mtomThreshold";
    public static final String KEY_WSD_BINDERLIST = "binderList";
    public static final String KEY_WSD_OPERATIONMAP = "operationMap";
    public static final String KEY_WSD_OPERATIONLIST = "operationList";
    public static final String KEY_WSD_DEFINITION_NAME = "definitionName";
    public static final String KEY_WSD_NAMESPACES = "namespaces";
    public static final String KEY_WSD_HANDLERLIST = "handlerList";
    public static String DEFAULT_SOAP_PROTOCOL = "SOAP 1.1 Protocol";
    private boolean _inbound;
    private boolean _wsi;
    private String _soapProtocol;
    private String _targetNamespace;
    private String _wsdlURL;
    private String _externalWSDL;
    private String _externalWSDLURL;
    private boolean _attachmentEnabled;
    private int _mtomThreshold;
    private NamespaceDecl[] _nsdecls;
    private javax.xml.namespace.QName _definitionName;
    private WSDLFactory _factory;
    private ExtensionRegistry _extregistry;
    private HashMap<String, String> _namespaces;
    private Map<String, WSOperation> _operations;
    private Vector<WSBinder> _binders;
    private Vector<WSHandler> _handlers;
    private boolean wsdlWrittenOnce = false;
    public static final String WSDL_NAMESPACE_PREFIX = "wsdl";
    public static final String XSD_NAMESPACE_PREFIX = "xsd";
    public static final String WSDNS1_NAMESPACE_PREFIX = "wsdns1";
    public static final String HTTP_NAMESPACE_PREFIX = "http";
    public static final String MIME_NAMESPACE_PREFIX = "mime";
    public static final String SOAP_NAMESPACE_PREFIX = "soap";
    public static final String WS_NAMESPACE_PREFIX = "ns";
    public static final String WSDL_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/";
    public static final String XSD_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    public static final String WSDNS1_NAMESPACE = "http://www.webmethods.com/";
    public static final String HTTP_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/http/";
    public static final String MIME_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/mime/";
    public static final String SOAP_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/soap/";
    public static final String SOAP_TRANSPORT = "http://schema.xmlsoap.org/soap/http";
    public static final String SOAP12_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/soap12/";
    private static final String[] fieldtypenames = new String[]{"anyType", "string", "record", "object", "recref"};
    private static final String[] objecttypes = new String[]{"anyType", "boolean", "byte", "string", "double", "float", "int", "long", "short", "dateTime", "byte", "decimal", "integer"};
    private int _attributeindx = -1;
    private static Values nsDecls = null;
    private static final String tabstring = "\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t";
    static final String WATT_CHECK_ACLS_INTERNALLY = "watt.server.checkAclsInternally";
    static boolean check = new Boolean(Config.getProperty("watt.server.checkAclsInternally"));
    boolean gCheckAclsInternallyRequired = false;
    private int _wsdType = 0;
    public static final int TYPE_PROVIDER = 1;
    public static final int TYPE_WSDL_FIRST = 2;
    public static final int TYPE_CONSUMER = 3;

    protected NSWSDescriptor(Namespace ns, NSPackage pkg, NSName nsName) {
        super(ns, pkg, nsName, TYPE);
        String host = "localhost";
        try {
            InetAddress hostAddr = Config.getLocalHost();
            host = hostAddr.getHostName();
        }
        catch (UnknownHostException ex) {
            // empty catch block
        }
        this.setWSDLURL(this.buildWSDLURL(nsName));
    }

    public boolean isWsdlWrittenOnce() {
        return this.wsdlWrittenOnce;
    }

    protected NSWSDescriptor(Namespace ns, IData values) {
        super(ns, values);
        if (this._wsdlURL == null) {
            this.setWSDLURL(this.buildWSDLURL(this.nsName));
        }
    }

    protected NSWSDescriptor(Namespace ns, Values values) {
        super(ns, values);
        if (this._wsdlURL == null) {
            this.setWSDLURL(this.buildWSDLURL(this.nsName));
        }
    }

    public static NSWSDescriptor create(Namespace namespace, Values values) {
        if (values == null) {
            return null;
        }
        return new NSWSDescriptor(namespace, values);
    }

    public static NSWSDescriptor create(Namespace namespace, IData anIData) {
        if (anIData == null) {
            return null;
        }
        return new NSWSDescriptor(namespace, anIData);
    }

    public String toString() {
        return this.getNSName().toString();
    }

    public boolean isInbound() {
        return this._inbound;
    }

    public void setInbound(boolean inbound) {
        this._inbound = inbound;
    }

    public boolean isWSI() {
        return this._wsi;
    }

    public void setWSI(boolean wsi) {
        this._wsi = wsi;
    }

    public javax.xml.namespace.QName getDefinitionName() {
        return this._definitionName;
    }

    public void setDefinitionName(javax.xml.namespace.QName name) {
        this._definitionName = name;
    }

    public String[] getNamespaces() {
        String[] ns = new String[this._nsdecls.length];
        for (int i = 0; i < this._nsdecls.length; ++i) {
            ns[i] = this._nsdecls[i].getPrefixWm() + ":" + this._nsdecls[i].getUri();
        }
        return ns;
    }

    public NamespaceDecl[] getPersistedNSDecls() {
        return this._nsdecls;
    }

    public void setNamespaces(String[] ns) {
        this._nsdecls = new NamespaceDecl[ns.length];
        for (int i = 0; i < ns.length; ++i) {
            int indx = ns[i].indexOf("{");
            this._nsdecls[i] = indx > -1 ? new NamespaceDecl(Name.create(ns[i].substring(0, indx)), Name.create(ns[i].substring(indx + 1))) : new NamespaceDecl(Name.create(ns[i]));
            if (this._nsdecls[i].getUri().toString().equals(SOAP12_NAMESPACE)) {
                this.setSOAPProtocol("SOAP 1.2 Protocol");
                continue;
            }
            if (!this._nsdecls[i].getUri().toString().equals(SOAP_NAMESPACE)) continue;
            this.setSOAPProtocol("SOAP 1.1 Protocol");
        }
    }

    private void setNamespaces(HashMap<String, String> ns) {
        if (ns == null) {
            return;
        }
        this._nsdecls = new NamespaceDecl[ns.size()];
        Iterator<String> iter = ns.keySet().iterator();
        int i = 0;
        String key = null;
        while (iter.hasNext()) {
            key = iter.next();
            this._nsdecls[i++] = new NamespaceDecl(Name.create(ns.get(key)), Name.create(key));
        }
    }

    public int getMTOMThreshold() {
        return this._mtomThreshold;
    }

    public void setMTOMTHreshold(int mtomThreshold) {
        this._mtomThreshold = mtomThreshold;
    }

    public boolean isAttachmentEnabled() {
        return this._attachmentEnabled;
    }

    public void setAttachmentEnabled(boolean attachmentEnabled) {
        this._attachmentEnabled = attachmentEnabled;
    }

    public String getSOAPProtocol() {
        return this._soapProtocol != null ? this._soapProtocol : DEFAULT_SOAP_PROTOCOL;
    }

    public void setSOAPProtocol(String soapProtocol) {
        if (!soapProtocol.equals("SOAP 1.1 Protocol") && !soapProtocol.equals("SOAP 1.2 Protocol")) {
            throw new RuntimeException("Invalid Protocol:" + soapProtocol);
        }
        this._soapProtocol = soapProtocol;
    }

    public String getTargetNamespace() {
        return this._targetNamespace;
    }

    private String getDefaultPrefix() {
        String df = null;
        String[] namespacenames = this.getNamespaces();
        for (int n = 0; n < namespacenames.length; ++n) {
            String prefix = "";
            String url = namespacenames[n];
            int indx = namespacenames[n].indexOf(":");
            if (indx > -1) {
                prefix = namespacenames[n].substring(0, indx);
                url = namespacenames[n].substring(indx + 1);
            }
            if (!url.equals(this.getTargetNamespace()) || prefix.equals("")) continue;
            df = prefix;
            break;
        }
        if (df == null) {
            df = "tns";
        }
        return df;
    }

    public void setTargetNamespace(String targetNamespace) {
        this._targetNamespace = targetNamespace;
    }

    public void updateNamespaceDecl(String prefix, String uri) {
        for (int i = 0; i < this._nsdecls.length; ++i) {
            if (this._nsdecls[i] == null || this._nsdecls[i].getLocalName() == null || !this._nsdecls[i].getLocalName().equals(prefix)) continue;
            this._nsdecls[i].setUri(Name.create(uri));
            break;
        }
    }

    public String getExternalWSDLURL() {
        return this._externalWSDLURL;
    }

    public void setExternalWSDLURL(String externalWSDLURL) {
        this._externalWSDLURL = externalWSDLURL;
    }

    public String getWSDLURL() {
        return this._wsdlURL;
    }

    public void setWSDLURL(String wsdlURL) {
        this._wsdlURL = wsdlURL;
    }

    public String getExternalWSDL() {
        return this._externalWSDL;
    }

    public void setExternalWSDL(String wsdl) {
        this._externalWSDL = wsdl;
    }

    public ListIterator<WSBinder> getBinderList() {
        return this._binders.listIterator();
    }

    public boolean addBinder(WSBinder binder) {
        binder.setWSD(this);
        return this._binders.add(binder);
    }

    public boolean removeBinder(WSBinder binder) {
        return this._binders.remove(binder);
    }

    public void addOperation(WSOperation operation) {
        if (operation == null || this._binders == null || this._binders.size() < 1) {
            return;
        }
        Enumeration<WSBinder> binderList = this._binders.elements();
        while (binderList.hasMoreElements()) {
            WSBinder wsb = binderList.nextElement();
            this.addOperation(wsb, operation, null);
        }
    }

    public void removeOperation(WSOperation operation) {
        if (operation == null || this._binders == null || this._binders.size() < 1) {
            return;
        }
        Enumeration<WSBinder> binderList = this._binders.elements();
        while (binderList.hasMoreElements()) {
            WSBinder wsb = binderList.nextElement();
            wsb.removeOperation(operation);
        }
        this._operations.remove(operation.getOperationName());
    }

    public void addOperation(WSBinder binder, WSOperation operation, String soapAction) {
        if (binder == null || operation == null) {
            return;
        }
        binder.addOperation(operation, soapAction);
        this._operations.put(operation.getOperationName(), operation);
    }

    public boolean removeOperation(WSBinder binder, WSOperation operation, String soapAction) {
        if (binder == null || operation == null) {
            return false;
        }
        binder.removeOperation(operation, soapAction);
        if (soapAction == null) {
            soapAction = binder.getDefaultSoapAction(operation.getOperationName());
        }
        if (this.findOperation(soapAction) == null) {
            this._operations.remove(operation.getOperationName());
            return true;
        }
        return false;
    }

    public WSOperation findOperation(String soapAction) {
        if (this._binders == null) {
            return null;
        }
        Enumeration<WSBinder> binders = this._binders.elements();
        while (binders.hasMoreElements()) {
            WSBinder binder = binders.nextElement();
            WSOperation op = binder.findOperation(soapAction);
            if (op == null) continue;
            return op;
        }
        return null;
    }

    public WSBinder findBinder(String soapAction) {
        if (this._binders == null) {
            return null;
        }
        Enumeration<WSBinder> binders = this._binders.elements();
        while (binders.hasMoreElements()) {
            WSBinder binder = binders.nextElement();
            if (binder.findOperation(soapAction) == null) continue;
            return binder;
        }
        return null;
    }

    public WSOperation[] getOperations() {
        WSOperation[] wsOperations = new WSOperation[this._operations.size()];
        this._operations.values().toArray(wsOperations);
        return wsOperations;
    }

    public WSOperation getOperation(String operationName) {
        return this._operations.get(operationName);
    }

    public void updateOperation(String oldOperationName, String newOperationName, WSOperation op) {
        if (oldOperationName == null || newOperationName == null || op == null) {
            return;
        }
        if (this._operations.containsKey(oldOperationName)) {
            this._operations.remove(oldOperationName);
            this._operations.put(newOperationName, op);
        }
    }

    public WSBinder[] getBinders() {
        Object[] wsBinder = new WSBinder[this._binders.size()];
        this._binders.copyInto(wsBinder);
        return wsBinder;
    }

    public WSBinder getBinder(String binderName) {
        WSBinder wsBinder = null;
        if (this._binders != null && binderName != null) {
            Enumeration<WSBinder> binderList = this._binders.elements();
            while (binderList.hasMoreElements()) {
                WSBinder wsb = binderList.nextElement();
                if (!binderName.equals(wsb.getBinderName())) continue;
                wsBinder = wsb;
                break;
            }
        }
        return wsBinder;
    }

    @Override
    public Values getValues() {
        int i;
        Values[] binderList = null;
        if (this._binders != null) {
            binderList = new Values[this._binders.size()];
            for (int i2 = 0; i2 < binderList.length; ++i2) {
                WSBinder wsBinder = this._binders.get(i2);
                if (wsBinder == null) continue;
                binderList[i2] = wsBinder.getValues();
            }
        }
        Values[] operationList = null;
        if (this._operations != null) {
            operationList = new Values[this._operations.size()];
            Iterator<WSOperation> opIterator = this._operations.values().iterator();
            i = 0;
            while (opIterator.hasNext()) {
                WSOperation wsOperation = opIterator.next();
                operationList[i] = wsOperation.getValues();
                ++i;
            }
        }
        Values[] handlerList = null;
        if (this._handlers != null) {
            handlerList = new Values[this._handlers.size()];
            for (i = 0; i < handlerList.length; ++i) {
                WSHandler wsHandler = this._handlers.get(i);
                if (wsHandler == null) continue;
                handlerList[i] = wsHandler.getValues();
            }
        }
        Values nsvalues = new Values();
        if (this._nsdecls != null && this._nsdecls.length > 0) {
            for (int i3 = 0; i3 < this._nsdecls.length; ++i3) {
                nsvalues.put(this._nsdecls[i3].getPrefixWm().toString(), this._nsdecls[i3].getUri().toString());
            }
        }
        Object[][] o = new Object[][]{{KEY_WSD_INBOUND, this._inbound ? "true" : null}, {KEY_WSD_WSI, this._wsi ? "true" : null}, {KEY_WSD_SOAP_PROTOCOL, this._soapProtocol}, {KEY_WSD_TARGET_NAMESPACE, this._targetNamespace}, {KEY_WSD_DEFINITION_NAME, this._definitionName != null ? this._definitionName.getLocalPart() : null}, {KEY_WSD_ATTACHMENT, this._attachmentEnabled ? "true" : null}, {KEY_WSD_MTOM_THRESHOLD, this._mtomThreshold}, {KEY_WSD_WSDL_URL, this._wsdlURL}, {KEY_WSD_EXTERNAL_WSDL_URL, this._externalWSDLURL}, {KEY_WSD_EXTERNAL_WSDL, this._externalWSDL}, {KEY_WSD_BINDERLIST, binderList}, {KEY_WSD_OPERATIONLIST, operationList}, {KEY_WSD_NAMESPACES, nsvalues}, {KEY_WSD_HANDLERLIST, handlerList}};
        return super.getValues().copyFrom(new Values(o));
    }

    @Override
    public void setValues(Values values) {
        Object h;
        if (values == null) {
            return;
        }
        super.setValues(values);
        String originalTargetNamespace = this._targetNamespace;
        this._inbound = values.getBoolean(KEY_WSD_INBOUND);
        this._wsi = values.getBoolean(KEY_WSD_WSI);
        this._soapProtocol = values.getString(KEY_WSD_SOAP_PROTOCOL);
        this._targetNamespace = values.getString(KEY_WSD_TARGET_NAMESPACE);
        this._attachmentEnabled = values.getBoolean(KEY_WSD_ATTACHMENT);
        this._mtomThreshold = values.getInt(KEY_WSD_MTOM_THRESHOLD);
        this._wsdlURL = values.getString(KEY_WSD_WSDL_URL);
        this._externalWSDL = values.getString(KEY_WSD_EXTERNAL_WSDL);
        this._externalWSDLURL = values.getString(KEY_WSD_EXTERNAL_WSDL_URL);
        String defName = values.getString(KEY_WSD_DEFINITION_NAME);
        if (defName != null) {
            this._definitionName = new javax.xml.namespace.QName(this._targetNamespace, defName);
        }
        if ((h = values.get(KEY_WSD_HANDLERLIST)) instanceof Vector || h == null) {
            this._handlers = this.createHandlers((Vector)h);
        } else if (h instanceof IData[]) {
            this._handlers = this.createHandlers((IData[])h);
        } else if (h instanceof ArrayList) {
            this._handlers = this.createHandlers((ArrayList)h);
        }
        Object f = values.get(KEY_WSD_BINDERLIST);
        if (f instanceof Vector || f == null) {
            this._binders = this.createBinders((Vector)f);
        } else if (f instanceof ArrayList) {
            this._binders = this.createBinders((ArrayList)f);
        } else if (f instanceof IData[]) {
            this._binders = this.createBinders((IData[])f);
        }
        Object o = values.get(KEY_WSD_OPERATIONLIST);
        if (o instanceof Vector || o == null) {
            this._operations = this.createOperations((Vector)o);
        } else if (o instanceof ArrayList) {
            this._operations = this.createOperations((ArrayList)o);
        } else if (o instanceof IData[]) {
            this._operations = this.createOperations((IData[])o);
        }
        Object n = values.get(KEY_WSD_NAMESPACES);
        if (n != null && n instanceof IData) {
            IDataCursor idc = ((IData)n).getCursor();
            Vector<NamespaceDecl> nsdecls = new Vector<NamespaceDecl>();
            while (idc.next()) {
                String key = idc.getKey();
                String value = (String)idc.getValue();
                nsdecls.add(new NamespaceDecl(Name.create(key), Name.create(value)));
            }
            if (nsdecls.size() > 0) {
                this._nsdecls = new NamespaceDecl[nsdecls.size()];
                nsdecls.toArray(this._nsdecls);
            }
        }
    }

    @Override
    public IData getAsData() {
        IData values = super.getAsData();
        IDataCursor ic = values.getCursor();
        ic.insertAfter(KEY_WSD_INBOUND, this._inbound);
        ic.insertAfter(KEY_WSD_WSI, this._wsi);
        ic.insertAfter(KEY_WSD_SOAP_PROTOCOL, this._soapProtocol);
        ic.insertAfter(KEY_WSD_TARGET_NAMESPACE, this._targetNamespace);
        ic.insertAfter(KEY_WSD_ATTACHMENT, this._attachmentEnabled);
        ic.insertAfter(KEY_WSD_MTOM_THRESHOLD, this._mtomThreshold);
        ic.insertAfter(KEY_WSD_WSDL_URL, this._wsdlURL);
        ic.insertAfter(KEY_WSD_EXTERNAL_WSDL, this._externalWSDL);
        ic.insertAfter(KEY_WSD_EXTERNAL_WSDL_URL, this._externalWSDLURL);
        ic.insertAfter(KEY_WSD_DEFINITION_NAME, this._definitionName != null ? this._definitionName.getLocalPart() : null);
        IData[] handlerList = null;
        if (this._handlers != null) {
            handlerList = new IData[this._handlers.size()];
            for (int i = 0; i < handlerList.length; ++i) {
                WSHandler wsHandler = this._handlers.get(i);
                if (wsHandler == null) continue;
                handlerList[i] = wsHandler.getAsData();
            }
        }
        ic.insertAfter(KEY_WSD_HANDLERLIST, handlerList);
        IData[] binderList = null;
        if (this._binders != null) {
            binderList = new IData[this._binders.size()];
            for (int i = 0; i < binderList.length; ++i) {
                WSBinder wsBinder = this._binders.get(i);
                if (wsBinder == null) continue;
                binderList[i] = wsBinder.getAsData();
            }
        }
        ic.insertAfter(KEY_WSD_BINDERLIST, binderList);
        IData[] operationList = null;
        if (this._operations != null) {
            operationList = new IData[this._operations.size()];
            Iterator<WSOperation> opIterator = this._operations.values().iterator();
            int i = 0;
            while (opIterator.hasNext()) {
                WSOperation wsOperation = opIterator.next();
                operationList[i] = wsOperation.getAsData();
                ++i;
            }
        }
        ic.insertAfter(KEY_WSD_OPERATIONLIST, operationList);
        IData nsvalues = IDataFactory.create(0);
        if (this._nsdecls != null && this._nsdecls.length > 0) {
            IDataCursor nsidc = nsvalues.getCursor();
            nsidc.last();
            for (int i = 0; i < this._nsdecls.length; ++i) {
                nsidc.insertAfter(this._nsdecls[i].getPrefixWm().toString(), this._nsdecls[i].getUri().toString());
            }
        }
        ic.insertAfter(KEY_WSD_NAMESPACES, nsvalues);
        ic.destroy();
        return values;
    }

    @Override
    public void setFromData(IData values) {
        Object h;
        if (values == null) {
            return;
        }
        super.setFromData(values);
        String originalTargetNamespace = this._targetNamespace;
        IDataCursor ic = values.getCursor();
        if (ic.first(KEY_WSD_INBOUND)) {
            this._inbound = IDataUtil.getBoolean(ic);
        }
        if (ic.first(KEY_WSD_WSI)) {
            this._wsi = IDataUtil.getBoolean(ic);
        }
        if (ic.first(KEY_WSD_SOAP_PROTOCOL)) {
            this._soapProtocol = IDataUtil.getString(ic);
        }
        if (ic.first(KEY_WSD_TARGET_NAMESPACE)) {
            this._targetNamespace = IDataUtil.getString(ic);
        }
        if (ic.first(KEY_WSD_ATTACHMENT)) {
            this._attachmentEnabled = IDataUtil.getBoolean(ic);
        }
        if (ic.first(KEY_WSD_MTOM_THRESHOLD)) {
            this._mtomThreshold = IDataUtil.getInt(ic);
        }
        if (ic.first(KEY_WSD_WSDL_URL)) {
            this._wsdlURL = IDataUtil.getString(ic);
        }
        if (ic.first(KEY_WSD_EXTERNAL_WSDL)) {
            this._externalWSDL = IDataUtil.getString(ic);
        }
        if (ic.first(KEY_WSD_EXTERNAL_WSDL_URL)) {
            this._externalWSDLURL = IDataUtil.getString(ic);
        }
        if (ic.first(KEY_WSD_DEFINITION_NAME)) {
            this._definitionName = new javax.xml.namespace.QName(this._targetNamespace, IDataUtil.getString(ic));
        }
        if ((h = IDataUtil.get(ic, KEY_WSD_HANDLERLIST)) instanceof Vector || h == null) {
            this._handlers = this.createHandlers((Vector)h);
        } else if (h instanceof IData[]) {
            this._handlers = this.createHandlers((IData[])h);
        } else if (h instanceof ArrayList) {
            this._handlers = this.createHandlers((ArrayList)h);
        }
        Object f = IDataUtil.get(ic, KEY_WSD_BINDERLIST);
        if (f instanceof Vector || f == null) {
            this._binders = this.createBinders((Vector)f);
        } else if (f instanceof ArrayList) {
            this._binders = this.createBinders((ArrayList)f);
        } else if (f instanceof IData[]) {
            this._binders = this.createBinders((IData[])f);
        }
        Object o = IDataUtil.get(ic, KEY_WSD_OPERATIONLIST);
        if (o instanceof Vector || f == null) {
            this._operations = this.createOperations((Vector)o);
        } else if (o instanceof ArrayList) {
            this._operations = this.createOperations((ArrayList)o);
        } else if (o instanceof IData[]) {
            this._operations = this.createOperations((IData[])o);
        }
        Object n = IDataUtil.get(ic, KEY_WSD_NAMESPACES);
        if (n != null && n instanceof IData) {
            IDataCursor idc = ((IData)n).getCursor();
            Vector<NamespaceDecl> nsdecls = new Vector<NamespaceDecl>();
            while (idc.next()) {
                String key = idc.getKey();
                String value = (String)idc.getValue();
                nsdecls.add(new NamespaceDecl(Name.create(key), Name.create(value)));
            }
            if (nsdecls.size() > 0) {
                this._nsdecls = new NamespaceDecl[nsdecls.size()];
                nsdecls.toArray(this._nsdecls);
            }
        }
    }

    private Vector<WSHandler> createHandlers(IData[] v) {
        if (v == null) {
            return new Vector<WSHandler>();
        }
        Vector<WSHandler> nv = new Vector<WSHandler>(v.length);
        for (int i = 0; i < v.length; ++i) {
            WSHandler handler = new WSHandler(null, null, null, null, null);
            handler.setFromData(v[i]);
            if (handler == null) continue;
            nv.add(handler);
        }
        return nv;
    }

    private Vector<WSHandler> createHandlers(ArrayList v) {
        if (v == null) {
            return new Vector<WSHandler>();
        }
        int vSize = v.size();
        Vector<WSHandler> nv = new Vector<WSHandler>(vSize);
        for (int i = 0; i < vSize; ++i) {
            Object o = v.get(i);
            WSHandler handler = new WSHandler(null, null, null, null, null);
            handler.setFromData((IData)o);
            if (handler == null) continue;
            nv.add(handler);
        }
        return nv;
    }

    private Vector<WSHandler> createHandlers(Vector v) {
        if (v == null) {
            return new Vector<WSHandler>();
        }
        int vSize = v.size();
        Vector<WSHandler> nv = new Vector<WSHandler>(vSize);
        for (int i = 0; i < vSize; ++i) {
            Object o = v.get(i);
            WSHandler handler = new WSHandler(null, null, null, null, null);
            handler.setFromData((IData)o);
            if (handler == null) continue;
            nv.add(handler);
        }
        return nv;
    }

    private Vector<WSBinder> createBinders(IData[] v) {
        if (v == null) {
            return new Vector<WSBinder>();
        }
        Vector<WSBinder> nv = new Vector<WSBinder>(v.length);
        for (int i = 0; i < v.length; ++i) {
            WSBinder binder = WSBinder.create(v[i], this.getNamespace());
            if (binder == null) continue;
            nv.add(binder);
            binder.setWSD(this);
        }
        return nv;
    }

    private Vector<WSBinder> createBinders(Vector v) {
        if (v == null) {
            return new Vector<WSBinder>();
        }
        int vSize = v.size();
        Vector<WSBinder> nv = new Vector<WSBinder>(vSize);
        for (int i = 0; i < vSize; ++i) {
            Object o = v.get(i);
            WSBinder binder = null;
            if (o instanceof IData) {
                binder = WSBinder.create((IData)o, this.getNamespace());
            }
            if (binder == null) continue;
            nv.add(binder);
            binder.setWSD(this);
        }
        return nv;
    }

    private Vector<WSBinder> createBinders(ArrayList v) {
        if (v == null) {
            return new Vector<WSBinder>();
        }
        int vSize = v.size();
        Vector<WSBinder> nv = new Vector<WSBinder>(vSize);
        for (int i = 0; i < vSize; ++i) {
            Object o = v.get(i);
            WSBinder binder = null;
            if (o instanceof IData) {
                binder = WSBinder.create((IData)o, this.getNamespace());
            }
            if (binder == null) continue;
            nv.add(binder);
            binder.setWSD(this);
        }
        return nv;
    }

    private Map<String, WSOperation> createOperations(IData[] v) {
        if (v == null) {
            return new LinkedHashMap<String, WSOperation>();
        }
        LinkedHashMap<String, WSOperation> nv = new LinkedHashMap<String, WSOperation>(v.length);
        for (int i = 0; i < v.length; ++i) {
            WSOperation op = WSOperation.create(v[i], this.getNamespace());
            if (op == null) continue;
            nv.put(op.getOperationName(), op);
        }
        return nv;
    }

    private Map<String, WSOperation> createOperations(Vector v) {
        if (v == null) {
            return new LinkedHashMap<String, WSOperation>();
        }
        int vSize = v.size();
        LinkedHashMap<String, WSOperation> nv = new LinkedHashMap<String, WSOperation>(vSize);
        for (int i = 0; i < vSize; ++i) {
            Object o = v.get(i);
            WSOperation op = null;
            if (o instanceof IData) {
                op = WSOperation.create((IData)o, this.getNamespace());
            }
            if (op == null) continue;
            nv.put(op.getOperationName(), op);
        }
        return nv;
    }

    private Map<String, WSOperation> createOperations(ArrayList v) {
        if (v == null) {
            return new LinkedHashMap<String, WSOperation>();
        }
        int vSize = v.size();
        LinkedHashMap<String, WSOperation> nv = new LinkedHashMap<String, WSOperation>(vSize);
        for (int i = 0; i < vSize; ++i) {
            Object o = v.get(i);
            WSOperation op = null;
            if (o instanceof IData) {
                op = WSOperation.create((IData)o, this.getNamespace());
            }
            if (op == null) continue;
            nv.put(op.getOperationName(), op);
        }
        return nv;
    }

    public Vector<javax.xml.namespace.QName> getHeaderQNames(String operationname, boolean inbound) {
        Vector<javax.xml.namespace.QName> headers = new Vector<javax.xml.namespace.QName>();
        WSOperation operation = this.findOperation(operationname);
        if (operation != null) {
            WSMessage message = null;
            message = inbound ? operation.getWSRequest() : operation.getWSResponse();
            if (message != null) {
                String[] headernames = message.getHeaderNames();
                for (int i = 0; i < headernames.length; ++i) {
                    String headerlocalpart = headernames[i];
                    String headernamespace = "";
                    int indx = headernames[i].indexOf("}");
                    if (indx > -1) {
                        headerlocalpart = headernames[i].substring(indx + 1);
                        headernamespace = headernames[i].substring(1, indx);
                    }
                    headers.add(new javax.xml.namespace.QName(headernamespace, headerlocalpart));
                }
            }
        }
        return headers;
    }

    public String writeWSDL() throws NSException {
        String wsdl;
        WSContext wsdc;
        block32: {
            block31: {
                wsdc = new WSContext(this);
                wsdl = "";
                try {
                    if (this._factory == null) {
                        this._factory = WSDLFactory.newInstance();
                    }
                    if (this._extregistry == null) {
                        this._extregistry = this._factory.newPopulatedExtensionRegistry();
                    }
                    WSDLWriter writer = this._factory.newWSDLWriter();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    Definition definition = this.toDefinition(wsdc);
                    writer.writeWSDL(definition, (OutputStream)baos);
                    wsdl = baos.toString("UTF-8");
                    definition = null;
                }
                catch (WSDLException we) {
                    NSException temp = new NSException(NSWebsvcExceptionBundle.class, NSWebsvcExceptionBundle.WSDL_GENERATION_EXCEPTION, "", new Object[]{this.getNSName().getNodeName().toString(), we.getMessage()});
                    throw temp;
                }
                catch (Exception e) {
                    NSException temp = new NSException(NSWebsvcExceptionBundle.class, NSWebsvcExceptionBundle.WSDL_GENERATION_EXCEPTION, "", new Object[]{this.getNSName().getNodeName().toString(), e.getLocalizedMessage()});
                    throw temp;
                }
                wsdl = this.setSoapHeaderAttrbiutesInWSDL(wsdl, this._wsdlURL);
                if (this.getWSDType() == 2) break block31;
                if (this.getWSDType() != 3) break block32;
            }
            WsdlMerger wsdlMerger = new WsdlMerger();
            wsdl = wsdlMerger.mergeWSDL(wsdl, this._externalWSDL, this._wsdlURL, this._externalWSDLURL, this.getWSDType());
        }
        int indx = 0;
        block3: while (indx < wsdl.length() && (indx = wsdl.indexOf("message=", indx)) > -1) {
            int start = indx + 9;
            indx += 9;
            while (indx < wsdl.length() && wsdl.charAt(indx) != '\"') {
                if (wsdl.charAt(indx) == ':') {
                    String dpfix = wsdc.getTNSPrefix();
                    indx = (wsdl = wsdl.substring(0, start) + dpfix + wsdl.substring(indx)).indexOf("message=", start);
                    if (indx != -1) continue block3;
                    indx = wsdl.length();
                    continue block3;
                }
                ++indx;
            }
        }
        WSBinder[] binders = this.getBinders();
        if (binders != null && binders.length > 0) {
            int start;
            boolean hasEncodedBinding = false;
            for (int i = 0; i < binders.length; ++i) {
                if ("literal".equals(binders[i].getBindingUse())) continue;
                hasEncodedBinding = true;
                break;
            }
            indx = 0;
            String xsdprefix = wsdc.getPrefix(XSD_NAMESPACE);
            String soapEncPrefix = "SOAP_ENC";
            String wsdlPrefix = wsdc.getPrefix(WSDL_NAMESPACE);
            while (indx < wsdl.length() && (indx = wsdl.indexOf(soapEncPrefix + ":Array", indx)) > -1 && (start = wsdl.substring(0, indx).lastIndexOf("<" + xsdprefix + ":complexType")) > -1) {
                String orgDef = "";
                if (hasEncodedBinding) {
                    int complexTypeEnd = wsdl.substring(indx).indexOf("</" + xsdprefix + ":complexType");
                    orgDef = wsdl.substring(start, indx + complexTypeEnd);
                    if ((orgDef = orgDef + "</" + xsdprefix + ":complexType>").startsWith("<" + xsdprefix + ":complexType name=\"ArrayOfENC") || orgDef.startsWith("<" + xsdprefix + ":complexType name=\"TableOfENC")) {
                        indx = wsdl.indexOf(orgDef) + orgDef.length();
                        continue;
                    }
                }
                int namestart = wsdl.indexOf("\"", start);
                int nameend = wsdl.indexOf("\"", namestart + 1);
                int end = wsdl.indexOf(">", start);
                if (wsdl.charAt(end + 1) == '\n') {
                    ++end;
                }
                String realtype = "";
                String ccend = "</" + xsdprefix + ":complexContent";
                int complexcontent = wsdl.indexOf(ccend, end);
                int complexcontentEnd = wsdl.indexOf(">", complexcontent);
                if (complexcontent <= -1 || complexcontentEnd <= -1) break;
                String cc = wsdl.substring(end + 1, complexcontentEnd + 1);
                int typeindx = cc.indexOf(wsdlPrefix + ":arrayType");
                if ((typeindx = cc.indexOf("\"", typeindx)) > -1) {
                    int closequote = cc.indexOf("\"", typeindx + 1);
                    if (closequote > -1) {
                        realtype = cc.substring(typeindx + 1, closequote);
                    }
                    while (realtype.endsWith("[]")) {
                        realtype = realtype.substring(0, realtype.length() - 2);
                    }
                }
                String newdef = null;
                if (realtype.endsWith("[,]")) {
                    realtype = realtype.substring(0, realtype.length() - 3);
                    String tablename = wsdl.substring(namestart + 1, nameend);
                    String arrayname = "Array" + wsdl.substring(namestart + 6, nameend);
                    newdef = "<" + xsdprefix + ":sequence>\n\t\t\t<" + xsdprefix + ":element name=\"" + arrayname + "\" maxOccurs=\"unbounded\">\n" + "<" + xsdprefix + ":complexType>\n" + "<" + xsdprefix + ":sequence>\n" + "<" + xsdprefix + ":element name=\"" + arrayname + "Item\"" + " type=\"" + realtype + "\"" + " maxOccurs=\"unbounded\"" + "/>" + "</" + xsdprefix + ":sequence>\n" + "</" + xsdprefix + ":complexType>\n" + "</" + xsdprefix + ":element>\n" + "\t\t</" + xsdprefix + ":sequence>";
                } else {
                    String arrayTypeName = wsdl.substring(namestart + 1, nameend);
                    String realTypePrefix = "";
                    String realTypeLocalName = "";
                    int realTypePrefixIndex = realtype.indexOf(58);
                    if (realTypePrefixIndex > 0) {
                        realTypePrefix = realtype.substring(0, realTypePrefixIndex);
                        realTypeLocalName = realtype.substring(realTypePrefixIndex + 1);
                    }
                    if (realTypePrefix != null && !realTypePrefix.equals(xsdprefix)) {
                        String realTypeNamespace = null;
                        for (int i = 0; i < this._nsdecls.length; ++i) {
                            if (!realTypePrefix.equals(this._nsdecls[i].getPrefixWm().toString())) continue;
                            realTypeNamespace = this._nsdecls[i].getUri().toString();
                            break;
                        }
                        QName realTypeQName = QName.create(realTypeNamespace, realTypeLocalName);
                        HashMap<QName, QName> duplicatesResolved = wsdc.getDuplicatesResolved();
                        if (duplicatesResolved != null && duplicatesResolved.containsKey(realTypeQName)) {
                            String originalTypeName = duplicatesResolved.get(realTypeQName).getNCName();
                            arrayTypeName = arrayTypeName.replace(realTypeLocalName, originalTypeName);
                        }
                    }
                    newdef = "<" + xsdprefix + ":sequence>\n\t\t\t<" + xsdprefix + ":element name=\"" + arrayTypeName + "Item\" type=\"" + realtype + "\" maxOccurs=\"unbounded\"/>\n" + "\t\t</" + xsdprefix + ":sequence>\n";
                }
                if (hasEncodedBinding) {
                    String cTEnd = "</" + xsdprefix + ":complexType>";
                    orgDef = orgDef.replaceAll("<" + xsdprefix + ":complexType name=\"ArrayOf", "<" + xsdprefix + ":complexType name=\"ArrayOfENC");
                    orgDef = orgDef.replaceAll("<" + xsdprefix + ":complexType name=\"TableOf", "<" + xsdprefix + ":complexType name=\"TableOfENC");
                    orgDef = orgDef.replaceAll("<" + xsdprefix + ":complexType name=\"ArrayOfENCENC", "<" + xsdprefix + ":complexType name=\"ArrayOfENC");
                    orgDef = orgDef.replaceAll("<" + xsdprefix + ":complexType name=\"TableOfENCENC", "<" + xsdprefix + ":complexType name=\"TableOfENC");
                    String wsdlStartPart = wsdl.substring(0, end + 1);
                    String wsdlEndPart = wsdl.substring(complexcontentEnd + 1);
                    wsdlEndPart = wsdlEndPart.replaceFirst(cTEnd, "");
                    wsdl = wsdlStartPart + newdef + cTEnd + "\n" + orgDef + wsdlEndPart;
                    indx = wsdl.indexOf(orgDef) + orgDef.length();
                    continue;
                }
                wsdl = wsdl.substring(0, end + 1) + newdef + wsdl.substring(complexcontentEnd + 1);
            }
            if (hasEncodedBinding) {
                String tnsPrefix = wsdc.getTNSPrefix();
                wsdl = wsdl.replaceAll("type=\"" + tnsPrefix + ":ArrayOf", "type=\"" + tnsPrefix + ":ArrayOfENC");
                wsdl = wsdl.replaceAll("type=\"" + tnsPrefix + ":TableOf", "type=\"" + tnsPrefix + ":TableOfENC");
                wsdl = wsdl.replaceAll("type=\"" + tnsPrefix + ":ArrayOfENCENC", "type=\"" + tnsPrefix + ":ArrayOfENC");
                wsdl = wsdl.replaceAll("type=\"" + tnsPrefix + ":TableOfENCENC", "type=\"" + tnsPrefix + ":TableOfENC");
            }
            if (!hasEncodedBinding) {
                int endTagIndex;
                int importIndex = wsdl.indexOf("<" + xsdprefix + ":import");
                while (importIndex > -1 && (endTagIndex = wsdl.indexOf("/>", importIndex)) > -1) {
                    if (wsdl.substring(importIndex, endTagIndex).indexOf("\"http://schemas.xmlsoap.org/soap/encoding/\"") > -1) {
                        wsdl = wsdl.substring(0, importIndex) + wsdl.substring(endTagIndex + 2);
                    }
                    importIndex = wsdl.indexOf("<" + xsdprefix + ":import", endTagIndex);
                }
            }
        }
        this._namespaces = wsdc.getNamespaces();
        this.wsdlWrittenOnce = true;
        return wsdl;
    }

    public static synchronized Values getNSDecls() {
        if (nsDecls == null) {
            nsDecls = new Values();
            nsDecls.put(WSDL_NAMESPACE_PREFIX, Name.create(WSDL_NAMESPACE));
            nsDecls.put(XSD_NAMESPACE_PREFIX, Name.create(XSD_NAMESPACE));
            nsDecls.put("xml", Name.create("http://www.w3.org/XML/1998/namespace"));
            nsDecls.put("xsi", Name.create("http://www.w3.org/2001/XMLSchema-instance"));
        }
        return nsDecls;
    }

    private String fixPrefixes(String wsdl, String fragment, String targetAttribute, String updateValue) {
        int indx = 0;
        block0: while (indx < wsdl.length() && (indx = wsdl.indexOf(fragment, indx)) > -1 && (indx = wsdl.indexOf(targetAttribute, indx)) > -1) {
            int start = indx + (targetAttribute.length() + 1);
            indx += targetAttribute.length() + 1;
            while (indx < wsdl.length() && wsdl.charAt(indx) != '\"') {
                if (wsdl.charAt(indx) == ':') {
                    indx = (wsdl = wsdl.substring(0, start) + updateValue + wsdl.substring(indx + 1)).indexOf(fragment, start);
                    if (indx != -1) continue block0;
                    indx = wsdl.length();
                    continue block0;
                }
                ++indx;
            }
        }
        return wsdl;
    }

    public Definition toDefinition() throws WSDLException {
        return this.toDefinition(new WSContext(this));
    }

    public Definition toDefinition(WSContext wsdc) throws WSDLException {
        Definition _definition = this._factory.newDefinition();
        _definition.setQName(this.getDefinitionName() != null ? new javax.xml.namespace.QName(this.getTargetNamespace(), this.getDefinitionName().getLocalPart()) : null);
        _definition.setTargetNamespace(this._targetNamespace);
        String[] namespacenames = this.getNamespaces();
        for (int n = 0; n < namespacenames.length; ++n) {
            String prefix = "";
            String url = namespacenames[n];
            int indx = namespacenames[n].indexOf(":");
            if (indx > -1) {
                prefix = namespacenames[n].substring(0, indx);
                url = namespacenames[n].substring(indx + 1);
            }
            _definition.addNamespace(prefix, url);
            wsdc.putPrefix(url, prefix);
        }
        ArrayList<Vector> allrecords = new ArrayList<Vector>();
        ArrayList<String> allrecordnames = new ArrayList<String>();
        WSOperation[] operations = this.getOperations();
        for (int op = 0; op < operations.length; ++op) {
            Vector<NSRecord> records = operations[op].getAllRecordsForOperation(this.getWSDType());
            while (records.size() > 0) {
                QName qn;
                NSRecord nsRec = records.remove(0);
                String tns = this.getTargetNamespace();
                String localname = nsRec.getName();
                Name name = nsRec.getXmlNamespace();
                if (name != null) {
                    tns = name.toString();
                }
                if ((qn = nsRec.getUniversalName()) != null) {
                    tns = qn.getNamespace();
                    localname = qn.getNCName();
                }
                qn = QName.create(tns, localname);
                Message msg = Message.create(qn, null);
                msg.setNSRecord(nsRec);
                msg.setTypeNameURI(tns);
                msg.setUseSoapRpc(true);
                if (!this.hasEncodedBinding()) {
                    msg.setUseSoapLiteral(true);
                }
                Vector msgvector = null;
                if (allrecordnames.indexOf(tns) > -1) {
                    msgvector = (Vector)allrecords.get(allrecordnames.indexOf(tns));
                } else {
                    msgvector = new Vector();
                    allrecords.add(msgvector);
                    allrecordnames.add(tns);
                }
                msgvector.add(msg);
            }
        }
        for (int n = 0; n < allrecords.size(); ++n) {
            Vector msgvector = (Vector)allrecords.get(n);
            Message[] msgs = new Message[msgvector.size()];
            msgs = msgvector.toArray(msgs);
            try {
                String endtag;
                WSD oldwsd = WSD.create(new Service[0], new com.wm.lang.wsdl.Binding[0], msgs, new Folder[0], new ExtendedElement[0], this.getDefinitionName().getLocalPart(), this.getTargetNamespace());
                wsdc.putOldWSD((String)allrecordnames.get(n), oldwsd);
                IData temp = new WSDGenerator().generate(oldwsd, this, true);
                wsdc.setDuplicatesResolved((HashMap)IDataUtil.get(temp.getCursor(), "DUPLICATES_RESOLVED"));
                String generatedwsdl = IDataUtil.getString(temp.getCursor(), "source");
                int start = generatedwsdl.indexOf("<wsdl:types>");
                int end = generatedwsdl.indexOf("</wsdl:types>");
                if (start <= -1 || end <= -1) continue;
                String xsdprefix = wsdc.getPrefix(XSD_NAMESPACE);
                String defaultTag = "xsd:schema";
                String usedTag = xsdprefix + ":schema";
                String schemas = generatedwsdl.substring(start + 12, end).trim();
                while (schemas.length() > 0 && (end = schemas.indexOf(endtag = "</" + defaultTag + ">")) > -1) {
                    int tnsindx;
                    String schemastring = schemas.substring(0, end);
                    if (!defaultTag.equals(usedTag)) {
                        schemastring = schemastring.replace(defaultTag, usedTag);
                    }
                    if ((tnsindx = schemastring.indexOf("targetNamespace=\"")) > -1) {
                        String tnsstring = schemastring.substring(tnsindx + 17, schemastring.indexOf("\"", tnsindx + 17));
                        wsdc.getSchemastringBuffers().put(tnsstring, new StringBuffer(schemastring));
                        if (!tnsstring.equals(this._targetNamespace)) {
                            int nsindx;
                            int iii = schemastring.indexOf(">");
                            for (int curindx = 0; curindx < iii && (nsindx = schemastring.substring(curindx, iii).indexOf(tnsstring)) != -1; curindx += nsindx + 1) {
                                if (curindx + nsindx == tnsindx + 17) continue;
                                String tempfrag = schemastring.substring(curindx, curindx + nsindx - 2);
                                if (wsdc.getPrefix(tnsstring) != null) {
                                    String prfx = wsdc.getPrefix(tnsstring);
                                    if (_definition.getNamespace(prfx) != null) continue;
                                    _definition.addNamespace(prfx, tnsstring);
                                    continue;
                                }
                                String newprefix = "HDR";
                                int sufx = 1;
                                String existingNS = _definition.getNamespace(newprefix + sufx);
                                while (existingNS != null && !tnsstring.equals(existingNS)) {
                                    existingNS = _definition.getNamespace(newprefix + ++sufx);
                                }
                                if (existingNS == null) {
                                    newprefix = newprefix + sufx;
                                    _definition.addNamespace(newprefix, tnsstring);
                                }
                                wsdc.putPrefix(tnsstring, newprefix);
                            }
                        }
                    }
                    schemas = schemas.substring(end + endtag.length());
                }
                continue;
            }
            catch (Exception ex) {
                if (!debug) continue;
                ex.printStackTrace();
            }
        }
        String xsdprefix = wsdc.getPrefix(XSD_NAMESPACE);
        if (wsdc.getSchemastringBuffers().get(this._targetNamespace) == null) {
            StringBuffer schemastring = new StringBuffer("<" + xsdprefix + ":schema  targetNamespace=\"" + this._targetNamespace + "\">\n");
            wsdc.getSchemastringBuffers().put(this._targetNamespace, schemastring);
            this._attributeindx = schemastring.length();
        }
        javax.wsdl.Service service = _definition.createService();
        service.setQName(new javax.xml.namespace.QName(this.getTargetNamespace(), this.getNSName().getNodeName().toString()));
        String originalSOAPProtocol = this.getSOAPProtocol();
        WSBinder[] binders = this.getBinders();
        for (int b = 0; b < binders.length; ++b) {
            this.setSOAPProtocol(binders[b].getSOAPProtocol());
            wsdc.setBinderStyleAndUse(binders[b].getBindingStyle().substring(0, 3) + binders[b].getBindingUse().substring(0, 3));
            binders[b].toDefinition(_definition, (WSDLElement)service, null, this, wsdc);
        }
        this.setSOAPProtocol(originalSOAPProtocol);
        _definition.addService(service);
        Types types = _definition.createTypes();
        Iterator<String> iter = wsdc.getSchemastringBuffers().keySet().iterator();
        while (iter.hasNext()) {
            this.createSchemaElement(types, wsdc.getSchemastringBuffers().get(iter.next()), wsdc);
        }
        List schemaslist = types.getExtensibilityElements();
        if (schemaslist != null && schemaslist.size() > 0) {
            _definition.setTypes(types);
        }
        return _definition;
    }

    private void createSchemaElement(Types types, StringBuffer sb, WSContext wsdc) {
        block9: {
            sb.append("\t</" + wsdc.getPrefix(XSD_NAMESPACE) + ":schema>");
            Schema schema = null;
            try {
                schema = (Schema)this._extregistry.createExtension(Types.class, new javax.xml.namespace.QName(XSD_NAMESPACE, "schema"));
                Document doc = new Document(sb.toString(), null, "UTF-8", false, true);
                doc.assignNamespaceDecl(new NamespaceDecl(Name.create(wsdc.getPrefix(XSD_NAMESPACE)), Name.create(XSD_NAMESPACE)));
                doc.completeLoad();
                ElementNode schemanode = (ElementNode)doc.getFirstElement();
                if (schemanode != null) {
                    boolean atleastone = false;
                    for (Node child = schemanode.getFirstChildWm(); child != null; child = child.getNextSiblingWm()) {
                        if (!(child instanceof ElementNode)) continue;
                        atleastone = true;
                        break;
                    }
                    if (!atleastone) {
                        return;
                    }
                }
                schema.setElement((Element)schemanode);
                types.addExtensibilityElement((ExtensibilityElement)schema);
            }
            catch (WMDocumentException wde) {
                if (debug) {
                    wde.printStackTrace();
                }
            }
            catch (IOException ioe) {
                if (debug) {
                    ioe.printStackTrace();
                }
            }
            catch (WSDLException wsdle) {
                if (!debug) break block9;
                wsdle.printStackTrace();
            }
        }
    }

    public HashMap getNamespaceMap() {
        if (this._namespaces != null) {
            return this._namespaces;
        }
        if (this._namespaces == null) {
            try {
                this.writeWSDL();
            }
            catch (Throwable ex) {
                HashMap<String, String> namespaces = new HashMap<String, String>();
                NamespaceDecl[] nsdecls = this.getPersistedNSDecls();
                String[] ns = new String[nsdecls.length];
                for (int i = 0; i < nsdecls.length; ++i) {
                    namespaces.put(nsdecls[i].getUri().toString(), nsdecls[i].getPrefixWm().toString());
                }
                return namespaces;
            }
        }
        return this._namespaces;
    }

    public void formatMessageFragment(WSElement element, String msgname) {
        this.formatMessageFragment(element, msgname, new WSContext(this));
    }

    public void formatMessageFragment(WSElement element, String msgname, WSContext wsdc) {
        StringBuffer sb = null;
        String targetns = null;
        String xsdNS = wsdc.getPrefix(XSD_NAMESPACE);
        int xmlnsindex = -1;
        if (element != null) {
            NSNode innode;
            String elementname = element.getName();
            if (wsdc.getSchemasFormatted().contains(elementname)) {
                return;
            }
            wsdc.getSchemasFormatted().add(elementname);
            targetns = this.resolveTargetNamespace(element);
            sb = wsdc.getSchemastringBuffers().get(targetns);
            if (sb == null) {
                sb = new StringBuffer("<" + xsdNS + ":schema  targetNamespace=\"" + targetns + "\"");
                xmlnsindex = sb.length();
                this._attributeindx = sb.length();
                wsdc.getSchemastringBuffers().put(targetns, sb);
            } else {
                this._attributeindx = sb.toString().indexOf(">") + 1;
            }
            if (element.get_nsOwnerType() == 0) {
                int index;
                String xsdURL = element.getSchemaURL();
                String xsdElement = element.getSchemaElement();
                String elementNamespace = null;
                String elementName = null;
                if (xsdElement != null && (index = xsdElement.indexOf(125)) > 0) {
                    elementName = xsdElement.substring(index + 1);
                    elementNamespace = xsdElement.substring(1, index);
                }
                if (elementNamespace != null && !wsdc.getExternalNSFormatted().contains(elementNamespace)) {
                    wsdc.getExternalNSFormatted().add(elementNamespace);
                    if (elementNamespace.equals(targetns)) {
                        sb.insert(this._attributeindx, "<" + xsdNS + ":include  schemaLocation=\"" + xsdURL + "\"/>");
                    } else {
                        sb.insert(this._attributeindx, "<" + xsdNS + ":import namespace=\"" + elementNamespace + "\" schemaLocation=\"" + xsdURL + "\"/>");
                    }
                }
                if (xmlnsindex > -1) {
                    sb.insert(xmlnsindex, " xmlns:" + wsdc.getPrefix(targetns) + "=\"" + targetns + "\">\n");
                }
                return;
            }
            NSRecord inputSig = element.getNSRecord();
            if (inputSig == null && (innode = this.ns.getNode(NSName.create(element.getDocType()))) != null && innode instanceof NSRecord) {
                inputSig = (NSRecord)innode;
            }
            if (inputSig != null) {
                this.formatNSRecord(sb, inputSig, msgname, targetns, 2, element, wsdc);
            }
        }
        if (xmlnsindex > -1) {
            sb.insert(xmlnsindex, " xmlns:" + wsdc.getPrefix(targetns) + "=\"" + targetns + "\">\n");
        }
    }

    public String resolveTargetNamespace(WSElement element) {
        QName qname;
        String targetns = null;
        String elementname = element.getName();
        int indx = elementname.lastIndexOf("}");
        if (indx > -1) {
            targetns = elementname.substring(1, indx);
            if (targetns.trim().equalsIgnoreCase("null")) {
                return this._targetNamespace;
            }
        } else {
            indx = elementname.lastIndexOf(":");
            if (indx > -1) {
                targetns = elementname.substring(0, indx);
            }
        }
        if (targetns != null) {
            return targetns;
        }
        NSRecord record = element.getNSRecord();
        if (record != null && (qname = record.getUniversalName()) != null) {
            targetns = qname.getNamespace();
        }
        if (targetns == null) {
            targetns = this._targetNamespace;
        }
        return targetns;
    }

    private boolean formatNSRecord(StringBuffer sb, NSRecord nsrecord, String msgname, String targetns, int tabs, WSElement element, WSContext wsdc) {
        if (this.getWSDType() != 1 && !element.isAddedByClient()) {
            return true;
        }
        String xsdprefix = wsdc.getPrefix(XSD_NAMESPACE);
        if (nsrecord != null) {
            String recordname = nsrecord.getName();
            if (recordname == null) {
                recordname = msgname;
            }
            String elementname = recordname;
            QName qn = nsrecord.getUniversalName();
            if (qn != null && qn.getNCName() != null && (element instanceof WSHeader || element instanceof WSFault)) {
                elementname = qn.getNCName();
                if (nsrecord.getNSName() != null) {
                    recordname = nsrecord.getNSName().getNodeName().toString();
                }
            }
            if (recordname.indexOf(58) > -1) {
                recordname = recordname.substring(recordname.indexOf(58) + 1);
            }
            String tnsprefix = null;
            if (targetns != null) {
                tnsprefix = wsdc.getPrefix(targetns);
            }
            Vector<String> elementsInSchema = (Vector<String>)wsdc.getSchemaElements().get(sb);
            if (wsdc.getSchemaElements().get(sb) == null) {
                elementsInSchema = new Vector<String>();
                wsdc.getSchemaElements().put(sb, elementsInSchema);
            }
            if (elementsInSchema.contains(elementname)) {
                return true;
            }
            elementsInSchema.add(elementname);
            if (tnsprefix == null || tnsprefix.trim().equals("")) {
                sb.append(tabstring.substring(0, ++tabs) + "<" + xsdprefix + ":element name=\"" + elementname + "\" type=\"tns:" + recordname + "\"/>\n");
            } else {
                sb.append(tabstring.substring(0, ++tabs) + "<" + xsdprefix + ":element name=\"" + elementname + "\" type=\"" + tnsprefix + ":" + recordname + "\"/>\n");
            }
            return true;
        }
        return false;
    }

    public ArrayList<String> parseNSRecord(Definition definition, javax.wsdl.Message message, String doctype, String type) {
        return this.parseNSRecord(definition, message, doctype, type, new WSContext(this));
    }

    public ArrayList<String> parseNSRecord(Definition definition, javax.wsdl.Message message, String doctype, String type, WSContext wsdc) {
        NSRecord oneSig = null;
        NSNode onenode = this.ns.getNode(NSName.create(doctype));
        if (onenode == null || !(onenode instanceof NSRecord)) {
            return null;
        }
        oneSig = (NSRecord)onenode;
        return this.parseNSRecord(definition, message, oneSig, type, wsdc);
    }

    public ArrayList<String> parseNSRecord(Definition definition, javax.wsdl.Message message, NSRecord oneSig, String type) {
        return this.parseNSRecord(definition, message, oneSig, type, null, new WSContext(this));
    }

    public ArrayList<String> parseNSRecord(Definition definition, javax.wsdl.Message message, NSRecord oneSig, String type, WSContext wsdc) {
        return this.parseNSRecord(definition, message, oneSig, type, null, wsdc);
    }

    public ArrayList<String> parseNSRecord(Definition definition, javax.wsdl.Message message, NSRecord oneSig, String type, QName qName) {
        return this.parseNSRecord(definition, message, oneSig, type, qName, new WSContext(this));
    }

    public ArrayList<String> parseNSRecord(Definition definition, javax.wsdl.Message message, NSRecord oneSig, String type, QName qName, WSContext wsdc) {
        ArrayList<String> parts = new ArrayList<String>();
        String recordname = oneSig.getName();
        boolean parsedOnce = false;
        boolean createWrapper = false;
        if (wsdc.getBinderStyleAndUse().equalsIgnoreCase("doclit")) {
            createWrapper = true;
        } else if ((wsdc.getBinderStyleAndUse().equalsIgnoreCase("rpclit") || wsdc.getBinderStyleAndUse().equalsIgnoreCase("rpcenc")) && (type.equals("FAULT") || type.equals("HEADER"))) {
            createWrapper = true;
        }
        String arrayTypePrefix = null;
        arrayTypePrefix = "ArrayOf";
        try {
            if (oneSig != null) {
                NSField[] fields = oneSig.getFields();
                if (fields != null) {
                    WSD oldWSD = wsdc.getOldWSD(message.getQName().getNamespaceURI());
                    Message oldMsg = null;
                    if (oldWSD != null) {
                        oldMsg = oldWSD.getMessage(QName.create(message.getQName().getNamespaceURI(), message.getQName().getLocalPart()));
                    }
                    for (int i = 0; i < fields.length; ++i) {
                        javax.xml.namespace.QName qn;
                        Name nsName;
                        String prefix = null;
                        String uri = null;
                        String fieldname = fields[i].getName();
                        if (fieldname.startsWith("@xmlns:")) continue;
                        if (this.getWSDType() != 1 && type.equals("BODY") && (fieldname.equals("auth") || fieldname.equals("timeout") || fieldname.equals("_port") || fieldname.equals("_url") || fieldname.equals("SOAP-FAULT"))) continue;
                        parsedOnce = true;
                        javax.wsdl.Part part = definition.createPart();
                        int indx = fieldname.indexOf(":");
                        if (indx > -1) {
                            prefix = fieldname.substring(0, indx);
                            fieldname = fieldname.substring(indx + 1);
                        }
                        String typename = fieldtypenames[fields[i].getType()];
                        if (prefix == null) {
                            String temp = fields[i].getParentRecord().getName();
                            if (temp != null && (indx = temp.indexOf(":")) > -1) {
                                prefix = temp.substring(0, indx);
                                uri = definition.getNamespace(prefix);
                            }
                            if (prefix == null && (indx = (temp = message.getQName().toString()).indexOf("}")) > -1) {
                                uri = temp.substring(1, indx);
                                prefix = wsdc.getPrefix(uri);
                            }
                        }
                        if ((nsName = fields[i].getXmlNamespace()) != null && (uri = nsName.toString()) == null) {
                            nsName = oneSig.getXmlNamespace();
                            if (nsName != null) {
                                uri = nsName.toString();
                            }
                            if (uri == null) {
                                if (qName != null) {
                                    uri = qName.getNamespace();
                                } else {
                                    QName universal = oneSig.getUniversalName();
                                    if (universal != null) {
                                        uri = universal.getNamespace();
                                    }
                                }
                            }
                        }
                        if (uri == null) {
                            uri = this._targetNamespace;
                        }
                        if (!createWrapper) {
                            javax.xml.namespace.QName qn2;
                            if (!NCName.validate(fieldname)) {
                                fieldname = NCName.encode(fieldname);
                            }
                            part.setName(fieldname);
                            if (typename.equals("object")) {
                                block1 : switch (fields[i].getDimensions()) {
                                    case 0: {
                                        switch (fields[i].getJavaWrapperType()) {
                                            case 10: {
                                                if (prefix == null) {
                                                    prefix = wsdc.getPrefix(uri);
                                                }
                                                part.setTypeName(new javax.xml.namespace.QName(uri, "ArrayOfbyte", prefix));
                                                break block1;
                                            }
                                            case 3: {
                                                if (prefix == null) {
                                                    prefix = wsdc.getPrefix(uri);
                                                }
                                                part.setTypeName(new javax.xml.namespace.QName(uri, fieldname, prefix));
                                                break block1;
                                            }
                                        }
                                        typename = objecttypes[fields[i].getJavaWrapperType()];
                                        part.setTypeName(new javax.xml.namespace.QName(XSD_NAMESPACE, typename));
                                        break;
                                    }
                                    case 1: {
                                        if (prefix == null) {
                                            prefix = wsdc.getPrefix(uri);
                                        }
                                        switch (fields[i].getJavaWrapperType()) {
                                            case 10: {
                                                part.setTypeName(new javax.xml.namespace.QName(uri, arrayTypePrefix + "byte", prefix));
                                                break block1;
                                            }
                                            case 3: {
                                                part.setTypeName(new javax.xml.namespace.QName(uri, arrayTypePrefix + fieldname, prefix));
                                                break block1;
                                            }
                                        }
                                        typename = objecttypes[fields[i].getJavaWrapperType()];
                                        part.setTypeName(new javax.xml.namespace.QName(uri, arrayTypePrefix + typename, prefix));
                                    }
                                }
                            } else if (typename.equals("recref")) {
                                NSRecord recref = ((NSRecordRef)fields[i]).getNSRecord();
                                NSName recRefName = recref.getNSName();
                                qn2 = null;
                                if (prefix == null) {
                                    prefix = wsdc.getPrefix(uri);
                                }
                                qn2 = fields[i].getDimensions() == 0 ? new javax.xml.namespace.QName(uri, recRefName.getNodeName().toString(), prefix) : new javax.xml.namespace.QName(uri, arrayTypePrefix + recRefName.getNodeName().toString(), prefix);
                                part.setTypeName(qn2);
                                if (prefix != null && definition.getNamespace(prefix) == null) {
                                    definition.addNamespace(prefix, uri);
                                    wsdc.putPrefix(uri, prefix);
                                }
                            } else if (typename.equals("record")) {
                                NSRecord rec = (NSRecord)fields[i];
                                String recName = rec.getName();
                                qn2 = null;
                                if (prefix == null) {
                                    prefix = wsdc.getPrefix(uri);
                                } else {
                                    int iii = recName.indexOf(":");
                                    if (iii > -1) {
                                        prefix = recName.substring(0, iii);
                                        recName = recName.substring(iii + 1);
                                    }
                                }
                                String typeLocalName = this.resolveType(oldMsg, part).getLocalPart();
                                qn2 = new javax.xml.namespace.QName(uri, typeLocalName, prefix);
                                part.setTypeName(qn2);
                                if (prefix != null && definition.getNamespace(prefix) == null) {
                                    definition.addNamespace(prefix, uri);
                                    wsdc.putPrefix(uri, prefix);
                                }
                            } else if (fields[i].getDimensions() == 0) {
                                qn = null;
                                if (fields[i].getContentType() instanceof WmString) {
                                    qn = new javax.xml.namespace.QName(uri, fieldname);
                                    part.setTypeName(qn);
                                } else if (fields[i].getContentType() != null) {
                                    qn = this.resolveType(oldMsg, part);
                                    if (qn != null) {
                                        part.setTypeName(qn);
                                    } else {
                                        part.setTypeName(new javax.xml.namespace.QName(XSD_NAMESPACE, typename));
                                    }
                                } else {
                                    part.setTypeName(new javax.xml.namespace.QName(XSD_NAMESPACE, typename));
                                }
                            } else {
                                if (prefix == null) {
                                    prefix = wsdc.getPrefix(uri);
                                }
                                String tableTypePrefix = arrayTypePrefix;
                                if (fields[i].getDimensions() == 2) {
                                    tableTypePrefix = "TableOf";
                                }
                                javax.xml.namespace.QName qn3 = null;
                                if (fields[i].getContentType() != null) {
                                    if (fields[i].getContentType() instanceof WmString) {
                                        qn3 = new javax.xml.namespace.QName(uri, fieldname);
                                        part.setTypeName(qn3);
                                    } else {
                                        qn3 = this.resolveType(oldMsg, part);
                                    }
                                    if (qn3 != null) {
                                        part.setTypeName(qn3);
                                    } else {
                                        part.setTypeName(new javax.xml.namespace.QName(uri, tableTypePrefix + typename, prefix));
                                    }
                                } else {
                                    part.setTypeName(new javax.xml.namespace.QName(uri, tableTypePrefix + typename, prefix));
                                }
                            }
                        } else {
                            fieldname = "parameters";
                            if (message.getQName().getNamespaceURI() != null) {
                                uri = message.getQName().getNamespaceURI();
                            }
                            qn = null;
                            prefix = wsdc.getPrefix(uri);
                            if (prefix == null && definition.getNamespace(prefix = "tns") != null) {
                                int fp = 1;
                                while (definition.getNamespace("tns" + fp) != null) {
                                    ++fp;
                                }
                                prefix = "tns" + fp;
                            }
                            qn = new javax.xml.namespace.QName(uri, message.getQName().getLocalPart(), prefix);
                            part.setName(fieldname);
                            part.setElementName(qn);
                            if (prefix != null && definition.getNamespace(prefix) == null) {
                                definition.addNamespace(prefix, uri);
                                wsdc.putPrefix(uri, prefix);
                            }
                        }
                        if (wsdc.getPrefix(uri) == null) {
                            int fp = 1;
                            while (definition.getNamespace("BDY" + fp) != null) {
                                ++fp;
                            }
                            String pfix = "BDY" + fp;
                            definition.addNamespace(pfix, uri);
                            wsdc.putPrefix(uri, pfix);
                        }
                        if (typename.equals("object")) {
                            typename = objecttypes[fields[i].getJavaWrapperType()];
                        }
                        message.addPart(part);
                        parts.add(part.getName());
                        if (createWrapper) break;
                    }
                }
                if (!parsedOnce && createWrapper) {
                    String fieldname = "parameters";
                    String prefix = null;
                    String uri = null;
                    uri = message.getQName().getNamespaceURI() != null ? message.getQName().getNamespaceURI() : this._targetNamespace;
                    javax.wsdl.Part part = definition.createPart();
                    javax.xml.namespace.QName qn = null;
                    if (prefix == null) {
                        prefix = wsdc.getPrefix(uri);
                    }
                    qn = new javax.xml.namespace.QName(uri, message.getQName().getLocalPart(), prefix);
                    part.setName(fieldname);
                    part.setElementName(qn);
                    if (prefix != null && definition.getNamespace(prefix) == null) {
                        definition.addNamespace(prefix, uri);
                        wsdc.putPrefix(uri, prefix);
                    }
                    message.addPart(part);
                    parts.add(part.getName());
                }
            }
            if (parts.size() == 0) {
                parts = null;
            }
        }
        catch (Exception e) {
            if (debug) {
                e.printStackTrace();
            }
            parts.clear();
        }
        return parts;
    }

    private javax.xml.namespace.QName resolveType(Message oldMsg, javax.wsdl.Part part) {
        String typeLocalName = null;
        String typeNamespaceName = null;
        if (oldMsg != null) {
            if (oldMsg.getParts() != null) {
                Part oldPart = oldMsg.getPart(part.getName());
                typeLocalName = oldPart.getType().getNCName();
                typeNamespaceName = oldPart.getType().getNamespace();
            } else if (oldMsg.getNSRecord() != null) {
                ArrayList list = oldMsg.getPartInfoFromRecord();
                for (int j = 0; j < list.size(); ++j) {
                    QName[] partQNames = (QName[])list.get(j);
                    QName elementQName = partQNames[0];
                    if (!elementQName.getNCName().equals(part.getName())) continue;
                    typeNamespaceName = partQNames[1].getNamespace();
                    typeLocalName = partQNames[1].getNCName();
                    break;
                }
            }
            if (typeLocalName != null) {
                return new javax.xml.namespace.QName(typeNamespaceName, typeLocalName);
            }
        }
        return null;
    }

    public void parseExternalSchema(Definition definition, javax.wsdl.Message message, String elementName) {
        this.parseExternalSchema(definition, message, elementName, new WSContext(this));
    }

    public void parseExternalSchema(Definition definition, javax.wsdl.Message message, String elementName, WSContext wsdc) {
        int index;
        String elementNamespace = null;
        String elementLocalName = null;
        String prefix = null;
        if (elementName != null && (index = elementName.indexOf(125)) > 0) {
            elementLocalName = elementName.substring(index + 1);
            elementNamespace = elementName.substring(1, index);
        }
        if (elementNamespace != null && (prefix = wsdc.getPrefix(elementNamespace)) == null) {
            prefix = this.generatePrefix(WS_NAMESPACE_PREFIX, wsdc);
            wsdc.putPrefix(elementNamespace, prefix);
            definition.addNamespace(prefix, elementNamespace);
        }
        javax.xml.namespace.QName qn = new javax.xml.namespace.QName(elementNamespace, elementLocalName, prefix);
        javax.wsdl.Part part = definition.createPart();
        part.setElementName(qn);
        part.setName(elementLocalName);
        message.addPart(part);
    }

    public ExtensibilityElement createExtension(Class clazz, javax.xml.namespace.QName qname) {
        ExtensibilityElement element = null;
        String soapns = SOAP_NAMESPACE;
        if (this.getSOAPProtocol().equals("SOAP 1.2 Protocol")) {
            soapns = SOAP12_NAMESPACE;
        }
        qname = new javax.xml.namespace.QName(soapns, qname.getLocalPart());
        try {
            element = this._extregistry.createExtension(clazz, qname);
        }
        catch (WSDLException we) {
            if (debug) {
                we.printStackTrace();
            }
            element = null;
        }
        return element;
    }

    public static String resolveNSRecordname(QName qname) {
        NSName name = UIDRegistry.resolve(qname);
        if (name != null) {
            return name.toString();
        }
        return null;
    }

    private String generatePrefix(String base, WSContext wsdc) {
        int i = 0;
        while (wsdc.getPrefix(base + ++i) != null) {
        }
        return base + i;
    }

    private String buildWSDLURL(NSName nsName) {
        String host = "localhost";
        String port = "5555";
        try {
            port = Config.getProperty("5555", "watt.server.port");
            InetAddress hostAddr = Config.getLocalHost();
            host = hostAddr.getHostName();
        }
        catch (UnknownHostException ex) {
            // empty catch block
        }
        return "http://" + host + ":" + port + "/ws/" + nsName + "?WSDL";
    }

    public WSHandler[] getHandlers() {
        Object[] wsHandlers = new WSHandler[]{};
        if (this._handlers != null) {
            wsHandlers = new WSHandler[this._handlers.size()];
            this._handlers.copyInto(wsHandlers);
        }
        return wsHandlers;
    }

    public void setHandlers(WSHandler[] handlers) {
        if (handlers == null) {
            if (this._handlers != null) {
                for (int i = 0; i < this._handlers.size(); ++i) {
                    this._handlers.remove(i);
                }
            }
            return;
        }
        this._handlers = new Vector(handlers.length);
        for (int i = 0; i < handlers.length; ++i) {
            this._handlers.add(handlers[i]);
        }
    }

    public void addHandler(WSHandler handler) {
        if (handler != null) {
            if (this._handlers == null) {
                this._handlers = new Vector(1);
            }
            this._handlers.add(handler);
        }
    }

    public boolean checkAclsInternally() {
        if (check) {
            return true;
        }
        return this.gCheckAclsInternallyRequired;
    }

    public void setCheckAclsInternally(boolean flag) {
        this.gCheckAclsInternallyRequired = flag;
    }

    public static String wsdl2isname(String name) {
        if (name == null) {
            return name;
        }
        name = name.replace('.', '_');
        name = name.replace('-', '_');
        return name;
    }

    public int getWSDType() {
        if (this._wsdType != 0) {
            return this._wsdType;
        }
        this._wsdType = !this.isInbound() ? 3 : (this.isInbound() && this.getExternalWSDL() != null ? 2 : 1);
        return this._wsdType;
    }

    public String setSoapHeaderAttrbiutesInWSDL(String wsdl, String wsdlURL) {
        String soapPrefix = null;
        String role = null;
        String mustUnderstand = "mustUnderstand";
        try {
            XqlQuery xqlquery = null;
            Document wsdlDoc = new Document(wsdl, wsdlURL, null, false, true);
            xqlquery = new XqlQuery("/wsdl:definitions/wsdl:binding/wsdl:operation", NSWSDescriptor.getNSDecls());
            Node[] wsdlOperations = xqlquery.getNodeArray(wsdlDoc);
            WSBinder[] binders = this.getBinders();
            for (int bind = 0; bind < binders.length; ++bind) {
                WSOperation[] operations = binders[bind].getOperations();
                for (int op = 0; op < operations.length; ++op) {
                    for (int wsdlOp = 0; wsdlOperations != null && wsdlOp < wsdlOperations.length; ++wsdlOp) {
                        Node findWsdlOutputNode;
                        Node findWsdlOutputHeaderNode;
                        String wsdlOperationName = wsdlOperations[wsdlOp].getAttributeValue(null, Name.create("name"));
                        if (operations[op].getOperationName() == null || !operations[op].getOperationName().equals(wsdlOperationName)) continue;
                        Node findWsdlInputNode = this.getElementNodeFromWsdl(wsdlOperations[wsdlOp], "input");
                        Node findWsdlInputHeaderNode = this.getElementNodeFromWsdl(findWsdlInputNode, "header");
                        if (findWsdlInputHeaderNode != null) {
                            soapPrefix = findWsdlInputHeaderNode.getPrefix();
                            role = soapPrefix.equals(SOAP_NAMESPACE_PREFIX) ? "actor" : "role";
                            WSReqMessage reqMsg = operations[op].getWSRequest();
                            WSHeader[] reqHeaders = reqMsg.getWSHeaders();
                            this.setHeaderRoleNMustUnderstandInWSDL(reqHeaders, findWsdlInputHeaderNode, soapPrefix, role, mustUnderstand);
                        }
                        if ((findWsdlOutputHeaderNode = this.getElementNodeFromWsdl(findWsdlOutputNode = this.getElementNodeFromWsdl(wsdlOperations[wsdlOp], "output"), "header")) == null) continue;
                        soapPrefix = findWsdlOutputHeaderNode.getPrefix();
                        role = soapPrefix.equals(SOAP_NAMESPACE_PREFIX) ? "actor" : "role";
                        WSRespMessage respMsg = operations[op].getWSResponse();
                        WSHeader[] respHeaders = respMsg.getWSHeaders();
                        this.setHeaderRoleNMustUnderstandInWSDL(respHeaders, findWsdlOutputHeaderNode, soapPrefix, role, mustUnderstand);
                    }
                }
            }
            StringBuffer sb = new StringBuffer();
            wsdlDoc.appendGeneratedMarkup(sb);
            return sb.toString();
        }
        catch (Exception e) {
            return wsdl;
        }
    }

    public void setSoapHeaderAttrbiutesInWSD(String wsdl, String wsdlURL, NSWSDescriptor wsd) {
        String soapPrefix = null;
        String role = null;
        String mustUnderstand = "mustUnderstand";
        try {
            XqlQuery xqlquery = null;
            Document wsdlDoc = new Document(wsdl, wsdlURL, null, false, true);
            xqlquery = new XqlQuery("/wsdl:definitions/wsdl:binding/wsdl:operation", NSWSDescriptor.getNSDecls());
            Node[] wsdlOperations = xqlquery.getNodeArray(wsdlDoc);
            WSBinder[] binders = wsd.getBinders();
            for (int bind = 0; bind < binders.length; ++bind) {
                WSOperation[] operations = binders[bind].getOperations();
                for (int op = 0; op < operations.length; ++op) {
                    for (int wsdlOp = 0; wsdlOperations != null && wsdlOp < wsdlOperations.length; ++wsdlOp) {
                        Node findWsdlOutputNode;
                        Node findWsdlOutputHeaderNode;
                        String wsdlOperationName = wsdlOperations[wsdlOp].getAttributeValue(null, Name.create("name"));
                        if (operations[op].getOperationName() == null || !operations[op].getOperationName().equals(wsdlOperationName)) continue;
                        Node findWsdlInputNode = this.getElementNodeFromWsdl(wsdlOperations[wsdlOp], "input");
                        Node findWsdlInputHeaderNode = this.getElementNodeFromWsdl(findWsdlInputNode, "header");
                        if (findWsdlInputHeaderNode != null) {
                            soapPrefix = findWsdlInputHeaderNode.getPrefix();
                            role = soapPrefix.equals(SOAP_NAMESPACE_PREFIX) ? "actor" : "role";
                            WSReqMessage reqMsg = operations[op].getWSRequest();
                            WSHeader[] reqHeaders = reqMsg.getWSHeaders();
                            this.setHeaderRoleNMustUnderstandInWSD(reqHeaders, findWsdlInputHeaderNode, soapPrefix, role, mustUnderstand);
                        }
                        if ((findWsdlOutputHeaderNode = this.getElementNodeFromWsdl(findWsdlOutputNode = this.getElementNodeFromWsdl(wsdlOperations[wsdlOp], "output"), "header")) == null) continue;
                        soapPrefix = findWsdlOutputHeaderNode.getPrefix();
                        role = soapPrefix.equals(SOAP_NAMESPACE_PREFIX) ? "actor" : "role";
                        WSRespMessage respMsg = operations[op].getWSResponse();
                        WSHeader[] respHeaders = respMsg.getWSHeaders();
                        this.setHeaderRoleNMustUnderstandInWSD(respHeaders, findWsdlOutputHeaderNode, soapPrefix, role, mustUnderstand);
                    }
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private String getHeaderRoleForWSDL(WSHeader header2, String soapPrefix) {
        String soapProtocol = null;
        String role = null;
        soapProtocol = soapPrefix.equals(SOAP_NAMESPACE_PREFIX) ? "SOAP 1.1 Protocol" : "SOAP 1.2 Protocol";
        if (header2.getRole() != null && !header2.getRole().trim().equals("")) {
            String shortName = header2.getRole();
            if (soapProtocol.equals("SOAP 1.2 Protocol")) {
                role = "Next".equalsIgnoreCase(shortName) ? "http://www.w3.org/2003/05/soap-envelope/role/next" : ("Ultimate Receiver".equalsIgnoreCase(shortName) ? "http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver" : ("None".equalsIgnoreCase(shortName) ? "http://www.w3.org/2003/05/soap-envelope/role/none" : shortName));
            } else if (soapProtocol.equals("SOAP 1.1 Protocol")) {
                role = "Next".equalsIgnoreCase(shortName) ? "http://schemas.xmlsoap.org/soap/actor/next" : shortName;
            }
        }
        return role;
    }

    private String getHeaderRoleForWSD(WSHeader header2, String soapPrefix, String roleFromWSDL) {
        String soapProtocol = null;
        String role = null;
        soapProtocol = soapPrefix.equals(SOAP_NAMESPACE_PREFIX) ? "SOAP 1.1 Protocol" : "SOAP 1.2 Protocol";
        if (roleFromWSDL != null && !roleFromWSDL.trim().equals("")) {
            if (soapProtocol.equals("SOAP 1.2 Protocol")) {
                role = "http://www.w3.org/2003/05/soap-envelope/role/next".equalsIgnoreCase(roleFromWSDL) ? "Next" : ("http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver".equalsIgnoreCase(roleFromWSDL) ? "Ultimate Receiver" : ("http://www.w3.org/2003/05/soap-envelope/role/none".equalsIgnoreCase(roleFromWSDL) ? "None" : roleFromWSDL));
            } else if (soapProtocol.equals("SOAP 1.1 Protocol")) {
                role = "http://schemas.xmlsoap.org/soap/actor/next".equalsIgnoreCase(roleFromWSDL) ? "Next" : roleFromWSDL;
            }
        }
        return role;
    }

    private String getHeaderMustUnderstandForWSDL(WSHeader header2, String soapPrefix) {
        String soapProtocol = null;
        soapProtocol = soapPrefix.equals(SOAP_NAMESPACE_PREFIX) ? "SOAP 1.1 Protocol" : "SOAP 1.2 Protocol";
        String mustUnderstand = null;
        if (header2.isMustUnderstand()) {
            if (soapProtocol.equals("SOAP 1.2 Protocol")) {
                mustUnderstand = "true";
            } else if (soapProtocol.equals("SOAP 1.1 Protocol")) {
                mustUnderstand = "1";
            }
        }
        return mustUnderstand;
    }

    private void setHeaderRoleNMustUnderstandInWSDL(WSHeader[] headers, Node headerNodeInWsdl, String soapPrefix, String role, String mustUnderstand) {
        if (headers == null || headerNodeInWsdl == null) {
            return;
        }
        int index = -1;
        Attribute attr = null;
        for (int h = 0; h < headers.length; ++h) {
            String mustUnderstandVal;
            String headerName = ((ElementNode)headerNodeInWsdl).getAttributeValue(null, Name.create("message"));
            String use = ((ElementNode)headerNodeInWsdl).getAttributeValue(null, Name.create("use"));
            if (!"literal".equals(use)) continue;
            index = headerName.indexOf(58) + 1;
            headerName = headerName.substring(index);
            if (!headers[h].getQName().getLocalPart().equals(headerName)) continue;
            String roleVal = this.getHeaderRoleForWSDL(headers[h], soapPrefix);
            if (roleVal != null) {
                attr = new Attribute((Document)headerNodeInWsdl.getOwnerDocument(), null, Name.create(role), roleVal);
                ((ElementNode)headerNodeInWsdl).setAttributeNode(attr);
            }
            if ((mustUnderstandVal = this.getHeaderMustUnderstandForWSDL(headers[h], soapPrefix)) == null) continue;
            attr = new Attribute((Document)headerNodeInWsdl.getOwnerDocument(), null, Name.create(mustUnderstand), mustUnderstandVal);
            ((ElementNode)headerNodeInWsdl).setAttributeNode(attr);
        }
    }

    private void setHeaderRoleNMustUnderstandInWSD(WSHeader[] headers, Node headerNodeInWsdl, String soapPrefix, String role, String mustUnderstand) {
        if (headers == null || headerNodeInWsdl == null) {
            return;
        }
        int index = -1;
        for (int h = 0; h < headers.length; ++h) {
            String headerName = ((ElementNode)headerNodeInWsdl).getAttributeValue(null, Name.create("message"));
            String use = ((ElementNode)headerNodeInWsdl).getAttributeValue(null, Name.create("use"));
            if (!"literal".equals(use)) continue;
            index = headerName.indexOf(58) + 1;
            headerName = headerName.substring(index);
            if (!headers[h].getQName().getLocalPart().equals(headerName)) continue;
            String roleVal = ((ElementNode)headerNodeInWsdl).getAttributeValue(null, Name.create(role));
            roleVal = this.getHeaderRoleForWSD(headers[h], soapPrefix, roleVal);
            headers[h].setRole(roleVal);
            String mustUnderstandVal = ((ElementNode)headerNodeInWsdl).getAttributeValue(null, Name.create(mustUnderstand));
            boolean mustUnderstandBoolVal = false;
            if (mustUnderstandVal != null && (mustUnderstandVal.equals("true") || mustUnderstandVal.equals("1"))) {
                mustUnderstandBoolVal = true;
            }
            headers[h].setMustUnderstand(mustUnderstandBoolVal);
        }
    }

    private Node getElementNodeFromWsdl(Node parentNode, String nodeType) {
        Node retNode = null;
        if (parentNode == null || nodeType == null) {
            return null;
        }
        try {
            for (retNode = (Node)parentNode.getFirstChild(); !(retNode == null || retNode instanceof ElementNode && retNode.getLocalName() != null && retNode.getLocalName().equalsIgnoreCase(nodeType)); retNode = retNode.getNextSiblingWm()) {
            }
        }
        catch (WMDocumentException e) {
            retNode = null;
        }
        return retNode;
    }

    public boolean isMixedUseInWSD(Values values) {
        if (values == null) {
            return false;
        }
        Vector<WSBinder> binders = null;
        Object f = values.get(KEY_WSD_BINDERLIST);
        if (f instanceof Vector || f == null) {
            binders = this.createBinders((Vector)f);
        } else if (f instanceof ArrayList) {
            binders = this.createBinders((ArrayList)f);
        } else if (f instanceof IData[]) {
            binders = this.createBinders((IData[])f);
        }
        if (binders == null || binders.size() == 0) {
            return false;
        }
        String bindingUse = binders.get(0).getBindingUse();
        for (int i = 1; i < binders.size(); ++i) {
            if (bindingUse == null || bindingUse.equals(binders.get(i).getBindingUse())) continue;
            return true;
        }
        return false;
    }

    public static boolean isMixedUseInWSDL(Map allPorts) {
        List extElements = null;
        Iterator elementIterator = null;
        if (allPorts == null || allPorts.values() == null) {
            return false;
        }
        Iterator portIterator = allPorts.values().iterator();
        String firstUse = null;
        String tempUse = null;
        while (portIterator.hasNext()) {
            Port port = (Port)portIterator.next();
            Binding binding = port.getBinding();
            List bindingOperations = binding.getBindingOperations();
            for (BindingOperation bindingOp : bindingOperations) {
                Map bindingFaultsMap;
                BindingOutput bindingoutput;
                BindingInput bindinginput = bindingOp.getBindingInput();
                if (bindinginput != null) {
                    extElements = bindinginput.getExtensibilityElements();
                    for (ExtensibilityElement extElement : extElements) {
                        tempUse = NSWSDescriptor.getUse(extElement);
                        if (firstUse == null) {
                            firstUse = tempUse;
                        }
                        if (firstUse == null || tempUse == null || firstUse.equals(tempUse)) continue;
                        return true;
                    }
                }
                if ((bindingoutput = bindingOp.getBindingOutput()) != null) {
                    extElements = bindingoutput.getExtensibilityElements();
                    for (ExtensibilityElement extElement : extElements) {
                        tempUse = NSWSDescriptor.getUse(extElement);
                        if (firstUse == null) {
                            firstUse = tempUse;
                        }
                        if (firstUse == null || tempUse == null || firstUse.equals(tempUse)) continue;
                        return true;
                    }
                }
                if ((bindingFaultsMap = bindingOp.getBindingFaults()) == null) continue;
                for (BindingFault bindingFault : bindingFaultsMap.values()) {
                    if (bindingFault == null) continue;
                    extElements = bindingFault.getExtensibilityElements();
                    for (ExtensibilityElement extElement : extElements) {
                        tempUse = NSWSDescriptor.getUse(extElement);
                        if (firstUse == null) {
                            firstUse = tempUse;
                        }
                        if (firstUse == null || tempUse == null || firstUse.equals(tempUse)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static String getUse(ExtensibilityElement extElement) {
        if (extElement instanceof SOAPBody) {
            return ((SOAPBody)extElement).getUse();
        }
        if (extElement instanceof SOAP12Body) {
            return ((SOAP12Body)extElement).getUse();
        }
        if (extElement instanceof SOAPHeader) {
            return ((SOAPHeader)extElement).getUse();
        }
        if (extElement instanceof SOAP12Header) {
            return ((SOAP12Header)extElement).getUse();
        }
        if (extElement instanceof SOAPFault) {
            return ((SOAPFault)extElement).getUse();
        }
        if (extElement instanceof SOAP12Fault) {
            return ((SOAP12Fault)extElement).getUse();
        }
        return null;
    }

    private boolean hasEncodedBinding() {
        boolean hasEncodedBinding = false;
        WSBinder[] binders = this.getBinders();
        if (binders != null && binders.length > 0) {
            for (int i = 0; i < binders.length; ++i) {
                if ("literal".equals(binders[i].getBindingUse())) continue;
                hasEncodedBinding = true;
                break;
            }
        }
        return hasEncodedBinding;
    }
}

