/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.ns;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSType;
import com.wm.util.Values;

public class NSTriggerType
extends NSType {
    static final boolean debug = false;
    public static final String BROKER_TRIGGER = "broker-trigger";
    public static final String JMS_TRIGGER = "jms-trigger";
    public static final String DEFAULT_TRIGGER_TYPE = "broker-trigger";
    public static final String KEY_NST_TYPE = "trigger_type";

    public NSTriggerType() {
    }

    protected NSTriggerType(String type) {
        super(type);
    }

    public void setValues(Values values) {
        values.put(KEY_NST_TYPE, this.type == null ? "unknown" : this.type);
    }

    public static NSTriggerType create(Values values) {
        String type = null;
        Object subtype = null;
        if (values != null) {
            type = values.getString(KEY_NST_TYPE);
        }
        return new NSTriggerType(type != null ? type : "unknown");
    }

    public static NSTriggerType create(IDataCursor c) {
        String type = IDataUtil.getString(c, KEY_NST_TYPE);
        return new NSTriggerType(type != null ? type : "unknown");
    }

    public static NSTriggerType create(String type) {
        if (type == null) {
            type = "broker-trigger";
        }
        return new NSTriggerType(type);
    }

    public void setData(IDataCursor c) {
        c.insertAfter(KEY_NST_TYPE, this.type == null ? "unknown" : this.type);
    }

    public boolean isBrokerTrigger() {
        return this.type.equals("broker-trigger");
    }

    public boolean isJMSTrigger() {
        return this.type.equals(JMS_TRIGGER);
    }

    public void setValue(String value) {
        this.type = value;
    }

    public String getValue() {
        return this.type;
    }

    public IData getAsData() {
        IData values = IDataFactory.create();
        IDataCursor ic = values.getCursor();
        ic.insertAfter(KEY_NST_TYPE, this.type == null ? "unknown" : this.type);
        ic.destroy();
        return values;
    }

    public void setFromData(IData values) {
        IDataCursor ic = values.getCursor();
        this.type = IDataUtil.getString(ic, KEY_NST_TYPE);
        ic.destroy();
    }
}

