/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.ns;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.AuditSettings;
import com.wm.lang.ns.AuditableNSNode;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSNode;
import com.wm.lang.ns.NSTriggerType;
import com.wm.lang.ns.NSType;
import com.wm.lang.ns.Namespace;
import com.wm.security.Util;
import com.wm.util.Base64;
import com.wm.util.EncUtil;
import com.wm.util.JournalLogger;
import com.wm.util.Values;

public abstract class NSTrigger
extends NSNode
implements AuditableNSNode {
    public static final String TYPE_KEY = "webMethods/trigger";
    public static NSType TYPE = new NSType("webMethods/trigger");
    NSTriggerType triggerType;
    public static final String KEY_NST_TYPE = "trigger_type";
    public static final long DEFAULT_DELAY_INTERVAL = 10000L;
    public static final int FAILURE_ACTION_THROW_EXCEPTION = 0;
    public static final int FAILURE_ACTION_SUSPEND_AND_NACK = 1;
    public static final int DEFAULT_REDELIVERY_FAILURE_ACTION = 0;
    public static final long DEFAULT_JOIN_TIMEOUT = 86400000L;
    public static final int DEFAULT_DELIVERY_MAX = 5;
    public static final int DEFAULT_DOC_PREFETCH_MAX = 10;
    public static final int DEFAULT_DOC_PREFETCH_MIN = 4;
    public static final int DEFAULT_MAX_CONCURRENT_THREADS = 10;
    public static final int JOIN_TIMEOUT_NEVER = -1;
    public static final int NEVER_TIMEOUT = -1;
    public static final long DEFAULT_RESOLUTION_HISTORY_TTL = 0x6DDD00L;
    public static final int DEFAULT_TRANSPORT_ACK_SIZE = 1;
    protected boolean isConcurrent;
    protected int ordering;
    protected int auditOption;
    protected AuditSettings auditSettings;
    protected int deliveryMax;
    protected long redeliveryDelay;
    protected int redeliveryFailureAction;
    protected NSName resourceMonitoringSvcName;
    protected boolean canDeliver;
    protected boolean canExecute;
    protected boolean initialized;
    protected long joinTimeout;
    protected int maxConcurrentThreads;
    protected boolean inDoubtDetection;
    protected boolean resolveWithHistory;
    protected long resolutionHistoryTTL;
    protected NSName resolverSvcName;
    protected String uniqueId;
    protected boolean serialSuspendOnError;
    public static final String KEY_TRIGGER = "trigger";
    public static final String KEY_CONCURRENCY = "concurrent";
    public static final String KEY_ORDERING = "ordering";
    public static final String KEY_AUDIT_OPTION = "auditOption";
    public static final String KEY_AUDIT_SETTINGS = "auditSettings";
    public static final String KEY_REDELIVERY = "redeliveryOptions";
    public static final String KEY_REDELIVERY_MAX = "max";
    public static final String KEY_REDELIVERY_INTERVAL = "delayInterval";
    public static final String KEY_DELIVERY_FLAG = "deliverEnabled";
    public static final String KEY_EXECUTE_FLAG = "executeEnabled";
    public static final String KEY_JOIN_TIMEOUT = "joinTimeout";
    public static final String KEY_MAX_CONCURRENT_THREADS = "maxConcurrentThreads";
    public static final String KEY_IN_DOUBT_DETECTION = "inDoubtDetection";
    public static final String KEY_RESOLVE_WITH_HISTORY = "resolveWithHistory";
    public static final String KEY_RESOLUTION_HISTORY_TTL = "resolutionHistoryTTL";
    public static final String KEY_RESOLVER_SVCNAME = "resolverSvcName";
    public static final String KEY_UNIQUE_ID = "uniqueId";
    public static final String KEY_SERIAL_AUTO_SUSPEND_MODE = "serialSuspendOnError";
    public static final String KEY_REDELIVERY_FAILURE_ACTION = "onRedeliveryFailure";
    public static final String KEY_REDELIVERY_TASK_SVCNAME = "resumeTaskSvcName";

    protected NSTrigger(Namespace ns, IData data, NSTriggerType triggerType) {
        super(ns, data);
        this.triggerType = triggerType;
    }

    protected void init() {
        if (this.initialized) {
            return;
        }
        this.serialSuspendOnError = false;
        this.isConcurrent = false;
        this.ordering = 0;
        this.auditOption = 0;
        this.auditSettings = new AuditSettings();
        this.deliveryMax = 5;
        this.redeliveryDelay = 10000L;
        this.joinTimeout = 86400000L;
        this.maxConcurrentThreads = 10;
        this.inDoubtDetection = false;
        this.resolveWithHistory = false;
        this.resolutionHistoryTTL = 0x6DDD00L;
        this.resolverSvcName = null;
        this.uniqueId = this.generateUniqueId();
        this.initialized = true;
    }

    public NSTriggerType getTriggerType() {
        return this.triggerType;
    }

    public void setTriggerType(NSTriggerType triggerType) {
        this.triggerType = triggerType;
    }

    public boolean getDeliveryEnabled() {
        return this.canDeliver;
    }

    public void setDeliveryEnabled(boolean flag) {
        this.canDeliver = flag;
    }

    public boolean getExecuteEnabled() {
        return this.canExecute;
    }

    public void setExecuteEnabled(boolean flag) {
        this.canExecute = flag;
    }

    public boolean getSerialSuspendOnError() {
        return this.serialSuspendOnError;
    }

    public void setSerialSuspendOnError(boolean flag) {
        this.serialSuspendOnError = flag;
    }

    public long getJoinTimeout() {
        return this.joinTimeout;
    }

    public void setJoinTimeout(long timeout) {
        this.joinTimeout = timeout;
    }

    public int getMaxConcurrentThreads() {
        return this.maxConcurrentThreads;
    }

    public void setMaxConcurrentThreads(int maxConcurrent) {
        this.maxConcurrentThreads = maxConcurrent;
    }

    public boolean allowsConcurrent() {
        return this.isConcurrent;
    }

    public int getAuditOption() {
        return this.auditOption;
    }

    public void setAuditOption(int option) {
        this.auditOption = option < 0 || option > 1 ? 0 : option;
    }

    public AuditSettings getAuditSettings() {
        return this.auditSettings;
    }

    public boolean setAuditSettings(AuditSettings as) {
        return this.auditSettings.setFromAuditSettings(as);
    }

    public int getMaxDeliveryAttempts() {
        return this.deliveryMax;
    }

    public void setMaxDeliveryAttempts(int maxRedeliveryAttempts) {
        this.deliveryMax = maxRedeliveryAttempts;
    }

    public long getRedeliveryDelay() {
        return this.redeliveryDelay;
    }

    public void setRedeliveryDelay(long redeliveryDelay) {
        this.redeliveryDelay = redeliveryDelay;
    }

    public int getRedeliveryFailureAction() {
        return this.redeliveryFailureAction;
    }

    public void setRedeliveryFailureAction(int redeliveryFailureAction) {
        this.redeliveryFailureAction = redeliveryFailureAction;
    }

    public NSName getResourceMonitoringSvcName() {
        return this.resourceMonitoringSvcName;
    }

    public void setResourceMonitoringSvcName(NSName resourceMonitoringSvcName) {
        this.resourceMonitoringSvcName = resourceMonitoringSvcName;
    }

    public int getOrderingMode() {
        return this.ordering;
    }

    public void setOrderingMode(int mode) {
        this.ordering = mode < 0 || mode > 2 ? 0 : mode;
    }

    public void setConcurrent(boolean flag) {
        this.isConcurrent = flag;
    }

    public void setInDoubtDetection(boolean flag) {
        this.inDoubtDetection = flag;
    }

    public boolean getInDoubtDetection() {
        return this.inDoubtDetection;
    }

    public void setResolveWithHistory(boolean flag, long ttl) {
        this.resolveWithHistory = flag;
        this.resolutionHistoryTTL = ttl;
    }

    public boolean getResolveWithHistory() {
        return this.resolveWithHistory;
    }

    public long getResolutionHistoryTTL() {
        return this.resolutionHistoryTTL;
    }

    public void setResolveWithHistory(boolean flag) {
        this.resolveWithHistory = flag;
    }

    public void setResolutionHistoryTTL(long ttl) {
        this.resolutionHistoryTTL = ttl;
    }

    public void setResolverServiceName(NSName name) {
        this.resolverSvcName = name;
    }

    public NSName getResolverServiceName() {
        return this.resolverSvcName;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public Values getValues() {
        IData localInfo = this.getAsData();
        return Values.use(localInfo);
    }

    public void setValues(Values vals) {
        super.setValues(vals);
        this.setFromData(vals.getIData());
    }

    public IData getAsData() {
        IData data = super.getAsData();
        if (this.triggerType == null) {
            this.triggerType = NSTriggerType.create("broker-trigger");
        }
        this.triggerType.setData(data.getCursor());
        IData localInfo = IDataFactory.create();
        IDataCursor dc = localInfo.getCursor();
        dc.insertAfter(KEY_SERIAL_AUTO_SUSPEND_MODE, new Boolean(this.serialSuspendOnError).toString());
        dc.insertAfter(KEY_CONCURRENCY, new Boolean(this.isConcurrent).toString());
        dc.insertAfter(KEY_ORDERING, new Integer(this.ordering).toString());
        dc.insertAfter(KEY_AUDIT_OPTION, new Integer(this.auditOption).toString());
        dc.insertAfter(KEY_AUDIT_SETTINGS, this.auditSettings.getAsData());
        IData redelivery = IDataFactory.create();
        IDataCursor dc1 = redelivery.getCursor();
        dc1.insertAfter(KEY_REDELIVERY_MAX, new Integer(this.deliveryMax).toString());
        dc1.insertAfter(KEY_REDELIVERY_INTERVAL, new Long(this.redeliveryDelay).toString());
        dc1.insertAfter(KEY_REDELIVERY_FAILURE_ACTION, new Integer(this.redeliveryFailureAction).toString());
        if (this.resourceMonitoringSvcName != null) {
            dc1.insertAfter(KEY_REDELIVERY_TASK_SVCNAME, this.resourceMonitoringSvcName.getFullName());
        }
        dc1.destroy();
        dc.insertAfter(KEY_REDELIVERY, redelivery);
        dc.insertAfter(KEY_JOIN_TIMEOUT, new Long(this.joinTimeout).toString());
        dc.insertAfter(KEY_MAX_CONCURRENT_THREADS, String.valueOf(this.maxConcurrentThreads));
        dc.insertAfter(KEY_IN_DOUBT_DETECTION, String.valueOf(this.inDoubtDetection));
        dc.insertAfter(KEY_RESOLVE_WITH_HISTORY, String.valueOf(this.resolveWithHistory));
        dc.insertAfter(KEY_RESOLUTION_HISTORY_TTL, String.valueOf(this.resolutionHistoryTTL));
        if (this.resolverSvcName != null) {
            dc.insertAfter(KEY_RESOLVER_SVCNAME, this.resolverSvcName.getFullName());
        }
        dc.insertAfter(KEY_UNIQUE_ID, this.uniqueId);
        dc.destroy();
        dc = data.getCursor();
        dc.insertAfter(KEY_TRIGGER, localInfo);
        return data;
    }

    public void setFromData(IData data) {
        this.init();
        if (data == null) {
            return;
        }
        super.setFromData(data);
        String trigType = IDataUtil.getString(data.getCursor(), KEY_NST_TYPE);
        if (trigType == null) {
            trigType = "broker-trigger";
            IDataUtil.put(data.getCursor(), KEY_NST_TYPE, "broker-trigger");
            this.setTriggerType(NSTriggerType.create(trigType));
        }
        this.auditSettings = new AuditSettings();
        IDataCursor dc = data.getCursor();
        if (!dc.first(KEY_TRIGGER)) {
            return;
        }
        IData localInfo = (IData)dc.getValue();
        dc.destroy();
        dc = localInfo.getCursor();
        if (dc.first(KEY_SERIAL_AUTO_SUSPEND_MODE) && dc.getValue() != null) {
            this.serialSuspendOnError = Boolean.valueOf((String)dc.getValue());
        }
        this.isConcurrent = dc.first(KEY_CONCURRENCY) && dc.getValue() != null ? Boolean.valueOf((String)dc.getValue()) : false;
        this.ordering = dc.first(KEY_ORDERING) && dc.getValue() != null ? Integer.parseInt((String)dc.getValue()) : 0;
        this.auditOption = dc.first(KEY_AUDIT_OPTION) && dc.getValue() != null ? Integer.parseInt((String)dc.getValue()) : 0;
        if (dc.first(KEY_AUDIT_SETTINGS) && dc.getValue() != null) {
            this.auditSettings.setFromData((IData)dc.getValue());
        }
        if (dc.first(KEY_REDELIVERY)) {
            IDataCursor dc1 = ((IData)dc.getValue()).getCursor();
            this.deliveryMax = dc1.first(KEY_REDELIVERY_MAX) && dc1.getValue() != null ? Integer.parseInt((String)dc1.getValue()) : 5;
            this.redeliveryDelay = dc1.first(KEY_REDELIVERY_INTERVAL) && dc1.getValue() != null ? Long.parseLong((String)dc1.getValue()) : 10000L;
            this.redeliveryFailureAction = dc1.first(KEY_REDELIVERY_FAILURE_ACTION) && dc1.getValue() != null ? Integer.parseInt((String)dc1.getValue()) : 0;
            this.resourceMonitoringSvcName = dc1.first(KEY_REDELIVERY_TASK_SVCNAME) && dc1.getValue() != null ? NSName.create((String)dc1.getValue()) : null;
            dc1.destroy();
        }
        this.joinTimeout = dc.first(KEY_JOIN_TIMEOUT) && dc.getValue() != null ? Long.parseLong((String)dc.getValue()) : 86400000L;
        this.maxConcurrentThreads = this.isConcurrent ? (dc.first(KEY_MAX_CONCURRENT_THREADS) && dc.getValue() != null ? Integer.parseInt((String)dc.getValue()) : 10) : 1;
        this.inDoubtDetection = dc.first(KEY_IN_DOUBT_DETECTION) && dc.getValue() != null ? Boolean.valueOf((String)dc.getValue()) : false;
        this.resolveWithHistory = dc.first(KEY_RESOLVE_WITH_HISTORY) && dc.getValue() != null ? Boolean.valueOf((String)dc.getValue()) : false;
        this.resolutionHistoryTTL = dc.first(KEY_RESOLUTION_HISTORY_TTL) && dc.getValue() != null ? Long.valueOf((String)dc.getValue()) : 0x6DDD00L;
        this.resolverSvcName = dc.first(KEY_RESOLVER_SVCNAME) && dc.getValue() != null ? NSName.create((String)dc.getValue()) : null;
        this.uniqueId = dc.first(KEY_UNIQUE_ID) && dc.getValue() != null ? (String)dc.getValue() : this.generateUniqueId();
        dc.destroy();
    }

    public void regenerateUniqueId() {
        this.uniqueId = this.generateUniqueId();
    }

    protected String generateUniqueId() {
        try {
            NSName triggerName = this.getNSName();
            if (triggerName != null) {
                return new String(Base64.encode(Util.getDigest(EncUtil.getNetBytes(triggerName.getFullName()))));
            }
            return null;
        }
        catch (NullPointerException npe) {
            return null;
        }
        catch (Exception e) {
            JournalLogger.logCritical(5, 81, e.getMessage());
            return null;
        }
    }

    public static interface OrderingMode {
        public static final int NONE = 0;
        public static final int BY_PUBLISHER = 1;
        public static final int BY_DOC_TYPE = 2;
    }
}

