/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.ns;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataPortable;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.Namespace;
import com.wm.lang.ns.resources.NSExceptionBundle;
import com.wm.util.LocalizedExceptionInfo;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;

public class NSSignature
implements ValuesCodable,
IDataPortable {
    Namespace ns;
    NSRecord input;
    NSRecord output;
    public static final String NS_EXCEPTION_BUNDLE_BASE_NAME = "com.wm.lang.ns.resources.NSExceptionBundle";
    public static final String KEY_NSSi_IN = "sig_in";
    public static final String KEY_NSSi_OUT = "sig_out";

    private NSSignature(Namespace ns, IData val) {
        this.ns = ns;
        this.setFromData(val);
    }

    private NSSignature(Namespace ns, Values val) {
        this.ns = ns;
        this.setValues(val);
    }

    public NSSignature(NSRecord in, NSRecord out) {
        this.input = in;
        this.output = out;
    }

    public static NSSignature create(Namespace ns, IData values) {
        if (values == null) {
            return null;
        }
        return new NSSignature(ns, values);
    }

    public static NSSignature create(Namespace ns, Values values) {
        if (values == null) {
            return null;
        }
        return new NSSignature(ns, values);
    }

    public NSRecord getInput() {
        return this.input;
    }

    public NSRecord getOutput() {
        return this.output;
    }

    public void setInput(NSRecord rec) {
        this.input = rec;
    }

    public void setOutput(NSRecord rec) {
        this.output = rec;
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{KEY_NSSi_IN, this.getInput()}, {KEY_NSSi_OUT, this.getOutput()}};
        return new Values(o);
    }

    public void setValues(Values val) {
        block8: {
            try {
                Object f = val.get(KEY_NSSi_IN);
                if (f == null || f instanceof Values) {
                    this.input = (NSRecord)NSField.create(this.ns, (Values)f);
                } else if (f instanceof NSRecord) {
                    this.input = (NSRecord)f;
                } else {
                    LocalizedExceptionInfo lei = new LocalizedExceptionInfo(NS_EXCEPTION_BUNDLE_BASE_NAME, NSExceptionBundle.UNKNOWN_SIGNATURE, null);
                    throw new RuntimeException(lei.formatMsgOnly());
                }
                f = val.get(KEY_NSSi_OUT);
                if (f == null || f instanceof Values) {
                    this.output = (NSRecord)NSField.create(this.ns, (Values)f);
                    break block8;
                }
                if (f instanceof NSRecord) {
                    this.output = (NSRecord)f;
                    break block8;
                }
                LocalizedExceptionInfo lei = new LocalizedExceptionInfo(NSExceptionBundle.class, NSExceptionBundle.UNKNOWN_SIGNATURE, null);
                throw new RuntimeException(lei.formatMsgOnly());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public IData getAsData() {
        NSRecord in = this.getInput();
        NSRecord out = this.getOutput();
        IData val = IDataFactory.create();
        IDataCursor ic = val.getCursor();
        if (in != null) {
            ic.insertAfter(KEY_NSSi_IN, in);
        }
        if (out != null) {
            ic.insertAfter(KEY_NSSi_OUT, out);
        }
        ic.destroy();
        return val;
    }

    public void setFromData(IData val) {
        IDataCursor ic;
        block8: {
            ic = val.getCursor();
            try {
                Object f = IDataUtil.get(ic, KEY_NSSi_IN);
                if (f == null || f instanceof IData) {
                    this.input = (NSRecord)NSField.create(this.ns, (IData)f);
                } else if (f instanceof NSRecord) {
                    this.input = (NSRecord)f;
                } else {
                    LocalizedExceptionInfo lei = new LocalizedExceptionInfo(NSExceptionBundle.class, NSExceptionBundle.UNKNOWN_SIGNATURE, null);
                    throw new RuntimeException(lei.formatMsgOnly());
                }
                f = IDataUtil.get(ic, KEY_NSSi_OUT);
                if (f == null || f instanceof IData) {
                    this.output = (NSRecord)NSField.create(this.ns, (IData)f);
                    break block8;
                }
                if (f instanceof NSRecord) {
                    this.output = (NSRecord)f;
                    break block8;
                }
                LocalizedExceptionInfo lei = new LocalizedExceptionInfo(NSExceptionBundle.class, NSExceptionBundle.UNKNOWN_SIGNATURE, null);
                throw new RuntimeException(lei.formatMsgOnly());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ic.destroy();
    }

    public String toString() {
        return "in:" + this.getInput() + "/out:" + this.getOutput();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public Object deepClone() {
        try {
            NSSignature clone = (NSSignature)super.clone();
            if (clone.input != null) {
                clone.input = (NSRecord)clone.input.deepClone(true);
            }
            if (clone.output != null) {
                clone.output = (NSRecord)clone.output.deepClone(true);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

