/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.ns;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSType;
import com.wm.util.Values;

public class NSServiceType
extends NSType {
    static final boolean debug = false;
    String subtype;
    public static final String SVC_JAVA = "java";
    public static final String SVC_FLOW = "flow";
    public static final String SVC_SPEC = "spec";
    public static final String SVCSUB_UNKNOWN = "unknown";
    public static final String SVCSUB_DEFAULT = "default";
    public static final String SVCSUB_C = "c";
    public static final String SVCSUB_WS = "webservice";
    public static final String SVCSUB_WEBTAP = "webtap";
    public static final String KEY_NSS_TYPE = "svc_type";
    public static final String KEY_NSS_SUBTYPE = "svc_subtype";

    public NSServiceType() {
    }

    protected NSServiceType(String type, String subtype) {
        super(type);
        this.subtype = subtype;
    }

    protected NSServiceType(String type) {
        super(type);
    }

    public void setValues(Values values) {
        values.put(KEY_NSS_TYPE, this.type == null ? SVCSUB_UNKNOWN : this.type);
        values.put(KEY_NSS_SUBTYPE, this.subtype == null ? SVCSUB_UNKNOWN : this.subtype);
    }

    public static NSServiceType create(Values values) {
        String type = null;
        String subtype = null;
        if (values != null) {
            type = values.getString(KEY_NSS_TYPE);
            subtype = values.getString(KEY_NSS_SUBTYPE);
        }
        return new NSServiceType(type != null ? type : SVCSUB_UNKNOWN, subtype != null ? subtype : SVCSUB_UNKNOWN);
    }

    public static NSServiceType create(IDataCursor c) {
        String type = IDataUtil.getString(c, KEY_NSS_TYPE);
        String subtype = IDataUtil.getString(c, KEY_NSS_SUBTYPE);
        return new NSServiceType(type != null ? type : SVCSUB_UNKNOWN, subtype != null ? subtype : SVCSUB_UNKNOWN);
    }

    public static NSServiceType create(String type, String subtype) {
        return new NSServiceType(type, subtype);
    }

    public void setData(IDataCursor c) {
        c.insertAfter(KEY_NSS_TYPE, this.type == null ? SVCSUB_UNKNOWN : this.type);
        c.insertAfter(KEY_NSS_SUBTYPE, this.subtype == null ? SVCSUB_UNKNOWN : this.subtype);
    }

    public boolean subtypeEquals(String subtype) {
        return subtype == null && this.subtype == null || subtype != null && subtype.equals(this.subtype);
    }

    public boolean isJavaService() {
        return this.type.equals(SVC_JAVA);
    }

    public boolean isSpecService() {
        return this.type.equals(SVC_SPEC);
    }

    public boolean isFlowService() {
        return this.type.equals(SVC_FLOW);
    }

    public String getSubtype() {
        return this.subtype;
    }

    public void setSubtype(String subtype) {
        this.subtype = subtype;
    }

    public void setValue(String value) {
        if (value != null) {
            int idx = value.indexOf(47);
            if (idx > -1) {
                this.type = value.substring(0, idx);
                this.subtype = value.substring(idx, value.length());
            } else {
                this.type = value;
            }
        }
    }

    public String getValue() {
        if (this.subtype != null) {
            return this.type + "/" + this.subtype;
        }
        return this.type;
    }

    public IData getAsData() {
        IData values = IDataFactory.create();
        IDataCursor ic = values.getCursor();
        ic.insertAfter(KEY_NSS_TYPE, this.type == null ? SVCSUB_UNKNOWN : this.type);
        ic.insertAfter(KEY_NSS_SUBTYPE, this.subtype == null ? SVCSUB_UNKNOWN : this.subtype);
        ic.destroy();
        return values;
    }

    public void setFromData(IData values) {
        IDataCursor ic = values.getCursor();
        this.type = IDataUtil.getString(ic, KEY_NSS_TYPE);
        this.subtype = IDataUtil.getString(ic, KEY_NSS_SUBTYPE);
        ic.destroy();
    }
}

