/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.ns;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataUtil;
import com.wm.g11n.util.iContext;
import com.wm.lang.ns.AuditSettings;
import com.wm.lang.ns.AuditableNSNode;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSNode;
import com.wm.lang.ns.NSPackage;
import com.wm.lang.ns.NSServiceType;
import com.wm.lang.ns.NSSignature;
import com.wm.lang.ns.NSType;
import com.wm.lang.ns.Namespace;
import com.wm.lang.ns.UIDRegistry;
import com.wm.lang.ns.UniversalNamedNSNode;
import com.wm.util.IntEnum;
import com.wm.util.QName;
import com.wm.util.Values;

public abstract class NSService
extends NSNode
implements AuditableNSNode,
UniversalNamedNSNode {
    public static final String TYPE_KEY = "service";
    public static final NSType TYPE = NSType.create("service");
    NSServiceType svcType;
    NSName spec;
    QName universalName;
    public iContext giContext;
    NSSignature sig;
    int svcSigtype;
    int inValidatorOptions;
    int outValidatorOptions;
    public static final int NO_VALIDATION = 1;
    public static final int DEFAULT_VALIDATION = 2;
    static final IntEnum vOptionEnum = new IntEnum(0);
    public static final int SIG_JAVA_UNKNOWN = -1;
    public static final int SIG_JAVA_ANCIENT = 1;
    public static final int SIG_JAVA_2_x = 2;
    public static final int SIG_JAVA_3_0 = 3;
    public static final int SIG_JAVA_3_5 = 4;
    protected int auditOption;
    protected AuditSettings auditSettings;
    static final IntEnum sigtypeEnum;
    public static final String KEY_NSS_TYPE = "svc_type";
    public static final String KEY_NSS_SUBTYPE = "svc_subtype";
    public static final String KEY_NSS_SIGTYPE = "svc_sigtype";
    public static final String KEY_NSS_SPEC = "svc_spec";
    public static final String KEY_NSS_SIG = "svc_sig";
    public static final String KEY_NSS_IN_VALIDATOR_OPTIONS = "svc_in_validator_options";
    public static final String KEY_NSS_OUT_VALIDATOR_OPTIONS = "svc_out_validator_options";
    public static final String KEY_NSS_AUDIT_OPTION = "auditoption";
    public static final String KEY_NSS_AUDIT_SETTINGS = "auditsettings";
    public static final String KEY_NSS_ICONTEXT_POLICY = "icontext_policy";

    protected NSService(Namespace ns, NSPackage pkg, NSName nsName, NSServiceType svcType) {
        super(ns, pkg, nsName, TYPE);
        this.svcType = svcType;
        this.init();
    }

    protected NSService(Namespace ns, IData values) {
        super(ns, values);
    }

    protected NSService(Namespace ns, Values values) {
        super(ns, values);
    }

    protected void init() {
        this.auditOption = 0;
        this.auditSettings = new AuditSettings();
        this.giContext = new iContext("$null");
    }

    public String toString() {
        return this.getNSName().toString();
    }

    public NSServiceType getServiceType() {
        return this.svcType;
    }

    public NSName getSpecification() {
        return this.spec;
    }

    public QName getUniversalName() {
        return this.universalName;
    }

    public iContext getIContextPolicy() {
        if (this.giContext == null) {
            return new iContext("$null");
        }
        return this.giContext;
    }

    public iContext getIContext() {
        if (this.giContext.isUserDefault()) {
            return this.giContext;
        }
        if (this.giContext.isServerDefault()) {
            return iContext.getDefault();
        }
        return this.giContext;
    }

    public NSSignature getSignature() {
        NSService svc;
        NSNode snode;
        if (this.spec != null && (snode = this.getNamespace().getNode(this.spec)) != null && snode != this && snode instanceof NSService && (svc = (NSService)snode).getServiceType().isSpecService()) {
            return svc.getSignature();
        }
        return this.sig;
    }

    public NSSignature getSig() {
        return this.sig;
    }

    public int getInputValidatorOptions() {
        return this.inValidatorOptions;
    }

    public int getOutputValidatorOptions() {
        return this.outValidatorOptions;
    }

    public void setServiceType(NSServiceType svcType) {
        this.svcType = svcType;
    }

    public void setSpecification(NSName spec) {
        if (spec != null) {
            this.sig = null;
            this.spec = spec;
        }
    }

    public void setUniversalName(QName qname) {
        this.universalName = qname;
    }

    public void setIContextPolicy(iContext ic) {
        if (ic == null) {
            ic = new iContext("$null");
        }
        this.giContext = ic;
    }

    public void setSignature(NSSignature sig) {
        if (sig != null) {
            this.spec = null;
            this.sig = sig;
        }
    }

    public void setInputValidatorOptions(int validatorOptions) {
        this.inValidatorOptions = validatorOptions;
    }

    public void setOutputValidatorOptions(int validatorOptions) {
        this.outValidatorOptions = validatorOptions;
    }

    public void setServiceSigtype(int svcSigtype) {
        this.svcSigtype = svcSigtype;
    }

    public void setServiceSigtype(String sSigtype) {
        this.svcSigtype = sigtypeEnum.getInt(sSigtype, -1);
    }

    public String getServiceSigtypeString() {
        return sigtypeEnum.getString(this.svcSigtype, "unknown");
    }

    public int getServiceSigtype() {
        return this.svcSigtype;
    }

    public abstract Values invoke(Values var1) throws Exception;

    public abstract IData invoke(IData var1) throws Exception;

    public Values getValues() {
        Values values = super.getValues();
        this.svcType.setValues(values);
        if (this.spec != null) {
            values.put(KEY_NSS_SPEC, this.spec);
        } else {
            values.put(KEY_NSS_SIG, this.sig);
        }
        values.put(KEY_NSS_SIGTYPE, sigtypeEnum.getString(this.getServiceSigtype(), "unknown"));
        if (this.inValidatorOptions == 1 || this.inValidatorOptions == 2) {
            values.put(KEY_NSS_IN_VALIDATOR_OPTIONS, vOptionEnum.getString(this.getInputValidatorOptions(), "none"));
        }
        if (this.outValidatorOptions == 1 || this.outValidatorOptions == 2) {
            values.put(KEY_NSS_OUT_VALIDATOR_OPTIONS, vOptionEnum.getString(this.getOutputValidatorOptions(), "none"));
        }
        values.put(KEY_NSS_ICONTEXT_POLICY, this.giContext.toString());
        if (this.universalName != null) {
            values.put("svc_universal_name", this.universalName.getValues());
        }
        values.put(KEY_NSS_AUDIT_OPTION, new Integer(this.auditOption).toString());
        if (this.auditSettings != null) {
            values.put(KEY_NSS_AUDIT_SETTINGS, this.auditSettings.getAsData());
        }
        return values;
    }

    public void setValues(Values values) {
        String aOption;
        this.init();
        if (values == null) {
            return;
        }
        super.setValues(values);
        this.setServiceType(NSServiceType.create(values));
        String spec = values.getString(KEY_NSS_SPEC);
        if (spec != null && spec.length() > 0) {
            this.setSpecification(NSName.create(spec));
        } else {
            Object sig = values.get(KEY_NSS_SIG);
            if (sig instanceof NSSignature) {
                this.setSignature((NSSignature)sig);
            } else {
                this.setSignature(NSSignature.create(this.getNamespace(), values.getValues(KEY_NSS_SIG)));
            }
        }
        this.setServiceSigtype(sigtypeEnum.getInt(values.getString(KEY_NSS_SIGTYPE), -1));
        this.setInputValidatorOptions(vOptionEnum.getInt(values.getString(KEY_NSS_IN_VALIDATOR_OPTIONS), 1));
        this.setOutputValidatorOptions(vOptionEnum.getInt(values.getString(KEY_NSS_OUT_VALIDATOR_OPTIONS), 1));
        String icpol = values.getString(KEY_NSS_ICONTEXT_POLICY);
        this.giContext = new iContext(icpol);
        Values temp = values.getValues("svc_universal_name");
        if (temp != null) {
            this.universalName = QName.create(temp);
        }
        this.auditOption = (aOption = values.getString(KEY_NSS_AUDIT_OPTION)) != null && aOption.length() > 0 ? Integer.parseInt(aOption) : 0;
        IData as = (IData)values.get(KEY_NSS_AUDIT_SETTINGS);
        if (as != null && this.auditSettings != null) {
            this.auditSettings.setFromData(as);
        }
    }

    public IData getAsData() {
        IData values = super.getAsData();
        IDataCursor ic = values.getCursor();
        this.svcType.setData(ic);
        if (this.spec != null) {
            ic.insertAfter(KEY_NSS_SPEC, this.spec);
        } else {
            ic.insertAfter(KEY_NSS_SIG, this.sig);
        }
        IDataUtil.put(ic, KEY_NSS_SIGTYPE, sigtypeEnum.getString(this.getServiceSigtype(), "unknown"));
        if (this.inValidatorOptions == 1 || this.inValidatorOptions == 2) {
            ic.insertAfter(KEY_NSS_IN_VALIDATOR_OPTIONS, vOptionEnum.getString(this.getInputValidatorOptions(), "none"));
        }
        if (this.outValidatorOptions == 1 || this.outValidatorOptions == 2) {
            ic.insertAfter(KEY_NSS_OUT_VALIDATOR_OPTIONS, vOptionEnum.getString(this.getOutputValidatorOptions(), "none"));
        }
        if (this.giContext.isAbstract()) {
            ic.insertAfter(KEY_NSS_ICONTEXT_POLICY, this.giContext.getAbstractKey());
        } else {
            ic.insertAfter(KEY_NSS_ICONTEXT_POLICY, this.giContext.toString());
        }
        if (this.universalName != null) {
            ic.insertAfter("svc_universal_name", this.universalName.getAsData());
        }
        ic.insertAfter(KEY_NSS_AUDIT_OPTION, new Integer(this.auditOption).toString());
        if (this.auditSettings != null) {
            ic.insertAfter(KEY_NSS_AUDIT_SETTINGS, this.auditSettings.getAsData());
        }
        ic.destroy();
        return values;
    }

    public void setFromData(IData values) {
        this.init();
        if (values == null) {
            return;
        }
        super.setFromData(values);
        IDataCursor ic = values.getCursor();
        this.setServiceType(NSServiceType.create(ic));
        String spec = IDataUtil.getString(ic, KEY_NSS_SPEC);
        if (spec != null && spec.length() > 0) {
            this.setSpecification(NSName.create(spec));
        } else {
            Object sig = IDataUtil.get(ic, KEY_NSS_SIG);
            if (sig instanceof NSSignature) {
                this.setSignature((NSSignature)sig);
            } else {
                this.setSignature(NSSignature.create(this.getNamespace(), IDataUtil.getIData(ic, KEY_NSS_SIG)));
            }
        }
        this.setServiceSigtype(sigtypeEnum.getInt(IDataUtil.getString(ic, KEY_NSS_SIGTYPE), -1));
        this.setInputValidatorOptions(vOptionEnum.getInt(IDataUtil.getString(ic, KEY_NSS_IN_VALIDATOR_OPTIONS), 1));
        this.setOutputValidatorOptions(vOptionEnum.getInt(IDataUtil.getString(ic, KEY_NSS_OUT_VALIDATOR_OPTIONS), 1));
        String icpol = IDataUtil.getString(ic, KEY_NSS_ICONTEXT_POLICY);
        this.giContext = new iContext(icpol);
        IData temp = (IData)IDataUtil.get(ic, "svc_universal_name");
        if (temp != null) {
            this.universalName = QName.create(temp);
        }
        this.auditOption = ic.first(KEY_NSS_AUDIT_OPTION) && ic.getValue() != null ? Integer.parseInt((String)ic.getValue()) : 0;
        if (ic.first(KEY_NSS_AUDIT_SETTINGS) && ic.getValue() != null && this.auditSettings != null) {
            this.auditSettings.setFromData((IData)ic.getValue());
        }
        ic.destroy();
    }

    public boolean register() {
        return true;
    }

    public boolean unregister() {
        return true;
    }

    public boolean validateUniversalName() {
        boolean valid = true;
        QName universalName = this.getUniversalName();
        if (universalName != null) {
            if (UIDRegistry.find(universalName) != null) {
                valid = false;
            } else if (universalName.getNamespace() != null) {
                NSName name = NSName.create(universalName.getNamespace(), universalName.getNCName());
                if (this.getNamespace().nodeExists(name)) {
                    valid = false;
                }
            }
        }
        return valid;
    }

    public int getAuditOption() {
        return this.auditOption;
    }

    public void setAuditOption(int option) {
        this.auditOption = option < 0 || option > 2 ? 0 : option;
    }

    public AuditSettings getAuditSettings() {
        return this.auditSettings;
    }

    public boolean setAuditSettings(AuditSettings as) {
        return this.auditSettings.setFromAuditSettings(as);
    }

    static {
        vOptionEnum.addInt("none", 1);
        vOptionEnum.addInt("default", 2);
        sigtypeEnum = new IntEnum(0);
        sigtypeEnum.addInt("java ancient", 1);
        sigtypeEnum.addInt("java 2.x", 2);
        sigtypeEnum.addInt("java 3.0", 3);
        sigtypeEnum.addInt("java 3.5", 4);
    }
}

