/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.ns;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataPortable;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSException;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSNode;
import com.wm.lang.ns.NSPackage;
import com.wm.lang.ns.NSSchemaRef;
import com.wm.lang.ns.NSType;
import com.wm.lang.ns.Namespace;
import com.wm.lang.ns.resources.NSExceptionBundle;
import com.wm.lang.schema.ComplexType;
import com.wm.lang.schema.ContentType;
import com.wm.lang.schema.Schema;
import com.wm.lang.schema.SchemaRegistry;
import com.wm.lang.schema.SimpleType;
import com.wm.lang.schema.SymbolSpace;
import com.wm.lang.schema.TNSException;
import com.wm.lang.schema.TypeDef;
import com.wm.lang.schema.WmAttribute;
import com.wm.lang.schema.WmComplexType;
import com.wm.lang.schema.WmElement;
import com.wm.lang.schema.datatype.Datatype;
import com.wm.lang.schema.datatype.DatatypeRef;
import com.wm.lang.schema.gen.DTDCompiler;
import com.wm.lang.schema.tx.Translator;
import com.wm.lang.schema.xsd.XSDCompiler;
import com.wm.lang.xml.ElementNode;
import com.wm.lang.xml.WMDocumentException;
import com.wm.util.ByteOutputBuffer;
import com.wm.util.Destroyable;
import com.wm.util.QName;
import com.wm.util.Showable;
import com.wm.util.Values;
import com.wm.util.coder.IDataBinCoder;
import com.wm.util.coder.ValuesCodable;
import com.wm.util.sort.QuickSort;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class NSSchema
extends NSNode
implements ValuesCodable,
Schema,
Destroyable,
Showable {
    public static final String TYPE_KEY = "schema";
    public static final NSType TYPE = NSType.create("schema");
    static final String MESSAGE_NAME_COLLISION = "Name collision (s)";
    String _name;
    String _targetNS;
    Hashtable _attributes;
    Hashtable _elements;
    Hashtable _types;
    int _internalType;
    boolean _registered;
    boolean _transient;
    IData _uriReferencePrefixPairs;
    public static final String KEY_NSS_NAME = "name";
    public static final String KEY_NSS_TARGETNS = "targetNamespace";
    public static final String KEY_NSS_ATTRIBUTES = "attributes";
    public static final String KEY_NSS_ELEMENTS = "elements";
    public static final String KEY_NSS_TYPES = "types";
    public static final String KEY_NSS_CONTENTTYPE = "contentType";
    public static final String KEY_NSS_URI_REFERENCE_PREFIX_PAIRS = "uriReferencePrefixPairs";
    boolean _isDestroyed = false;
    static final String VALUE_NSS_CONTENTTYPE = "schema";

    NSSchema(Namespace ns, IData values) {
        super(ns, values);
    }

    NSSchema(Namespace ns, Values values) {
        super(ns, (IData)values);
    }

    protected NSSchema(Namespace ns, NSPackage nsPackage, NSName nsName) {
        super(ns, nsPackage, nsName, TYPE);
        this._attributes = new SymbolSpace((Schema)this, 11);
        this._elements = new SymbolSpace((Schema)this, 11);
        this._types = new SymbolSpace((Schema)this, 11);
    }

    protected NSSchema(Namespace ns, String name) {
        super(ns, null, null, TYPE);
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public int getType() {
        return 3;
    }

    public String getTargetNamespace() {
        return this._targetNS;
    }

    public boolean containsAttribute(String ncName) {
        if (ncName == null) {
            return false;
        }
        return this._attributes.containsKey(ncName);
    }

    public boolean containsElement(String ncName) {
        if (ncName == null) {
            return false;
        }
        return this._elements.containsKey(ncName);
    }

    public boolean containsType(String ncName) {
        if (ncName == null) {
            return false;
        }
        return this._types.containsKey(ncName);
    }

    public boolean containsSimpleType(String ncName) {
        if (ncName == null) {
            return false;
        }
        return this._types.containsKey(ncName) && ((ContentType)this._types.get(ncName)).getType() == 1;
    }

    public boolean containsComplexType(String ncName) {
        if (ncName == null) {
            return false;
        }
        return this._types.containsKey(ncName) && ((ContentType)this._types.get(ncName)).getType() == 2;
    }

    public boolean containsInTargetNamespace(String ncName, int abstractionType) {
        if (this._transient) {
            return false;
        }
        if (this._targetNS != null) {
            return NSSchema.containsInTargetNamespace(this.getNamespace(), this._targetNS, ncName, abstractionType);
        }
        return false;
    }

    public static final boolean containsInTargetNamespace(Namespace ns, String targetNamespace, String ncName, int abstractionType) {
        if (targetNamespace == null) {
            return false;
        }
        NSName[] qnames = SchemaRegistry.resolve(targetNamespace);
        if (qnames == null) {
            return false;
        }
        boolean found = false;
        for (int index = 0; index < qnames.length; ++index) {
            NSNode node = ns.getNode(qnames[index]);
            if (node != null && node.getNodeTypeObj().equals(TYPE)) {
                Schema schema = (Schema)((Object)node);
                switch (abstractionType) {
                    case 1: {
                        found = schema.containsElement(ncName);
                        break;
                    }
                    case 2: {
                        found = schema.containsAttribute(ncName);
                        break;
                    }
                    case 3: {
                        found = schema.containsType(ncName);
                        break;
                    }
                }
            }
            if (found) break;
        }
        return found;
    }

    private String lookupInTargetNamespace(String ncName, int abstractionType) {
        if (this._transient) {
            return null;
        }
        if (this._targetNS != null) {
            return NSSchema.lookupInTargetNamespace(this.getNamespace(), this._targetNS, ncName, abstractionType);
        }
        return null;
    }

    private static final String lookupInTargetNamespace(Namespace ns, String targetNamespace, String ncName, int abstractionType) {
        if (targetNamespace == null) {
            return null;
        }
        NSName[] qnames = SchemaRegistry.resolve(targetNamespace);
        if (qnames == null) {
            return null;
        }
        boolean found = false;
        for (int index = 0; index < qnames.length; ++index) {
            NSNode node = ns.getNode(qnames[index]);
            if (node != null && node.getNodeTypeObj().equals(TYPE)) {
                Schema schema = (Schema)((Object)node);
                switch (abstractionType) {
                    case 1: {
                        found = schema.containsElement(ncName);
                        break;
                    }
                    case 2: {
                        found = schema.containsAttribute(ncName);
                        break;
                    }
                    case 3: {
                        found = schema.containsType(ncName);
                        break;
                    }
                }
            }
            if (!found) continue;
            return qnames[index].toString();
        }
        return null;
    }

    public Enumeration attributes() {
        return this._attributes.elements();
    }

    public Enumeration elements() {
        return this._elements.elements();
    }

    public Enumeration types() {
        return this._types.elements();
    }

    public Object get(String ncName) {
        if (ncName == null) {
            return null;
        }
        Object o = this._elements.get(ncName);
        if (o != null) {
            return o;
        }
        o = this._attributes.get(ncName);
        if (o != null) {
            return o;
        }
        return this._types.get(ncName);
    }

    public WmAttribute getAttribute(String ncName) {
        if (ncName != null) {
            return (WmAttribute)this._attributes.get(ncName);
        }
        return null;
    }

    public WmElement getElement(String ncName) {
        if (ncName != null) {
            return (WmElement)this._elements.get(ncName);
        }
        return null;
    }

    public ContentType getType(String ncName) {
        if (ncName != null) {
            return (ContentType)this._types.get(ncName);
        }
        return null;
    }

    public WmAttribute[] getAttributes() {
        if (this._attributes != null) {
            return (WmAttribute[])QuickSort.sort(NSSchema.HashtableToWmAttributeArray(this._attributes));
        }
        return null;
    }

    public WmElement[] getElements() {
        if (this._elements != null) {
            return (WmElement[])QuickSort.sort(NSSchema.HashtableToWmElementArray(this._elements));
        }
        return null;
    }

    public TypeDef[] getTypes() {
        if (this._types != null) {
            return (TypeDef[])QuickSort.sort(NSSchema.HashtableToTypeDefArray(this._types));
        }
        return null;
    }

    public SimpleType getSimpleType(String ncName) {
        ContentType ct;
        if (ncName != null && (ct = (ContentType)this._types.get(ncName)) != null && ct.getType() == 1) {
            return (SimpleType)ct;
        }
        return null;
    }

    public ComplexType getComplexType(String ncName) {
        ContentType ct;
        if (ncName != null && (ct = (ContentType)this._types.get(ncName)) != null && ct.getType() == 2) {
            return (ComplexType)ct;
        }
        return null;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setTargetNamespace(String targetNamespace) throws TNSException {
        NSName[] qnames;
        boolean D;
        if (this._transient) {
            this._targetNS = targetNamespace;
            return;
        }
        boolean A = targetNamespace != null;
        boolean B = this._targetNS != null;
        boolean C = this._registered;
        boolean bl = D = A && B && this._targetNS.equals(targetNamespace) || !A && !B;
        if (D) {
            return;
        }
        if (A && !D && (qnames = SchemaRegistry.resolve(targetNamespace)) != null) {
            Enumeration elements = null;
            Enumeration types = null;
            Object attributes = null;
            Vector<String> errors = new Vector<String>();
            for (int index = 0; index < qnames.length; ++index) {
                String name;
                NSNode node = this.ns.getNode(qnames[index]);
                if (node == null || !node.getNodeTypeObj().equals(TYPE)) continue;
                Schema schema = (Schema)((Object)node);
                if (elements == null) {
                    elements = this._elements.keys();
                }
                while (elements.hasMoreElements()) {
                    name = (String)elements.nextElement();
                    if (!schema.containsElement(name)) continue;
                    errors.addElement("{" + targetNamespace + "} " + name + " - element decl - in " + qnames[index]);
                }
                if (types == null) {
                    types = this._types.keys();
                }
                while (types.hasMoreElements()) {
                    name = (String)types.nextElement();
                    if (!schema.containsType(name)) continue;
                    errors.addElement("{" + targetNamespace + "} " + name + " - type def - in " + qnames[index]);
                }
            }
            if (errors.size() > 0) {
                StringBuffer sb = new StringBuffer();
                int size = errors.size();
                for (int i = 0; i < size; ++i) {
                    sb.append((String)errors.elementAt(i) + '\n');
                }
                throw new TNSException(MESSAGE_NAME_COLLISION, sb.toString());
            }
        }
        if (C && !D) {
            SchemaRegistry.unregister(this);
        }
        if (!D) {
            this._targetNS = targetNamespace;
        }
        if (A && C && !D) {
            SchemaRegistry.register(this);
        }
    }

    public WmAttribute put(WmAttribute attribute) throws TNSException {
        String foundAt = this.lookupInTargetNamespace(attribute.getName(), 2);
        if (foundAt != null) {
            throw new TNSException(NSExceptionBundle.class, NSExceptionBundle.MSG_NAME_COLLISION, "", foundAt, foundAt);
        }
        return this._attributes.put(attribute.getName(), attribute);
    }

    public WmElement put(WmElement element) throws TNSException {
        String foundAt = this.lookupInTargetNamespace(element.getName(), 1);
        if (foundAt != null) {
            throw new TNSException(NSExceptionBundle.class, NSExceptionBundle.MSG_NAME_COLLISION, "", foundAt, foundAt);
        }
        return this._elements.put(element.getName(), element);
    }

    public ContentType put(ContentType ct) throws TNSException {
        String foundAt = NSSchema.lookupInTargetNamespace(this.getNamespace(), this._targetNS, ct.getName(), 3);
        if (foundAt != null) {
            throw new TNSException(NSExceptionBundle.class, NSExceptionBundle.MSG_NAME_COLLISION, "", foundAt, foundAt);
        }
        int type = ct.getType();
        if (type == 3) {
            return null;
        }
        Object dup = this._types.get(ct.getName());
        if (dup != null) {
            this.markDestroyed((Destroyable)dup);
        }
        return this._types.put(ct.getName(), ct);
    }

    public WmAttribute removeAttribute(String ncName) {
        if (ncName == null) {
            return null;
        }
        WmAttribute attribute = (WmAttribute)this._attributes.remove(ncName);
        if (attribute != null) {
            attribute.setDestroyed();
        }
        return attribute;
    }

    public WmElement removeElement(String ncName) {
        if (ncName == null) {
            return null;
        }
        WmElement element = (WmElement)this._elements.remove(ncName);
        if (element != null) {
            element.setDestroyed();
        }
        return element;
    }

    public ContentType removeType(String ncName) {
        if (ncName == null) {
            return null;
        }
        ContentType ct = (ContentType)this._types.remove(ncName);
        if (ct != null && ct instanceof Destroyable) {
            ((Destroyable)((Object)ct)).setDestroyed();
        }
        return ct;
    }

    public static final NSSchema create(Namespace ns, NSPackage nsPackage, NSName nsName) {
        return new NSSchema(ns, nsPackage, nsName);
    }

    public static final NSSchema createTransientSchema(Namespace ns, NSPackage nsPackage, NSName nsName) {
        NSSchema schema = NSSchema.create(ns, nsPackage, nsName);
        schema.setTransient();
        return schema;
    }

    public static final NSSchema createRef(Namespace ns, String name, NSName targetName) {
        return new NSSchemaRef(ns, name, targetName);
    }

    public static final Values create(Namespace ns, NSName name, String targetNS, String url) throws IOException, WMDocumentException {
        return null;
    }

    public static final NSSchema[] createFromDTD(Namespace ns, String url) throws IOException, WMDocumentException, Exception {
        return DTDCompiler.compileIntoTransientSchemas(ns, url);
    }

    public static final NSSchema[] createFromXSD(Namespace ns, String url) throws IOException, WMDocumentException, Exception {
        return XSDCompiler.compileIntoTransientSchemas(ns, url);
    }

    public static final Values createFromXSD2(Namespace ns, String url) throws IOException, WMDocumentException, Exception {
        return XSDCompiler.compileIntoTransientSchemas2(ns, url);
    }

    public static final NSSchema create(Namespace ns, IData values) {
        return new NSSchema(ns, values);
    }

    public static final NSSchema create(Namespace ns, Values values) {
        return new NSSchema(ns, values);
    }

    public static final NSSchema create(Translator tx) {
        return null;
    }

    public static final WmElement createElement(IData values) {
        return WmElement.create(null, values);
    }

    public static final WmElement createElement(String ncName) {
        return WmElement.create(ncName);
    }

    public static final WmElement createElement(String targetNS, String targetNCName) {
        return WmElement.create(targetNS, targetNCName);
    }

    public static final WmAttribute createAttribute(IData values) {
        return WmAttribute.create(null, values);
    }

    public static final WmAttribute createAttribute(String ncName) {
        return WmAttribute.create(ncName);
    }

    public static final SimpleType createDatatype(IData values) {
        Datatype st = null;
        try {
            st = Datatype.create(values);
        }
        catch (NSException nSException) {
            // empty catch block
        }
        return st;
    }

    public static final SimpleType createDatatype(String ncName) throws NSException {
        return Datatype.create(ncName);
    }

    public static final SimpleType createDatatypeRef(String targetNS, String ncName) {
        return new DatatypeRef(targetNS, ncName);
    }

    public static final SimpleType createDatatypeRef(QName qName) {
        return new DatatypeRef(qName);
    }

    public static final ComplexType createComplexType(String ncName) {
        return WmComplexType.create(ncName);
    }

    public static final ComplexType createComplexType(String ncName, String targetNS, String targetNCName) {
        return WmComplexType.create(ncName, targetNS, targetNCName);
    }

    public static final ContentType createContentType(IData values) {
        return null;
    }

    public boolean validate(ElementNode node, Object workspace) {
        return true;
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{KEY_NSS_CONTENTTYPE, Integer.toString(3)}, {KEY_NSS_NAME, this._name}, {KEY_NSS_TARGETNS, this._targetNS}, {KEY_NSS_ATTRIBUTES, this._attributes != null ? ((ValuesCodable)((Object)this._attributes)).getValues() : null}, {KEY_NSS_ELEMENTS, this._elements != null ? ((ValuesCodable)((Object)this._elements)).getValues() : null}, {KEY_NSS_TYPES, this._types != null ? ((ValuesCodable)((Object)this._types)).getValues() : null}, {KEY_NSS_URI_REFERENCE_PREFIX_PAIRS, this._uriReferencePrefixPairs}};
        return super.getValues().copyFrom(new Values(o));
    }

    public void setValues(Values values) {
        this.markDestroyed();
        super.setValues(values);
        this._name = values.getString(KEY_NSS_NAME);
        this._targetNS = values.getString(KEY_NSS_TARGETNS);
        Values in = values.getValues(KEY_NSS_ATTRIBUTES);
        if (in != null) {
            if (this._attributes != null) {
                ((ValuesCodable)((Object)this._attributes)).setValues(in);
            } else {
                this._attributes = new SymbolSpace((Schema)this, in);
            }
        }
        if ((in = values.getValues(KEY_NSS_ELEMENTS)) != null) {
            if (this._elements != null) {
                ((ValuesCodable)((Object)this._elements)).setValues(in);
            } else {
                this._elements = new SymbolSpace((Schema)this, in);
            }
        }
        if ((in = values.getValues(KEY_NSS_TYPES)) != null) {
            if (this._types != null) {
                ((ValuesCodable)((Object)this._types)).setValues(in);
            } else {
                this._types = new SymbolSpace((Schema)this, in);
            }
        }
        this._uriReferencePrefixPairs = (IData)values.get(KEY_NSS_URI_REFERENCE_PREFIX_PAIRS);
    }

    public IData getAsData() {
        IData val = super.getAsData();
        IDataCursor ic = val.getCursor();
        ic.insertAfter(KEY_NSS_CONTENTTYPE, Integer.toString(3));
        ic.insertAfter(KEY_NSS_NAME, this._name);
        if (this._targetNS != null) {
            ic.insertAfter(KEY_NSS_TARGETNS, this._targetNS);
        }
        if (this._attributes != null) {
            ic.insertAfter(KEY_NSS_ATTRIBUTES, ((IDataPortable)((Object)this._attributes)).getAsData());
        }
        if (this._elements != null) {
            ic.insertAfter(KEY_NSS_ELEMENTS, ((IDataPortable)((Object)this._elements)).getAsData());
        }
        if (this._types != null) {
            ic.insertAfter(KEY_NSS_TYPES, ((IDataPortable)((Object)this._types)).getAsData());
        }
        if (this._uriReferencePrefixPairs != null) {
            ic.insertAfter(KEY_NSS_URI_REFERENCE_PREFIX_PAIRS, this._uriReferencePrefixPairs);
        }
        ic.destroy();
        return val;
    }

    public void setFromData(IData values) {
        this.markDestroyed();
        super.setFromData(values);
        IDataCursor ic = values.getCursor();
        this._name = IDataUtil.getString(ic, KEY_NSS_NAME);
        this._targetNS = IDataUtil.getString(ic, KEY_NSS_TARGETNS);
        IData in = (IData)IDataUtil.get(ic, KEY_NSS_ATTRIBUTES);
        if (in != null) {
            if (this._attributes != null) {
                ((IDataPortable)((Object)this._attributes)).setFromData(in);
            } else {
                this._attributes = new SymbolSpace((Schema)this, in);
            }
        }
        if ((in = (IData)IDataUtil.get(ic, KEY_NSS_ELEMENTS)) != null) {
            if (this._elements != null) {
                ((IDataPortable)((Object)this._elements)).setFromData(in);
            } else {
                this._elements = new SymbolSpace((Schema)this, in);
            }
        }
        if ((in = (IData)IDataUtil.get(ic, KEY_NSS_TYPES)) != null) {
            if (this._types != null) {
                ((IDataPortable)((Object)this._types)).setFromData(in);
            } else {
                this._types = new SymbolSpace((Schema)this, in);
            }
        }
        this._uriReferencePrefixPairs = (IData)IDataUtil.get(ic, KEY_NSS_URI_REFERENCE_PREFIX_PAIRS);
        ic.destroy();
    }

    public boolean isDestroyed() {
        return this._isDestroyed;
    }

    public void setDestroyed() {
        this._isDestroyed = true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Schema dump \n\n");
        sb.append("NSName =" + this.getNSName().toString() + '\n');
        sb.append("name =" + this._name + '\n');
        sb.append("contentType = SCHEMA\n");
        sb.append("targetNS = " + this._targetNS + '\n');
        sb.append("attributes = " + this._attributes + '\n');
        sb.append("elements = " + this._elements + '\n');
        sb.append("types = " + this._types + "\n");
        return sb.toString();
    }

    public boolean validate(String data, Object context) {
        return false;
    }

    public Values getView() {
        Object[][] o = new Object[][]{{KEY_NSS_CONTENTTYPE, "schema"}, {KEY_NSS_NAME, this._name}, {KEY_NSS_TARGETNS, this._targetNS}, {KEY_NSS_ATTRIBUTES, this._attributes != null ? SymbolSpace.retrieveValuesArray(((Showable)((Object)this._elements)).getView()) : null}, {KEY_NSS_ELEMENTS, this._elements != null ? SymbolSpace.retrieveValuesArray(((Showable)((Object)this._elements)).getView()) : null}, {KEY_NSS_TYPES, this._types != null ? SymbolSpace.retrieveValuesArray(((Showable)((Object)this._types)).getView()) : null}};
        return super.getValues().copyFrom(new Values(o));
    }

    public void setRegistration() {
        this._registered = true;
    }

    public void clearRegistration() {
        this._registered = false;
    }

    public boolean register() {
        return SchemaRegistry.register(this);
    }

    public boolean unregister() {
        this.markDestroyed();
        return SchemaRegistry.unregister(this);
    }

    public Object deepClone() {
        Values values = this.getValues();
        IDataBinCoder coder = new IDataBinCoder();
        ByteOutputBuffer os = new ByteOutputBuffer();
        try {
            coder.encode(os, values);
            byte[] encData = os.toByteArray();
            values = (Values)coder.decodeFromBytes(encData);
        }
        catch (IOException e) {
            // empty catch block
        }
        NSSchema clone = NSSchema.create(this.getNamespace(), values);
        return clone;
    }

    private void setTransient() {
        this._transient = true;
    }

    public boolean isTransient() {
        return this._transient;
    }

    public void setURIReferencePrefixPairs(IData idata) {
        this._uriReferencePrefixPairs = idata;
    }

    public IData getURIReferencePrefixPairs() {
        return this._uriReferencePrefixPairs;
    }

    public String[] getNamesOfElements() {
        String[] names = new String[this._elements.size()];
        Enumeration keys = this._elements.keys();
        int i = 0;
        while (keys.hasMoreElements()) {
            names[i++] = (String)keys.nextElement();
        }
        return names;
    }

    public QName[] getQNamesOfElements() {
        QName[] names = new QName[this._elements.size()];
        Enumeration keys = this._elements.keys();
        int i = 0;
        while (keys.hasMoreElements()) {
            names[i++] = QName.create(this.getTargetNamespace(), (String)keys.nextElement());
        }
        return names;
    }

    public QName[] getQNamesOfTypes() {
        QName[] names = new QName[this._types.size()];
        Enumeration keys = this._types.keys();
        int i = 0;
        while (keys.hasMoreElements()) {
            names[i++] = QName.create(this.getTargetNamespace(), (String)keys.nextElement());
        }
        return names;
    }

    public String[] getNamesOfSimpleTypes() {
        return null;
    }

    public boolean isEmpty() {
        return this._elements.size() <= 0 && this._types.size() <= 0 && this._attributes.size() <= 0;
    }

    private void markDestroyed(Destroyable dest) {
        dest.setDestroyed();
    }

    private void markDestroyed() {
        if (this._elements != null) {
            this.markDestroyed(this._elements.elements());
        }
        if (this._attributes != null) {
            this.markDestroyed(this._attributes.elements());
        }
        if (this._types != null) {
            this.markDestroyed(this._types.elements());
        }
    }

    private void markDestroyed(Enumeration enumvar) {
        while (enumvar.hasMoreElements()) {
            this.markDestroyed((Destroyable)enumvar.nextElement());
        }
    }

    private static WmElement[] HashtableToWmElementArray(Hashtable ht) {
        if (ht == null) {
            return null;
        }
        WmElement[] oa = new WmElement[ht.size()];
        int i = 0;
        Enumeration e = ht.elements();
        while (e.hasMoreElements()) {
            oa[i] = (WmElement)e.nextElement();
            ++i;
        }
        return oa;
    }

    private static WmAttribute[] HashtableToWmAttributeArray(Hashtable ht) {
        if (ht == null) {
            return null;
        }
        WmAttribute[] oa = new WmAttribute[ht.size()];
        int i = 0;
        Enumeration e = ht.elements();
        while (e.hasMoreElements()) {
            oa[i] = (WmAttribute)e.nextElement();
            ++i;
        }
        return oa;
    }

    private static TypeDef[] HashtableToTypeDefArray(Hashtable ht) {
        if (ht == null) {
            return null;
        }
        TypeDef[] oa = new TypeDef[ht.size()];
        int i = 0;
        Enumeration e = ht.elements();
        while (e.hasMoreElements()) {
            oa[i] = (TypeDef)e.nextElement();
            ++i;
        }
        return oa;
    }
}

