/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.ns;

import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSRecordRef;
import com.wm.lang.ns.NSRecordUtil;
import com.wm.lang.ns.WmPathInfo;
import com.wm.lang.ns.WmPathItem;
import com.wm.lang.ns.resources.NSExceptionBundle;
import com.wm.util.LocalizedExceptionInfo;

public class NSRecordWmPathProcessor {
    public static final String NS_EXCEPTION_BUNDLE_BASE_NAME = "com.wm.lang.ns.resources.NSExceptionBundle";

    public static NSField get(NSRecord record, WmPathItem pathItem) {
        return NSRecordWmPathProcessor.get(record, pathItem, true);
    }

    public static NSField get(NSRecord record, WmPathItem pathItem, boolean checkTypeAndDim) {
        if (record == null || pathItem == null) {
            return null;
        }
        if (pathItem.getPathType() == 0) {
            if (!checkTypeAndDim) {
                return record.getFieldByName(pathItem.getName());
            }
            NSField[] fields = record.getFieldsByName(pathItem.getName());
            if (fields == null) {
                return null;
            }
            for (int i = 0; i < fields.length; ++i) {
                NSField field = fields[i];
                if (!NSRecordWmPathProcessor.typeCheck(field, pathItem) || !NSRecordWmPathProcessor.dimCheck(field, pathItem)) continue;
                return field;
            }
            return null;
        }
        if (pathItem.getPathType() == 1) {
            if (pathItem.getPosition() < 0) {
                return null;
            }
            NSField field = record.getField(pathItem.getPosition());
            if (NSRecordWmPathProcessor.nameCheck(field, pathItem) && NSRecordWmPathProcessor.typeCheck(field, pathItem) && NSRecordWmPathProcessor.dimCheck(field, pathItem)) {
                return field;
            }
        } else {
            if (pathItem.getPathType() == 2) {
                NSField[] fields = record.getFieldsByName(pathItem.getName());
                if (fields == null) {
                    return null;
                }
                int pos = pathItem.getPosition();
                if (pos < 0 || pos > fields.length - 1) {
                    return null;
                }
                return fields[pos];
            }
            if (pathItem.getPathType() == 3) {
                LocalizedExceptionInfo lei = new LocalizedExceptionInfo(NS_EXCEPTION_BUNDLE_BASE_NAME, NSExceptionBundle.NOT_SUPPORTED_YET, null);
                new Exception(lei.formatMsgOnly()).printStackTrace();
            }
        }
        return null;
    }

    public static NSField get(NSRecord record, String path) {
        WmPathItem[] pathInfo = WmPathInfo.parsePath(path);
        if (pathInfo == null) {
            return null;
        }
        return NSRecordWmPathProcessor.get(record, pathInfo);
    }

    public static NSField get(NSRecord record, WmPathItem[] pathInfo) {
        return NSRecordWmPathProcessor.get(record, pathInfo, true);
    }

    public static NSField get(NSRecord record, WmPathItem[] pathInfo, boolean checkTypeAndDim) {
        if (record == null || pathInfo == null || pathInfo.length == 0) {
            return null;
        }
        int len = pathInfo.length - 1;
        for (int i = 0; i < len; ++i) {
            NSField field = NSRecordWmPathProcessor.get(record, pathInfo[i]);
            if (!(field instanceof NSRecord)) {
                return null;
            }
            record = (NSRecord)field;
        }
        return NSRecordWmPathProcessor.get(record, pathInfo[len], checkTypeAndDim);
    }

    public static NSField getByPathName(NSRecord record, String path) {
        if (record == null || path == null || path.length() == 0) {
            return null;
        }
        WmPathItem[] pathInfo = WmPathInfo.parsePath(path);
        if (pathInfo == null) {
            return null;
        }
        for (int i = 0; i < pathInfo.length; ++i) {
            pathInfo[i].setPathType(0);
        }
        return NSRecordWmPathProcessor.get(record, pathInfo);
    }

    public static int[] getAbsPosition(NSRecord record, WmPathItem[] pathItems) {
        if (record == null || pathItems == null || pathItems.length == 0) {
            return null;
        }
        int[] pos = new int[pathItems.length];
        for (int i = 0; i < pos.length; ++i) {
            pos[i] = -1;
        }
        NSRecord parent = record;
        for (int i = 0; i < pathItems.length; ++i) {
            if (parent == null) {
                return pos;
            }
            NSField field = NSRecordWmPathProcessor.get(parent, pathItems[i]);
            if (field == null) {
                return pos;
            }
            NSField[] fields = parent.getFieldNodes();
            if (fields != null) {
                for (int j = 0; j < fields.length; ++j) {
                    if (field != fields[j]) continue;
                    pos[i] = j;
                    break;
                }
            }
            if (pos[i] == -1) {
                return null;
            }
            parent = field instanceof NSRecord ? (NSRecord)field : null;
        }
        return pos;
    }

    public static int getAbsPosition(NSRecord record, WmPathItem pathItem) {
        return NSRecordWmPathProcessor.getAbsPosition(record, pathItem, true);
    }

    public static int getAbsPosition(NSRecord record, WmPathItem pathItem, boolean checkTypeAndDim) {
        if (record == null || pathItem == null) {
            return -1;
        }
        NSField field = NSRecordWmPathProcessor.get(record, pathItem, checkTypeAndDim);
        if (field == null) {
            return -1;
        }
        int len = record.getFieldCount();
        for (int j = 0; j < len; ++j) {
            if (field != record.getField(j)) continue;
            return j;
        }
        return -1;
    }

    public static void delete(NSRecord record, WmPathItem pathItem) {
        if (record == null || pathItem == null) {
            return;
        }
        if (record instanceof NSRecordRef) {
            return;
        }
        NSField find = NSRecordWmPathProcessor.get(record, pathItem);
        if (find != null) {
            record.removeField(find);
        }
    }

    public static void delete(NSRecord record, String path) {
        WmPathItem[] pathInfo = WmPathInfo.parsePath(path);
        if (pathInfo == null) {
            return;
        }
        NSRecordWmPathProcessor.delete(record, pathInfo);
    }

    public static void delete(NSRecord record, WmPathItem[] pathInfo) {
        if (record == null || pathInfo == null || pathInfo.length == 0) {
            return;
        }
        int len = pathInfo.length - 1;
        for (int i = 0; i < len; ++i) {
            NSField field = NSRecordWmPathProcessor.get(record, pathInfo[i]);
            if (field instanceof NSRecordRef) {
                return;
            }
            if (!(field instanceof NSRecord)) {
                return;
            }
            record = (NSRecord)field;
        }
        NSRecordWmPathProcessor.delete(record, pathInfo[len]);
    }

    public static NSField create(NSRecord record, WmPathItem pathItem) {
        NSField field;
        if (record == null || pathItem == null) {
            return null;
        }
        NSField find = NSRecordWmPathProcessor.get(record, pathItem);
        if (find != null) {
            return find;
        }
        int type = pathItem.getType();
        int dim = pathItem.getNodeDimension();
        if (type == -1) {
            type = 3;
        }
        if (dim == -1) {
            dim = 0;
        }
        if ((field = NSRecordUtil.createField(pathItem.getName(), type, dim, record.getNamespace(), pathItem.getNSName())) instanceof NSRecordRef) {
            field = (NSField)((NSRecordRef)field).deepClone();
        }
        return NSRecordWmPathProcessor.put(record, field, pathItem);
    }

    public static NSField put(NSRecord record, NSField field, WmPathItem pathItem) {
        int i;
        NSField[] fields;
        if (record == null || field == null || pathItem == null) {
            return null;
        }
        NSField find = NSRecordWmPathProcessor.get(record, pathItem);
        if (find != null && (fields = record.getFieldNodes()) != null) {
            for (i = 0; i < fields.length; ++i) {
                if (find != fields[i]) continue;
                record.removeField(find);
                record.insertFieldAt(field, i);
                return field;
            }
        }
        if (pathItem.getPathType() == 0) {
            return record.addField(field);
        }
        if (pathItem.getPathType() == 1) {
            if (pathItem.getPosition() < 0) {
                return null;
            }
            if (pathItem.getPosition() >= record.getFieldCount()) {
                return record.addField(field);
            }
            return record.insertFieldAt(field, pathItem.getPosition());
        }
        if (pathItem.getPathType() == 2) {
            if (pathItem.getPosition() < 0) {
                return null;
            }
            fields = record.getFieldsByName(pathItem.getName());
            if (fields == null || fields.length <= pathItem.getPosition()) {
                int numberOfFieldsThatExist = 0;
                if (fields != null) {
                    numberOfFieldsThatExist = fields.length + 1;
                }
                int fieldPosition = pathItem.getPosition() + 1;
                int numberOfFieldsYouNeed = fieldPosition - numberOfFieldsThatExist - 1;
                for (int i2 = 1; i2 <= numberOfFieldsYouNeed; ++i2) {
                    record.addField(pathItem.getName(), pathItem.getType(), pathItem.getDimension());
                }
                return record.addField(field);
            }
            find = fields[pathItem.getPosition()];
            fields = record.getFieldNodes();
            if (fields != null) {
                for (i = 0; i < fields.length; ++i) {
                    if (fields[i] != find) continue;
                    return record.insertFieldAt(field, i);
                }
            }
            return null;
        }
        if (pathItem.getPathType() == 3) {
            LocalizedExceptionInfo lei = new LocalizedExceptionInfo(NSExceptionBundle.class, NSExceptionBundle.NOT_SUPPORTED_YET, null);
            new Exception(lei.formatMsgOnly()).printStackTrace();
        }
        return null;
    }

    public static NSField create(NSRecord record, String path) {
        WmPathItem[] pathInfo = WmPathInfo.parsePath(path);
        if (pathInfo == null) {
            return null;
        }
        return NSRecordWmPathProcessor.create(record, pathInfo);
    }

    public static NSField create(NSRecord record, WmPathItem[] pathInfo) {
        if (record == null || pathInfo == null || pathInfo.length == 0) {
            return null;
        }
        int len = pathInfo.length - 1;
        for (int i = 0; i < len; ++i) {
            NSField field = NSRecordWmPathProcessor.create(record, pathInfo[i]);
            if (!(field instanceof NSRecord)) {
                return field;
            }
            record = (NSRecord)field;
        }
        return NSRecordWmPathProcessor.create(record, pathInfo[len]);
    }

    public static NSField put(NSRecord record, NSField field, WmPathItem[] pathInfo) {
        if (record == null || field == null || pathInfo == null || pathInfo.length == 0) {
            return null;
        }
        int len = pathInfo.length - 1;
        for (int i = 0; i < len; ++i) {
            NSField afield = NSRecordWmPathProcessor.create(record, pathInfo[i]);
            if (!(afield instanceof NSRecord)) {
                return afield;
            }
            record = (NSRecord)afield;
        }
        return NSRecordWmPathProcessor.put(record, field, pathInfo[len]);
    }

    public static NSRecord getIntersection(NSRecord record, Object[] paths) {
        if (record == null || paths == null || paths.length == 0) {
            return null;
        }
        return null;
    }

    public static boolean nameCheck(NSField field, WmPathItem pathItem) {
        if (field == null || pathItem == null) {
            return false;
        }
        if (field.getName() == null || pathItem.getName() == null) {
            return false;
        }
        return pathItem.getName().equals(field.getName());
    }

    public static boolean typeCheck(NSField field, WmPathItem pathItem) {
        if (field == null || pathItem == null) {
            return false;
        }
        if (pathItem.getType() == -1) {
            return true;
        }
        return pathItem.getType() == field.getType();
    }

    public static boolean dimCheck(NSField field, WmPathItem pathItem) {
        if (field == null || pathItem == null) {
            return false;
        }
        if (pathItem.getNodeDimension() == -1) {
            return true;
        }
        if (pathItem.getNodeDimension() == field.getDimensions()) {
            return true;
        }
        return pathItem.getNodeDimension() == field.getDimensions() - 1;
    }
}

