/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.ns;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataPortable;
import com.wm.lang.ns.EventDescription;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSNode;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSRecordRef;
import com.wm.lang.ns.Namespace;
import com.wm.util.Table;
import com.wm.util.coder.IDataCodable;

public class NSRecordUtil {
    public static NSField createField(String name, int type, int dim, Namespace ns, String nsname) {
        NSField field = null;
        switch (type) {
            case 4: {
                if (ns != null && nsname != null) {
                    NSRecord src = (NSRecord)ns.getNode(NSName.create(nsname));
                    if (src != null) {
                        NSRecord target = (NSRecord)src.deepClone();
                        field = new NSRecordRef(ns, name, target, dim);
                        break;
                    }
                    field = new NSRecordRef(ns, name, NSName.create(nsname), dim);
                    break;
                }
            }
            case 2: {
                field = new NSRecord(ns);
                field.setName(name);
                field.setDimensions(dim);
                break;
            }
            case 1: {
                field = new NSField(ns, NSNode.NODE_UNKNOWN_TYPE, name, 1, dim);
                break;
            }
            case 3: {
                field = new NSField(ns, NSNode.NODE_UNKNOWN_TYPE, name, 3, dim);
                break;
            }
            default: {
                field = null;
            }
        }
        return field;
    }

    public static void merge(NSRecord record, NSRecord parent) {
        NSRecordUtil.merge(record, parent, true);
    }

    public static void merge(NSRecord record, NSRecord parent, boolean overwrite) {
        int i;
        if (parent == null || record == null) {
            return;
        }
        if (record.getFieldCount() < 1) {
            return;
        }
        NSRecord clone = (NSRecord)record.clone();
        NSField[] fields = parent.getFieldNodes();
        for (i = 0; i < fields.length; ++i) {
            NSField find = clone.getFieldByName(fields[i].getName());
            if (find == null) continue;
            if (overwrite) {
                parent.removeField(fields[i]);
                parent.insertFieldAt(find, i);
            } else if (find.getType() != 2 || fields[i].getType() != 4) {
                if (find.getType() != fields[i].getType() || find.getDimensions() != fields[i].getDimensions()) {
                    parent.addField(find);
                } else if (!(fields[i] instanceof NSRecordRef) && fields[i] instanceof NSRecord) {
                    NSRecordUtil.merge((NSRecord)find, (NSRecord)fields[i], overwrite);
                }
            }
            clone.removeField(find);
        }
        if (clone.getFieldCount() < 1) {
            return;
        }
        fields = clone.getFieldNodes();
        for (i = 0; i < fields.length; ++i) {
            parent.addField(fields[i]);
        }
    }

    public static void mergeRecord(NSRecord record, NSRecord parent) {
        if (parent == null || record == null) {
            return;
        }
        NSField[] fields = record.getFieldNodes();
        if (fields == null || fields.length == 0) {
            return;
        }
        for (int i = 0; i < fields.length; ++i) {
            NSRecordUtil.mergeField(fields[i], parent, parent);
        }
    }

    public static void mergeField(NSField field, NSRecord record) {
        NSRecordUtil.mergeField(field, record, record);
    }

    public static void mergeField(NSField field, NSRecord record, NSRecord possibleRecursiveRecord) {
        NSField find = record.getField(field.getName(), field.getType(), field.getDimensions());
        if (find == null) {
            record.addField(field);
        } else {
            if (find instanceof NSRecordRef) {
                return;
            }
            if (find instanceof NSRecord && field instanceof NSRecord) {
                NSRecord subRecord = null;
                subRecord = field instanceof NSRecordRef ? ((NSRecordRef)field).getNSRecord() : (NSRecord)field;
                if (subRecord.isIdenticalTo(possibleRecursiveRecord)) {
                    return;
                }
                NSField[] fields = ((NSRecord)field).getFieldNodes();
                if (fields != null) {
                    for (int i = 0; i < fields.length; ++i) {
                        NSRecordUtil.mergeField(fields[i], (NSRecord)find, possibleRecursiveRecord);
                    }
                }
            }
        }
    }

    public static NSField createFromSample(Object value) {
        return NSRecordUtil.createFromSample(null, value, null);
    }

    public static NSField createFromSample(Object o, String name) {
        return NSRecordUtil.createFromSample(null, o, name);
    }

    public static NSField createFromSample(Namespace ns, Object o, String name) {
        int i;
        IData[] ida;
        Object[] idca;
        if (o == null) {
            return null;
        }
        if (o instanceof Table) {
            o = ((Table)o).getItems();
        } else if (!(o instanceof IData) && o instanceof IDataCodable) {
            o = ((IDataCodable)o).getIData();
        } else if (!(o instanceof IData[]) && o instanceof IDataCodable[]) {
            idca = (IDataCodable[])o;
            ida = new IData[idca.length];
            for (i = 0; i < idca.length; ++i) {
                ida[i] = idca[i].getIData();
            }
            o = ida;
        } else if (!(o instanceof IData) && o instanceof IDataPortable) {
            o = ((IDataPortable)o).getAsData();
        } else if (!(o instanceof IData[]) && o instanceof IDataPortable[]) {
            idca = (IDataPortable[])o;
            ida = new IData[idca.length];
            for (i = 0; i < idca.length; ++i) {
                ida[i] = idca[i].getAsData();
            }
            o = ida;
        }
        int type = NSRecordUtil.typeFromSample(o);
        int dim = NSRecordUtil.dimFromSample(o);
        if (type == 2) {
            NSRecord record = new NSRecord(ns, name, dim);
            IData values = null;
            if (dim == 1) {
                if (((IData[])o).length == 0) {
                    return record;
                }
                values = o[0];
            } else {
                values = (IData)o;
            }
            IDataCursor cursor = values.getCursor();
            NSField field = null;
            while (cursor.next()) {
                field = NSRecordUtil.createFromSample(cursor.getValue(), cursor.getKey());
                if (field == null) continue;
                record.addField(field);
            }
            return record;
        }
        return new NSField(null, NSNode.NODE_UNKNOWN_TYPE, name, type, dim);
    }

    public static int typeFromSample(Object o) {
        if (o instanceof String || o instanceof String[] || o instanceof String[][]) {
            return 1;
        }
        if (o instanceof IData || o instanceof IData[]) {
            return 2;
        }
        if (o instanceof IDataCodable || o instanceof IDataCodable[]) {
            return 2;
        }
        if (o instanceof IDataPortable || o instanceof IDataPortable[]) {
            return 2;
        }
        return 3;
    }

    public static int dimFromSample(Object o) {
        if (o instanceof Object[][]) {
            return 2;
        }
        if (o instanceof Object[] || o instanceof Table) {
            return 1;
        }
        return 0;
    }

    public static boolean isRecordRefAncester(NSField field) {
        if (field == null) {
            return false;
        }
        for (NSRecord parent = field.getParentRecord(); parent != null; parent = parent.getParentRecord()) {
            if (!(parent instanceof NSRecordRef)) continue;
            return true;
        }
        return false;
    }

    public static NSRecord deepClone(NSRecord record, boolean cloneContentType) {
        if (record == null) {
            return null;
        }
        return (NSRecord)record.deepClone(cloneContentType);
    }

    public static NSRecord deepClone(NSRecord record) {
        if (record == null) {
            return null;
        }
        return (NSRecord)record.deepClone(false);
    }

    public static NSRecord fastDeepClone(NSRecord record) {
        if (record == null) {
            return null;
        }
        if (record instanceof NSRecordRef) {
            NSRecordRef ref = (NSRecordRef)record;
            NSRecordRef clone = (NSRecordRef)ref.clone();
            clone.target = NSRecordUtil.fastDeepClone(clone.target);
            if (clone.target != null) {
                clone.target.setParent(clone);
            }
            clone.setDeepClone(true);
            return clone;
        }
        NSRecord clone = (NSRecord)record.clone();
        int count = record.getFieldCount();
        if (count == 0) {
            return clone;
        }
        clone.removeAllFields();
        for (int i = 0; i < count; ++i) {
            NSField field = record.getField(i);
            field = field instanceof NSRecord ? NSRecordUtil.fastDeepClone((NSRecord)field) : (NSField)field.clone();
            clone.addField(field);
        }
        return clone;
    }

    public static void transform(NSRecord record, EventDescription ed) {
        record.eventDescription = ed;
    }
}

