/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.ns;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.EventDescription;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSNode;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.Namespace;
import com.wm.lang.schema.ContentType;
import com.wm.util.List;
import com.wm.util.QName;
import com.wm.util.Values;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NSRecordRef
extends NSRecord {
    NSName targetName;
    NSRecord target;
    boolean targetExists;
    private static boolean alwaysDeepClone = false;
    private boolean instanceDeepClone = false;
    private HashMap<NSName, NSRecord> deepClonedTargets;
    public static final String KEY_REFERENCE_NAME = "ref_name";
    public static final String KEY_NSR_REFERENCE = "rec_ref";
    private static final int RECURSIVE_COUNT = 2;

    public static void setAlwaysDeepClone(boolean shouldDeepClone) {
        alwaysDeepClone = shouldDeepClone;
    }

    public void setDeepClone(boolean shouldDeepClone) {
        this.instanceDeepClone = shouldDeepClone;
    }

    public NSRecordRef(Namespace ns, String name, NSRecord target, int dim) {
        super(ns, NSRecord.TYPE, name, 4, dim);
        this.target = target;
        this.targetName = target.getNSName();
        this.targetExists = true;
    }

    NSRecordRef(Namespace ns, String name, NSName targetName, int dim) {
        super(ns, NSRecord.TYPE, name, 4, dim);
        this.target = null;
        this.targetName = targetName;
        this.targetExists = false;
    }

    private NSRecordRef(Namespace ns, IData values) {
        super(ns, values);
        this.targetExists = true;
    }

    private NSRecordRef(Namespace ns, Values values) {
        super(ns, values);
        this.targetExists = true;
    }

    public static NSRecordRef createRecordRef(Namespace ns, IData values) {
        if (ns == null || values == null) {
            return null;
        }
        return new NSRecordRef(ns, values);
    }

    public static NSRecordRef createRecordRef(Namespace ns, Values values) {
        if (ns == null || values == null) {
            return null;
        }
        return new NSRecordRef(ns, values);
    }

    @Override
    public Values getValues() {
        this.fields = null;
        Object[][] o = new Object[][]{{KEY_NSR_REFERENCE, this.targetName}};
        return super.getValues().copyFrom(new Values(o));
    }

    @Override
    public void setValues(Values val) {
        super.setValues(val);
        try {
            this.targetName = NSName.create(val.getString(KEY_NSR_REFERENCE));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.fields = null;
    }

    @Override
    public IData getAsData() {
        this.fields = null;
        IData val = super.getAsData();
        IDataCursor ic = val.getCursor();
        ic.insertAfter(KEY_NSR_REFERENCE, this.targetName);
        ic.destroy();
        return val;
    }

    @Override
    public void setFromData(IData val) {
        super.setFromData(val);
        IDataCursor ic = val.getCursor();
        try {
            Object o = IDataUtil.get(ic, KEY_NSR_REFERENCE);
            this.targetName = o instanceof NSName ? (NSName)o : NSName.create(IDataUtil.getString(ic, KEY_NSR_REFERENCE));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ic.destroy();
        this.fields = null;
    }

    public NSRecord getNSRecord() {
        if (this.target == null || !this.targetExists) {
            if (this.deepClonedTargets != null) {
                this.target = this.deepClonedTargets.get(this.targetName);
            }
            if (this.target != null && this.targetExists) {
                if (alwaysDeepClone || this.instanceDeepClone) {
                    this.target = this.target.deepClone(new HashMap<NSName, NSRecord>(), false);
                    this.target.setParent(this);
                }
                return this.target;
            }
            NSNode o = this.getNamespace().getNode(this.targetName);
            if (o instanceof NSRecord) {
                this.target = (NSRecord)o;
                this.targetExists = true;
                if (alwaysDeepClone || this.instanceDeepClone) {
                    this.target = this.target.deepClone(new HashMap<NSName, NSRecord>(), false);
                    this.target.setParent(this);
                }
            } else if (this.targetExists || this.target == null) {
                this.targetExists = false;
                String s = this.targetName != null ? this.targetName.toString() : "";
                this.target = new NSRecord(this.getNamespace(), s, 0);
                this.target.setParent(this);
            }
        }
        return this.target;
    }

    public NSName getTargetName() {
        return this.targetName;
    }

    public void setTargetName(NSName name) {
        this.targetName = name;
    }

    public boolean targetExists() {
        return this.targetExists;
    }

    @Override
    public String toString() {
        return "ref: name=" + this.targetName;
    }

    @Override
    public String[] getStringOptions() {
        return this.getNSRecord().getStringOptions();
    }

    @Override
    public IData[] getValueOptions() {
        return this.getNSRecord().getValueOptions();
    }

    @Override
    public NSField getField(int index) {
        return this.getNSRecord().getField(index);
    }

    @Override
    public NSField getField(String name, int type, int dim) {
        return this.getNSRecord().getField(name, type, dim);
    }

    @Override
    public NSField[] getFieldNodes() {
        return this.getNSRecord().getFieldNodes();
    }

    @Override
    public NSField[] getFields() {
        return this.getNSRecord().getFields();
    }

    @Override
    public int getFieldCount() {
        return this.getNSRecord().getFieldCount();
    }

    @Override
    public NSField getFieldByName(String name) {
        return this.getNSRecord().getFieldByName(name);
    }

    @Override
    public NSField[] getFieldsByName(String name) {
        return this.getNSRecord().getFieldsByName(name);
    }

    @Override
    public void setValueOptions(IData[] val) {
        this.getNSRecord().setValueOptions(val);
    }

    @Override
    public NSField addField(String name, int type, int dim) {
        return this.getNSRecord().addField(name, type, dim);
    }

    @Override
    public NSField addField(String name, int type, int dim, String nsname) {
        return this.getNSRecord().addField(name, type, dim, nsname);
    }

    @Override
    public NSField addField(NSField field) {
        return this.getNSRecord().addField(field);
    }

    @Override
    public NSField insertFieldAt(NSField field, int index) {
        return this.getNSRecord().insertFieldAt(field, index);
    }

    @Override
    public void removeField(NSField field) {
        this.getNSRecord().removeField(field);
    }

    @Override
    public void removeAllFields() {
        this.getNSRecord().removeAllFields();
    }

    @Override
    public void orderField(NSField field, int index) {
        this.getNSRecord().orderField(field, index);
    }

    @Override
    public void reorderField(NSField field, int index) {
        this.getNSRecord().reorderField(field, index);
    }

    @Override
    public NSField findFromPath(String path) {
        return this.getNSRecord().findFromPath(path);
    }

    @Override
    public void mergeRecord(NSRecord record) {
        this.getNSRecord().mergeRecord(record);
    }

    @Override
    public void mergePath(String fieldPath, Namespace ns) {
        this.getNSRecord().mergePath(fieldPath, ns);
    }

    @Override
    public ContentType getContentType() {
        return this.getNSRecord().getContentType();
    }

    @Override
    public void validateContent(String value, Object workspace) {
        this.getNSRecord().validateContent(value, workspace);
    }

    @Override
    public Values getReportable() {
        Values reportableData = this.getValues();
        reportableData.put(KEY_REFERENCE_NAME, this.targetName.getNodeName().toString());
        reportableData.put("rec_fields", this.getFieldNodes());
        return reportableData;
    }

    @Override
    public void setSchemaTypeName(QName schemaTypeName) {
    }

    @Override
    public QName getSchemaTypeName() {
        return this.getNSRecord().getSchemaTypeName();
    }

    @Override
    public boolean isPublishable() {
        return this.getNSRecord().isPublishable();
    }

    @Override
    public EventDescription getEventDescription() {
        return this.getNSRecord().getEventDescription();
    }

    public void transform(EventDescription ed) {
    }

    @Override
    public boolean isRecursive() {
        Object clone = this.deepClone();
        NSField field = (NSField)clone;
        NSRecord nsr = new NSRecord(this.ns);
        nsr.addField(field);
        return nsr.isRecursive();
    }

    @Override
    protected NSRecord deepClone(HashMap<NSName, NSRecord> stack, boolean cloneContentType) {
        NSRecordRef clone = (NSRecordRef)this.clone();
        NSName name = this.getTargetName();
        if (!stack.containsKey(name)) {
            NSRecord nSRecord = clone.target = this.target == null ? null : this.target.deepClone(stack, cloneContentType);
            if (clone.target != null) {
                clone.target.setParent(clone);
            }
        } else {
            NSRecord dct;
            clone.target = alwaysDeepClone ? null : (dct = stack.get(name));
        }
        clone.deepClonedTargets = stack;
        clone.setDeepClone(true);
        return clone;
    }

    @Override
    public NSRecord deepCloneForDeveloper() {
        NSRecordRef clone = (NSRecordRef)this.clone();
        NSName name = this.getTargetName();
        NSRecord nSRecord = clone.target = this.target == null ? null : this.target.deepCloneForDeveloper();
        if (clone.target != null) {
            clone.target.setParent(clone);
        }
        clone.setDeepClone(true);
        return clone;
    }

    private static boolean checkRecursive(List stack, NSName target) {
        if (!stack.contains(target)) {
            return true;
        }
        int repeat = 0;
        int size = stack.size();
        for (int i = 0; i < size; ++i) {
            if (stack.elementAt(i) != target) continue;
            ++repeat;
        }
        return repeat < 2;
    }
}

