/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.ns;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.EventDescription;
import com.wm.lang.ns.EventTypeRegistry;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSRecordRef;
import com.wm.lang.ns.NSRecordUtil;
import com.wm.lang.ns.NSRecordWmPathProcessor;
import com.wm.lang.ns.NSType;
import com.wm.lang.ns.Namespace;
import com.wm.lang.ns.UIDRegistry;
import com.wm.lang.ns.UniversalNamedNSNode;
import com.wm.lang.ns.resources.NSExceptionBundle;
import com.wm.util.Config;
import com.wm.util.JournalLogger;
import com.wm.util.LocalizedExceptionInfo;
import com.wm.util.QName;
import com.wm.util.Values;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NSRecord
extends NSField
implements UniversalNamedNSNode {
    public static final String TYPE_KEY = "record";
    public static final NSType TYPE = NSType.create("record");
    public static final String NS_EXCEPTION_BUNDLE_BASE_NAME = "com.wm.lang.ns.resources.NSExceptionBundle";
    public static final String WATT_SERVER_NS_SYNCHRONIZED = "watt.server.ns.synchronized";
    private static final boolean debug1 = false;
    public static final boolean DEFAULT_NS_SYNCHRONIZED = true;
    public static final String DEFAULT_SERVER_CONFIG_NS_SYNCHRONIZED = "false";
    TreeMap fieldHash;
    ArrayList fields;
    boolean closed;
    EventDescription eventDescription;
    boolean expand;
    static boolean shouldSynchronize = Config.getBooleanProperty(true, "watt.server.ns.synchronized");
    QName universalName;
    NSField currentField;
    public static final String KEY_NSR_FIELDS = "rec_fields";
    public static final String KEY_NSR_CLOSED = "rec_closed";
    public static final String KEY_NSR_EVENT_DESCRIPTION = "eventDescription";
    public static final String KEY_NSR_EXPAND = "expand";
    private QName schemaTypeName;
    public static final String KEY_NSR_SCHEMA_TYPE = "schemaType";
    public static final String SEARCH_DELIMITER = "/";

    public NSRecord(Namespace ns) {
        this(ns, null, 0);
    }

    public NSRecord(Namespace ns, String name, int dim) {
        super(ns, TYPE, name, 2, dim);
        this.fields = new ArrayList();
        this.closed = false;
    }

    NSRecord(Namespace ns, IData values) {
        super(ns, values);
    }

    NSRecord(Namespace ns, Values values) {
        super(ns, (IData)values);
    }

    NSRecord(Namespace ns, NSType ntype, String fname, int ftype, int dim) {
        super(ns, ntype, fname, ftype, dim);
        this.closed = false;
    }

    public static NSRecord createRecord(Namespace ns, IData values) {
        if (values == null) {
            return null;
        }
        return new NSRecord(ns, values);
    }

    public static NSRecord createRecord(Namespace ns, Values values) {
        if (values == null) {
            return null;
        }
        return new NSRecord(ns, values);
    }

    @Override
    public Values getValues() {
        Values[] fieldList = null;
        if (this.fields != null) {
            fieldList = new Values[this.fields.size()];
            for (int i = 0; i < fieldList.length; ++i) {
                NSField nsField = (NSField)this.fields.get(i);
                if (nsField == null) continue;
                fieldList[i] = nsField.getValues();
            }
        }
        Object[][] o = new Object[][]{{KEY_NSR_FIELDS, fieldList}, {KEY_NSR_CLOSED, this.closed ? "true" : null}, {KEY_NSR_SCHEMA_TYPE, this.schemaTypeName != null ? this.schemaTypeName.getValues() : null}, {KEY_NSR_EVENT_DESCRIPTION, this.eventDescription != null ? this.eventDescription.getValues() : null}, {"svc_universal_name", this.universalName != null ? this.universalName.getValues() : null}};
        return super.getValues().copyFrom(new Values(o));
    }

    @Override
    public void setValues(Values val) {
        boolean locked = false;
        super.setValues(val);
        try {
            Values temp = val.getValues("svc_universal_name");
            this.universalName = temp != null ? QName.create(temp) : null;
            this.closed = val.getBoolean(KEY_NSR_CLOSED);
            Object f = val.get(KEY_NSR_FIELDS);
            Values schemaType = val.getValues(KEY_NSR_SCHEMA_TYPE);
            Values ed = val.getValues(KEY_NSR_EVENT_DESCRIPTION);
            if (f instanceof Vector || f == null) {
                this.fields = this.createFields((Vector)f);
            } else if (f instanceof ArrayList) {
                this.fields = this.createFields((ArrayList)f);
            } else if (f instanceof IData[]) {
                this.fields = this.createFields((IData[])f);
            } else {
                LocalizedExceptionInfo lei = new LocalizedExceptionInfo(NS_EXCEPTION_BUNDLE_BASE_NAME, NSExceptionBundle.UNKNOWN_FIELD_TYPE, null);
                throw new RuntimeException(lei.formatMsgOnly());
            }
            if (schemaType != null) {
                this.schemaTypeName = QName.create(schemaType);
            }
            if (ed != null) {
                this.eventDescription = EventDescription.create(ed);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.fieldHash = null;
    }

    @Override
    public IData getAsData() {
        IData val = super.getAsData();
        IDataCursor ic = val.getCursor();
        IData[] fieldList = null;
        if (this.fields != null) {
            fieldList = new IData[this.fields.size()];
            for (int i = 0; i < fieldList.length; ++i) {
                NSField nsField = (NSField)this.fields.get(i);
                if (nsField == null) continue;
                fieldList[i] = nsField.getAsData();
            }
        }
        ic.insertAfter(KEY_NSR_FIELDS, fieldList);
        ic.insertAfter(KEY_NSR_CLOSED, this.closed ? "true" : null);
        if (this.schemaTypeName != null) {
            ic.insertAfter(KEY_NSR_SCHEMA_TYPE, this.schemaTypeName.getValues());
        }
        if (this.eventDescription != null) {
            ic.insertAfter(KEY_NSR_EVENT_DESCRIPTION, this.eventDescription.getValues());
        }
        if (this.universalName != null) {
            ic.insertAfter("svc_universal_name", this.universalName.getAsData());
        }
        ic.destroy();
        return val;
    }

    @Override
    public void setFromData(IData val) {
        super.setFromData(val);
        IDataCursor ic = val.getCursor();
        try {
            IData temp;
            if (ic.first(KEY_NSR_CLOSED)) {
                this.closed = IDataUtil.getBoolean(ic);
            }
            Object f = IDataUtil.get(ic, KEY_NSR_FIELDS);
            IData schemaType = (IData)IDataUtil.get(ic, KEY_NSR_SCHEMA_TYPE);
            IData ed = (IData)IDataUtil.get(ic, KEY_NSR_EVENT_DESCRIPTION);
            if (f instanceof Vector || f == null) {
                this.fields = this.createFields((Vector)f);
            } else if (f instanceof ArrayList) {
                this.fields = this.createFields((ArrayList)f);
            } else if (f instanceof IData[]) {
                this.fields = this.createFields((IData[])f);
            } else {
                LocalizedExceptionInfo lei = new LocalizedExceptionInfo(NSExceptionBundle.class, NSExceptionBundle.UNKNOWN_FIELD_TYPE, null);
                throw new RuntimeException(lei.formatMsgOnly());
            }
            if (schemaType != null) {
                this.schemaTypeName = QName.create(schemaType);
            }
            if (ed != null) {
                this.eventDescription = EventDescription.create(ed);
            }
            this.universalName = (temp = (IData)IDataUtil.get(ic, "svc_universal_name")) != null ? QName.create(temp) : null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ic.destroy();
        this.fieldHash = null;
    }

    private ArrayList createFields(IData[] v) {
        if (v == null) {
            return new ArrayList();
        }
        ArrayList<NSField> nv = new ArrayList<NSField>(v.length);
        for (int i = 0; i < v.length; ++i) {
            NSField fld = NSField.create(this.ns, v[i]);
            if (fld == null) continue;
            fld.setParent(this);
            nv.add(fld);
        }
        return nv;
    }

    private ArrayList createFields(Vector v) {
        if (v == null) {
            return new ArrayList();
        }
        int vSize = v.size();
        ArrayList<NSField> nv = new ArrayList<NSField>(vSize);
        for (int i = 0; i < vSize; ++i) {
            Object o = v.get(i);
            NSField fld = null;
            if (o instanceof IData) {
                fld = NSField.create(this.ns, (IData)o);
            }
            if (fld == null) continue;
            fld.setParent(this);
            nv.add(fld);
        }
        return nv;
    }

    private ArrayList createFields(ArrayList v) {
        if (v == null) {
            return new ArrayList();
        }
        int vSize = v.size();
        ArrayList<NSField> nv = new ArrayList<NSField>(vSize);
        for (int i = 0; i < vSize; ++i) {
            Object o = v.get(i);
            NSField fld = null;
            if (o instanceof IData) {
                fld = NSField.create(this.ns, (IData)o);
            }
            if (fld == null) continue;
            fld.setParent(this);
            nv.add(fld);
        }
        return nv;
    }

    private synchronized void createFieldHash() {
        if (this.fields == null) {
            this.fieldHash = new TreeMap();
            return;
        }
        int fSize = this.fields.size();
        TreeMap<String, NSField> myFieldHash = new TreeMap<String, NSField>();
        for (int i = fSize - 1; i >= 0; --i) {
            NSField fld = (NSField)this.fields.get(i);
            myFieldHash.put(fld.getName(), fld);
        }
        this.fieldHash = myFieldHash;
    }

    @Override
    public String[] getStringOptions() {
        return null;
    }

    public IData[] getValueOptions() {
        if (this.options instanceof IData[]) {
            return (IData[])this.options;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NSField[] getFieldNodes() {
        if (shouldSynchronize) {
            ArrayList arrayList = this.fields;
            synchronized (arrayList) {
                return this.getFields();
            }
        }
        return this.getFields();
    }

    public NSField[] getFields() {
        if (this.fields == null) {
            return null;
        }
        NSField[] fld = new NSField[this.fields.size()];
        this.fields.toArray(fld);
        return fld;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFieldCount() {
        if (shouldSynchronize) {
            ArrayList arrayList = this.fields;
            synchronized (arrayList) {
                return this.getFieldCountUnsychronized();
            }
        }
        return this.getFieldCountUnsychronized();
    }

    private int getFieldCountUnsychronized() {
        if (this.fields == null) {
            return 0;
        }
        return this.fields.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NSField getFieldByName(String name) {
        if (shouldSynchronize) {
            ArrayList arrayList = this.fields;
            synchronized (arrayList) {
                return this.getFieldByNameUnsynchronized(name);
            }
        }
        return this.getFieldByNameHash(name);
    }

    private NSField getFieldByNameUnsynchronized(String name) {
        if (this.fields == null) {
            return null;
        }
        int iSize = this.fields.size();
        for (int i = 0; i < iSize; ++i) {
            NSField nsf = (NSField)this.fields.get(i);
            String nm = nsf.getName();
            if (nm == null || !nm.equals(name)) continue;
            return nsf;
        }
        return null;
    }

    private NSField getFieldByNameHash(String name) {
        if (this.fieldHash == null) {
            this.createFieldHash();
        }
        return (NSField)this.fieldHash.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NSField[] getFieldsByName(String name) {
        ArrayList v;
        if (shouldSynchronize) {
            ArrayList arrayList = this.fields;
            synchronized (arrayList) {
                v = this.getFieldsByNameUnsynchronized(name);
            }
        } else {
            v = this.getFieldsByNameUnsynchronized(name);
        }
        if (v != null && v.size() > 0) {
            NSField[] fld = new NSField[v.size()];
            v.toArray(fld);
            return fld;
        }
        return null;
    }

    private ArrayList getFieldsByNameUnsynchronized(String name) {
        if (this.fields == null || this.fields.size() == 0) {
            return null;
        }
        ArrayList<NSField> v = new ArrayList<NSField>(this.fields.size());
        int iSize = this.fields.size();
        for (int i = 0; i < iSize; ++i) {
            NSField nsf = (NSField)this.fields.get(i);
            String nm = nsf.getName();
            if (nm == null || !nm.equals(name)) continue;
            v.add(nsf);
        }
        return v;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public NSField getSelectedField() {
        return this.currentField;
    }

    public void setValueOptions(IData[] val) {
        this.options = val;
    }

    public NSField addField(String name, int type, int dim) {
        return this.addField(name, type, dim, null);
    }

    public NSField addField(String name, int type, int dim, String nsname) {
        NSField field = this.createField(name, type, dim, nsname);
        return this.addField(field);
    }

    public NSField createField(String name, int type, int dim, String nsname) {
        return NSRecordUtil.createField(name, type, dim, this.getNamespace(), nsname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NSField addField(NSField field) {
        ArrayList arrayList = this.fields;
        synchronized (arrayList) {
            if (field == null) {
                return null;
            }
            field.setParent(this);
            if (this.fields == null) {
                this.fields = new ArrayList();
            }
            this.fields.add(field);
            this.fieldHash = null;
            return field;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NSField insertFieldAt(NSField field, int index) {
        ArrayList arrayList = this.fields;
        synchronized (arrayList) {
            if (field == null) {
                return null;
            }
            field.setParent(this);
            if (this.fields == null) {
                this.fields = new ArrayList();
            }
            this.fields.add(index, field);
            this.fieldHash = null;
            return field;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeField(NSField field) {
        ArrayList arrayList = this.fields;
        synchronized (arrayList) {
            if (this.fields == null) {
                return;
            }
            this.fields.remove(field);
            this.fieldHash = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllFields() {
        ArrayList arrayList = this.fields;
        synchronized (arrayList) {
            if (this.fields == null) {
                return;
            }
            this.fields.clear();
            this.fieldHash = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void orderField(NSField field, int index) {
        ArrayList arrayList = this.fields;
        synchronized (arrayList) {
            if (this.fields == null) {
                return;
            }
            try {
                int idx = this.fields.indexOf(field);
                if (idx < 0) {
                    return;
                }
                int newIdx = idx + index;
                if (newIdx > idx) {
                    this.fields.add(newIdx, field);
                    this.fields.remove(idx);
                } else if (newIdx < idx) {
                    this.fields.add(newIdx, field);
                    this.fields.remove(idx + 1);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void setClosed(boolean isClosed) {
        this.closed = isClosed;
    }

    public void setSelectedField(NSField field) {
        this.currentField = field;
    }

    public static NSField createFromSample(Object value) {
        return NSRecordUtil.createFromSample(null, value, null);
    }

    public static NSField createFromSample(Object o, String name) {
        return NSRecordUtil.createFromSample(null, o, name);
    }

    public static NSField createFromSample(Namespace ns, Object o, String name) {
        return NSRecordUtil.createFromSample(ns, o, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reorderField(NSField field, int index) {
        ArrayList arrayList = this.fields;
        synchronized (arrayList) {
            if (this.fields == null) {
                return;
            }
            try {
                int idx = this.fields.indexOf(field);
                if (idx > -1 && idx != index && index < this.fields.size()) {
                    this.fields.remove(idx);
                    this.fields.add(index, field);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public NSField findFromPath(String path) {
        return NSRecordWmPathProcessor.get(this, path);
    }

    public void mergeRecord(NSRecord record) {
        NSRecordUtil.mergeRecord(record, this);
    }

    public void mergePath(String fieldPath, Namespace ns) {
        NSRecord.mergePath(this, fieldPath, ns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NSField getField(String name, int type, int dim) {
        if (shouldSynchronize) {
            ArrayList arrayList = this.fields;
            synchronized (arrayList) {
                return this.getFieldUnsychronized(name, type, dim);
            }
        }
        return this.getFieldHash(name, type, dim);
    }

    private NSField getFieldUnsychronized(String name, int type, int dim) {
        if (this.fields == null) {
            return null;
        }
        int iSize = this.fields.size();
        for (int i = 0; i < iSize; ++i) {
            NSField field = (NSField)this.fields.get(i);
            String nm = field.getName();
            if (nm == null || !nm.equals(name) || type != field.getType() || dim != field.getDimensions()) continue;
            return field;
        }
        return null;
    }

    private NSField getFieldHash(String name, int type, int dim) {
        if (this.fields == null) {
            return null;
        }
        NSField field = this.getFieldByNameHash(name);
        if (field == null) {
            return null;
        }
        if (type == field.getType() && dim == field.getDimensions()) {
            return field;
        }
        return this.getFieldUnsychronized(name, type, dim);
    }

    public NSField getField(int index) {
        if (this.fields == null || index < 0 || index >= this.fields.size()) {
            return null;
        }
        return (NSField)this.fields.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeField(int index) {
        ArrayList arrayList = this.fields;
        synchronized (arrayList) {
            if (this.fields == null) {
                return;
            }
            if (index < 0 || index >= this.fields.size()) {
                return;
            }
            this.fields.remove(index);
            this.fieldHash = null;
        }
    }

    public static void mergeField(NSRecord record, NSField field) {
        NSRecord.mergeField(record, field, record);
    }

    private static void mergeField(NSRecord record, NSField field, NSRecord possibleRecursiveRecord) {
        NSRecordUtil.mergeField(field, record, possibleRecursiveRecord);
    }

    public static void deletePath(NSRecord record, String path) {
        NSRecordWmPathProcessor.delete(record, path);
    }

    public static void mergePath(NSRecord record, String path, Namespace ns) {
        NSRecordWmPathProcessor.create(record, path);
    }

    public static NSField findFromPath(NSRecord record, String path) {
        return NSRecordWmPathProcessor.get(record, path);
    }

    public NSField findFromPathName(String path) {
        return NSRecordWmPathProcessor.getByPathName(this, path);
    }

    @Override
    public String toString() {
        return "{" + super.toString() + "}" + this.fields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object clone() {
        NSRecord clone = (NSRecord)super.clone();
        if (this.fields != null) {
            if (shouldSynchronize) {
                ArrayList arrayList = this.fields;
                synchronized (arrayList) {
                    clone.fields = (ArrayList)this.fields.clone();
                }
            } else {
                clone.fields = (ArrayList)this.fields.clone();
            }
        }
        if (this.eventDescription != null) {
            clone.eventDescription = (EventDescription)this.eventDescription.clone();
        }
        return clone;
    }

    @Override
    public Object deepClone() {
        return this.deepClone(new HashMap<NSName, NSRecord>(), false);
    }

    public Object deepClone(boolean cloneContentType) {
        return this.deepClone(new HashMap<NSName, NSRecord>(), cloneContentType);
    }

    protected NSRecord deepClone(HashMap<NSName, NSRecord> stack, boolean cloneContentType) {
        int count;
        NSName nsname = this.getNSName();
        if (nsname != null && stack.containsKey(nsname)) {
            return stack.get(this.nsName);
        }
        NSRecord clone = (NSRecord)this.clone();
        if (nsname != null) {
            stack.put(nsname, clone);
        }
        if ((count = this.getFieldCount()) == 0) {
            return clone;
        }
        clone.removeAllFields();
        for (int i = 0; i < count; ++i) {
            NSField field = this.getField(i);
            field = field instanceof NSRecord ? ((NSRecord)field).deepClone(stack, cloneContentType) : (cloneContentType ? (NSField)field.clone() : (NSField)field.fastClone());
            clone.addField(field);
        }
        return clone;
    }

    public NSRecord deepCloneForDeveloper() {
        NSRecord clone = (NSRecord)this.clone();
        int count = this.getFieldCount();
        if (count == 0) {
            return clone;
        }
        clone.removeAllFields();
        for (int i = 0; i < count; ++i) {
            NSField field = this.getField(i);
            field = field instanceof NSRecord ? ((NSRecord)field).deepCloneForDeveloper() : (NSField)field.fastClone();
            clone.addField(field);
        }
        return clone;
    }

    public boolean isIdenticalTo(NSRecord anotherRecord) {
        if (anotherRecord == null) {
            return false;
        }
        return this.getNSName() != null && this.getNSName() == anotherRecord.getNSName();
    }

    @Override
    public void setSchemaTypeName(QName schemaTypeName) {
        this.schemaTypeName = schemaTypeName;
    }

    @Override
    public QName getSchemaTypeName() {
        return this.schemaTypeName;
    }

    public NSField[] findAll(String test, boolean isCase, boolean isWholeWord, boolean includeStart) {
        ArrayList<NSField> nodes = new ArrayList<NSField>();
        NSField found = null;
        found = this.find(test, null, isCase, isWholeWord, includeStart);
        while (found != null) {
            nodes.add(found);
            found = this.find(test, found, isCase, isWholeWord, includeStart);
        }
        if (nodes.size() == 0) {
            return null;
        }
        NSField[] nodeList = new NSField[nodes.size()];
        return nodes.toArray(nodeList);
    }

    public NSField find(String test, NSField start, boolean isCase, boolean isWholeWord, boolean includeStart) {
        NSField fndField;
        if (test == null) {
            return null;
        }
        if (!isCase) {
            test = test.toUpperCase();
        }
        String[] tokens = this.getTokens(test);
        test = tokens[tokens.length - 1];
        if (start == null) {
            start = this;
        }
        if (includeStart && this.test(start.getName(), test, isCase, isWholeWord)) {
            if (tokens.length == 1) {
                return start;
            }
            if (this.checkPath(start, tokens, isCase, isWholeWord)) {
                return start;
            }
        }
        do {
            if ((fndField = this.find(test, start, isCase, isWholeWord)) == null) {
                return null;
            }
            if (tokens.length == 1) {
                return fndField;
            }
            start = fndField;
        } while (!this.checkPath(fndField, tokens, isCase, isWholeWord));
        return fndField;
    }

    boolean checkPath(NSField fndField, String[] tokens, boolean isCase, boolean isWholeWord) {
        for (int i = tokens.length - 2; i >= 0; --i) {
            NSRecord rec = fndField.getParentRecord();
            String testName = rec.getName();
            if (testName == null && rec.getParentRecord() instanceof NSRecordRef) {
                testName = rec.getParentRecord().getName();
            }
            if (!this.test(testName, tokens[i], isCase, isWholeWord)) {
                return false;
            }
            fndField = rec;
        }
        return true;
    }

    String[] getTokens(String str) {
        if (str.equals(SEARCH_DELIMITER)) {
            String[] tokens = new String[]{str};
            return tokens;
        }
        StringTokenizer tknzr = new StringTokenizer(str, SEARCH_DELIMITER);
        String[] tokens = new String[tknzr.countTokens()];
        int i = 0;
        while (tknzr.hasMoreTokens()) {
            tokens[i] = tknzr.nextToken();
            ++i;
        }
        return tokens;
    }

    NSField find(String test, NSField start, boolean isCase, boolean isWholeWord) {
        String compare;
        HashMap recurs = null;
        if (this.isRecursive()) {
            recurs = new HashMap();
        }
        do {
            if ((start = this.getNextField(start, recurs)) != null) continue;
            return null;
        } while (!this.test(compare = start.getName(), test, isCase, isWholeWord));
        return start;
    }

    private NSField getNextField(NSField current, HashMap recurs) {
        NSRecord currentRec;
        NSField next;
        if (current instanceof NSRecordRef && recurs != null) {
            String refName = ((NSRecordRef)current).getTargetName().getFullName();
            if (recurs.containsKey(refName)) {
                return this.getNextRecurs(current, recurs);
            }
            recurs.put(refName, current.getPath());
        }
        if (current instanceof NSRecord && (next = (currentRec = (NSRecord)current).getField(0)) != null) {
            return next;
        }
        return this.getNextRecurs(current, recurs);
    }

    private NSField getNextRecurs(NSField current, HashMap recurs) {
        NSRecord parent = current.getParentRecord();
        if (parent == null) {
            return null;
        }
        if (parent instanceof NSRecordRef) {
            if (recurs != null) {
                String refName = ((NSRecordRef)parent).getTargetName().getFullName();
                recurs.remove(refName);
            }
            return this.getNextRecurs(parent, recurs);
        }
        int count = parent.indexOfField(current) + 1;
        NSField next = parent.getField(count);
        if (next != null) {
            return next;
        }
        return this.getNextRecurs(parent, recurs);
    }

    boolean test(String compare, String test, boolean isCase, boolean isWholeWord) {
        if (compare == null) {
            return false;
        }
        if (!isCase) {
            compare = compare.toUpperCase();
        }
        if (!isWholeWord) {
            return compare.indexOf(test) >= 0;
        }
        return test.equals(compare);
    }

    public int indexOfField(NSField field) {
        return this.fields.indexOf(field);
    }

    public boolean isRecursive() {
        NSRecord parentRef = this.parent;
        this.parent = null;
        HashMap<String, String> hs = new HashMap<String, String>();
        NSName thisName = this.getNSName();
        if (thisName != null) {
            hs.put(thisName.getFullName(), this.getPath());
        }
        NSRecord start = this;
        while (true) {
            NSRecordRef next;
            if ((next = this.getNextRecordRef(start)) == null) {
                this.parent = parentRef;
                return false;
            }
            String path = next.getPath();
            String nextTarget = next.getTargetName().getFullName();
            if (hs.containsKey(nextTarget)) {
                String path1 = (String)hs.get(nextTarget);
                if (path != null && path.startsWith(path1)) {
                    this.parent = parentRef;
                    return true;
                }
            }
            hs.put(nextTarget, path);
            start = next;
        }
    }

    NSRecordRef getNextRecordRef(NSField current) {
        if (current instanceof NSRecord) {
            NSRecord currentRec = (NSRecord)current;
            NSField next = currentRec.getField(0);
            if (next == null) {
                return this.getNextRecordRefRecurs(currentRec);
            }
            if (next instanceof NSRecordRef) {
                return (NSRecordRef)next;
            }
            return this.getNextRecordRef(next);
        }
        if (current == null) {
            return null;
        }
        return this.getNextRecordRefRecurs(current);
    }

    NSRecordRef getNextRecordRefRecurs(NSField current) {
        NSRecord parent = current.getParentRecord();
        if (parent == null) {
            return null;
        }
        if (parent instanceof NSRecordRef) {
            return this.getNextRecordRefRecurs(parent);
        }
        int count = parent.indexOfField(current) + 1;
        NSField next = parent.getField(count);
        while (next != null) {
            if (next instanceof NSRecordRef) {
                return (NSRecordRef)next;
            }
            if (next instanceof NSRecord) {
                return this.getNextRecordRef(next);
            }
            next = parent.getField(++count);
        }
        return this.getNextRecordRefRecurs(parent);
    }

    public boolean isPublishable() {
        return this.eventDescription != null;
    }

    public EventDescription getEventDescription() {
        return this.eventDescription;
    }

    public boolean isClientValidation() {
        return this.eventDescription.isClientValidation();
    }

    public void setExpanded(boolean expand) {
        this.expand = expand;
    }

    public boolean isExpanded() {
        return this.expand;
    }

    @Override
    public boolean register() {
        if (this.isPublishable()) {
            EventTypeRegistry.current().register(this);
        }
        return this.registerUUID();
    }

    public boolean registerUUID() {
        try {
            return UIDRegistry.register(this.getUniversalName(), this.getNSName());
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean unregister() {
        if (this.isPublishable()) {
            EventTypeRegistry.current().unregister(this);
        }
        return this.unregisterUUID();
    }

    public boolean unregisterUUID() {
        NSName other;
        QName uid = this.getUniversalName();
        if (uid != null && (other = UIDRegistry.find(uid)) != null) {
            if (other.equals(this.getNSName())) {
                return UIDRegistry.unregister(uid);
            }
            JournalLogger.logError(4, 81, new Object[]{uid.toString(), other.toString(), this.getNSName().toString()});
            return false;
        }
        return true;
    }

    @Override
    public QName getUniversalName() {
        return this.universalName;
    }

    @Override
    public void setUniversalName(QName qname) {
        this.universalName = qname;
    }

    @Override
    public boolean validateUniversalName() {
        boolean valid = true;
        QName universalName = this.getUniversalName();
        if (universalName != null) {
            if (UIDRegistry.find(universalName) != null) {
                valid = false;
            } else if (universalName.getNamespace() != null) {
                NSName name = NSName.create(universalName.getNamespace(), universalName.getNCName());
                if (this.getNamespace().nodeExists(name)) {
                    valid = false;
                }
            }
        }
        return valid;
    }
}

