/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.ns;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataPortable;
import com.wm.data.IDataUtil;
import com.wm.util.IntEnum;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;
import com.wm.util.sort.Sortable;
import java.text.Collator;

public abstract class NSPackage
implements Sortable,
ValuesCodable,
IDataPortable {
    public static final int PKG_UNKNOWN = -1;
    public static final int PKG_JAVA = 1;
    public static final int PKG_NATIVE = 2;
    static final IntEnum typeEnum = new IntEnum(0);
    String name;
    int pkgType;
    public static final String KEY_PKG_TYPE = "pkg_type";
    public static final String KEY_PKG_NAME = "pkg_name";

    protected NSPackage(String name) {
        this.name = name;
        this.pkgType = 1;
    }

    protected NSPackage(IData values) {
        this.setFromData(values);
    }

    protected NSPackage(Values values) {
        this.setValues(values);
    }

    public String getName() {
        return this.name;
    }

    public int getPackageType() {
        return this.pkgType;
    }

    public String getPackageTypeString() {
        return typeEnum.getString(this.pkgType, "unknown");
    }

    public String toString() {
        return (this.pkgType == 2 ? "PKG(native):" : "PKG:") + this.name;
    }

    public void setPackageType(int pkgType) {
        this.pkgType = pkgType;
    }

    public void setPackageType(String pType) {
        this.pkgType = typeEnum.getInt(pType, -1);
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{KEY_PKG_NAME, this.name}, {KEY_PKG_TYPE, this.getPackageTypeString()}};
        return new Values(o);
    }

    public void setValues(Values values) {
        this.name = values.getString(KEY_PKG_NAME);
        this.setPackageType(typeEnum.getInt(values.getString(KEY_PKG_TYPE), -1));
    }

    public IData getAsData() {
        Object[][] o = new Object[][]{{KEY_PKG_NAME, this.name}, {KEY_PKG_TYPE, this.getPackageTypeString()}};
        return IDataFactory.create(o);
    }

    public void setFromData(IData values) {
        IDataCursor ic = values.getCursor();
        this.name = IDataUtil.getString(ic, KEY_PKG_NAME);
        this.setPackageType(typeEnum.getInt(IDataUtil.getString(ic, KEY_PKG_TYPE), -1));
        ic.destroy();
    }

    public int compare(Sortable cmp, boolean reverse, int sort_by) {
        if (cmp instanceof NSPackage) {
            NSPackage pkg = (NSPackage)cmp;
            int result = 0;
            Collator col = Collator.getInstance();
            col.setStrength(2);
            result = col.compare(this.name, pkg.getName());
            if (reverse) {
                result = 0 - result;
            }
            return result;
        }
        return 0;
    }

    static {
        typeEnum.addInt("java", 1);
        typeEnum.addInt("native", 2);
    }
}

