/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.ns;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataPortable;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSContentType;
import com.wm.lang.ns.NSDatatype;
import com.wm.lang.ns.NSInterface;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSPackage;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSReference;
import com.wm.lang.ns.NSSchema;
import com.wm.lang.ns.NSService;
import com.wm.lang.ns.NSTrigger;
import com.wm.lang.ns.NSType;
import com.wm.lang.ns.Namespace;
import com.wm.util.IntEnum;
import com.wm.util.Reportable;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;
import com.wm.util.sort.Sortable;
import java.text.Collator;

public abstract class NSNode
implements Sortable,
ValuesCodable,
Cloneable,
Reportable,
IDataPortable {
    public static final NSType NODE_UNKNOWN_TYPE = NSType.create("unknown");
    Namespace ns;
    NSPackage pkg;
    NSName nsName;
    String comment;
    Values hints;
    NSType nodeType = NODE_UNKNOWN_TYPE;
    public static final String KEY_OWNER = "OWNER";
    public static final String KEY_HOST = "HOST";
    public static final String KEY_LOCK_TIME = "LOCK_TIME";
    public static final String KEY_SYSTEM_USER = "WM_NS_SYSTEM_USER";
    public static final String KEY_LOCK_STATUS = "LOCK_STATUS";
    public static final int LOCKED = 1;
    public static final int UNLOCKED = 2;
    public static final int LOCKED_USER_LOCKED = 3;
    public static final int LOCKED_OTHER_LOCKED = 4;
    public static final int LOCKED_SYSTEM_LOCKED = 5;
    public static final String KEY_NSN_TYPE = "node_type";
    public static final String KEY_NSN_PACKAGE = "node_pkg";
    public static final String KEY_NSN_NSNAME = "node_nsName";
    public static final String KEY_NSN_COMMENT = "node_comment";
    public static final String KEY_NSN_HINTS = "node_hints";
    public static final String KEY_NSS_UNIVERSAL_NAME = "svc_universal_name";
    public int gLockState = 2;
    public static final int NODE_UNKNOWN = -1;
    public static final int NODE_INTERFACE = 1;
    public static final int NODE_SERVICE = 2;
    public static final int NODE_RECORD = 4;
    public static final int NODE_CONTENTTYPE = 8;
    public static final int NODE_DATATYPE = 16;
    public static final int NODE_SCHEMA = 32;
    public static final int NODE_WS = 64;
    public static final int NODE_PLUGIN = 128;
    public static final int NODE_ALL = 255;
    static final IntEnum ienumvar = new IntEnum(1);
    static final String IFC_SORT_NAME = "a";
    static final String SVC_SORT_NAME = "b";
    static final String TRIGGER_SORT_NAME = "c";
    static final String DOC_TYPE_SORT_NAME = "d";
    static final String SCHEMA_SORT_NAME = "e";
    static final String PLUGIN_SORT_NAME = "y";
    static final String DEFAULT_SORT_NAME = "z";

    protected NSNode(Namespace ns, NSPackage pkg, NSName nsName, NSType nodeType) {
        this.ns = ns;
        this.pkg = pkg;
        this.nsName = nsName;
        this.nodeType = nodeType;
    }

    protected NSNode(Namespace ns, IData values) {
        this.ns = ns;
        this.setFromData(values);
    }

    protected NSNode(Namespace ns, Values values) {
        this.ns = ns;
        this.setValues(values);
    }

    public NSPackage getPackage() {
        return this.pkg;
    }

    public NSName getNSName() {
        return this.nsName;
    }

    public String getComment() {
        return this.comment;
    }

    public NSType getNodeTypeObj() {
        return this.nodeType;
    }

    public Namespace getNamespace() {
        return this.ns;
    }

    public Values getHints() {
        return this.hints;
    }

    public void setNamespace(Namespace ns) {
        this.ns = ns;
    }

    public void setPackage(NSPackage pkg) {
        this.pkg = pkg;
    }

    public void setNSName(NSName name) {
        this.nsName = name;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setHints(Values hints) {
        this.hints = hints;
    }

    public void setHints(IData hints) {
        this.hints = Values.use(hints);
    }

    private void setNodeType(NSType nodeType) {
        this.nodeType = nodeType;
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{KEY_NSN_TYPE, this.nodeType != null ? this.nodeType.getValue() : "unknown"}, {KEY_NSN_NSNAME, this.nsName != null ? this.nsName.toString() : null}, {KEY_NSN_PACKAGE, this.pkg != null ? this.pkg.getName() : null}, {KEY_NSN_COMMENT, this.comment}, {KEY_NSN_HINTS, this.hints}};
        return new Values(o);
    }

    public void setValues(Values values) {
        if (values == null) {
            return;
        }
        this.setNodeType(NSType.create(values.getString(KEY_NSN_TYPE)));
        this.nsName = NSName.create(values.getString(KEY_NSN_NSNAME));
        if (this.ns != null) {
            this.setPackage(this.ns.getPackage(values.getString(KEY_NSN_PACKAGE)));
        }
        this.setComment(values.getString(KEY_NSN_COMMENT));
        this.setHints(values.getValues(KEY_NSN_HINTS));
    }

    public IData getAsData() {
        Object[][] o = new Object[][]{{KEY_NSN_TYPE, this.nodeType != null ? this.nodeType.getValue() : "unknown"}, {KEY_NSN_NSNAME, this.nsName != null ? this.nsName.toString() : null}, {KEY_NSN_PACKAGE, this.pkg != null ? this.pkg.getName() : null}, {KEY_NSN_COMMENT, this.comment}, {KEY_NSN_HINTS, this.hints}};
        return IDataFactory.create(o);
    }

    public void setFromData(IData values) {
        if (values == null) {
            return;
        }
        IDataCursor ic = values.getCursor();
        this.setNodeType(NSType.create(IDataUtil.getString(ic, KEY_NSN_TYPE)));
        this.nsName = NSName.create(IDataUtil.getString(ic, KEY_NSN_NSNAME));
        if (this.ns != null) {
            this.setPackage(this.ns.getPackage(IDataUtil.getString(ic, KEY_NSN_PACKAGE)));
        }
        this.setComment(IDataUtil.getString(ic, KEY_NSN_COMMENT));
        this.setHints((IData)IDataUtil.get(ic, KEY_NSN_HINTS));
        ic.destroy();
    }

    public int getLockState() {
        return this.gLockState;
    }

    public int compare(Sortable cmp, boolean reverse, int sort_by) {
        if (cmp instanceof NSNode) {
            NSNode node = (NSNode)cmp;
            int result = 0;
            String ctype = node.getNodeTypeSortName();
            String ntype = this.getNodeTypeSortName();
            result = ntype.compareTo(ctype);
            if (result == 0) {
                Collator col = Collator.getInstance();
                col.setStrength(2);
                result = col.compare(this.getNSName().getNodeName().toString(), node.getNSName().getNodeName().toString());
            }
            if (reverse) {
                result = 0 - result;
            }
            return result;
        }
        return 0;
    }

    public Object clone() {
        try {
            NSNode newNode = (NSNode)super.clone();
            return newNode;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public Object deepClone() {
        NSNode newNode = (NSNode)this.clone();
        if (newNode.hints != null) {
            newNode.hints = (Values)newNode.hints.clone();
        }
        newNode.setPackage(this.pkg);
        newNode.setComment(this.comment);
        newNode.setNodeType(this.nodeType);
        newNode.setNSName(this.nsName);
        newNode.setNamespace(this.ns);
        return newNode;
    }

    public Values getReportable() {
        return this.getValues();
    }

    public boolean register() {
        return true;
    }

    public boolean unregister() {
        return true;
    }

    public NSReference[] getDependencies() {
        return NSReference.REFERENCE_NONE;
    }

    public boolean nodeChanged(NSName oldNode, NSName newNode) {
        return false;
    }

    public int getNodeType() {
        if (this.nodeType == null || this.nodeType.equals(NODE_UNKNOWN_TYPE)) {
            return -1;
        }
        if (this.nodeType.equals(NSInterface.TYPE)) {
            return 1;
        }
        if (this.nodeType.equals(NSService.TYPE)) {
            return 2;
        }
        if (this.nodeType.equals(NSRecord.TYPE)) {
            return 4;
        }
        if (this.nodeType.equals(NSContentType.TYPE)) {
            return 8;
        }
        if (this.nodeType.equals(NSDatatype.TYPE)) {
            return 16;
        }
        if (this.nodeType.equals(NSSchema.TYPE)) {
            return 32;
        }
        return 128;
    }

    public String getNodeSType() {
        return ienumvar.getString(this.getNodeType(), "unknown");
    }

    public static String getNodeSType(int nodeType) {
        return ienumvar.getString(nodeType, "unknown");
    }

    public static int getNodeType(String type) {
        return ienumvar.getInt(type, -1);
    }

    public static NSType intToNSType(int nodeType) {
        switch (nodeType) {
            case -1: {
                return NODE_UNKNOWN_TYPE;
            }
            case 1: {
                return NSInterface.TYPE;
            }
            case 2: {
                return NSService.TYPE;
            }
            case 4: {
                return NSRecord.TYPE;
            }
            case 8: {
                return NSContentType.TYPE;
            }
            case 16: {
                return NSDatatype.TYPE;
            }
            case 32: {
                return NSSchema.TYPE;
            }
        }
        return NODE_UNKNOWN_TYPE;
    }

    private String getNodeTypeSortName() {
        if (this.nodeType == null || this.nodeType.equals(NODE_UNKNOWN_TYPE)) {
            return DEFAULT_SORT_NAME;
        }
        if (this.nodeType.equals(NSInterface.TYPE)) {
            return IFC_SORT_NAME;
        }
        if (this.nodeType.equals(NSService.TYPE)) {
            return SVC_SORT_NAME;
        }
        if (this.nodeType.equals(NSRecord.TYPE)) {
            return DOC_TYPE_SORT_NAME;
        }
        if (this.nodeType.equals(NSTrigger.TYPE)) {
            return TRIGGER_SORT_NAME;
        }
        if (this.nodeType.equals(NSSchema.TYPE)) {
            return SCHEMA_SORT_NAME;
        }
        return PLUGIN_SORT_NAME;
    }

    static {
        ienumvar.addInt("interface", 1);
        ienumvar.addInt("service", 2);
        ienumvar.addInt("record", 4);
        ienumvar.addInt("contenttype", 8);
        ienumvar.addInt("datatype", 16);
        ienumvar.addInt("schema", 32);
        ienumvar.addInt("webservice", 64);
        ienumvar.addInt("plugin", 128);
    }
}

