/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.ns;

import com.wm.lang.ns.resources.ValidationBundle;
import com.wm.util.Config;
import com.wm.util.Name;
import com.wm.util.Strings;
import com.wm.util.coder.StringCodable;
import java.io.File;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;

public final class NSName
implements StringCodable {
    public static String EMPTY_WORD_MSG = ValidationBundle.EMPTY_WORD_MSG;
    public static String EMPTY_WORD_INTERFACE_MSG = ValidationBundle.EMPTY_WORD_INTERFACE_MSG;
    public static String EMPTY_WORD_NODE_MSG = ValidationBundle.EMPTY_WORD_NODE_MSG;
    public static String EXTRA_WORDS_MSG = ValidationBundle.EXTRA_WORDS_MSG;
    public static String NO_INTERFACE_MSG = ValidationBundle.NO_INTERFACE_MSG;
    public static String LEADING_DIGIT_MSG = ValidationBundle.LEADING_DIGIT_MSG;
    public static String ILLEGAL_CHAR_MSG = ValidationBundle.ILLEGAL_CHAR_MSG;
    public static String RESERVED_WORD_MSG = ValidationBundle.RESERVED_WORD_MSG;
    public static String UNEXPECTED_TOKEN_MSG = ValidationBundle.UNEXPECTED_TOKEN_MSG;
    public static String AT_INDEX_MSG = ValidationBundle.AT_INDEX_MSG;
    public static String ILLEGAL_CHAR_MSG_NDX = ValidationBundle.ILLEGAL_CHAR_MSG_NDX;
    public static final char[] ILLEGAL_CHARS = Config.getProperty("- #&@^!%*:$./\\`;,~+=)(|}{][><\"", "watt.server.illegalNSChars").toCharArray();
    public static final HashSet RESERVED_WORDS = NSName.initReservedWords();
    public static final String INTERFACE_SEP = ".";
    public static final String NODE_SEP = ":";
    public static final String SEPS = ".:";
    static final ConcurrentHashMap<String, NSName> names = new ConcurrentHashMap(503);
    String fullName;
    Name ifcName;
    Name[] ifcPath;
    Name node;
    boolean isInterface;

    private static HashSet initReservedWords() {
        Object[] o = new Object[]{"abstract", "assert", "boolean", "break", "byte", "byvalue", "case", "cast", "default", "do", "double", "else", "extends", "false", "final", "goto", "if", "implements", "import", "inner", "instanceof", "int", "operator", "outer", "package", "private", "protected", "public", "rest", "synchronized", "this", "throw", "throws", "transient", "true", "try", "catch", "char", "class", "const", "continue", "finally", "float", "for", "future", "generic", "interface", "long", "native", "new", "null", "return", "short", "static", "super", "switch", "var", "void", "volatile", "while", "clone", "equals", "finalize", "getClass", "hashCode", "notify", "notifyAll", "toString", "wait", "auto", "enum", "extern", "register", "signed", "sizeof", "static", "struct", "typedef", "union", "unsigned", "asm", "delete", "friend", "inline", "template", "virtual"};
        int l = o.length;
        HashSet<Object> h = new HashSet<Object>(l, 1.0f);
        for (int i = 0; i < l; ++i) {
            h.add(o[i]);
        }
        return h;
    }

    public static String validateWord(String word) {
        return NSName.validateWord(word, Locale.getDefault());
    }

    public static String validateWord(String word, Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (word == null || word.length() < 1) {
            return NSName.getValidationMessage(EMPTY_WORD_MSG, locale);
        }
        char c = word.charAt(0);
        if (Character.isDigit(c)) {
            Object[] args = new Object[]{new Character(c)};
            return NSName.getValidationMessage(LEADING_DIGIT_MSG, locale, args);
        }
        for (int i = 0; i < ILLEGAL_CHARS.length; ++i) {
            if (word.indexOf(ILLEGAL_CHARS[i]) < 0) continue;
            Object[] args = new Object[]{new Character(ILLEGAL_CHARS[i])};
            return NSName.getValidationMessage(ILLEGAL_CHAR_MSG, locale, args);
        }
        int len = word.length();
        for (int i = 0; i < len; ++i) {
            char ch = word.charAt(i);
            if (ch <= '\u00ff') continue;
            Object[] args = new Object[]{new Character(ch), new Integer(i)};
            return NSName.getValidationMessage(ILLEGAL_CHAR_MSG_NDX, locale, args);
        }
        if (RESERVED_WORDS.contains(word)) {
            Object[] args = new Object[]{word};
            return NSName.getValidationMessage(RESERVED_WORD_MSG, locale, args);
        }
        return null;
    }

    public static String validateName(String name) {
        return NSName.validateName(name, Locale.getDefault());
    }

    public static String validateName(String name, Locale locale) {
        String first;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (name == null || name.length() < 1) {
            return NSName.getValidationMessage(EMPTY_WORD_MSG, locale);
        }
        StringTokenizer st = new StringTokenizer(name, SEPS, true);
        String err = null;
        err = !st.hasMoreTokens() ? NSName.getValidationMessage(EMPTY_WORD_MSG, locale) : ((first = st.nextToken()).equals(NODE_SEP) || first.equals(INTERFACE_SEP) ? NSName.getValidationMessage(NO_INTERFACE_MSG, locale) : NSName.validateWord(first, locale));
        if (err != null) {
            return err;
        }
        boolean expectSvc = false;
        while (st.hasMoreTokens()) {
            String dot = st.nextToken();
            if (dot.equals(NODE_SEP)) {
                expectSvc = true;
                break;
            }
            if (dot.equals(INTERFACE_SEP)) {
                if (!st.hasMoreTokens()) {
                    err = NSName.getValidationMessage(EMPTY_WORD_INTERFACE_MSG, locale);
                    break;
                }
                String ifc = st.nextToken();
                err = NSName.validateWord(ifc, locale);
                if (err == null) continue;
                break;
            }
            Object[] args = new Object[]{dot};
            err = NSName.getValidationMessage(UNEXPECTED_TOKEN_MSG, locale, args);
        }
        if (err != null) {
            return err;
        }
        if (expectSvc) {
            if (!st.hasMoreTokens()) {
                err = NSName.getValidationMessage(EMPTY_WORD_NODE_MSG, locale);
            } else {
                String svc = st.nextToken();
                err = NSName.validateWord(svc, locale);
            }
        }
        if (st.hasMoreTokens()) {
            Object[] args = new Object[]{st.nextToken()};
            err = NSName.getValidationMessage(EXTRA_WORDS_MSG, locale, args);
        }
        return err;
    }

    public static NSName create(String name) {
        NSName alreadyCached;
        if (name == null || name.length() == 0) {
            return null;
        }
        NSName n = names.get(name);
        if (n == null && (alreadyCached = names.putIfAbsent(name, n = new NSName(name))) != null) {
            n = alreadyCached;
        }
        return n;
    }

    public static NSName create(String ifc, String node) {
        return NSName.create(Strings.cat(ifc, NODE_SEP, node));
    }

    private NSName(Name ifcName, Name[] ifcPath) {
        this.fullName = ifcName.toString();
        this.ifcPath = ifcPath;
        this.node = ifcPath[ifcPath.length - 1];
    }

    private NSName(String name) {
        this.setValue(name);
    }

    public String getValue() {
        return this.toString();
    }

    public void setValue(String name) {
        this.fullName = name;
        StringTokenizer is = new StringTokenizer(name, NODE_SEP);
        if (is.hasMoreTokens()) {
            this.ifcName = Name.create(is.nextToken());
            StringTokenizer ifc = new StringTokenizer(this.ifcName.toString(), INTERFACE_SEP);
            this.ifcPath = new Name[ifc.countTokens()];
            for (int i = 0; i < this.ifcPath.length; ++i) {
                this.ifcPath[i] = Name.create(ifc.nextToken());
            }
            if (is.hasMoreTokens()) {
                this.node = Name.create(is.nextToken());
                this.isInterface = false;
            } else if (this.ifcPath.length > 0) {
                this.node = this.ifcPath[this.ifcPath.length - 1];
                this.isInterface = true;
            }
        }
    }

    public static char[] getIllegalChars() {
        return ILLEGAL_CHARS;
    }

    public Name[] getInterfacePath() {
        return this.ifcPath;
    }

    public Name getInterfaceName() {
        return this.ifcName;
    }

    public NSName getInterfaceNSName() {
        return NSName.create(this.ifcName.toString());
    }

    public NSName getParent() {
        String ifcStr = this.ifcName.toString();
        int lastDot = ifcStr.lastIndexOf(INTERFACE_SEP);
        if (lastDot >= 0) {
            return NSName.create(ifcStr.substring(0, lastDot));
        }
        return null;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public Name getNodeName() {
        return this.node;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String toString() {
        return this.getFullName();
    }

    public File getNodeDir(File nsRoot) {
        nsRoot = this.getInterfaceDir(nsRoot);
        if (!this.isInterface) {
            nsRoot = new File(nsRoot, this.getNodeName().toString());
        }
        return nsRoot;
    }

    public File getInterfaceDir(File nsRoot) {
        Name[] path = this.getInterfacePath();
        for (int i = 0; i < path.length; ++i) {
            nsRoot = new File(nsRoot, path[i].toString());
        }
        return nsRoot;
    }

    protected static String getValidationMessage(String key, Locale locale) {
        return NSName.getValidationMessage(key, locale, null);
    }

    protected static String getValidationMessage(String key, Locale locale, Object[] args) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            ResourceBundle rb = ResourceBundle.getBundle("com.wm.lang.ns.resources.ValidationBundle", locale);
            if (rb == null) {
                return new String();
            }
            String msg = rb.getString(key);
            return MessageFormat.format(msg, args);
        }
        catch (MissingResourceException mre) {
            return new String();
        }
    }
}

