/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.ns;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSReference;
import com.wm.lang.ns.NSTrigger;
import com.wm.lang.ns.NSTriggerType;
import com.wm.lang.ns.NSType;
import com.wm.lang.ns.Namespace;
import com.wm.msg.JMSDestinationFilterPair;
import com.wm.msg.JMSRoutingRule;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NSJMSTrigger
extends NSTrigger {
    public static final String TYPE_KEY = "webMethods/trigger";
    public static NSType TYPE = new NSType("webMethods/trigger");
    public static final int DEST_TYPE_QUEUE = 0;
    public static final int DEST_TYPE_XAQUEUE = 1;
    public static final int DEST_TYPE_TOPIC = 2;
    public static final int DEST_TYPE_XATOPIC = 3;
    public static final int PROVIDER_TYPE_WEBMETHODS = 0;
    public static final int PROVIDER_TYPE_OTHER = 1;
    public static final int PROVIDER_TYPE_UNKNOWN = 1;
    public static final int AND = 1;
    public static final int XOR = 2;
    public static final int OR = 3;
    public static final int DUPS_OK_ACKNOWLEDGE = 3;
    public static final int AUTO_ACKNOWLEDGE = 1;
    public static final int CLIENT_ACKNOWLEDGE = 2;
    public static final int COMMIT = 0;
    public static final int ROLLBACK = 1;
    public static final String KEY_ALIAS_NAME = "aliasName";
    public static final String KEY_ENABLED = "enabled";
    public static final String KEY_PREFETCH_SIZE = "prefetchSize";
    public static final String KEY_INACTIVE_WAIT_TIME = "inactiveWaitTime";
    public static final String KEY_BATCH_SIZE = "batchSize";
    public static final String KEY_ACKNOWLEDGE_MODE = "acknowledgeMode";
    public static final String KEY_INCLUDE_ORIG_MSG = "includeOriginalMessage";
    public static final String KEY_ROUTING_RULES = "routingRules";
    public static final String KEY_DESTINATIONS = "destinations";
    public static final String KEY_JOIN_TYPE = "joinType";
    public static final String KEY_EXECUTE_USER = "executeUser";
    public static final int DEFAULT_TOTAL_SESSIONS = 10;
    public static final int DEFAULT_PREFETCH_SIZE = -1;
    public static final int DEFAULT_INACTIVE_WAIT_TIME = 1500;
    public static final int DEFAULT_BATCH_SIZE = 1;
    public static final int DEFAULT_DESTINATION_TYPE = -1;
    public static final int DEFAULT_ACKNOWLEDGE_MODE = 2;
    public static final int DEFAULT_JOIN_TYPE = 3;
    public static final boolean DEFAULT_INCLUDE_ORIG_MSG = false;
    public static final String DEFAULT_USER = "Administrator";
    protected String aliasName;
    protected String providerName;
    protected String providerVersion;
    protected String connectionType;
    protected String executeUser;
    protected int joinType;
    protected int jmsProviderType;
    protected int prefetchSize;
    protected int inactiveWaitTime;
    protected int batchSize;
    protected int acknowledgeMode;
    protected boolean suspendOnError;
    protected boolean enabled;
    protected boolean includeOriginalMessage;
    protected ArrayList<JMSRoutingRule> routingRules;
    protected ArrayList<JMSDestinationFilterPair> destinationFilterPairs;

    protected NSJMSTrigger() {
        this(null, null, NSTriggerType.create("jms-trigger"));
    }

    protected NSJMSTrigger(Namespace ns, IData data) {
        this(ns, data, NSTriggerType.create("jms-trigger"));
    }

    protected NSJMSTrigger(Namespace ns, IData data, NSTriggerType type) {
        super(ns, data, type);
    }

    @Override
    protected void init() {
        this.routingRules = new ArrayList();
        this.destinationFilterPairs = new ArrayList();
        this.redeliveryDelay = 10000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reset() {
        ArrayList<Object> arrayList = this.routingRules;
        synchronized (arrayList) {
            this.routingRules.clear();
        }
        arrayList = this.destinationFilterPairs;
        synchronized (arrayList) {
            this.destinationFilterPairs.clear();
        }
    }

    public int getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public void setAcknowledgeMode(int acknowledgeMode) {
        this.acknowledgeMode = acknowledgeMode;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public void setAliasName(String aliasName) {
        this.aliasName = aliasName;
    }

    public int getJoinType() {
        return this.joinType;
    }

    public void setJoinType(int joinType) {
        this.joinType = joinType;
    }

    public String getExecuteUser() {
        return this.executeUser;
    }

    public void setExecuteUser(String executeUser) {
        this.executeUser = executeUser;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getInactiveWaitTime() {
        return this.inactiveWaitTime;
    }

    public void setInactiveWaitTime(int inactiveWaitTime) {
        this.inactiveWaitTime = inactiveWaitTime;
    }

    public int getPrefetchSize() {
        return this.prefetchSize;
    }

    public void setPrefetchSize(int prefetchSize) {
        this.prefetchSize = prefetchSize;
    }

    public boolean shouldIncludeOriginalMessage() {
        return this.includeOriginalMessage;
    }

    public void setIncludeOriginalMessage(boolean includeOriginalMessage) {
        this.includeOriginalMessage = includeOriginalMessage;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public int getJmsProviderType() {
        return this.jmsProviderType;
    }

    public void setJmsProviderType(int jmsProviderType) {
        this.jmsProviderType = jmsProviderType;
    }

    public String getProviderVersion() {
        return this.providerVersion;
    }

    public void setProviderVersion(String providerVersion) {
        this.providerVersion = providerVersion;
    }

    public String getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(String connectionType) {
        this.connectionType = connectionType;
    }

    public boolean isSuspendOnError() {
        return this.suspendOnError;
    }

    public void setSuspendOnError(boolean suspendOnError) {
        this.suspendOnError = suspendOnError;
    }

    @Override
    public NSReference[] getDependencies() {
        ArrayList<NSName> services = this.getRoutingRuleServices();
        if (this.resolverSvcName != null) {
            services.add(this.resolverSvcName);
        }
        if (this.resourceMonitoringSvcName != null) {
            services.add(this.resourceMonitoringSvcName);
        }
        NSReference[] dependencies = new NSReference[services.size()];
        if (!services.isEmpty()) {
            for (int i = 0; i < services.size(); ++i) {
                dependencies[i] = new NSReference(services.get(i), null);
            }
            return dependencies;
        }
        return NSReference.REFERENCE_NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean nodeChanged(NSName oldName, NSName newName) {
        ArrayList<JMSRoutingRule> arrayList = this.routingRules;
        synchronized (arrayList) {
            for (int i = 0; i < this.routingRules.size(); ++i) {
                JMSRoutingRule rule = this.routingRules.get(i);
                if (oldName != rule.getServiceName()) continue;
                rule.setServiceName(newName);
            }
        }
        if (oldName == this.resolverSvcName) {
            this.resolverSvcName = newName;
        }
        if (oldName == this.resourceMonitoringSvcName) {
            this.resourceMonitoringSvcName = newName;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<JMSDestinationFilterPair> getDestinationFilterPairs() {
        if (this.destinationFilterPairs == null || this.destinationFilterPairs.size() < 1) {
            return null;
        }
        ArrayList<JMSDestinationFilterPair> list = new ArrayList<JMSDestinationFilterPair>();
        ArrayList<JMSDestinationFilterPair> arrayList = this.destinationFilterPairs;
        synchronized (arrayList) {
            for (int i = 0; i < this.destinationFilterPairs.size(); ++i) {
                list.add(this.destinationFilterPairs.get(i).deepClone());
            }
            return list;
        }
    }

    public int getDestinationFilterPairsCount() {
        if (this.destinationFilterPairs == null) {
            return 0;
        }
        return this.destinationFilterPairs.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDestinationFilterPairs(ArrayList<JMSDestinationFilterPair> pairs) {
        ArrayList<JMSDestinationFilterPair> arrayList = this.destinationFilterPairs;
        synchronized (arrayList) {
            this.destinationFilterPairs = pairs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<JMSRoutingRule> getRoutingRules() {
        if (this.routingRules == null || this.routingRules.size() < 1) {
            return null;
        }
        ArrayList<JMSRoutingRule> list = new ArrayList<JMSRoutingRule>();
        ArrayList<JMSRoutingRule> arrayList = this.routingRules;
        synchronized (arrayList) {
            for (int i = 0; i < this.routingRules.size(); ++i) {
                list.add(this.routingRules.get(i).deepClone());
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRoutingRules(ArrayList<JMSRoutingRule> rules) {
        ArrayList<JMSRoutingRule> arrayList = this.routingRules;
        synchronized (arrayList) {
            this.routingRules = rules;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<NSName> getRoutingRuleServices() {
        ArrayList<NSName> list = new ArrayList<NSName>();
        ArrayList<JMSRoutingRule> arrayList = this.routingRules;
        synchronized (arrayList) {
            for (int i = 0; i < this.routingRules.size(); ++i) {
                list.add(this.routingRules.get(i).getServiceName());
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IData getAsData() {
        int i;
        IData data = super.getAsData();
        IDataCursor dc = data.getCursor();
        if (!dc.first("trigger")) {
            return null;
        }
        IData localInfo = (IData)dc.getValue();
        dc.destroy();
        dc = localInfo.getCursor();
        dc.insertAfter(KEY_ALIAS_NAME, this.aliasName);
        dc.insertAfter(KEY_ENABLED, this.enabled);
        dc.insertAfter(KEY_PREFETCH_SIZE, String.valueOf(this.prefetchSize));
        dc.insertAfter(KEY_INACTIVE_WAIT_TIME, String.valueOf(this.inactiveWaitTime));
        dc.insertAfter(KEY_BATCH_SIZE, String.valueOf(this.batchSize));
        if (this.acknowledgeMode == 0) {
            this.acknowledgeMode = 3;
        }
        dc.insertAfter(KEY_ACKNOWLEDGE_MODE, String.valueOf(this.acknowledgeMode));
        dc.insertAfter(KEY_INCLUDE_ORIG_MSG, String.valueOf(this.includeOriginalMessage));
        dc.insertAfter(KEY_JOIN_TYPE, String.valueOf(this.joinType));
        dc.insertAfter(KEY_EXECUTE_USER, this.executeUser);
        ArrayList<Object> arrayList = this.routingRules;
        synchronized (arrayList) {
            IData[] ruleDataAry = new IData[this.routingRules.size()];
            for (i = 0; i < this.routingRules.size(); ++i) {
                JMSRoutingRule rule = this.routingRules.get(i);
                ruleDataAry[i] = rule.getAsData();
            }
            dc.insertAfter(KEY_ROUTING_RULES, ruleDataAry);
        }
        arrayList = this.destinationFilterPairs;
        synchronized (arrayList) {
            IData[] destDataAry = new IData[this.destinationFilterPairs.size()];
            for (i = 0; i < this.destinationFilterPairs.size(); ++i) {
                JMSDestinationFilterPair dest = this.destinationFilterPairs.get(i);
                destDataAry[i] = dest.getAsData();
            }
            dc.insertAfter(KEY_DESTINATIONS, destDataAry);
        }
        dc.destroy();
        return data;
    }

    @Override
    public void setFromData(IData data) {
        IData[] destData;
        IData[] ruleData;
        this.init();
        this.reset();
        if (data == null) {
            return;
        }
        super.setFromData(data);
        IDataCursor dc = data.getCursor();
        if (!dc.first("trigger")) {
            return;
        }
        IData localInfo = (IData)dc.getValue();
        dc.destroy();
        dc = localInfo.getCursor();
        this.aliasName = IDataUtil.getString(dc, KEY_ALIAS_NAME);
        this.enabled = IDataUtil.getBoolean(dc, KEY_ENABLED, true);
        this.prefetchSize = IDataUtil.getInt(dc, KEY_PREFETCH_SIZE, -1);
        this.inactiveWaitTime = IDataUtil.getInt(dc, KEY_INACTIVE_WAIT_TIME, 1500);
        this.batchSize = IDataUtil.getInt(dc, KEY_BATCH_SIZE, 1);
        this.includeOriginalMessage = IDataUtil.getBoolean(dc, KEY_INCLUDE_ORIG_MSG, false);
        this.joinType = IDataUtil.getInt(dc, KEY_JOIN_TYPE, 3);
        this.executeUser = IDataUtil.getString(dc, KEY_EXECUTE_USER);
        if (this.executeUser == null) {
            this.executeUser = DEFAULT_USER;
        }
        this.acknowledgeMode = IDataUtil.getInt(dc, KEY_ACKNOWLEDGE_MODE, 2);
        if (this.acknowledgeMode == 0) {
            this.acknowledgeMode = 3;
        }
        if ((ruleData = IDataUtil.getIDataArray(dc, KEY_ROUTING_RULES)) != null) {
            for (int i = 0; i < ruleData.length; ++i) {
                this.routingRules.add(new JMSRoutingRule(ruleData[i]));
            }
        }
        if ((destData = IDataUtil.getIDataArray(dc, KEY_DESTINATIONS)) != null) {
            for (int i = 0; i < destData.length; ++i) {
                this.destinationFilterPairs.add(new JMSDestinationFilterPair(destData[i]));
            }
        }
    }
}

