/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.ns;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataPortable;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSNode;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSRecordRef;
import com.wm.lang.ns.NSType;
import com.wm.lang.ns.Namespace;
import com.wm.lang.ns.WmPathInfo;
import com.wm.lang.ns.WmPathItem;
import com.wm.lang.schema.ContentType;
import com.wm.lang.schema.ContentTypeFactory;
import com.wm.lang.schema.TypeDef;
import com.wm.util.IntEnum;
import com.wm.util.JavaWrapperType;
import com.wm.util.Name;
import com.wm.util.QName;
import com.wm.util.Strings;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;

public class NSField
extends NSNode
implements ValuesCodable,
IDataPortable {
    private static final boolean debug = false;
    public static final int FIELD_STRING = 1;
    public static final int FIELD_RECORD = 2;
    public static final int FIELD_OBJECT = 3;
    public static final int FIELD_RECORDREF = 4;
    static final IntEnum fieldEnum = new IntEnum(0);
    public static final int DIM_SCALAR = 0;
    public static final int DIM_ARRAY = 1;
    public static final int DIM_TABLE = 2;
    public static final String SEPARATOR_PATH = "/";
    public static final String SEPARATOR_TYPE = ";";
    private static final String SEPARATOR_LBRACKET = "[";
    private static final String SEPARATOR_RBRACKET = "]";
    private static final String FIELDNAME_ENCODECHAR = "\"";
    static final IntEnum wrapperTypeEnum;
    private int _javaWrapperType;
    NSRecord parent;
    String fname;
    int ftype;
    int dim;
    boolean opt;
    Object[] options;
    private boolean nillable;
    ContentType contenttype;
    boolean isUIEditable;
    Name xmlns;
    String substitutionGroupName;
    boolean soapArrayEncodingUsed;
    boolean formQualified;
    boolean isGlobal;
    public static final String KEY_NSF_NAME = "field_name";
    public static final String KEY_NSF_TYPE = "field_type";
    public static final String KEY_NSF_DIM = "field_dim";
    public static final String KEY_NSF_OPT = "field_opt";
    public static final String KEY_NSF_OPTS = "field_options";
    public static final String KEY_CONTENT_TYPE = "field_content_type";
    public static final String KEY_NSF_ENCODINGSTYLE = "field_encodingStyle";
    public static final String KEY_NSF_XMLNS = "field_xmlns";
    public static final String KEY_NSF_WRAPPER_TYPE = "wrapper_type";
    public static final String KEY_NSF_NILLABLE = "nillable";
    public static final String KEY_NSF_SUBSTITUTION_GROUP_NAME = "substitution_group_name";
    public static final String KEY_NSF_IS_SOAP_ARRAY_ENCODING_USED = "is_soap_array_encoding_used";
    public static final String KEY_NSF_FORM_QUALIFIED = "form_qualified";
    public static final String KEY_NSF_IS_GLOBAL = "is_global";
    String encodingStyle;

    public NSField(Namespace ns, String fname, int ftype, int dim) {
        this(ns, NSType.create("unknown"), fname, ftype, dim);
    }

    public NSField(Namespace ns, NSType ntype, String fname, int ftype, int dim) {
        super(ns, null, null, ntype);
        this.fname = fname;
        this.ftype = ftype;
        this.dim = dim;
        this.opt = false;
        this.isUIEditable = true;
        this.nillable = true;
    }

    protected NSField(Namespace ns, IData values) {
        super(ns, values);
    }

    protected NSField(Namespace ns, Values values) {
        super(ns, values);
    }

    public static NSField create(Namespace ns, IData val) {
        if (val == null) {
            return null;
        }
        IDataCursor ic = val.getCursor();
        int ftype = fieldEnum.getInt(IDataUtil.getString(ic, KEY_NSF_TYPE), -1);
        ic.destroy();
        switch (ftype) {
            case 4: {
                return NSRecordRef.createRecordRef(ns, val);
            }
            case 2: {
                return NSRecord.createRecord(ns, val);
            }
            case 1: 
            case 3: {
                return new NSField(ns, val);
            }
        }
        return null;
    }

    public static NSField create(Namespace ns, Values val) {
        if (val == null) {
            return null;
        }
        IDataCursor ic = val.getCursor();
        int ftype = fieldEnum.getInt(IDataUtil.getString(ic, KEY_NSF_TYPE), -1);
        ic.destroy();
        switch (ftype) {
            case 4: {
                return NSRecordRef.createRecordRef(ns, val);
            }
            case 2: {
                return NSRecord.createRecord(ns, val);
            }
            case 1: 
            case 3: {
                return new NSField(ns, val);
            }
        }
        return null;
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{KEY_NSF_NAME, this.getName()}, {KEY_NSF_TYPE, fieldEnum.getString(this.getType(), "unknown")}, {KEY_NSF_DIM, Integer.toString(this.getDimensions())}, {KEY_NSF_OPT, this.opt ? "true" : null}, {KEY_NSF_OPTS, this.options}, {KEY_CONTENT_TYPE, this.contenttype != null ? this.contenttype.getValues() : null}, {KEY_NSF_ENCODINGSTYLE, this.encodingStyle}, {KEY_NSF_WRAPPER_TYPE, this._javaWrapperType != 0 ? wrapperTypeEnum.getString(this._javaWrapperType, "UNKNOWN") : null}, {KEY_NSF_NILLABLE, this.nillable ? "true" : "false"}, {KEY_NSF_XMLNS, this.xmlns != null && this.xmlns.toString().length() > 0 ? this.xmlns.toString() : null}, {KEY_NSF_SUBSTITUTION_GROUP_NAME, this.substitutionGroupName}, {KEY_NSF_FORM_QUALIFIED, this.formQualified ? "true" : "false"}, {KEY_NSF_IS_GLOBAL, this.isGlobal ? "true" : "false"}};
        Object[][] o1 = null;
        if (this.dim != 0) {
            o1 = new Object[1][2];
            o1[0][0] = KEY_NSF_IS_SOAP_ARRAY_ENCODING_USED;
            Object object = o1[0][1] = this.soapArrayEncodingUsed ? "true" : "false";
        }
        if (o1 != null) {
            Object[][] tempA = new Object[o.length + 1][2];
            System.arraycopy(o, 0, tempA, 0, o.length);
            System.arraycopy(o1, 0, tempA, o.length, o1.length);
            o = tempA;
        }
        return super.getValues().copyFrom(new Values(o));
    }

    public void setValues(Values val) {
        super.setValues(val);
        try {
            String strWrapperType;
            this.fname = val.getString(KEY_NSF_NAME);
            this.ftype = fieldEnum.getInt(val.getString(KEY_NSF_TYPE), 1);
            this.dim = val.getInt(KEY_NSF_DIM, 0);
            String req = val.getString(KEY_NSF_OPT);
            this.opt = req != null && req.equalsIgnoreCase("true");
            this.options = (Object[])val.get(KEY_NSF_OPTS);
            Object values = val.get(KEY_CONTENT_TYPE);
            this.contenttype = values != null && values instanceof Values ? ContentTypeFactory.create(this.getNamespace(), (Values)values) : null;
            this.encodingStyle = val.getString(KEY_NSF_ENCODINGSTYLE);
            String tmpNS = val.getString(KEY_NSF_XMLNS);
            if (tmpNS != null && tmpNS.length() > 0) {
                this.xmlns = Name.create(tmpNS);
            }
            this._javaWrapperType = (strWrapperType = val.getString(KEY_NSF_WRAPPER_TYPE)) == null ? 0 : wrapperTypeEnum.getInt(strWrapperType, 0);
            String strNillable = val.getString(KEY_NSF_NILLABLE);
            this.nillable = strNillable == null ? true : strNillable.equalsIgnoreCase("true");
            String substitutionGroupNameString = val.getString(KEY_NSF_SUBSTITUTION_GROUP_NAME);
            this.substitutionGroupName = substitutionGroupNameString != null && substitutionGroupNameString.length() > 0 ? substitutionGroupNameString : null;
            String strSoapArray = val.getString(KEY_NSF_IS_SOAP_ARRAY_ENCODING_USED);
            this.soapArrayEncodingUsed = strSoapArray == null ? true : strSoapArray.equalsIgnoreCase("true");
            String strFormQualified = val.getString(KEY_NSF_FORM_QUALIFIED);
            this.formQualified = strFormQualified == null ? false : strFormQualified.equalsIgnoreCase("true");
            String strIsGlobal = val.getString(KEY_NSF_IS_GLOBAL);
            this.isGlobal = strIsGlobal == null ? false : strIsGlobal.equalsIgnoreCase("true");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public IData getAsData() {
        IData val = super.getAsData();
        IDataCursor ic = val.getCursor();
        ic.insertAfter(KEY_NSF_NAME, this.getName());
        ic.insertAfter(KEY_NSF_TYPE, fieldEnum.getString(this.getType(), "unknown"));
        ic.insertAfter(KEY_NSF_DIM, Integer.toString(this.getDimensions()));
        ic.insertAfter(KEY_NSF_OPT, this.opt ? "true" : null);
        if (this.options != null) {
            ic.insertAfter(KEY_NSF_OPTS, this.options);
        }
        if (this.contenttype != null) {
            ic.insertAfter(KEY_CONTENT_TYPE, this.contenttype.getAsData());
        }
        if (this.encodingStyle != null) {
            ic.insertAfter(KEY_NSF_ENCODINGSTYLE, this.encodingStyle);
        }
        ic.insertAfter(KEY_NSF_WRAPPER_TYPE, this._javaWrapperType != 0 ? wrapperTypeEnum.getString(this._javaWrapperType, "UNKNOWN") : null);
        ic.insertAfter(KEY_NSF_NILLABLE, this.nillable ? "true" : "false");
        ic.insertAfter(KEY_NSF_XMLNS, this.xmlns != null && this.xmlns.toString().length() > 0 ? this.xmlns.toString() : null);
        if (this.substitutionGroupName != null) {
            ic.insertAfter(KEY_NSF_SUBSTITUTION_GROUP_NAME, this.substitutionGroupName);
        }
        if (this.dim != 0) {
            ic.insertAfter(KEY_NSF_IS_SOAP_ARRAY_ENCODING_USED, this.soapArrayEncodingUsed ? "true" : "false");
        }
        ic.insertAfter(KEY_NSF_FORM_QUALIFIED, this.formQualified ? "true" : "false");
        ic.insertAfter(KEY_NSF_IS_GLOBAL, this.isGlobal ? "true" : "false");
        ic.destroy();
        return val;
    }

    public void setFromData(IData val) {
        super.setFromData(val);
        IDataCursor ic = val.getCursor();
        try {
            String strWrapperType;
            this.fname = IDataUtil.getString(ic, KEY_NSF_NAME);
            this.ftype = fieldEnum.getInt(IDataUtil.getString(ic, KEY_NSF_TYPE), 1);
            this.dim = IDataUtil.getInt(ic, KEY_NSF_DIM, 0);
            String req = IDataUtil.getString(ic, KEY_NSF_OPT);
            this.opt = req != null && req.equalsIgnoreCase("true");
            this.options = (Object[])IDataUtil.get(ic, KEY_NSF_OPTS);
            Object values = IDataUtil.get(ic, KEY_CONTENT_TYPE);
            this.contenttype = values != null && values instanceof IData ? ContentTypeFactory.create(this.getNamespace(), (IData)values) : null;
            this.encodingStyle = IDataUtil.getString(ic, KEY_NSF_ENCODINGSTYLE);
            String tmpNS = IDataUtil.getString(ic, KEY_NSF_XMLNS);
            if (tmpNS != null && tmpNS.length() > 0) {
                this.xmlns = Name.create(tmpNS);
            }
            this._javaWrapperType = (strWrapperType = IDataUtil.getString(ic, KEY_NSF_WRAPPER_TYPE)) == null ? 0 : wrapperTypeEnum.getInt(strWrapperType, 0);
            String strNillable = IDataUtil.getString(ic, KEY_NSF_NILLABLE);
            this.nillable = strNillable == null ? true : strNillable.equalsIgnoreCase("true");
            String substitutionGroupNameString = IDataUtil.getString(ic, KEY_NSF_SUBSTITUTION_GROUP_NAME);
            this.substitutionGroupName = substitutionGroupNameString != null && substitutionGroupNameString.length() > 0 ? substitutionGroupNameString : null;
            String strSoapArray = IDataUtil.getString(ic, KEY_NSF_IS_SOAP_ARRAY_ENCODING_USED);
            this.soapArrayEncodingUsed = strSoapArray == null ? true : strSoapArray.equalsIgnoreCase("true");
            String strFormQualified = IDataUtil.getString(ic, KEY_NSF_FORM_QUALIFIED);
            this.formQualified = strFormQualified == null ? false : strFormQualified.equalsIgnoreCase("true");
            String strIsGlobal = IDataUtil.getString(ic, KEY_NSF_IS_GLOBAL);
            this.isGlobal = strIsGlobal == null ? false : strIsGlobal.equalsIgnoreCase("true");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ic.destroy();
    }

    public String getName() {
        return this.fname;
    }

    public int getType() {
        return this.ftype;
    }

    public int getDimensions() {
        return this.dim;
    }

    public boolean isOptional() {
        return this.opt;
    }

    public NSRecord getParentRecord() {
        return this.parent;
    }

    public NSRecord getRootRecord() {
        NSField root = this;
        while (root.getParentRecord() != null) {
            root = root.getParentRecord();
        }
        return root instanceof NSRecord ? (NSRecord)root : null;
    }

    public String[] getStringOptions() {
        if (this.options instanceof String[]) {
            return (String[])this.options;
        }
        return null;
    }

    public ContentType getContentType() {
        return this.contenttype;
    }

    public Name getXmlNamespace() {
        if (this.xmlns == null || this.xmlns.toString().length() == 0) {
            return null;
        }
        return this.xmlns;
    }

    public String getSubstitutionGroupName() {
        return this.substitutionGroupName;
    }

    public void setXmlNamespace(Name name) {
        this.xmlns = name;
    }

    public void setName(String fname) {
        this.fname = fname;
    }

    public void setType(int ftype) {
        this.ftype = ftype;
    }

    public void setDimensions(int dim) {
        this.dim = dim;
    }

    public void setOptional(boolean opt) {
        this.opt = opt;
    }

    public void setStringOptions(String[] opt) {
        this.options = opt;
    }

    public void setParent(NSRecord parent) {
        this.parent = parent;
    }

    public void setContentType(ContentType contenttype) {
        this.contenttype = contenttype;
    }

    public void setSubstitutionGroupName(String name) {
        this.substitutionGroupName = name;
    }

    public String toString() {
        String str = this.fname == null ? Strings.cat("<unnamed>", ";t=", Integer.toString(this.ftype), ";d=", Integer.toString(this.dim)) : Strings.cat("n=", this.fname, ";t=", Integer.toString(this.ftype), ";d=", Integer.toString(this.dim));
        return str;
    }

    public String getSigString(boolean in, int depth) {
        if (this.getName() == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(30);
        sb.append(in ? "[i] " : "[o] ");
        if (depth > 0) {
            for (int i = 0; i < depth; ++i) {
                sb.append('-');
            }
            sb.append(' ');
        }
        switch (this.getType()) {
            case 1: {
                sb.append("field:");
                break;
            }
            case 3: {
                sb.append("object:");
                break;
            }
            case 2: {
                sb.append("record:");
                break;
            }
            case 4: {
                sb.append("recref:");
            }
        }
        sb.append(Integer.toString(this.getDimensions()));
        sb.append(':');
        sb.append(this.isOptional() ? "optional " : "required ");
        sb.append(this.getName());
        String[] s = this.getStringOptions();
        if (s != null && s.length > 0) {
            sb.append(" {");
            for (int i = 0; i < s.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append('\"');
                sb.append(s[i]);
                sb.append('\"');
            }
            sb.append('}');
        }
        return sb.toString();
    }

    public String getPath() {
        return WmPathInfo.createPath(this);
    }

    public static String getPath(String name, int type, int dim) {
        return WmPathInfo.getPath(name, type, dim);
    }

    public static String getPath(String[] paths, int[] types, int[] dims) {
        return WmPathInfo.getPath(paths, types, dims);
    }

    public static String getPath(String name, int type, int dim, NSName referenceName) {
        return WmPathInfo.getPath(name, type, dim, referenceName);
    }

    public static Object[] parsePath(String path) {
        WmPathItem[] pathInfo = WmPathInfo.parsePath(path);
        if (pathInfo == null) {
            return null;
        }
        String[] names = new String[pathInfo.length];
        int[] types = new int[pathInfo.length];
        int[] dims = new int[pathInfo.length];
        String[] nsNames = new String[pathInfo.length];
        for (WmPathItem item : pathInfo) {
            names[i] = item.getName();
            types[i] = item.getType();
            dims[i] = item.getDimension();
            nsNames[i] = item.getNSName();
        }
        Object[] result = new Object[]{names, types, dims, nsNames};
        return result;
    }

    public static final boolean isRecordType(int type) {
        return type == 2 || type == 4;
    }

    public static String encodePathName(String name) {
        return WmPathInfo.encodePathName(name);
    }

    public void validateContent(String value, Object workspace) {
        if (this.contenttype != null) {
            this.contenttype.validate(value, workspace);
        }
    }

    public String getMPath() {
        return WmPathInfo.createPath(this, -1);
    }

    public boolean isUIEditable() {
        return this.isUIEditable;
    }

    public void setUIEditable(boolean b) {
        this.isUIEditable = b;
    }

    public Object clone() {
        NSField clone = (NSField)super.clone();
        clone.setUIEditable(this.isUIEditable());
        clone.setParent(this.parent);
        if (this.contenttype != null) {
            ContentType contentType_clone = ContentTypeFactory.create(this.getNamespace(), this.contenttype.getAsData());
            contentType_clone.setFromData(this.contenttype.getAsData());
            clone.contenttype = contentType_clone;
        }
        clone.setJavaWrapperType(this._javaWrapperType);
        return clone;
    }

    public Object fastClone() {
        NSField clone = (NSField)super.clone();
        clone.setUIEditable(this.isUIEditable());
        clone.setParent(this.parent);
        clone.setJavaWrapperType(this._javaWrapperType);
        return clone;
    }

    public void setEncodingStyle(String encodingStyle) {
        this.encodingStyle = encodingStyle;
    }

    public String getEncodingStyle() {
        return this.encodingStyle;
    }

    public void setSchemaTypeName(QName schemaTypeName) {
    }

    public QName getSchemaTypeName() {
        TypeDef typeDefinition = (TypeDef)this.contenttype;
        if (typeDefinition != null && typeDefinition.isProxy()) {
            return typeDefinition.getQName();
        }
        return null;
    }

    public String[] getJavaWrapperTypes() {
        return JavaWrapperType.getNames();
    }

    public String getJavaWrapperTypeString() {
        String[] java_wrapper_types = JavaWrapperType.getNames();
        return java_wrapper_types[this._javaWrapperType];
    }

    public int getJavaWrapperType() {
        return this._javaWrapperType;
    }

    public void setJavaWrapperType(int wrapperType) {
        this._javaWrapperType = this.ftype == 3 ? wrapperType : 0;
    }

    public boolean isNillable() {
        return this.nillable;
    }

    public void setNillable(boolean isNillable) {
        this.nillable = isNillable;
    }

    public void setSoapArrayEncodingUsed(boolean isSoapArrayEncodingUsed) {
        this.soapArrayEncodingUsed = isSoapArrayEncodingUsed;
    }

    public boolean isSoapArrayEncodingUsed() {
        return this.soapArrayEncodingUsed;
    }

    public void setFormQualified(boolean formQualified) {
        this.formQualified = formQualified;
    }

    public boolean isFormQualified() {
        return this.formQualified;
    }

    public void setGlobal(boolean isGlobal) {
        this.isGlobal = isGlobal;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    static {
        fieldEnum.addInt("string", 1);
        fieldEnum.addInt("record", 2);
        fieldEnum.addInt("object", 3);
        fieldEnum.addInt("recref", 4);
        wrapperTypeEnum = new IntEnum(0);
        wrapperTypeEnum.addInt("UNKNOWN", 0);
        wrapperTypeEnum.addInt("java.lang.Byte", 2);
        wrapperTypeEnum.addInt("java.lang.Boolean", 1);
        wrapperTypeEnum.addInt("java.lang.Character", 3);
        wrapperTypeEnum.addInt("java.lang.Double", 4);
        wrapperTypeEnum.addInt("java.lang.Float", 5);
        wrapperTypeEnum.addInt("java.lang.Integer", 6);
        wrapperTypeEnum.addInt("java.lang.Long", 7);
        wrapperTypeEnum.addInt("java.lang.Short", 8);
        wrapperTypeEnum.addInt("java.util.Date", 9);
        wrapperTypeEnum.addInt("byte []", 10);
        wrapperTypeEnum.addInt("java.math.BigDecimal", 11);
        wrapperTypeEnum.addInt("java.math.BigInteger", 12);
    }
}

