/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.ns;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataUtil;
import com.wm.lang.ns.AuditSettings;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSReference;
import com.wm.lang.ns.NSTrigger;
import com.wm.lang.ns.NSTriggerType;
import com.wm.lang.ns.Namespace;
import com.wm.msg.ConditionFactory;
import com.wm.msg.ICondition;
import com.wm.msg.IMessage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public abstract class NSBrokerLocalTrigger
extends NSTrigger {
    protected int docsPrefetchMax;
    protected int docsPrefetchMin;
    protected int transportAckSize;
    protected boolean processingSuspended;
    protected boolean retrievalSuspended;
    protected ICondition[] conditions;
    public static final NSTriggerType BROKER_TRIGGER = NSTriggerType.create("broker-trigger");
    static final String KEY_CONDITION_TYPE = "type";
    static final String KEY_CONDITION_DATA = "data";
    public static final String KEY_TRANSPORT_ACK_SIZE = "transportAckSize";
    public static final String KEY_DELIVERY_FLAG = "deliverEnabled";
    public static final String KEY_EXECUTE_FLAG = "executeEnabled";
    public static final String KEY_DOC_PREFETCH_MAX = "docsPrefetchMax";
    public static final String KEY_DOC_PREFETCH_MIN = "docsPrefetchMin";
    public static final String KEY_PROCESSING_SUSPENDED = "processingSuspended";
    public static final String KEY_RETRIEVAL_SUSPENDED = "retrievalSuspended";
    public static final String KEY_CONDITIONS = "conditions";

    protected NSBrokerLocalTrigger(Namespace ns, IData data) {
        super(ns, data, NSTriggerType.create("broker-trigger"));
    }

    protected NSBrokerLocalTrigger(Namespace ns, IData data, NSTriggerType type) {
        super(ns, data, type);
    }

    public boolean isProcessingSuspended() {
        return this.processingSuspended;
    }

    public void setProcessingSuspended(boolean flag) {
        this.processingSuspended = flag;
    }

    public boolean isRetrievalSuspended() {
        return this.retrievalSuspended;
    }

    public void setRetrievalSuspended(boolean flag) {
        this.retrievalSuspended = flag;
    }

    public int getMaxDocsPrefetch() {
        return this.docsPrefetchMax;
    }

    public void setMaxDocsPrefetch(int maxDocs) {
        this.docsPrefetchMax = maxDocs;
    }

    public int getMinDocsPrefetch() {
        return this.docsPrefetchMin;
    }

    public void setMinDocsPrefetch(int minDocs) {
        this.docsPrefetchMin = minDocs;
    }

    public boolean isBatchTransportAck() {
        return this.transportAckSize > 1;
    }

    public int getTransportAckSize() {
        return this.transportAckSize;
    }

    public void setTransportAckSize(int size) {
        this.transportAckSize = size;
    }

    public ICondition[] getConditions() {
        return this.conditions;
    }

    public ICondition getCondition(String name) {
        for (int i = 0; i < this.conditions.length; ++i) {
            if (!this.conditions[i].getName().equals(name)) continue;
            return this.conditions[i];
        }
        return null;
    }

    public void setConditions(ICondition[] conds) {
        this.conditions = conds;
    }

    public NSName resolveServiceName(IMessage data) {
        NSName result = null;
        for (int i = 0; i < this.conditions.length; ++i) {
            if (!this.conditions[i].isSatisfied(data)) continue;
            result = this.conditions[i].getServiceName();
            break;
        }
        return result;
    }

    public NSReference[] getDependencies() {
        Iterator iterator;
        if (this.conditions == null && this.resolverSvcName == null && this.resourceMonitoringSvcName == null) {
            return NSReference.REFERENCE_NONE;
        }
        HashSet<NSName> documents = new HashSet<NSName>();
        HashSet<NSName> services = new HashSet<NSName>();
        if (this.conditions != null) {
            for (int i = 0; i < this.conditions.length; ++i) {
                NSName serviceName;
                List l = this.conditions[i].getMessageTypes();
                if (l.isEmpty()) {
                    serviceName = this.conditions[i].getServiceName();
                    if (serviceName == null) continue;
                    services.add(serviceName);
                    continue;
                }
                for (String msgType : l) {
                    documents.add(NSName.create(msgType));
                    serviceName = this.conditions[i].getServiceName();
                    services.add(serviceName);
                }
            }
        }
        if (this.getResolverServiceName() != null) {
            services.add(this.getResolverServiceName());
        }
        if (this.getResourceMonitoringSvcName() != null) {
            services.add(this.getResourceMonitoringSvcName());
        }
        NSReference[] dependencies = new NSReference[documents.size() + services.size()];
        int count = 0;
        if (!documents.isEmpty()) {
            iterator = documents.iterator();
            while (iterator.hasNext()) {
                dependencies[count] = new NSReference((NSName)iterator.next(), null);
                ++count;
            }
        }
        if (!services.isEmpty()) {
            iterator = services.iterator();
            while (iterator.hasNext()) {
                dependencies[count] = new NSReference((NSName)iterator.next(), null);
                ++count;
            }
        }
        return dependencies;
    }

    public boolean nodeChanged(NSName oldName, NSName newName) {
        if (this.conditions == null && this.resolverSvcName == null && this.resourceMonitoringSvcName == null) {
            return false;
        }
        for (int i = 0; i < this.conditions.length; ++i) {
            this.conditions[i].updateReferences(oldName, newName);
        }
        if (oldName == this.resolverSvcName) {
            this.resolverSvcName = newName;
        }
        if (oldName == this.resourceMonitoringSvcName) {
            this.resourceMonitoringSvcName = newName;
        }
        return true;
    }

    protected IData[] persistConditions() {
        if (this.conditions == null) {
            return null;
        }
        IData[] data = new IData[this.conditions.length];
        for (int i = 0; i < this.conditions.length; ++i) {
            data[i] = IDataFactory.create();
            IDataCursor dc = data[i].getCursor();
            dc.insertAfter(KEY_CONDITION_TYPE, this.conditions[i].getType());
            dc.insertAfter(KEY_CONDITION_DATA, this.conditions[i].getAsData());
            dc.destroy();
        }
        return data;
    }

    public void buildConditions(IData[] data) {
        if (data == null || data.length == 0) {
            this.conditions = null;
            return;
        }
        ArrayList<ICondition> list = new ArrayList<ICondition>();
        for (int i = 0; i < data.length; ++i) {
            IDataCursor dc = data[i].getCursor();
            String type = (String)IDataUtil.get(dc, KEY_CONDITION_TYPE);
            ConditionFactory fac = ConditionFactory.getInstance(type);
            if (fac == null) {
                dc.destroy();
                continue;
            }
            if (!dc.first(KEY_CONDITION_DATA) || dc.getValue() == null) {
                dc.destroy();
                continue;
            }
            IData condData = (IData)dc.getValue();
            list.add(fac.create(condData));
        }
        this.setConditions(list.toArray(new ICondition[0]));
    }

    public IData getAsData() {
        IData data = super.getAsData();
        IDataCursor dc = data.getCursor();
        if (!dc.first("trigger")) {
            return null;
        }
        IData localInfo = (IData)dc.getValue();
        dc.destroy();
        dc = localInfo.getCursor();
        dc.insertAfter(KEY_CONDITIONS, this.persistConditions());
        dc.insertAfter(KEY_PROCESSING_SUSPENDED, new Boolean(this.processingSuspended).toString());
        dc.insertAfter(KEY_RETRIEVAL_SUSPENDED, new Boolean(this.retrievalSuspended).toString());
        dc.insertAfter(KEY_TRANSPORT_ACK_SIZE, new Integer(this.transportAckSize).toString());
        dc.insertAfter(KEY_DELIVERY_FLAG, new Boolean(this.canDeliver).toString());
        dc.insertAfter(KEY_EXECUTE_FLAG, new Boolean(this.canExecute).toString());
        dc.insertAfter(KEY_DOC_PREFETCH_MAX, String.valueOf(this.docsPrefetchMax));
        dc.insertAfter(KEY_DOC_PREFETCH_MIN, String.valueOf(this.docsPrefetchMin));
        dc.destroy();
        dc = data.getCursor();
        dc.insertAfter("trigger", localInfo);
        return data;
    }

    protected void init() {
        this.processingSuspended = false;
        this.retrievalSuspended = false;
        this.transportAckSize = 1;
        this.canDeliver = true;
        this.canExecute = true;
        this.docsPrefetchMax = 10;
        this.docsPrefetchMin = 4;
        this.redeliveryDelay = 10000L;
    }

    public void setFromData(IData data) {
        this.init();
        if (data == null) {
            return;
        }
        super.setFromData(data);
        this.auditSettings = new AuditSettings();
        IDataCursor dc = data.getCursor();
        if (!dc.first("trigger")) {
            return;
        }
        IData localInfo = (IData)dc.getValue();
        dc.destroy();
        dc = localInfo.getCursor();
        if (dc.first(KEY_CONDITIONS)) {
            this.buildConditions((IData[])dc.getValue());
        } else {
            this.setConditions(null);
        }
        if (dc.first(KEY_PROCESSING_SUSPENDED) && dc.getValue() != null) {
            this.processingSuspended = Boolean.valueOf((String)dc.getValue());
        }
        if (dc.first(KEY_RETRIEVAL_SUSPENDED) && dc.getValue() != null) {
            this.retrievalSuspended = Boolean.valueOf((String)dc.getValue());
        }
        this.transportAckSize = dc.first(KEY_TRANSPORT_ACK_SIZE) && dc.getValue() != null ? Integer.parseInt((String)dc.getValue()) : 1;
        this.canDeliver = dc.first(KEY_DELIVERY_FLAG) && dc.getValue() != null ? Boolean.valueOf((String)dc.getValue()) : true;
        this.canExecute = dc.first(KEY_EXECUTE_FLAG) && dc.getValue() != null ? Boolean.valueOf((String)dc.getValue()) : true;
        this.docsPrefetchMax = dc.first(KEY_DOC_PREFETCH_MAX) && dc.getValue() != null ? Integer.parseInt((String)dc.getValue()) : 10;
        this.docsPrefetchMin = dc.first(KEY_DOC_PREFETCH_MIN) && dc.getValue() != null ? Integer.parseInt((String)dc.getValue()) : 4;
        dc.destroy();
    }
}

