/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.ns;

import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSRecord;
import com.wm.util.Name;
import java.util.Enumeration;
import java.util.Hashtable;

public final class EventTypeRegistry {
    private static final EventTypeRegistry _etr = new EventTypeRegistry();
    private Hashtable _registry = new Hashtable();

    public static final EventTypeRegistry current() {
        return _etr;
    }

    private EventTypeRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void register(NSRecord publishableRecord) {
        NSRecord nSRecord = publishableRecord;
        synchronized (nSRecord) {
            this._registry.put(publishableRecord.getEventDescription().getBrokerEventTypeName(), publishableRecord.getNSName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregister(NSRecord publishableRecord) {
        NSRecord nSRecord = publishableRecord;
        synchronized (nSRecord) {
            this._registry.remove(publishableRecord.getEventDescription().getBrokerEventTypeName());
        }
    }

    public final NSName resolve(Name brokerEventTypeName) {
        return (NSName)this._registry.get(brokerEventTypeName);
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("List of registered Publishable Records\n\n");
        Enumeration keys = EventTypeRegistry.current()._registry.keys();
        int index = 1;
        while (keys.hasMoreElements()) {
            Name key = (Name)keys.nextElement();
            sb.append("(" + index + ") brokerEventTypeName=" + key + " resolves to {");
            NSName nsName = (NSName)EventTypeRegistry.current()._registry.get(key);
            sb.append(nsName);
            sb.append('}');
            sb.append('\n');
            ++index;
        }
        return sb.toString();
    }

    public final Enumeration getEventTypeNames() {
        return this._registry.keys();
    }
}

