/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.ns;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataPortable;
import com.wm.data.IDataUtil;
import com.wm.util.IntEnum;
import com.wm.util.Name;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;

public class EventDescription
implements ValuesCodable,
IDataPortable,
Cloneable {
    private static final boolean debug = false;
    public static final int FOREVER = 0;
    public static final int VOLATILE = 0;
    public static final int GUARANTEED = 1;
    private static final IntEnum storageEnum = new IntEnum(0);
    private Name _brokerEventTypeName;
    private int _timeToLive;
    private int _storageType;
    private boolean _clientValidation;
    private IData _properties;
    public static final String KEY_ED_BROKER_EVENT_TYPE_NAME = "brokerEventTypeName";
    public static final String KEY_ED_TIME_TO_LIVE = "timeToLive";
    public static final String KEY_ED_STORAGE_TYPE = "storageType";
    public static final String KEY_ED_VALIDATE_ON_IS = "clientValidation";
    public static final String KEY_ED_PROPERTIES = "properties";

    private EventDescription() {
        this._timeToLive = 0;
    }

    private EventDescription(Name brokerEventTypeName, int timeToLive, int storageType) {
        this._brokerEventTypeName = brokerEventTypeName;
        this._timeToLive = timeToLive;
        this._storageType = storageType;
        this._clientValidation = true;
    }

    public static final EventDescription create(Name brokerEventTypeName, int timeToLive, int storageType) {
        if (brokerEventTypeName == null) {
            return null;
        }
        return new EventDescription(brokerEventTypeName, timeToLive, storageType);
    }

    public static final EventDescription create(Name brokerEventTypeName, int timeToLive, int storageType, IData properties) {
        EventDescription ed = EventDescription.create(brokerEventTypeName, timeToLive, storageType);
        if (ed == null) {
            return null;
        }
        ed.setProperties(properties);
        return ed;
    }

    public static final EventDescription create(IData data) {
        EventDescription ed = new EventDescription();
        ed.setFromData(data);
        return ed;
    }

    public static final EventDescription create(Values val) {
        EventDescription ed = new EventDescription();
        ed.setValues(val);
        return ed;
    }

    public Name getBrokerEventTypeName() {
        return this._brokerEventTypeName;
    }

    public int getTimeToLive() {
        return this._timeToLive;
    }

    public int getStorageType() {
        return this._storageType;
    }

    public IData getProperties() {
        return this._properties;
    }

    public boolean isClientValidation() {
        return this._clientValidation;
    }

    public void setTimeToLive(int timeToLive) {
        this._timeToLive = timeToLive;
    }

    public void setStorageType(int storageType) {
        this._storageType = storageType;
    }

    public void setClientValidation(boolean clientValidation) {
        this._clientValidation = clientValidation;
    }

    public void setProperties(IData properties) {
        this._properties = properties;
    }

    public void setBrokerEventTypeName(Name typeName) {
        this._brokerEventTypeName = typeName;
    }

    public IData getAsData() {
        Object[][] o = new Object[][]{{KEY_ED_BROKER_EVENT_TYPE_NAME, this._brokerEventTypeName.toString()}, {KEY_ED_TIME_TO_LIVE, Integer.toString(this._timeToLive)}, {KEY_ED_STORAGE_TYPE, storageEnum.getString(this._storageType, "volatile")}, {KEY_ED_VALIDATE_ON_IS, Boolean.toString(this._clientValidation)}, {KEY_ED_PROPERTIES, this._properties}};
        return IDataFactory.create(o);
    }

    public void setFromData(IData data) {
        IDataCursor cursor = data.getCursor();
        this._brokerEventTypeName = Name.create(IDataUtil.getString(cursor, KEY_ED_BROKER_EVENT_TYPE_NAME));
        try {
            this._timeToLive = Integer.parseInt(IDataUtil.getString(cursor, KEY_ED_TIME_TO_LIVE));
        }
        catch (NumberFormatException nx) {
            this._timeToLive = 0;
        }
        this._storageType = storageEnum.getInt(IDataUtil.getString(cursor, KEY_ED_STORAGE_TYPE), 0);
        this._properties = IDataUtil.getIData(cursor, KEY_ED_PROPERTIES);
        String s = IDataUtil.getString(cursor, KEY_ED_VALIDATE_ON_IS);
        this._clientValidation = s == null || s.length() < 1 || s.equals("true");
        cursor.destroy();
    }

    public void setValues(Values values) {
        this._brokerEventTypeName = Name.create(values.getString(KEY_ED_BROKER_EVENT_TYPE_NAME));
        try {
            this._timeToLive = Integer.parseInt(values.getString(KEY_ED_TIME_TO_LIVE));
        }
        catch (NumberFormatException nx) {
            this._timeToLive = 0;
        }
        String s = values.getString(KEY_ED_VALIDATE_ON_IS);
        this._clientValidation = s == null || s.length() < 1 || s.equals("true");
        this._storageType = storageEnum.getInt(values.getString(KEY_ED_STORAGE_TYPE), 0);
        this._properties = (IData)values.get(KEY_ED_PROPERTIES);
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{KEY_ED_BROKER_EVENT_TYPE_NAME, this._brokerEventTypeName.toString()}, {KEY_ED_TIME_TO_LIVE, Integer.toString(this._timeToLive)}, {KEY_ED_STORAGE_TYPE, storageEnum.getString(this._storageType, "volatile")}, {KEY_ED_VALIDATE_ON_IS, Boolean.toString(this._clientValidation)}, {KEY_ED_PROPERTIES, this._properties}};
        return new Values(o);
    }

    public Object clone() {
        try {
            EventDescription ed = (EventDescription)super.clone();
            if (this._properties != null) {
                try {
                    ed.setProperties(IDataUtil.deepClone(this._properties));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return ed;
        }
        catch (CloneNotSupportedException ce) {
            return null;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("eventTypeName=");
        sb.append(this.getBrokerEventTypeName().toString());
        sb.append(", storageType=");
        sb.append(storageEnum.getString(this._storageType, "volatile"));
        sb.append(", clientValidation=");
        sb.append(Boolean.toString(this._clientValidation));
        sb.append(", timeToLive=");
        sb.append(Integer.toString(this._timeToLive));
        return sb.toString();
    }

    static {
        storageEnum.addInt("volatile", 0);
        storageEnum.addInt("guaranteed", 1);
    }
}

