/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.ns;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.lang.ns.NSInterface;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSReference;
import com.wm.lang.ns.NSType;
import com.wm.util.List;
import com.wm.util.synch.ReadWriteLock;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class DependencyManager {
    private Hashtable nodes = new Hashtable();
    private ReadWriteLock lock = new ReadWriteLock();
    private boolean enabled = true;
    protected static DependencyManager _instance;

    protected DependencyManager() {
    }

    public static DependencyManager current() {
        return _instance;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (!enabled) {
            this.nodes = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean register(Object node) {
        if (!this.enabled) {
            return false;
        }
        if (node == null) {
            return false;
        }
        NSReference[] refs = this.getReferenceInfo(node);
        if (refs == null) {
            return false;
        }
        if (node instanceof NSInterface) {
            return false;
        }
        try {
            this.lock.getForWrite();
            this.nodes.put(node, refs);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean unregister(Object node) {
        if (!this.enabled) {
            return false;
        }
        if (node == null) {
            return false;
        }
        try {
            this.lock.getForWrite();
            this.nodes.remove(node);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasNode(Object node) {
        try {
            this.lock.getForRead();
            boolean bl = this.nodes.containsKey(node);
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    protected abstract NSReference[] getReferenceInfo(Object var1);

    protected abstract Object getNode(Object var1);

    protected abstract Object getReference(Object var1);

    protected abstract String getName(Object var1);

    protected abstract NSType getType(Object var1);

    protected abstract boolean isPublishable(String var1, NSType var2);

    protected abstract boolean isNotification(String var1, NSType var2);

    public abstract Object[] getPathNodes(Object var1, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IData getUnResolved(Object node, Filter filter) {
        try {
            this.lock.getForRead();
            NSReference refInfo = new NSReference((NSName)this.getReference(node), null);
            List parent = new List();
            List stack = new List();
            this.resolve(refInfo, parent, false, filter, stack);
            ReferenceData result = (ReferenceData)parent.elementAt(0);
            if (result.hasReferences()) {
                IData iData = result.getIData();
                return iData;
            }
            IData iData = null;
            return iData;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IData getReferenced(Object node, Filter filter) {
        try {
            this.lock.getForRead();
            NSReference refInfo = new NSReference((NSName)this.getReference(node), null);
            List parent = new List();
            List stack = new List();
            this.resolve(refInfo, parent, true, filter, stack);
            ReferenceData result = (ReferenceData)parent.elementAt(0);
            if (result.hasReferences()) {
                IData iData = result.getIData();
                return iData;
            }
            IData iData = null;
            return iData;
        }
        finally {
            this.lock.release();
        }
    }

    public final IData getDependent(Object node, Filter filter) {
        return this.getDependent(node, filter, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IData getDependent(Object node, Filter filter, Object[] excluded) {
        try {
            this.lock.getForRead();
            List parent = new List();
            List stack = new List();
            stack.addElement(node);
            if (this.dependent(node, parent, filter, stack, excluded)) {
                Object ref = this.getReference(node);
                String name = this.getName(ref);
                NSType type = this.getType(ref);
                DependentData result = new DependentData(ref.toString(), name, type, null, this.isPublishable(name, type), this.isNotification(name, type));
                result.setReferencedBy(parent);
                IData iData = result.getIData();
                return iData;
            }
            IData iData = null;
            return iData;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IData getDependentWithInvalidPaths(Object node, Filter filter) {
        try {
            this.lock.getForRead();
            List parent = new List();
            List stack = new List();
            stack.addElement(node);
            if (this.dependent(node, parent, filter, stack, null)) {
                Object ref = this.getReference(node);
                String name = this.getName(ref);
                NSType type = this.getType(ref);
                DependentData result = new DependentData(ref.toString(), name, type, null, this.isPublishable(name, type), this.isNotification(name, type));
                result.setReferencedBy(parent);
                for (int i = 0; i < result.refs.length; ++i) {
                    DependentData data = result.refs[i];
                    data.invalid = this.getInvalidPaths(data.ref.toString(), data.paths, node);
                    if (data.invalid == null) {
                        parent.removeElement(data);
                        continue;
                    }
                    int num = 0;
                    for (int j = 0; j < data.invalid.length; ++j) {
                        if (data.invalid[j] == null) continue;
                        ++num;
                    }
                    String[] paths = new String[num];
                    String[] invalid = new String[num];
                    num = 0;
                    for (int j = 0; j < data.invalid.length; ++j) {
                        if (data.invalid[j] == null) continue;
                        paths[num] = data.paths[j];
                        invalid[num] = data.invalid[j];
                        ++num;
                    }
                    data.paths = paths;
                    data.invalid = invalid;
                }
                if (parent.size() == 0) {
                    IData iData = null;
                    return iData;
                }
                result.setReferencedBy(parent);
                IData iData = result.getIData();
                return iData;
            }
            IData iData = null;
            return iData;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IData getInvalidPaths(Object node) {
        try {
            this.lock.getForRead();
            NSReference[] refs = (NSReference[])this.nodes.get(node);
            if (refs == null) {
                IData iData = null;
                return iData;
            }
            List invalids = new List();
            Object ref = this.getReference(node);
            String nsname = ref.toString();
            for (int i = 0; i < refs.length; ++i) {
                Object record = this.getNode(refs[i].getReference());
                String[] paths = new String[]{refs[i].getPath()};
                String[] invalid = null;
                invalid = record == null ? new String[]{refs[i].getPath()} : this.getInvalidPaths(nsname, paths, record);
                if (invalid == null) continue;
                String name = this.getName(refs[i].getReference());
                NSType type = this.getType(refs[i].getReference());
                Object aNode = this.getNode(refs[i].getReference());
                boolean isPublishable = this.isPublishable(name, type);
                boolean isNotification = this.isNotification(name, type);
                String resolved = "unresolved";
                if (aNode != null && this.nodes.get(aNode) != null) {
                    resolved = "resolved";
                }
                ReferenceData refData = new ReferenceData(name, type, paths[0], resolved, isPublishable, isNotification);
                refData.invalid = invalid[0];
                invalids.addElement(refData);
            }
            if (invalids.size() == 0) {
                IData i = null;
                return i;
            }
            String name = this.getName(ref);
            NSType type = this.getType(ref);
            ReferenceData result = new ReferenceData(name, type, null, "resolved", this.isPublishable(name, type), this.isNotification(name, type));
            result.setReference(invalids);
            IData iData = result.getIData();
            return iData;
        }
        finally {
            this.lock.release();
        }
    }

    protected abstract String[] getInvalidPaths(String var1, String[] var2, Object var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void changeReference(Object oldRef, Object newRef, Filter filter, boolean excludeDSP) throws Exception {
        Object[] keys = null;
        Object[] values = null;
        try {
            this.lock.getForRead();
            keys = new Object[this.nodes.size()];
            values = new Object[this.nodes.size()];
            Enumeration enumvar = this.nodes.keys();
            int i = 0;
            while (enumvar.hasMoreElements()) {
                keys[i] = enumvar.nextElement();
                values[i] = this.nodes.get(keys[i]);
                ++i;
            }
        }
        finally {
            this.lock.release();
        }
        for (int i = 0; i < keys.length; ++i) {
            NSReference[] refs;
            Object node = keys[i];
            if (filter != null) {
                node = filter.filter(node);
            }
            if (node == null || (refs = (NSReference[])values[i]) == null || refs.length <= 0) continue;
            this.changeReference(node, refs, oldRef, newRef, excludeDSP);
        }
    }

    public final void changeReference(Object oldRef, Object newRef, Filter filter) throws Exception {
        this.changeReference(oldRef, newRef, filter, false);
    }

    protected abstract void changeReference(Object var1, NSReference[] var2, Object var3, Object var4) throws Exception;

    protected abstract void changeReference(Object var1, NSReference[] var2, Object var3, Object var4, boolean var5) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String[] search(Filter filter) {
        try {
            Object node;
            this.lock.getForRead();
            Enumeration enumvar = this.nodes.keys();
            List list = new List();
            while (enumvar.hasMoreElements()) {
                node = enumvar.nextElement();
                if (filter != null && (node = filter.securityFilter(node)) != null) {
                    node = filter.filter(node);
                }
                if (node == null) continue;
                list.addElement(this.getName(this.getReference(node)));
            }
            if (list.size() == 0) {
                node = null;
                return node;
            }
            Object[] found = new String[list.size()];
            list.copyInto(found);
            Object[] objectArray = found;
            return objectArray;
        }
        finally {
            this.lock.release();
        }
    }

    private final boolean resolve(NSReference refInfo, List parent, boolean reportAll, Filter filter, List stack) {
        NSReference[] refs = null;
        Object node = this.getNode(refInfo.getReference());
        if (node != null && filter != null) {
            node = filter.filter(node);
        }
        if (node != null) {
            refs = (NSReference[])this.nodes.get(node);
        }
        if (refs == null) {
            String name = this.getName(refInfo.getReference());
            NSType type = this.getType(refInfo.getReference());
            boolean isPublishable = this.isPublishable(name, type);
            boolean isNotification = this.isNotification(name, type);
            String path = refInfo.getPath();
            String status = "unresolved";
            parent.addElement(new ReferenceData(name, type, path, status, isPublishable, isNotification));
            return false;
        }
        if (refs.length == 0) {
            if (reportAll) {
                String name = this.getName(refInfo.getReference());
                NSType type = this.getType(refInfo.getReference());
                boolean isPublishable = this.isPublishable(name, type);
                boolean isNotification = this.isNotification(name, type);
                String path = refInfo.getPath();
                String status = "resolved";
                parent.addElement(new ReferenceData(name, type, path, status, isPublishable, isNotification));
            }
            return true;
        }
        boolean isRecursive = stack.contains(node);
        String name = this.getName(refInfo.getReference());
        NSType type = this.getType(refInfo.getReference());
        boolean isPublishable = this.isPublishable(name, type);
        boolean isNotification = this.isNotification(name, type);
        String path = refInfo.getPath();
        String status = isRecursive ? "recursive" : "reference";
        ReferenceData item = new ReferenceData(name, type, path, status, isPublishable, isNotification);
        boolean resolved = true;
        if (isRecursive) {
            parent.addElement(item);
        } else {
            stack.addElement(node);
            List newParent = new List();
            for (int i = 0; i < refs.length; ++i) {
                if (this.resolve(refs[i], newParent, reportAll, filter, stack)) continue;
                resolved = false;
            }
            if (!resolved || reportAll) {
                item.setReference(newParent);
                parent.addElement(item);
            }
        }
        return resolved;
    }

    private final boolean dependent(Object dependent, List parent, Filter filter, List stack, Object[] excluded) {
        boolean find = false;
        Enumeration enumvar = this.nodes.keys();
        while (enumvar.hasMoreElements()) {
            Object node = enumvar.nextElement();
            if (filter != null) {
                node = filter.filter(node);
            }
            if (excluded != null) {
                for (int i = 0; i < excluded.length; ++i) {
                    if (node != excluded[i]) continue;
                    node = null;
                    break;
                }
            }
            if (node == null) continue;
            NSReference[] refs = (NSReference[])this.nodes.get(node);
            List paths = new List();
            for (int i = 0; i < refs.length; ++i) {
                if (dependent != this.getNode(refs[i].getReference())) continue;
                paths.addElement(refs[i].getPath());
            }
            if (paths.size() <= 0) continue;
            Object[] o = new String[paths.size()];
            paths.copyInto(o);
            Object ref = this.getReference(node);
            String name = this.getName(ref);
            NSType type = this.getType(ref);
            DependentData item = new DependentData(ref.toString(), name, type, (String[])o, this.isPublishable(name, type), this.isNotification(name, type));
            parent.addElement(item);
            if (!stack.contains(node)) {
                stack.addElement(node);
                List newParent = new List();
                if (this.dependent(node, newParent, filter, stack, excluded)) {
                    item.setReferencedBy(newParent);
                }
            }
            if (find) continue;
            find = true;
        }
        return find;
    }

    public static interface Filter {
        public Object filter(Object var1);

        public Object securityFilter(Object var1);
    }

    private static class DependentData {
        public static final String REF_NAME = "name";
        public static final String REF_TYPE = "type";
        public static final String REF_PATHS = "paths";
        public static final String REF_INVALID = "invalidPaths";
        public static final String REF_REFERENCEDBY = "referencedBy";
        public static final String REF_ISPUBLISHABLE = "isPub";
        public static final String REF_ISNOTIFICATION = "isNotification";
        public static final String STATUS_DEPENDENT = "referencedBy";
        String ref;
        String name;
        NSType type;
        boolean isPublishable;
        boolean isNotification;
        String[] paths;
        String[] invalid;
        DependentData[] refs;

        public DependentData(String ref, String name, NSType type, String[] paths, boolean isPublishable, boolean isNotification) {
            this.ref = ref;
            this.name = name;
            this.type = type;
            this.paths = paths;
            this.isPublishable = isPublishable;
            this.isNotification = isNotification;
        }

        public void setReferencedBy(List list) {
            if (list.size() == 0) {
                return;
            }
            this.refs = new DependentData[list.size()];
            list.copyInto(this.refs);
        }

        public IData getIData() {
            IData data = IDataFactory.create();
            IDataCursor c = data.getCursor();
            c.first();
            c.insertAfter(REF_NAME, this.name);
            c.insertAfter(REF_TYPE, this.type);
            c.insertAfter(REF_PATHS, this.paths);
            c.insertAfter(REF_ISPUBLISHABLE, String.valueOf(this.isPublishable));
            c.insertAfter(REF_ISNOTIFICATION, String.valueOf(this.isNotification));
            if (this.invalid != null) {
                c.insertAfter(REF_INVALID, this.invalid);
            }
            if (this.refs != null) {
                int i;
                int num_res = 0;
                int num_ref = 0;
                for (int i2 = 0; i2 < this.refs.length; ++i2) {
                    DependentData ref = this.refs[i2];
                    if (ref.refs == null) {
                        ++num_res;
                        continue;
                    }
                    ++num_ref;
                }
                DependentData[] res = new DependentData[num_res];
                DependentData[] reference = new DependentData[num_ref];
                num_res = 0;
                num_ref = 0;
                for (int i3 = 0; i3 < this.refs.length; ++i3) {
                    DependentData ref = this.refs[i3];
                    if (ref.refs == null) {
                        res[num_res++] = ref;
                        continue;
                    }
                    reference[num_ref++] = ref;
                }
                IData[] o = new IData[num_res + num_ref];
                int kk = 0;
                if (num_res > 0) {
                    for (i = 0; i < res.length; ++i) {
                        o[kk++] = res[i].getIData();
                    }
                }
                if (num_ref > 0) {
                    for (i = 0; i < reference.length; ++i) {
                        o[kk++] = reference[i].getIData();
                    }
                }
                c.insertAfter("referencedBy", o);
            }
            c.destroy();
            return data;
        }
    }

    private static class ReferenceData {
        public static final String REF_NAME = "name";
        public static final String REF_TYPE = "type";
        public static final String REF_PATH = "path";
        public static final String REF_STATUS = "status";
        public static final String REF_REFERENCE = "reference";
        public static final String REF_INVALID = "invalidPath";
        public static final String REF_ISPUBLISHABLE = "isPub";
        public static final String REF_ISNOTIFICATION = "isNotification";
        public static final String STATUS_UNRESOLVED = "unresolved";
        public static final String STATUS_RESOLVED = "resolved";
        public static final String STATUS_REFERENCE = "reference";
        public static final String STATUS_RECURSIVE = "recursive";
        String name;
        NSType type;
        String path;
        String invalid;
        boolean isPublishable;
        boolean isNotification;
        String status;
        ReferenceData[] refs;
        String[] paths;
        String[] invalids;

        public ReferenceData(String name, NSType type, String path, String status, boolean isPublishable, boolean isNotification) {
            this.name = name;
            this.type = type;
            this.path = path;
            this.status = status;
            this.isPublishable = isPublishable;
            this.isNotification = isNotification;
        }

        public void setReference(List list) {
            if (list.size() == 0) {
                return;
            }
            this.refs = new ReferenceData[list.size()];
            list.copyInto(this.refs);
            this.status = "reference";
        }

        public IData getIData() {
            ReferenceData[] sortedRefs = this.sortPaths();
            IData data = IDataFactory.create();
            IDataCursor c = data.getCursor();
            c.first();
            c.insertAfter(REF_NAME, this.name);
            c.insertAfter(REF_TYPE, this.type);
            c.insertAfter(REF_PATH, this.paths);
            c.insertAfter(REF_ISPUBLISHABLE, String.valueOf(this.isPublishable));
            c.insertAfter(REF_ISNOTIFICATION, String.valueOf(this.isNotification));
            if (this.invalids != null) {
                c.insertAfter(REF_INVALID, this.invalids);
            }
            c.insertAfter(REF_STATUS, this.status);
            if (sortedRefs != null) {
                c.insertAfter("reference", this.sortStatus(sortedRefs));
            }
            c.destroy();
            return data;
        }

        private ReferenceData[] sortPaths() {
            if (this.paths == null) {
                this.paths = new String[1];
                this.paths[0] = this.path;
            }
            if (this.invalids == null && this.invalid != null) {
                this.invalids = new String[1];
                this.invalids[0] = this.invalid;
            }
            if (this.refs == null) {
                return null;
            }
            int num = 0;
            for (int i = 0; i < this.refs.length; ++i) {
                ReferenceData refi = this.refs[i];
                if (refi == null) continue;
                List pathList = new List();
                List invalidList = refi.invalid == null ? null : new List();
                pathList.addElement(refi.path);
                if (invalidList != null) {
                    invalidList.addElement(refi.invalid);
                }
                ++num;
                for (int j = i + 1; j < this.refs.length; ++j) {
                    ReferenceData refj = this.refs[j];
                    if (refj == null || !refi.name.equals(refj.name)) continue;
                    pathList.addElement(refj.path);
                    if (invalidList != null) {
                        invalidList.addElement(refj.invalid);
                    }
                    this.refs[j] = null;
                }
                refi.paths = new String[pathList.size()];
                pathList.copyInto(refi.paths);
                if (invalidList == null) continue;
                refi.invalids = new String[invalidList.size()];
                invalidList.copyInto(refi.invalids);
            }
            ReferenceData[] sortedRefs = new ReferenceData[num];
            num = 0;
            for (int i = 0; i < this.refs.length; ++i) {
                if (this.refs[i] == null) continue;
                sortedRefs[num++] = this.refs[i];
            }
            return sortedRefs;
        }

        private IData[] sortStatus(ReferenceData[] sortedRefs) {
            int i;
            if (sortedRefs == null) {
                return null;
            }
            int num_unres = 0;
            int num_res = 0;
            int num_ref = 0;
            for (int i2 = 0; i2 < sortedRefs.length; ++i2) {
                ReferenceData ref = sortedRefs[i2];
                if (STATUS_RESOLVED.equals(ref.status)) {
                    ++num_res;
                    continue;
                }
                if (STATUS_UNRESOLVED.equals(ref.status)) {
                    ++num_unres;
                    continue;
                }
                ++num_ref;
            }
            ReferenceData[] unres = new ReferenceData[num_unres];
            ReferenceData[] res = new ReferenceData[num_res];
            ReferenceData[] reference = new ReferenceData[num_ref];
            num_res = 0;
            num_unres = 0;
            num_ref = 0;
            for (int i3 = 0; i3 < sortedRefs.length; ++i3) {
                ReferenceData ref = sortedRefs[i3];
                if (STATUS_RESOLVED.equals(ref.status)) {
                    res[num_res++] = ref;
                    continue;
                }
                if (STATUS_UNRESOLVED.equals(ref.status)) {
                    unres[num_unres++] = ref;
                    continue;
                }
                reference[num_ref++] = ref;
            }
            IData[] o = new IData[num_res + num_unres + num_ref];
            int kk = 0;
            if (num_unres > 0) {
                for (i = 0; i < unres.length; ++i) {
                    o[kk++] = unres[i].getIData();
                }
            }
            if (num_res > 0) {
                for (i = 0; i < res.length; ++i) {
                    o[kk++] = res[i].getIData();
                }
            }
            if (num_ref > 0) {
                for (i = 0; i < reference.length; ++i) {
                    o[kk++] = reference[i].getIData();
                }
            }
            return o;
        }

        boolean hasReferences() {
            return this.refs != null;
        }
    }
}

