/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.ns;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataPortable;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;

public class AuditSettings
implements IDataPortable,
ValuesCodable {
    public static final int PIPELINE_NEVER = 0;
    public static final int PIPELINE_ONERROR = 1;
    public static final int PIPELINE_LOGALWAYS = 2;
    public static final int STATE_BEGIN = 1;
    public static final int STATE_END = 2;
    public static final int STATE_ERROR = 3;
    public static final int STATE_RETRY = 4;
    public static final int LOG_NONE = 0;
    public static final int LOG_WITHOUTPIPELINE = 1;
    public static final int LOG_WITHPIPELINE = 2;
    protected int docAudit = 0;
    protected boolean startAudit = false;
    protected boolean stopAudit = false;
    protected boolean errorAudit = true;
    static final String KEY_DOCUMENT = "document_data";
    static final String KEY_START = "startExecution";
    static final String KEY_STOP = "stopExecution";
    static final String KEY_ERROR = "onError";

    public final int isDocumentAuditEnabled() {
        return this.docAudit;
    }

    public final void enableDocumentAudit(int state) {
        this.docAudit = state == 0 || state == 2 || state == 1 ? state : 0;
    }

    public final boolean isStartAuditEnabled() {
        return this.startAudit;
    }

    public final void enableStartAudit(boolean flag) {
        this.startAudit = flag;
    }

    public final boolean isCompleteAuditEnabled() {
        return this.stopAudit;
    }

    public final void enableCompleteAudit(boolean flag) {
        this.stopAudit = flag;
    }

    public final boolean isErrorAuditEnabled() {
        return this.errorAudit;
    }

    public final void enableErrorAudit(boolean flag) {
        this.errorAudit = flag;
    }

    public IData getAsData() {
        IData data = IDataFactory.create();
        IDataCursor dc = data.getCursor();
        dc.insertAfter(KEY_DOCUMENT, new Integer(this.docAudit).toString());
        dc.insertAfter(KEY_START, new Boolean(this.startAudit).toString());
        dc.insertAfter(KEY_STOP, new Boolean(this.stopAudit).toString());
        dc.insertAfter(KEY_ERROR, new Boolean(this.errorAudit).toString());
        dc.destroy();
        return data;
    }

    public void setFromData(IData data) {
        if (data == null) {
            return;
        }
        IDataCursor dc = data.getCursor();
        if (dc.next(KEY_DOCUMENT)) {
            this.docAudit = Integer.valueOf((String)dc.getValue());
        }
        if (dc.next(KEY_START)) {
            this.startAudit = Boolean.valueOf((String)dc.getValue());
        }
        if (dc.next(KEY_STOP)) {
            this.stopAudit = Boolean.valueOf((String)dc.getValue());
        }
        if (dc.next(KEY_ERROR)) {
            this.errorAudit = Boolean.valueOf((String)dc.getValue());
        }
    }

    public Values getValues() {
        return Values.use(this.getAsData());
    }

    public void setValues(Values vals) {
        this.setFromData(vals.getIData());
    }

    public boolean setFromAuditSettings(AuditSettings as) {
        if (as == null) {
            return false;
        }
        this.docAudit = as.docAudit;
        this.errorAudit = as.errorAudit;
        this.startAudit = as.startAudit;
        this.stopAudit = as.stopAudit;
        return true;
    }

    public void union(AuditSettings as) {
        if (as == null) {
            return;
        }
        this.docAudit |= as.docAudit;
        this.errorAudit |= as.errorAudit;
        this.startAudit |= as.startAudit;
        this.stopAudit |= as.stopAudit;
    }

    public int getLogStatus(int state) {
        int logState = 0;
        switch (state) {
            case 1: {
                if (this.startAudit) {
                    logState = 1;
                    if (this.docAudit != 2) break;
                    logState = 2;
                    break;
                }
                logState = 0;
                break;
            }
            case 2: {
                if (this.stopAudit) {
                    logState = 1;
                    if (this.docAudit != 2) break;
                    logState = 2;
                    break;
                }
                logState = 0;
                break;
            }
            case 3: {
                if (this.errorAudit) {
                    logState = 1;
                    if (this.docAudit != 2 && this.docAudit != 1) break;
                    logState = 2;
                    break;
                }
                logState = 0;
                break;
            }
            case 4: {
                if (this.errorAudit) {
                    logState = 1;
                    break;
                }
                logState = 0;
                break;
            }
            default: {
                logState = 0;
            }
        }
        return logState;
    }
}

