/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.jaxrpc;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.lang.jaxrpc.JAXRPCException;
import com.wm.lang.jaxrpc.resources.JAXRPCExceptionBundle;
import com.wm.util.JournalLogger;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.Handler;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;

public class JAXHandlerRegistry {
    static final JAXHandlerRegistry _JAXHandlerRegistry = new JAXHandlerRegistry();
    public static final boolean INBOUND = true;
    public static final boolean OUTBOUND = false;
    private Hashtable<String, Handler> logical2HandlerIn = new Hashtable();
    private Hashtable<String, Handler> logical2HandlerOut = new Hashtable();
    private Hashtable<String, HandlerInfo> logical2HandlerInfoIn = new Hashtable();
    private Hashtable<String, HandlerInfo> logical2HandlerInfoOut = new Hashtable();
    private Hashtable<Handler, String> handlerIn2Logical = new Hashtable();
    private Hashtable<Handler, String> handlerOut2Logical = new Hashtable();
    private Hashtable<QName, ArrayList<String>> qname2HandlerIn = new Hashtable();
    private Hashtable<QName, ArrayList<String>> qname2HandlerOut = new Hashtable();
    public static final int FAC_SOAP_HANDLER_REGISTER_FAILED = 8;
    public static final int FAC_SOAP_HANDLER_INIT_FAILED = 9;
    public static final int FAC_SOAP_HANDLER_DESTROY_FAILED = 10;
    public static final int FAC_SOAP_HANDLER_NOT_REGISTERED = 12;

    public static JAXHandlerRegistry current() {
        return _JAXHandlerRegistry;
    }

    private JAXHandlerRegistry() {
    }

    public void clear() {
        this.qname2HandlerIn.clear();
        this.qname2HandlerOut.clear();
        this.logical2HandlerIn.clear();
        this.logical2HandlerOut.clear();
        this.logical2HandlerInfoIn.clear();
        this.logical2HandlerInfoOut.clear();
        this.handlerIn2Logical.clear();
        this.handlerOut2Logical.clear();
    }

    public boolean register(String logicalName, Handler handler, boolean in) throws JAXRPCException {
        return this.register(logicalName, handler, null, in);
    }

    public boolean register(String logicalName, Handler handler, HandlerInfo info, boolean in) throws JAXRPCException {
        Hashtable<QName, ArrayList<String>> qname;
        Hashtable<String, HandlerInfo> handlerInfo;
        Hashtable<String, Handler> logical;
        Hashtable<Handler, String> instance;
        if (handler == null || logicalName == null) {
            return false;
        }
        if (in) {
            instance = this.handlerIn2Logical;
            logical = this.logical2HandlerIn;
            handlerInfo = this.logical2HandlerInfoIn;
            qname = this.qname2HandlerIn;
        } else {
            instance = this.handlerOut2Logical;
            logical = this.logical2HandlerOut;
            handlerInfo = this.logical2HandlerInfoOut;
            qname = this.qname2HandlerOut;
        }
        if (logical.containsKey(logicalName)) {
            JournalLogger.logError(8, 88, logicalName);
            throw new JAXRPCException(JAXRPCExceptionBundle.class, JAXRPCExceptionBundle.JAX_HANDLER_ALREADY_REGISTERED, "", logicalName);
        }
        try {
            handler.init(info);
        }
        catch (Exception ex) {
            JournalLogger.logError(9, 88, logicalName, ex.getMessage());
            throw new JAXRPCException(JAXRPCExceptionBundle.class, JAXRPCExceptionBundle.JAX_HANDLER_INIT_ERROR, "", new Object[]{logicalName, ex, ex.getMessage()});
        }
        QName[] qnames = handler.getHeaders();
        if (qnames != null) {
            for (int i = 0; i < qnames.length; ++i) {
                ArrayList<String> existingList = qname.get(qnames[i]);
                if (existingList == null) {
                    existingList = new ArrayList();
                }
                existingList.add(logicalName);
                qname.put(qnames[i], existingList);
            }
        }
        logical.put(logicalName, handler);
        if (info != null) {
            handlerInfo.put(logicalName, info);
        }
        instance.put(handler, logicalName);
        return true;
    }

    public boolean unregister(String logicalName, boolean in) throws JAXRPCException {
        Hashtable<QName, ArrayList<String>> qname;
        Hashtable<String, HandlerInfo> handlerInfo;
        Hashtable<String, Handler> logical;
        Hashtable<Handler, String> instance;
        if (in) {
            instance = this.handlerIn2Logical;
            logical = this.logical2HandlerIn;
            handlerInfo = this.logical2HandlerInfoIn;
            qname = this.qname2HandlerIn;
        } else {
            instance = this.handlerOut2Logical;
            logical = this.logical2HandlerOut;
            handlerInfo = this.logical2HandlerInfoOut;
            qname = this.qname2HandlerOut;
        }
        if (logicalName == null || !logical.containsKey(logicalName)) {
            JournalLogger.logError(12, 88, logicalName);
            throw new JAXRPCException(JAXRPCExceptionBundle.class, JAXRPCExceptionBundle.JAX_HANDLER_NOT_REGISTERED, "", logicalName);
        }
        Handler handler = logical.remove(logicalName);
        if (handler == null) {
            JournalLogger.logError(12, 88, logicalName);
            throw new JAXRPCException(JAXRPCExceptionBundle.class, JAXRPCExceptionBundle.JAX_HANDLER_NOT_REGISTERED, "", logicalName);
        }
        handlerInfo.remove(logicalName);
        instance.remove(handler);
        QName[] qnames = handler.getHeaders();
        try {
            handler.destroy();
        }
        catch (Exception ex) {
            JournalLogger.logError(10, 88, logicalName, ex.getMessage());
            throw new JAXRPCException(JAXRPCExceptionBundle.class, JAXRPCExceptionBundle.JAX_HANDLER_DESTROY_ERROR, "", new Object[]{logicalName, ex, ex.getMessage()});
        }
        finally {
            if (qnames != null) {
                for (int i = 0; i < qnames.length; ++i) {
                    ArrayList<String> handlerList = qname.get(qnames[i]);
                    if (handlerList == null) continue;
                    handlerList.remove(logicalName);
                    if (handlerList.isEmpty()) {
                        qname.remove(qnames[i]);
                        continue;
                    }
                    qname.put(qnames[i], handlerList);
                }
            }
        }
        return true;
    }

    public Handler find(String key, boolean in) {
        if (in) {
            return this.logical2HandlerIn.get(key);
        }
        return this.logical2HandlerOut.get(key);
    }

    public String find(Handler handler, boolean in) {
        if (in) {
            return this.handlerIn2Logical.get(handler);
        }
        return this.handlerOut2Logical.get(handler);
    }

    public Handler[] findHandlers(QName qname, boolean in) {
        Hashtable<QName, ArrayList<String>> qn;
        Hashtable<String, Handler> logical;
        if (in) {
            logical = this.logical2HandlerIn;
            qn = this.qname2HandlerIn;
        } else {
            logical = this.logical2HandlerOut;
            qn = this.qname2HandlerOut;
        }
        if (qn == null) {
            return null;
        }
        ArrayList<String> handlerList = qn.get(qname);
        if (handlerList == null || handlerList.isEmpty()) {
            return null;
        }
        Handler[] handlers = new Handler[handlerList.size()];
        for (int i = 0; i < handlers.length; ++i) {
            handlers[i] = this.find(handlerList.get(i), in);
        }
        return handlers;
    }

    public IData[] list(boolean in) {
        Hashtable<QName, ArrayList<String>> qname;
        Hashtable<String, HandlerInfo> handlerInfo;
        Hashtable<String, Handler> logical;
        Vector<IData> v = new Vector<IData>();
        if (in) {
            logical = this.logical2HandlerIn;
            handlerInfo = this.logical2HandlerInfoIn;
            qname = this.qname2HandlerIn;
        } else {
            logical = this.logical2HandlerOut;
            handlerInfo = this.logical2HandlerInfoOut;
            qname = this.qname2HandlerOut;
        }
        Enumeration<String> keys = logical.keys();
        while (keys.hasMoreElements()) {
            QName[] qnames;
            String policyType;
            Map config;
            String key = keys.nextElement();
            Handler handler = this.find(key, in);
            IData tuple = IDataFactory.create();
            IDataCursor tuplecr = tuple.getCursor();
            tuplecr.insertAfter("descriptiveName", key);
            tuplecr.insertAfter("className", handler.getClass().getName());
            HandlerInfo info = handlerInfo.get(key);
            if (info != null && (config = info.getHandlerConfig()) != null && (policyType = (String)config.get("policyType")) != null && policyType.trim().length() > 0) {
                tuplecr.insertAfter("policyType", policyType);
            }
            if ((qnames = handler.getHeaders()) != null) {
                IData[] qn = new IData[qnames.length];
                for (int i = 0; i < qnames.length; ++i) {
                    qn[i] = IDataFactory.create();
                    IDataCursor qncr = qn[i].getCursor();
                    qncr.insertAfter("namespace", qnames[i].getNamespaceURI());
                    qncr.insertAfter("localName", qnames[i].getLocalPart());
                    qncr.destroy();
                }
                tuplecr.insertAfter("Headers", qn);
            }
            v.addElement(tuple);
        }
        IData[] list = new IData[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            list[i] = (IData)v.elementAt(i);
        }
        return list;
    }

    public String toString() {
        return this.toString("List of registered handlers:");
    }

    public String toString(String title) {
        String handlerName;
        Handler handler;
        String logicalName;
        StringBuffer sb = new StringBuffer();
        sb.append(title + "\n Inbound:\n");
        Enumeration<String> keys = this.logical2HandlerIn.keys();
        int index = 1;
        while (keys.hasMoreElements()) {
            logicalName = keys.nextElement();
            handler = this.find(logicalName, true);
            handlerName = handler.getClass().getName();
            sb.append("  (" + index + ") " + logicalName + " : " + handlerName + "\n");
            ++index;
        }
        sb.append("\n\n Outbound:\n");
        keys = this.logical2HandlerOut.keys();
        index = 1;
        while (keys.hasMoreElements()) {
            logicalName = keys.nextElement();
            handler = this.find(logicalName, false);
            handlerName = handler.getClass().getName();
            sb.append("  (" + index + ") " + logicalName + " : " + handlerName + "\n");
            ++index;
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        try {
            JAXHandlerRegistry jaxReg = JAXHandlerRegistry.current();
            jaxReg.init();
            jaxReg.list(true);
            jaxReg.list(false);
            Handler h = jaxReg.find("InThree", true);
            h = jaxReg.find("InOne", true);
            h = jaxReg.find("InTwo", true);
            h = jaxReg.find("InSix", true);
            h = jaxReg.find("noneIn", true);
            h = jaxReg.find("noneOut", false);
            Handler[] hList = jaxReg.findHandlers(new QName("ns1", "local1"), true);
            hList = jaxReg.findHandlers(new QName("ns1", "local2"), true);
            hList = jaxReg.findHandlers(new QName("ns1", "local3"), true);
            hList = jaxReg.findHandlers(new QName("ns1", "local4"), true);
            hList = jaxReg.findHandlers(new QName("ns1", "local6"), true);
            hList = jaxReg.findHandlers(new QName("ns1", "local7"), true);
            hList = jaxReg.findHandlers(new QName("ns1", "none"), true);
            jaxReg.unregister("InTwo", true);
            jaxReg.unregister("InThree", true);
            jaxReg.unregister("InOne", true);
            jaxReg.unregister("InSix", true);
            jaxReg.unregister("OutTwo", false);
            jaxReg.unregister("OutThree", false);
            jaxReg.unregister("OutOne", false);
            jaxReg.unregister("OutSix", false);
            jaxReg.list(true);
            jaxReg.list(false);
            jaxReg.initDuplicate();
        }
        catch (JAXRPCException ex) {
            ex.printStackTrace();
        }
    }

    private void init() throws JAXRPCException {
        boolean inbound = true;
        boolean outbound = false;
        this.register("InOne", new HandlerOne(), true);
        this.register("InTwo", new HandlerTwo(), true);
        this.register("InThree", new HandlerThree(), true);
        this.register("InSix", new HandlerDynamic(), new HandlerInfo(HandlerDynamic.class, null, new QName[]{new QName("ns1", "local6"), new QName("ns1", "local7")}), true);
        this.register("OutSix", new HandlerDynamic(), new HandlerInfo(HandlerDynamic.class, null, new QName[]{new QName("ns1", "local6"), new QName("ns1", "local7")}), false);
        this.register("OutThree", new HandlerThree(), false);
        this.register("OutTwo", new HandlerTwo(), false);
        this.register("OutOne", new HandlerOne(), false);
    }

    private void initDuplicate() throws JAXRPCException {
        this.register("DuplicateIn", new HandlerOne(), true);
        this.register("DuplicateIn", new HandlerOne(), true);
    }

    class HandlerDynamic
    extends HandlerOne {
        private HandlerInfo handlerInfo;

        HandlerDynamic() {
        }

        public void init(HandlerInfo arg0) {
            System.out.println("HandlerDynamic:init invoked with:" + arg0);
            this.handlerInfo = arg0;
        }

        public void destroy() {
            System.out.println("HandlerDynamic:destroy invoked");
        }

        public QName[] getHeaders() {
            System.out.println("HandlerDynamic:getHeaders invoked");
            return this.handlerInfo.getHeaders();
        }
    }

    class HandlerThree
    extends HandlerOne {
        HandlerThree() {
        }

        public void init(HandlerInfo arg0) {
            System.out.println("HandlerThree:init invoked with:" + arg0);
        }

        public void destroy() {
            System.out.println("HandlerThree:destroy invoked");
        }

        public QName[] getHeaders() {
            System.out.println("HandlerThree:getHeaders invoked");
            return new QName[]{new QName("ns1", "local3"), new QName("ns1", "local4"), new QName("ns1", "local5")};
        }
    }

    class HandlerTwo
    extends HandlerOne {
        HandlerTwo() {
        }

        public void init(HandlerInfo arg0) {
            System.out.println("HandlerTwo:init invoked with:" + arg0);
        }

        public void destroy() {
            System.out.println("HandlerTwo:destroy invoked");
        }

        public QName[] getHeaders() {
            System.out.println("HandlerTwo:getHeaders invoked");
            return new QName[]{new QName("ns1", "local1"), new QName("ns1", "local2")};
        }
    }

    class HandlerOne
    implements Handler {
        HandlerOne() {
        }

        public boolean handleRequest(MessageContext arg0) {
            return true;
        }

        public boolean handleResponse(MessageContext arg0) {
            return true;
        }

        public boolean handleFault(MessageContext arg0) {
            return true;
        }

        public void init(HandlerInfo arg0) {
            System.out.println("HandlerOne:init invoked with:" + arg0);
        }

        public void destroy() {
            System.out.println("HandlerOne:destroy invoked");
        }

        public QName[] getHeaders() {
            System.out.println("HandlerOne:getHeaders invoked");
            return new QName[]{new QName("ns1", "local1")};
        }
    }
}

