/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow.sig;

import com.wm.lang.flow.FlowBranch;
import com.wm.lang.flow.FlowElement;
import com.wm.lang.flow.FlowExit;
import com.wm.lang.flow.FlowInvoke;
import com.wm.lang.flow.FlowLoop;
import com.wm.lang.flow.FlowMap;
import com.wm.lang.flow.FlowRetry;
import com.wm.lang.flow.FlowRoot;
import com.wm.lang.flow.FlowSequence;
import com.wm.lang.flow.sig.BranchSignature;
import com.wm.lang.flow.sig.InvokeSignature;
import com.wm.lang.flow.sig.LoopSignature;
import com.wm.lang.flow.sig.MapSignature;
import com.wm.lang.flow.sig.RetrySignature;
import com.wm.lang.flow.sig.Signature;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSRecordRef;
import com.wm.lang.ns.NSRecordUtil;
import com.wm.lang.ns.NSRecordWmPathProcessor;
import com.wm.lang.ns.NSSignature;
import com.wm.lang.ns.Namespace;
import com.wm.lang.ns.WmPathInfo;
import com.wm.lang.ns.WmPathItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SignatureState {
    FlowRoot root;
    Namespace namespace;
    NSSignature serviceSig;
    FlowElement lastNode;

    public SignatureState(FlowRoot root, Namespace namespace, NSSignature serviceSig) {
        this.root = root;
        this.namespace = namespace;
        this.serviceSig = serviceSig;
    }

    public NSSignature getPipelineSignature(FlowElement selected) {
        NSRecord in = new NSRecord(this.namespace);
        NSRecord out = new NSRecord(this.namespace);
        if (this.serviceSig != null && this.serviceSig.getInput() != null) {
            NSRecord input = (NSRecord)this.serviceSig.getInput().deepClone();
            Signature.markNode(input, false);
            NSRecordUtil.merge(input, in);
        }
        NSSignature sig = new NSSignature(in, out);
        FlowElement[] nodes = this.root.getNodes();
        if (nodes == null || nodes.length == 0) {
            return sig;
        }
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i] instanceof FlowLoop && this.serviceSig != null && this.serviceSig.getOutput() != null) {
                NSRecord output = (NSRecord)this.serviceSig.getOutput().deepClone();
                Signature.markNode(output, false);
                NSRecordUtil.merge(output, sig.getOutput(), false);
            }
            if (SignatureState.collectSignature(sig, nodes[i], selected, this.namespace)) break;
        }
        if (this.serviceSig != null && this.serviceSig.getOutput() != null && this.isLastNode(selected)) {
            NSRecord serviceOutput = (NSRecord)this.serviceSig.getOutput().deepClone();
            Signature.markNode(serviceOutput, false);
            SignatureState.customMerge(serviceOutput, sig.getOutput(), selected);
            this.adjustLastMapOrInvokeInALoop(selected, sig.getOutput());
        }
        return sig;
    }

    public static void customMerge(NSRecord source, NSRecord destination, FlowElement selected) {
        int i;
        if (destination == null || source == null) {
            return;
        }
        if (source.getFieldCount() < 1) {
            return;
        }
        NSRecord cloneOfSource = (NSRecord)source.clone();
        NSField[] destinationFields = destination.getFieldNodes();
        for (i = 0; i < destinationFields.length; ++i) {
            NSField sourceField = cloneOfSource.getFieldByName(destinationFields[i].getName());
            if (!SignatureState.sourceFieldExists(sourceField)) continue;
            if (sourceField.getType() != 2 || destinationFields[i].getType() != 4) {
                if (SignatureState.eitherTypeOrDimensionDoNotMatch(sourceField, destinationFields, i, selected)) {
                    destination.addField(sourceField);
                } else if (!(destinationFields[i] instanceof NSRecordRef)) {
                    if (destinationFields[i] instanceof NSRecord) {
                        SignatureState.customMerge((NSRecord)sourceField, (NSRecord)destinationFields[i], selected);
                    } else {
                        destination.removeField(destinationFields[i]);
                        destination.insertFieldAt(sourceField, i);
                    }
                }
            }
            cloneOfSource.removeField(sourceField);
        }
        if (cloneOfSource.getFieldCount() < 1) {
            return;
        }
        destinationFields = cloneOfSource.getFieldNodes();
        for (i = 0; i < destinationFields.length; ++i) {
            destination.addField(destinationFields[i]);
        }
    }

    private static boolean sourceFieldExists(NSField sourceField) {
        return sourceField != null;
    }

    private static boolean eitherTypeOrDimensionDoNotMatch(NSField sourceField, NSField[] destinationFields, int i, FlowElement selected) {
        List inArrayPaths = SignatureState.getInArrayPathsOfLoopAncestors(selected);
        List outArrayPaths = SignatureState.getOutArrayPathsOfLoopAncestors(selected);
        String sourcePath = SignatureState.getSourcePath(sourceField);
        int sourceFieldDimensions = sourceField.getDimensions();
        if (inArrayPaths.contains(sourcePath) || outArrayPaths.contains(sourcePath)) {
            --sourceFieldDimensions;
        }
        return sourceField.getType() != destinationFields[i].getType() || sourceFieldDimensions != destinationFields[i].getDimensions();
    }

    private static String getSourcePath(NSField sourceField) {
        String sourceVerbosePath = sourceField.getPath();
        WmPathItem[] wmPathItems = WmPathInfo.parsePath(sourceVerbosePath);
        StringBuffer buffer = new StringBuffer();
        for (int j = 0; j < wmPathItems.length; ++j) {
            WmPathItem wmPathItem = wmPathItems[j];
            buffer.append("/");
            buffer.append(wmPathItem.getName());
        }
        String sourcePath = buffer.toString();
        return sourcePath;
    }

    private static List getInArrayPathsOfLoopAncestors(FlowElement selected) {
        if (SignatureState.notAMapOrAnInvoke(selected)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> inArrayPaths = new ArrayList<String>();
        FlowElement currentElement = selected;
        while (currentElement.getParent() != null) {
            if (currentElement instanceof FlowLoop) {
                String inArrayPath = ((FlowLoop)currentElement).getInArray();
                inArrayPaths.add(inArrayPath);
            }
            currentElement = currentElement.getParent();
        }
        return inArrayPaths;
    }

    private static List getOutArrayPathsOfLoopAncestors(FlowElement selected) {
        if (SignatureState.notAMapOrAnInvoke(selected)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> outArrayPaths = new ArrayList<String>();
        FlowElement currentElement = selected;
        while (currentElement.getParent() != null) {
            if (currentElement instanceof FlowLoop) {
                String outArrayPath = ((FlowLoop)currentElement).getOutArray();
                outArrayPaths.add(outArrayPath);
            }
            currentElement = currentElement.getParent();
        }
        return outArrayPaths;
    }

    private void adjustLastMapOrInvokeInALoop(FlowElement selected, NSRecord outputPipeline) {
        if (SignatureState.notAMapOrAnInvoke(selected)) {
            return;
        }
        int loopAncestorCount = 0;
        FlowElement currentElement = selected;
        FlowLoop firstLoopAncestor = null;
        while (currentElement.getParent() != null) {
            if (currentElement instanceof FlowLoop) {
                ++loopAncestorCount;
                if (firstLoopAncestor == null) {
                    firstLoopAncestor = (FlowLoop)currentElement;
                }
            }
            currentElement = currentElement.getParent();
        }
        if (loopAncestorCount == 0) {
            return;
        }
        String inArrayPath = firstLoopAncestor.getInArray();
        this.reduceArrayPath(outputPipeline, inArrayPath, loopAncestorCount);
        String outArrayPath = firstLoopAncestor.getOutArray();
        this.reduceArrayPath(outputPipeline, outArrayPath, loopAncestorCount);
    }

    private static boolean notAMapOrAnInvoke(FlowElement selected) {
        boolean isAMap = selected instanceof FlowMap;
        boolean isAnInvoke = selected instanceof FlowInvoke;
        return !isAMap && !isAnInvoke;
    }

    private void reduceArrayPath(NSRecord outputPipeline, String arrayPath, int loopAncestorCount) {
        NSField arrayField = NSRecordWmPathProcessor.get(outputPipeline, arrayPath);
        if (arrayField == null) {
            return;
        }
        for (int i = 0; i < loopAncestorCount; ++i) {
            LoopSignature.dimReduction(outputPipeline, arrayPath);
        }
    }

    public static boolean collectSignature(NSSignature sig, FlowElement node, FlowElement selected, Namespace ns) {
        if (node instanceof FlowInvoke) {
            InvokeSignature collector = new InvokeSignature((FlowInvoke)node, ns);
            collector.addSignature(sig, selected);
            return collector.isDone();
        }
        if (node instanceof FlowMap) {
            MapSignature collector = new MapSignature((FlowMap)node, ns);
            collector.addSignature(sig, selected);
            return collector.isDone();
        }
        if (node instanceof FlowBranch) {
            BranchSignature collector = new BranchSignature((FlowBranch)node, ns);
            collector.addSignature(sig, selected);
            return collector.isDone();
        }
        if (node instanceof FlowLoop) {
            LoopSignature collector = new LoopSignature((FlowLoop)node, ns);
            collector.addSignature(sig, selected);
            return collector.isDone();
        }
        if (node instanceof FlowRetry) {
            RetrySignature collector = new RetrySignature((FlowRetry)node, ns);
            collector.addSignature(sig, selected);
            return collector.isDone();
        }
        if (node instanceof FlowSequence) {
            Signature collector = new Signature((FlowSequence)node, ns);
            collector.addSignature(sig, selected);
            return collector.isDone();
        }
        return !(node instanceof FlowExit);
    }

    boolean isLastNode(FlowElement selected) {
        this.lastNode = this.findLastNode(this.root);
        if (this.lastNode.getParent() instanceof FlowBranch) {
            this.lastNode = this.lastNode.getParent();
        }
        return this.lastNode == null || this.lastNode == selected || selected.getParent() == this.lastNode;
    }

    FlowElement findLastNode(FlowElement element) {
        if (element instanceof FlowMap || element instanceof FlowInvoke) {
            return element;
        }
        if (!element.isEnabled()) {
            return element;
        }
        FlowElement[] nodes = element.getNodes();
        if (nodes == null || nodes.length == 0) {
            return element;
        }
        for (int i = nodes.length - 1; i >= 0; --i) {
            if (!nodes[i].isEnabled()) continue;
            return this.findLastNode(nodes[i]);
        }
        return element;
    }
}

