/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow.sig;

import com.wm.lang.flow.FlowElement;
import com.wm.lang.flow.FlowMapSet;
import com.wm.lang.flow.MapWmPathInfo;
import com.wm.lang.flow.sig.SignatureState;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSRecordRef;
import com.wm.lang.ns.NSRecordUtil;
import com.wm.lang.ns.NSRecordWmPathProcessor;
import com.wm.lang.ns.NSSignature;
import com.wm.lang.ns.Namespace;
import com.wm.lang.ns.WmPathItem;

public class Signature {
    FlowElement node;
    Namespace namespace;
    boolean done = false;
    NSSignature nodeScope;

    public Signature(FlowElement node, Namespace name) {
        this.node = node;
        this.namespace = name;
    }

    public boolean isDone() {
        return this.done;
    }

    public void addSignature(NSSignature pipeline, FlowElement selected) {
        if (pipeline == null) {
            return;
        }
        if (this.node == selected) {
            this.done = true;
            return;
        }
        if (!this.node.isEnabled()) {
            return;
        }
        NSSignature scope = this.createScope(pipeline);
        FlowElement[] nodes = this.node.getNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.length; ++i) {
                if (!SignatureState.collectSignature(scope, nodes[i], selected, this.namespace)) continue;
                this.done = true;
                break;
            }
        }
        if (!this.done) {
            this.recoverScope(pipeline.getInput(), scope.getInput());
        } else {
            pipeline.setInput(scope.getInput());
            pipeline.setOutput(scope.getOutput());
        }
    }

    public NSSignature createScope(NSSignature pipeline) {
        if (this.nodeScope != null) {
            return this.nodeScope;
        }
        String scope = this.node.getScope();
        if (scope == null || scope.length() == 0) {
            return pipeline;
        }
        MapWmPathInfo path = MapWmPathInfo.create(scope);
        if (path == null) {
            return pipeline;
        }
        NSRecord record = pipeline.getInput();
        WmPathItem[] pathInfo = path.getPathItems();
        for (int i = 0; i < pathInfo.length; ++i) {
            NSField field = NSRecordWmPathProcessor.get(record, pathInfo[i]);
            if (field instanceof NSRecord) {
                record = (NSRecord)field;
                continue;
            }
            NSRecord rec = new NSRecord(this.namespace, pathInfo[i].getName(), 0);
            record.addField(rec);
            record = rec;
        }
        NSRecord input = new NSRecord(this.namespace, record.getName(), record.getDimensions());
        NSRecordUtil.merge(record, input);
        this.nodeScope = new NSSignature(input, input);
        return this.nodeScope;
    }

    public void recoverScope(NSRecord pipeline, NSRecord scopeRec) {
        String scope = this.node.getScope();
        if (scope == null || scope.length() == 0) {
            return;
        }
        MapWmPathInfo path = MapWmPathInfo.create(scope);
        if (path == null) {
            return;
        }
        NSRecordWmPathProcessor.put(pipeline, (NSField)scopeRec, path.getPathItems());
    }

    static void markNode(NSField field, boolean editable) {
        NSRecord record;
        NSField[] fields;
        if (field == null) {
            return;
        }
        field.setUIEditable(editable);
        if (field instanceof NSRecordRef) {
            return;
        }
        if (field instanceof NSRecord && (fields = (record = (NSRecord)field).getFieldNodes()) != null) {
            for (int i = 0; i < fields.length; ++i) {
                Signature.markNode(fields[i], editable);
            }
        }
    }

    static void addFieldsFromData(NSRecord pipeline, FlowMapSet set) {
        if (pipeline == null || set == null) {
            return;
        }
        MapWmPathInfo path = set.getParsedPath();
        if (path == null) {
            return;
        }
        NSField field = NSRecordUtil.createFromSample(set.getInput(), path.getDataName());
        if (field == null) {
            return;
        }
        WmPathItem[] items = path.getPathItems();
        NSRecord parent = pipeline;
        for (int i = 0; i < items.length - 1; ++i) {
            NSField find = NSRecordWmPathProcessor.get(parent, items[i]);
            if (find instanceof NSRecord) {
                parent = (NSRecord)find;
                continue;
            }
            if (find == null) {
                find = NSRecordWmPathProcessor.create(parent, items[i]);
                if (find instanceof NSRecord) {
                    parent = (NSRecord)find;
                    continue;
                }
                return;
            }
            return;
        }
        NSField find = NSRecordWmPathProcessor.get(parent, items[items.length - 1]);
        if (find == null) {
            NSRecordWmPathProcessor.put(parent, field, items[items.length - 1]);
        } else if (find instanceof NSRecord) {
            if (field instanceof NSRecord) {
                NSRecordUtil.merge((NSRecord)field, (NSRecord)find, false);
            } else {
                NSRecordWmPathProcessor.put(parent, field, items[items.length - 1]);
            }
        } else if (field instanceof NSRecord) {
            NSRecordWmPathProcessor.put(parent, field, items[items.length - 1]);
        }
    }
}

