/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow.sig;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.lang.flow.FlowElement;
import com.wm.lang.flow.FlowMap;
import com.wm.lang.flow.FlowMapCopy;
import com.wm.lang.flow.FlowMapDelete;
import com.wm.lang.flow.FlowMapInvoke;
import com.wm.lang.flow.FlowMapSet;
import com.wm.lang.flow.MapCompiler;
import com.wm.lang.flow.MapWmPathInfo;
import com.wm.lang.flow.WmPathItemProcessor;
import com.wm.lang.flow.sig.Signature;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSRecordWmPathProcessor;
import com.wm.lang.ns.NSSignature;
import com.wm.lang.ns.Namespace;
import com.wm.lang.ns.WmPathInfo;
import java.util.Hashtable;
import java.util.Vector;

public class MapSignature
extends Signature {
    boolean isDeleteLeft = true;

    public MapSignature(FlowMap map, Namespace ns) {
        super(map, ns);
    }

    public void setDeleteLeft(boolean b) {
        this.isDeleteLeft = b;
    }

    public void addSignature(NSSignature pipeline, FlowElement selected) {
        if (pipeline == null) {
            return;
        }
        boolean bl = this.done = this.node == selected;
        if (!this.node.isEnabled() && !this.done) {
            return;
        }
        NSSignature scope = this.createScope(pipeline);
        if (this.done) {
            this.nodeSelected(scope);
            pipeline.setInput(scope.getInput());
            pipeline.setOutput(scope.getOutput());
        } else {
            this.nodeNotSelected(scope);
            this.recoverScope(pipeline.getInput(), scope.getInput());
        }
    }

    void nodeSelected(NSSignature scope) {
        if (!this.node.isEnabled() && !this.done) {
            return;
        }
        NSRecord input = scope.getInput();
        NSRecord in = this.computeInput(input.deepCloneForDeveloper());
        NSRecord out = this.computeOutput(input);
        scope.setInput(in);
        scope.setOutput(out);
    }

    void nodeNotSelected(NSSignature scope) {
        FlowMapDelete[] deletes;
        if (!this.node.isEnabled() && !this.done) {
            return;
        }
        NSRecord in = this.computeOutput(scope.getInput());
        if (!this.isDeleteLeft && (deletes = ((FlowMap)this.node).getDeleteMaps()) != null) {
            for (int i = 0; i < deletes.length; ++i) {
                MapWmPathInfo path = deletes[i].getParsedPath();
                if (path == null) continue;
                NSRecordWmPathProcessor.delete(in, path.getPathItems());
            }
        }
        scope.setInput(in);
    }

    NSRecord computeInput(NSRecord in) {
        if (!this.node.isEnabled() && !this.done) {
            return in;
        }
        this.addSourceFields(in);
        return in;
    }

    NSRecord computeOutput(NSRecord in) {
        FlowMapDelete[] deletes;
        if (!this.node.isEnabled() && !this.done) {
            return in;
        }
        NSRecord out = this.computeInput(in);
        if (this.isDeleteLeft && (deletes = ((FlowMap)this.node).getDeleteMaps()) != null) {
            for (int i = 0; i < deletes.length; ++i) {
                MapWmPathInfo path = deletes[i].getParsedPath();
                if (path == null) continue;
                NSRecordWmPathProcessor.delete(out, path.getPathItems());
            }
        }
        this.addTargetFields(out);
        return out;
    }

    void addTargetFields(NSRecord pipeline) {
        FlowElement[] nodes = ((FlowMap)this.node).getNodes();
        if (nodes == null || nodes.length == 0) {
            return;
        }
        NSRecord targetSchema = ((FlowMap)this.node).getTarget(this.namespace);
        Hashtable order = new Hashtable();
        Vector nonorder = new Vector();
        for (int i = 0; i < nodes.length; ++i) {
            FlowMap output_map;
            FlowElement[] maps;
            if (nodes[i] instanceof FlowMapCopy) {
                this.addField(order, nonorder, this.getMapWmPathInfo(((FlowMapCopy)nodes[i]).getMapTo()), targetSchema);
                continue;
            }
            if (nodes[i] instanceof FlowMapSet) {
                FlowMapSet set = (FlowMapSet)nodes[i];
                if ("source".equals(set.getFieldPosition())) continue;
                this.addField(order, nonorder, this.getMapWmPathInfo(set.getField()), targetSchema);
                continue;
            }
            if (nodes[i] instanceof FlowMapDelete) {
                FlowMapDelete delete = (FlowMapDelete)nodes[i];
                if ((delete.getFieldPosition() != null || this.isDeleteLeft) && !"target".equals(delete.getFieldPosition())) continue;
                this.addField(order, nonorder, this.getMapWmPathInfo(delete.getField()), targetSchema);
                continue;
            }
            if (!(nodes[i] instanceof FlowMapInvoke) || !nodes[i].isEnabled() || (maps = (output_map = ((FlowMapInvoke)nodes[i]).getOutputMap()).getNodes()) == null) continue;
            for (int j = 0; j < maps.length; ++j) {
                if (!(maps[j] instanceof FlowMapCopy)) continue;
                this.addField(order, nonorder, this.getMapWmPathInfo(((FlowMapCopy)maps[j]).getMapTo()), targetSchema);
            }
        }
        Object[] execOrder = null;
        if (order.size() > 0) {
            execOrder = MapCompiler.lazySort(order);
        }
        this.createFields(pipeline, nonorder, execOrder);
        for (int i = 0; i < nodes.length; ++i) {
            FlowMapSet set;
            if (!(nodes[i] instanceof FlowMapSet) || "source".equals((set = (FlowMapSet)nodes[i]).getFieldPosition())) continue;
            MapSignature.addFieldsFromData(pipeline, set);
        }
    }

    void addSourceFields(NSRecord pipeline) {
        FlowElement[] nodes = ((FlowMap)this.node).getNodes();
        if (nodes == null || nodes.length == 0) {
            return;
        }
        NSRecord sourceSchema = ((FlowMap)this.node).getSource(this.namespace);
        Hashtable order = new Hashtable();
        Vector nonorder = new Vector();
        for (int i = 0; i < nodes.length; ++i) {
            FlowMap map;
            FlowElement[] maps;
            if (nodes[i] instanceof FlowMapCopy) {
                this.addField(order, nonorder, this.getMapWmPathInfo(((FlowMapCopy)nodes[i]).getMapFrom()), sourceSchema);
                continue;
            }
            if (nodes[i] instanceof FlowMapSet) {
                FlowMapSet set = (FlowMapSet)nodes[i];
                if (!"source".equals(set.getFieldPosition())) continue;
                this.addField(order, nonorder, this.getMapWmPathInfo(set.getField()), sourceSchema);
                continue;
            }
            if (nodes[i] instanceof FlowMapDelete) {
                FlowMapDelete delete = (FlowMapDelete)nodes[i];
                if ((delete.getFieldPosition() != null || !this.isDeleteLeft) && !"source".equals(delete.getFieldPosition())) continue;
                this.addField(order, nonorder, this.getMapWmPathInfo(delete.getField()), sourceSchema);
                continue;
            }
            if (!(nodes[i] instanceof FlowMapInvoke) || (maps = (map = ((FlowMapInvoke)nodes[i]).getInputMap()).getNodes()) == null) continue;
            for (int j = 0; j < maps.length; ++j) {
                if (!(maps[j] instanceof FlowMapCopy)) continue;
                this.addField(order, nonorder, this.getMapWmPathInfo(((FlowMapCopy)maps[j]).getMapFrom()), sourceSchema);
            }
        }
        Object[] execOrder = null;
        if (order.size() > 0) {
            execOrder = MapCompiler.lazySort(order);
        }
        this.createFields(pipeline, nonorder, execOrder);
        for (int i = 0; i < nodes.length; ++i) {
            FlowMapSet set;
            if (!(nodes[i] instanceof FlowMapSet) || !"source".equals((set = (FlowMapSet)nodes[i]).getFieldPosition())) continue;
            MapSignature.addFieldsFromData(pipeline, set);
        }
    }

    void createFields(NSRecord pipeline, Vector nonorder, Object[] execOrder) {
        if (nonorder != null && nonorder.size() > 0) {
            int len = nonorder.size();
            for (int i = 0; i < len; ++i) {
                MapWmPathInfo pathInfo = (MapWmPathInfo)nonorder.elementAt(i);
                NSRecordWmPathProcessor.create(pipeline, pathInfo.getPathItems());
            }
        }
        if (execOrder != null) {
            block1: for (int i = 0; i < execOrder.length; ++i) {
                MapWmPathInfo pathInfo = (MapWmPathInfo)execOrder[i];
                WmPathItemProcessor[] procs = pathInfo.getItemProcessors();
                NSRecord parent = pipeline;
                for (int j = 0; j < procs.length; ++j) {
                    NSField find = NSRecordWmPathProcessor.get(parent, procs[j].getPathItem());
                    if (find == null) {
                        find = NSRecordWmPathProcessor.create(parent, procs[j].getPosPathItem());
                    }
                    if (!(find instanceof NSRecord)) continue block1;
                    parent = (NSRecord)find;
                }
            }
        }
    }

    void addField(Hashtable order, Vector nonorder, MapWmPathInfo pathInfo, NSRecord schema) {
        if (pathInfo == null) {
            return;
        }
        pathInfo.compile(schema);
        int[] pos = pathInfo.getAbsPosition();
        if (pos != null) {
            order.put(pos, pathInfo);
        } else {
            nonorder.addElement(pathInfo);
        }
    }

    MapWmPathInfo getMapWmPathInfo(String path) {
        if (path != null) {
            return MapWmPathInfo.create(path);
        }
        return null;
    }

    public static void mergeSchema(NSRecord record, NSRecord parent) {
        int i;
        if (parent == null || record == null) {
            return;
        }
        if (record.getFieldCount() < 1) {
            return;
        }
        NSField[] fields = parent.getFieldNodes();
        for (i = 0; i < fields.length; ++i) {
            NSField find = record.getFieldByName(fields[i].getName());
            if (find == null || find.getType() != fields[i].getType() || find.getDimensions() != fields[i].getDimensions()) continue;
            record.removeField(find);
        }
        if (record.getFieldCount() < 1) {
            return;
        }
        fields = record.getFieldNodes();
        for (i = 0; i < fields.length; ++i) {
            parent.addField(fields[i]);
        }
    }

    void addBindVarElements(Vector bindVars, IData[] vars, String parentPath) {
        for (int j = 0; j < vars.length; ++j) {
            IData[] fields;
            IDataCursor c = vars[j].getCursor();
            String fieldType = c.first("resultType") ? (String)c.getValue() : null;
            int dim = 0;
            if (fieldType.indexOf("[][]") > 0) {
                dim = 2;
            } else if (fieldType.indexOf("[]") > 0) {
                dim = 1;
            }
            int type = 1;
            if (fieldType.startsWith("Object")) {
                type = 3;
            } else if (fieldType.startsWith("Record")) {
                type = 2;
            }
            String name = c.first("name") ? (String)c.getValue() : null;
            String path = parentPath + WmPathInfo.getPath(name, type, dim);
            bindVars.addElement(path);
            IData[] iDataArray = fields = c.first("fields") ? (IData[])c.getValue() : null;
            if (fields == null) continue;
            this.addBindVarElements(bindVars, fields, path);
        }
    }

    public NSRecord getBindVars() {
        IData[] vars;
        IDataCursor c;
        if (this.node.getNodeCount() < 1) {
            return null;
        }
        Vector<Object> variables = new Vector<Object>();
        Vector<Object> regions = new Vector<Object>();
        FlowElement[] nodes = this.node.getNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.length; ++i) {
                IData var;
                MapWmPathInfo fieldPath;
                if (!(nodes[i] instanceof FlowMapSet)) continue;
                Object data = ((FlowMapSet)nodes[i]).getInput();
                String field = ((FlowMapSet)nodes[i]).getField();
                if (field != null && field.length() > 0 && (fieldPath = MapWmPathInfo.create(field)) != null) {
                    String[] names = fieldPath.getPathInfo();
                    field = names[0];
                }
                if ("fields".equals(field) && data instanceof IData[]) {
                    if (((IData[])data).length <= 0 || (var = ((IData[])data)[0]) == null) continue;
                    c = var.getCursor();
                    if (c.first("name") && c.first("resultType") && c.first("queryType") && c.first("query") && c.first("onnull")) {
                        variables.addElement(data);
                    }
                    c.destroy();
                    continue;
                }
                if (!"regions".equals(field) || !(data instanceof IData[]) || ((IData[])data).length <= 0 || (var = ((IData[])data)[0]) == null) continue;
                c = var.getCursor();
                if (c.first("name") && c.first("start") && c.first("end")) {
                    regions.addElement(data);
                }
                c.destroy();
            }
        }
        Vector<String> bindVars = new Vector<String>();
        if (variables.size() > 0) {
            for (int i = 0; i < variables.size(); ++i) {
                vars = (IData[])variables.elementAt(i);
                this.addBindVarElements(bindVars, vars, "");
            }
        }
        if (regions.size() > 0) {
            for (int i = 0; i < regions.size(); ++i) {
                vars = (IData[])regions.elementAt(i);
                for (int j = 0; j < vars.length; ++j) {
                    Object name;
                    c = vars[j].getCursor();
                    Object object = name = c.first("name") ? c.getValue() : null;
                    if (name instanceof String) {
                        String path = "/" + (String)name + ";3;0";
                        bindVars.addElement(path);
                    }
                    c.destroy();
                }
            }
        }
        if (bindVars.size() == 0) {
            return null;
        }
        NSRecord out = new NSRecord(this.namespace);
        for (int i = 0; i < bindVars.size(); ++i) {
            NSRecordWmPathProcessor.create(out, (String)bindVars.elementAt(i));
        }
        return out;
    }
}

