/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow.sig;

import com.wm.lang.flow.FlowElement;
import com.wm.lang.flow.FlowLoop;
import com.wm.lang.flow.MapWmPathInfo;
import com.wm.lang.flow.sig.Signature;
import com.wm.lang.flow.sig.SignatureState;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSRecordUtil;
import com.wm.lang.ns.NSRecordWmPathProcessor;
import com.wm.lang.ns.NSSignature;
import com.wm.lang.ns.Namespace;
import com.wm.lang.ns.WmPathInfo;
import com.wm.lang.ns.WmPathItem;
import java.util.ArrayList;

public class LoopSignature
extends Signature {
    MapWmPathInfo inPath;
    MapWmPathInfo outPath;

    public LoopSignature(FlowLoop loop, Namespace ns) {
        super(loop, ns);
        this.inPath = MapWmPathInfo.create(((FlowLoop)this.node).getInArray());
        this.outPath = MapWmPathInfo.create(((FlowLoop)this.node).getOutArray());
    }

    public void addSignature(NSSignature pipeline, FlowElement selected) {
        if (pipeline == null) {
            return;
        }
        if (this.node == selected) {
            this.done = true;
            return;
        }
        if (!this.node.isEnabled()) {
            return;
        }
        FlowElement[] nodes = this.node.getNodes();
        if (nodes == null || nodes.length == 0) {
            return;
        }
        NSSignature scope = this.createScope(pipeline);
        String[] dimPaths = this.dimReduction(scope);
        for (int i = 0; i < nodes.length; ++i) {
            if (!SignatureState.collectSignature(scope, nodes[i], selected, this.namespace)) continue;
            this.done = true;
            this.addLoopParameters(scope);
            pipeline.setInput(scope.getInput());
            pipeline.setOutput(scope.getOutput());
            return;
        }
        this.dimRecovery(scope, dimPaths);
        this.recoverScope(pipeline.getInput(), scope.getInput());
    }

    void addLoopParameters(NSSignature pipeline) {
        NSRecord input = pipeline.getInput();
        WmPathItem item = new WmPathItem("$iteration", null, -1, -1, -1, 1, 0);
        NSRecordWmPathProcessor.create(input, item);
    }

    String[] dimReduction(NSSignature pipeline) {
        NSRecord input = pipeline.getInput();
        NSRecord output = pipeline.getOutput();
        String inarray = ((FlowLoop)this.node).getInArray();
        String outarray = ((FlowLoop)this.node).getOutArray();
        if (output.getFieldCount() > 0) {
            NSField find = NSRecordWmPathProcessor.get(output, inarray);
            if (find == null) {
                find = NSRecordWmPathProcessor.get(output, outarray);
            }
            if (find != null) {
                NSRecordUtil.merge(output, input, false);
            }
        }
        output = input;
        String[] dimPaths = new String[]{LoopSignature.dimReduction(input, inarray), LoopSignature.dimReduction(output, outarray)};
        return dimPaths;
    }

    void dimRecovery(NSSignature pipeline, String[] dimPaths) {
        ArrayList fldTracker = new ArrayList(5);
        if (dimPaths[0] != null) {
            this.dimIncrement(pipeline.getInput(), dimPaths[0], fldTracker);
        } else if (this.inPath != null) {
            this.dimIncrement(pipeline.getInput(), this.inPath.getPathItems(), fldTracker);
        }
        if (dimPaths[1] != null) {
            this.dimIncrement(pipeline.getInput(), dimPaths[1], fldTracker);
        } else if (this.outPath != null) {
            this.dimIncrement(pipeline.getInput(), this.outPath.getPathItems(), fldTracker);
        }
    }

    public static String dimReduction(NSRecord record, String path) {
        if (record == null || path == null || path.length() == 0) {
            return null;
        }
        WmPathItem[] pathInfo = WmPathInfo.parsePath(path);
        if (pathInfo == null) {
            return null;
        }
        for (int i = 0; i < pathInfo.length; ++i) {
            NSField find = NSRecordWmPathProcessor.get(record, pathInfo[i]);
            if (find == null) {
                return null;
            }
            if (find.getDimensions() > 0) {
                find.setDimensions(find.getDimensions() - 1);
                return WmPathInfo.createPath(find);
            }
            if (!(find instanceof NSRecord)) {
                return null;
            }
            record = (NSRecord)find;
        }
        return null;
    }

    void dimIncrement(NSRecord record, String dimPath, ArrayList fldTracker) {
        WmPathItem[] pathInfo = WmPathInfo.parsePath(dimPath);
        if (pathInfo == null) {
            return;
        }
        NSField find = NSRecordWmPathProcessor.get(record, pathInfo);
        if (find != null && !fldTracker.contains(find)) {
            fldTracker.add(find);
            find.setDimensions(find.getDimensions() + 1);
        }
    }

    void dimIncrement(NSRecord record, WmPathItem[] pathInfo, ArrayList fldTracker) {
        if (pathInfo == null || record == null) {
            return;
        }
        NSField find = NSRecordWmPathProcessor.get(record, pathInfo);
        if (find == null) {
            return;
        }
        do {
            if (find.getType() == 1) {
                if (find.getDimensions() == 2) continue;
                if (fldTracker.contains(find)) break;
                fldTracker.add(find);
                find.setDimensions(find.getDimensions() + 1);
                break;
            }
            if (find.getDimensions() != 0 || fldTracker.contains(find)) break;
            fldTracker.add(find);
            find.setDimensions(find.getDimensions() + 1);
            break;
        } while ((find = find.getParentRecord()) != null);
    }
}

