/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow.sig;

import com.wm.lang.flow.FlowElement;
import com.wm.lang.flow.FlowInvoke;
import com.wm.lang.flow.FlowMap;
import com.wm.lang.flow.FlowMapCopy;
import com.wm.lang.flow.FlowMapDelete;
import com.wm.lang.flow.FlowMapSet;
import com.wm.lang.flow.MapWmPathInfo;
import com.wm.lang.flow.sig.MapSignature;
import com.wm.lang.flow.sig.Signature;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSRecordUtil;
import com.wm.lang.ns.NSRecordWmPathProcessor;
import com.wm.lang.ns.NSService;
import com.wm.lang.ns.NSSignature;
import com.wm.lang.ns.Namespace;

public class InvokeSignature
extends Signature {
    public InvokeSignature(FlowInvoke node, Namespace ns) {
        super(node, ns);
    }

    public void addSignature(NSSignature pipeline, FlowElement selected) {
        if (pipeline == null) {
            return;
        }
        boolean bl = this.done = this.node == selected;
        if (!this.node.isEnabled() && !this.done) {
            return;
        }
        NSSignature scope = this.createScope(pipeline);
        if (this.done) {
            this.nodeSelected(scope);
            pipeline.setInput(scope.getInput());
            pipeline.setOutput(scope.getOutput());
        } else {
            this.nodeNotSelected(scope);
            this.recoverScope(pipeline.getInput(), scope.getInput());
        }
    }

    void nodeSelected(NSSignature scope) {
        NSRecord input = scope.getInput();
        NSRecord in = this.computeInput((NSRecord)input.deepClone());
        NSRecord out = this.computeOutput(input);
        scope.setInput(in);
        scope.setOutput(out);
    }

    NSRecord computeInput(NSRecord in) {
        if (this.node.getInputMap() != null) {
            FlowMap map = this.node.getInputMap();
            MapSignature inputMap = new MapSignature(map, this.namespace);
            inputMap.setDeleteLeft(true);
            in = inputMap.computeInput(in);
        }
        return in;
    }

    NSRecord computeOutput(NSRecord input) {
        NSSignature sig;
        NSRecord out = input;
        if (this.node.getInputMap() != null) {
            FlowMap map = this.node.getInputMap();
            MapSignature inputMap = new MapSignature(map, this.namespace);
            NSSignature sig2 = new NSSignature(out, new NSRecord(this.namespace));
            inputMap.nodeNotSelected(sig2);
            out = sig2.getInput();
        }
        if ((sig = InvokeSignature.getRealSignature((FlowInvoke)this.node, this.namespace)) != null && sig.getOutput() != null) {
            NSRecordUtil.merge(sig.getOutput(), out, false);
        }
        if (this.node.getOutputMap() != null) {
            FlowMap map = this.node.getOutputMap();
            MapSignature outputMap = new MapSignature(map, this.namespace);
            outputMap.setDeleteLeft(false);
            out = outputMap.computeOutput(out);
        }
        return out;
    }

    public static NSSignature getRealSignature(FlowInvoke invoke, Namespace ns) {
        MapSignature mapSig;
        NSRecord bindVars;
        NSService nsService = invoke.getService(ns, invoke.getService());
        NSSignature sig = nsService != null ? nsService.getSignature() : null;
        NSRecord in = null;
        NSRecord out = null;
        if (sig != null) {
            in = sig.getInput();
            out = sig.getOutput();
            if (in != null) {
                in = (NSRecord)in.deepClone();
                InvokeSignature.markNode(in, false);
            }
            if (out != null) {
                out = (NSRecord)out.deepClone();
                InvokeSignature.markNode(out, false);
            }
        }
        if (in == null) {
            in = new NSRecord(ns);
        }
        if (out == null) {
            out = new NSRecord(ns);
        }
        if (invoke.getInputMap() != null && (bindVars = (mapSig = new MapSignature(invoke.getInputMap(), ns)).getBindVars()) != null) {
            NSRecordUtil.merge(bindVars, out, false);
        }
        sig = new NSSignature(in, out);
        return sig;
    }

    public static NSSignature getSignature(FlowInvoke invoke, Namespace ns) {
        MapWmPathInfo path;
        FlowMapCopy copy;
        int i;
        FlowElement[] nodes;
        FlowMap map;
        NSSignature sig = InvokeSignature.getRealSignature(invoke, ns);
        if (invoke.getInputMap() != null) {
            map = invoke.getInputMap();
            NSRecord in = sig.getInput();
            nodes = map.getNodes();
            if (nodes != null) {
                for (i = 0; i < nodes.length; ++i) {
                    if (nodes[i] instanceof FlowMapCopy) {
                        copy = (FlowMapCopy)nodes[i];
                        path = copy.getParsedTo();
                        if (path == null) continue;
                        NSRecordWmPathProcessor.create(in, path.getPathItems());
                        continue;
                    }
                    if (!(nodes[i] instanceof FlowMapSet)) continue;
                    InvokeSignature.addFieldsFromData(in, (FlowMapSet)nodes[i]);
                }
            }
        }
        if (invoke.getOutputMap() != null) {
            map = invoke.getOutputMap();
            NSRecord out = sig.getOutput();
            nodes = map.getNodes();
            if (nodes != null) {
                for (i = 0; i < nodes.length; ++i) {
                    if (!(nodes[i] instanceof FlowMapCopy) || (path = (copy = (FlowMapCopy)nodes[i]).getParsedFrom()) == null) continue;
                    NSRecordWmPathProcessor.create(out, path.getPathItems());
                }
            }
        }
        return sig;
    }

    void nodeNotSelected(NSSignature scope) {
        FlowMapDelete[] deletes;
        NSRecord out = this.computeOutput(scope.getInput());
        FlowMap map = this.node.getOutputMap();
        if (map != null && (deletes = map.getDeleteMaps()) != null) {
            for (int i = 0; i < deletes.length; ++i) {
                MapWmPathInfo path = deletes[i].getParsedPath();
                if (path == null) continue;
                NSRecordWmPathProcessor.delete(out, path.getPathItems());
            }
        }
        scope.setInput(out);
    }
}

